/*
 * Decompiled with CFR 0.152.
 */
package com.tplink.smb.omada.monitor.roaming.a;

import com.google.common.collect.Sets;
import com.tplink.smb.eventcenter.api.event.DomainEvent;
import com.tplink.smb.eventcenter.domain.DomainEventBusHolder;
import com.tplink.smb.omada.common.constant.DeviceTypeEnum;
import com.tplink.smb.omada.common.util.T;
import com.tplink.smb.omada.common.util.W;
import com.tplink.smb.omada.common.util.l;
import com.tplink.smb.omada.device.manage.message.inform.ap.roaming.ReportedApNeighborList;
import com.tplink.smb.omada.device.manage.message.inform.ap.roaming.ReportedProbeClient;
import com.tplink.smb.omada.manager.device.api.internal.dto.DeviceQueryDTO;
import com.tplink.smb.omada.manager.device.api.internal.dto.ap.ApImageDTO;
import com.tplink.smb.omada.manager.device.api.internal.dto.ap.ApImageStatusDTO;
import com.tplink.smb.omada.monitor.roaming.a.d;
import com.tplink.smb.omada.monitor.roaming.b.a;
import com.tplink.smb.omada.monitor.roaming.port.cache.dto.RoamingAp;
import com.tplink.smb.omada.monitor.roaming.port.cache.dto.RoamingCapability;
import com.tplink.smb.omada.monitor.roaming.port.cache.dto.RoamingClient;
import com.tplink.smb.omada.monitor.roaming.port.cache.dto.RoamingRelatedAp;
import com.tplink.smb.omada.monitor.roaming.port.eventcenter.dto.RoamingEventDTO;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class b {
    @Generated
    private static final Logger a = LoggerFactory.getLogger(b.class);
    @Autowired
    private com.tplink.smb.omada.monitor.roaming.port.cache.a b;
    @Autowired
    private d c;
    @Autowired
    private com.tplink.smb.omada.manager.device.api.internal.device.a d;
    @Autowired
    private com.tplink.smb.omada.monitor.roaming.port.a.a e;
    @Autowired
    private com.tplink.smb.omada.monitor.roaming.port.cache.d f;
    @Autowired
    private com.tplink.smb.omada.manager.device.api.internal.device.b g;

    public void a(String omadacId, String siteId, String deviceMac, List<ReportedApNeighborList> apNeighborTable, @Nullable ApImageDTO apImage, RoamingCapability apCap, boolean aiRoamingEnableBySite) {
        boolean needCh = apNeighborTable.stream().anyMatch(reportedApNeighbor -> reportedApNeighbor.getCh() == null);
        if (apImage == null && needCh) {
            DeviceQueryDTO queryDTO = DeviceQueryDTO.builder().omadacId(omadacId).mac(deviceMac).build();
            apImage = this.d.a(queryDTO);
            if (apImage == null || !apImage.getStatus().b()) {
                a.warn("Failed to handle ap neighbor table, {} not exist or not online, omadacId={}, siteId={}", new Object[]{com.tplink.smb.omada.common.util.e.a.d((String)deviceMac), omadacId, siteId});
                return;
            }
            apCap = new RoamingCapability(apImage);
            this.b.a(omadacId, siteId, deviceMac, apCap);
        }
        int channel2G = 0;
        if (needCh && ((ApImageStatusDTO)apImage.getDeviceStatus()).getWp2g() != null && ((ApImageStatusDTO)apImage.getDeviceStatus()).getWp2g().getActualChannel() != null) {
            channel2G = l.a((String)((ApImageStatusDTO)apImage.getDeviceStatus()).getWp2g().getActualChannel());
        }
        int channel5G = 0;
        if (needCh && ((ApImageStatusDTO)apImage.getDeviceStatus()).getWp5g() != null && ((ApImageStatusDTO)apImage.getDeviceStatus()).getWp5g().getActualChannel() != null) {
            channel5G = l.a((String)((ApImageStatusDTO)apImage.getDeviceStatus()).getWp5g().getActualChannel());
        }
        a.debug("Received AP neighbor list from mac: {}, omadacId={}, siteId={}", new Object[]{deviceMac, omadacId, siteId});
        DomainEventBusHolder.getPublisher().publish((DomainEvent)new RoamingEventDTO(omadacId, siteId, RoamingEventDTO.RoamingEventType.UNSTABLE));
        Set connectApMacSet = this.g.a(omadacId, siteId, DeviceTypeEnum.a, Boolean.valueOf(false));
        a.debug("connected ap macs :{}, omadacId={}, siteId={}", new Object[]{connectApMacSet, omadacId, siteId});
        HashSet<String> reportedBssidList = new HashSet<String>();
        HashSet issuedRoamingApMacs = Sets.newHashSet((Object[])new String[]{deviceMac});
        this.b.b(omadacId, siteId, deviceMac, apNeighborTable.stream().map(ReportedApNeighborList::getBssid).collect(Collectors.toSet()));
        for (ReportedApNeighborList reportedApNeighborList : apNeighborTable) {
            if (reportedApNeighborList.getBssid() == null) {
                a.warn("Reported AP BSSID is null and illegal, ap mac : {}, omadacId={}, siteId={}", new Object[]{com.tplink.smb.omada.common.util.e.a.d((String)deviceMac), omadacId, siteId});
                continue;
            }
            reportedBssidList.add(reportedApNeighborList.getBssid());
            int channel = channel2G;
            if (reportedApNeighborList.getCh() != null) {
                channel = reportedApNeighborList.getCh();
            } else if (!com.tplink.smb.omada.monitor.roaming.b.a.a(deviceMac, reportedApNeighborList.getBssid())) {
                channel = channel5G;
            }
            if (channel < 1 && reportedApNeighborList.getFreq() == null) {
                a.warn("channel <1 and don't handle, ap mac {}, omadacId={}, siteId={}", new Object[]{com.tplink.smb.omada.common.util.e.a.d((String)deviceMac), omadacId, siteId});
                continue;
            }
            RoamingAp roamingAp = this.c.a(reportedApNeighborList, deviceMac);
            roamingAp = this.a(omadacId, siteId, roamingAp, connectApMacSet);
            RoamingRelatedAp reportAp = new RoamingRelatedAp(deviceMac, roamingAp.getBssid(), channel, reportedApNeighborList.getFreq());
            issuedRoamingApMacs.addAll(this.a(omadacId, siteId, reportAp, roamingAp, Boolean.TRUE.equals(apCap.getSupportAiRoaming()), aiRoamingEnableBySite));
            this.e.a(roamingAp.getApList().size());
        }
        issuedRoamingApMacs.addAll(this.a(omadacId, siteId, deviceMac, reportedBssidList, aiRoamingEnableBySite));
        this.c.a(omadacId, siteId, issuedRoamingApMacs);
    }

    public void a(String omadacId, String siteId, String deviceMac, boolean supportRoamingV2, boolean supportAiRoaming, boolean aiRoamingEnableBySite, List<ReportedProbeClient> probeClientList) {
        if (supportRoamingV2) {
            return;
        }
        if (CollectionUtils.isEmpty(probeClientList)) {
            return;
        }
        HashMap<RoamingRelatedAp, Map> cachedRoamingRelatedApMap = new HashMap<RoamingRelatedAp, Map>();
        HashMap bssid2ProbeClients = new HashMap(128);
        probeClientList.forEach(probeClient -> {
            if (bssid2ProbeClients.containsKey(probeClient.getBssid())) {
                ((Set)bssid2ProbeClients.get(probeClient.getBssid())).add(probeClient);
            } else {
                bssid2ProbeClients.put(probeClient.getBssid(), Sets.newHashSet((Object[])new ReportedProbeClient[]{probeClient}));
            }
        });
        for (Map.Entry bssidEntry : bssid2ProbeClients.entrySet()) {
            String bssid = (String)bssidEntry.getKey();
            RoamingAp roamingAp = this.b.a(omadacId, siteId, bssid);
            if (roamingAp == null) {
                a.debug("First get probe client from mac: {}, request AP Neighbor, omadacId={}, siteId={}", new Object[]{deviceMac, omadacId, siteId});
                this.c.b(omadacId, siteId, deviceMac);
                break;
            }
            if (roamingAp.isRegetingNeighbor()) {
                this.a(omadacId, siteId, bssid);
                continue;
            }
            Set probeClients = (Set)bssidEntry.getValue();
            for (ReportedProbeClient probeClient2 : probeClients) {
                RoamingRelatedAp reportAp = this.c.a(deviceMac, probeClient2);
                if (reportAp == null) continue;
                RoamingClient roamingClient = this.a(omadacId, siteId, probeClient2.getMac(), probeClient2.getSsid(), reportAp);
                if (roamingClient == null || CollectionUtils.isEmpty(roamingClient.getApList())) {
                    a.debug("roamingClient update failed, ap mac {}, omadacId={}, siteId={}", new Object[]{deviceMac, omadacId, siteId});
                    continue;
                }
                Map<String, RoamingRelatedAp> relatedApMap = this.c.a(reportAp, roamingClient.getApList());
                if (cachedRoamingRelatedApMap.computeIfPresent(reportAp, (k, v) -> {
                    v.putAll(relatedApMap);
                    return v;
                }) != null) continue;
                cachedRoamingRelatedApMap.put(reportAp, relatedApMap);
            }
        }
        HashSet<String> roamingApMacsSet = new HashSet<String>();
        cachedRoamingRelatedApMap.forEach((k, v) -> roamingApMacsSet.addAll(this.a(omadacId, siteId, (RoamingRelatedAp)k, (Map<String, RoamingRelatedAp>)v, supportAiRoaming, aiRoamingEnableBySite)));
        this.c.a(omadacId, siteId, roamingApMacsSet);
    }

    @Nonnull
    private RoamingAp a(String omadacId, String siteId, @Nonnull RoamingAp roamingAp, Set<String> apMacSet) {
        if (CollectionUtils.isEmpty(roamingAp.getApList())) {
            return roamingAp;
        }
        ArrayList<RoamingRelatedAp> newApList = new ArrayList<RoamingRelatedAp>(roamingAp.getApList());
        ListIterator<RoamingRelatedAp> each = newApList.listIterator();
        while (each.hasNext()) {
            RoamingRelatedAp roamingRelatedAp = (RoamingRelatedAp)each.next();
            String neighborMac = null;
            String bssid = roamingRelatedAp.getBssid();
            RoamingAp neighborAp = this.b.a(omadacId, siteId, bssid);
            if (neighborAp != null) {
                if (neighborAp.isRegetingNeighbor()) {
                    each.remove();
                    continue;
                }
                neighborMac = neighborAp.getMac();
            }
            RoamingRelatedAp newRoamingRelatedAp = com.tplink.smb.omada.monitor.roaming.b.a.a(roamingRelatedAp, apMacSet);
            if (T.a((String)neighborMac) && newRoamingRelatedAp != null) {
                each.set(newRoamingRelatedAp);
                continue;
            }
            if (!T.a((String)neighborMac) && com.tplink.smb.omada.monitor.roaming.b.a.a(apMacSet, neighborMac)) {
                Integer channel = roamingRelatedAp.getChannel();
                Integer frequency = roamingRelatedAp.getFrequency();
                Long recvTime = roamingRelatedAp.getRecvTime();
                each.set(new RoamingRelatedAp(neighborMac, bssid, channel, recvTime, frequency));
                continue;
            }
            each.remove();
        }
        return new RoamingAp(roamingAp.getMac(), roamingAp.getBssid(), roamingAp.getRegetNeighbor(), newApList);
    }

    private Set<String> a(String omadacId, String siteId, RoamingRelatedAp centerAp, RoamingAp newRoamingAp, boolean supportAiRoaming, boolean aiRoamingEnableBySite) {
        if (newRoamingAp == null) {
            return Sets.newHashSet((Object[])new String[]{centerAp.getMac()});
        }
        this.b.a(omadacId, siteId, newRoamingAp.getBssid(), newRoamingAp);
        a.debug("replaceApNeighborList issue: Center AP {} neighbor list is changed, issue\n{}, omadacId={}, siteId={}", new Object[]{newRoamingAp.getMac(), newRoamingAp, omadacId, siteId});
        this.c.a(omadacId, siteId, newRoamingAp.getMac(), newRoamingAp, supportAiRoaming, aiRoamingEnableBySite, false);
        Set<String> relatedBssidList = com.tplink.smb.omada.monitor.roaming.b.a.a(newRoamingAp);
        Set<String> neighborApMacSet = this.a(omadacId, siteId, centerAp, relatedBssidList, aiRoamingEnableBySite);
        neighborApMacSet.add(newRoamingAp.getMac());
        neighborApMacSet.add(centerAp.getMac());
        return neighborApMacSet;
    }

    private Set<String> a(String omadacId, String siteId, RoamingRelatedAp centerAp, Set<String> relatedBssidList, boolean aiRoamingEnableBySite) {
        if (CollectionUtils.isEmpty(relatedBssidList)) {
            return Sets.newHashSet((Object[])new String[]{centerAp.getMac()});
        }
        HashSet roamingRelatedApMacs = Sets.newHashSet((Object[])new String[]{centerAp.getMac()});
        Set<String> aiRoamingMacs = this.b.c(omadacId, siteId);
        for (String relatedBssid : relatedBssidList) {
            String neighborApMac = this.a(omadacId, siteId, relatedBssid, centerAp, aiRoamingMacs, aiRoamingEnableBySite);
            if (neighborApMac == null) continue;
            roamingRelatedApMacs.add(neighborApMac);
        }
        return roamingRelatedApMacs;
    }

    private String a(String omadacId, String siteId, String relatedBssid, RoamingRelatedAp centerAp, Set<String> aiRoamingMacs, boolean aiRoamingEnableBySite) {
        for (int i = 0; i < 2; ++i) {
            String bssid;
            String mac;
            boolean changed;
            RoamingAp neighborRoamingAp = this.b.a(omadacId, siteId, relatedBssid);
            if (neighborRoamingAp == null) {
                a.debug("Related AP {} not exist, omadacId={}, siteId={}", new Object[]{relatedBssid, omadacId, siteId});
                return null;
            }
            ArrayList<RoamingRelatedAp> newApList = new ArrayList<RoamingRelatedAp>(neighborRoamingAp.getApList());
            RoamingRelatedAp oldRoamingRelatedAp = this.c.a(neighborRoamingAp, centerAp, newApList);
            if (oldRoamingRelatedAp != null) {
                changed = com.tplink.smb.omada.monitor.roaming.b.a.a(centerAp, oldRoamingRelatedAp);
                mac = oldRoamingRelatedAp.getMac();
                bssid = oldRoamingRelatedAp.getBssid();
                Integer channel = centerAp.getChannel();
                Long recvTime = centerAp.getRecvTime();
                Integer freq = centerAp.getFrequency();
                newApList.add(new RoamingRelatedAp(mac, bssid, channel, recvTime, freq));
            } else {
                changed = com.tplink.smb.omada.monitor.roaming.b.a.a(newApList, centerAp);
                a.debug("updateRelatedApNeighborList: changed add new ApNeighbor {}, omadacId={}, siteId={}", new Object[]{changed, omadacId, siteId});
            }
            mac = neighborRoamingAp.getMac();
            bssid = neighborRoamingAp.getBssid();
            int regetNeighbor = neighborRoamingAp.getRegetNeighbor();
            RoamingAp newRoamingAp = new RoamingAp(mac, bssid, regetNeighbor, newApList);
            if (!this.b.a(omadacId, siteId, bssid, neighborRoamingAp, newRoamingAp)) continue;
            if (changed) {
                a.debug("updateRelatedApNeighborList issue: Related AP {} neighbor list is changed, issue {}, omadacId={}, siteId={}", new Object[]{newRoamingAp.getMac(), newRoamingAp, omadacId, siteId});
                this.c.a(omadacId, siteId, mac, newRoamingAp, aiRoamingMacs.contains(mac), aiRoamingEnableBySite, false);
                this.a(regetNeighbor);
                return mac;
            }
            return null;
        }
        a.warn("try clear update list failed, omadac:{}, site:{}, bssid:{}", new Object[]{omadacId, siteId, com.tplink.smb.omada.common.util.e.a.d((String)relatedBssid)});
        return null;
    }

    private Set<String> a(String omadacId, String siteId, @Nonnull RoamingRelatedAp centerAp, Map<String, RoamingRelatedAp> relatedApMap, boolean suppotAiRoaming, boolean aiRoamingEnableBySite) {
        for (int i = 0; i < 2; ++i) {
            int regetNeighbor;
            RoamingAp updatedRoamingAp;
            RoamingAp roamingAp = this.b.a(omadacId, siteId, centerAp.getBssid());
            if (roamingAp == null || roamingAp.getApList() == null) {
                a.warn("roaming neighbor list null, bssid {}, omadacId={}, siteId={}", new Object[]{com.tplink.smb.omada.common.util.e.a.d((String)centerAp.getBssid()), omadacId, siteId});
                return Collections.emptySet();
            }
            if (CollectionUtils.isEmpty(relatedApMap)) {
                return Collections.emptySet();
            }
            ArrayList<RoamingRelatedAp> newRoamingRelatedApList = new ArrayList<RoamingRelatedAp>(roamingAp.getApList());
            boolean changed = this.a(omadacId, siteId, newRoamingRelatedApList, relatedApMap);
            String mac = roamingAp.getMac();
            String bssid = roamingAp.getBssid();
            if (!this.b.a(omadacId, siteId, bssid, roamingAp, updatedRoamingAp = new RoamingAp(mac, bssid, regetNeighbor = roamingAp.getRegetNeighbor(), newRoamingRelatedApList))) continue;
            if (changed) {
                a.debug("updateApNeighborList issue: Center AP {} neighbor list is changed, issue\n{}, omadacId={}, siteId={}", new Object[]{updatedRoamingAp.getMac(), updatedRoamingAp, omadacId, siteId});
                this.c.a(omadacId, siteId, updatedRoamingAp.getMac(), updatedRoamingAp, suppotAiRoaming, aiRoamingEnableBySite, false);
                this.e.b(updatedRoamingAp.getApList().size() - roamingAp.getApList().size());
                return this.a(omadacId, siteId, centerAp, relatedApMap.keySet(), aiRoamingEnableBySite);
            }
            return Collections.emptySet();
        }
        a.warn("try update neighbor list failed, omadac:{}, site:{}, mac:{}", new Object[]{omadacId, siteId, com.tplink.smb.omada.common.util.e.a.d((String)centerAp.getMac())});
        return Collections.emptySet();
    }

    private boolean a(String omadacId, String siteId, @Nonnull List<RoamingRelatedAp> oldRoamingRelatedApList, Map<String, RoamingRelatedAp> relatedApMap) {
        boolean changed = false;
        for (int i = 0; i < oldRoamingRelatedApList.size(); ++i) {
            RoamingRelatedAp existAp = oldRoamingRelatedApList.get(i);
            RoamingRelatedAp newAp = relatedApMap.remove(existAp.getBssid());
            if (newAp == null) continue;
            if (!Objects.equals(newAp.getChannel(), existAp.getChannel()) || !Objects.equals(newAp.getFrequency(), existAp.getFrequency())) {
                a.debug("updateApNeighborList: changed- channel for bssid: {}, old channel: {}, new channel: {}, omadacId={}, siteId={}", new Object[]{newAp.getBssid(), existAp.getChannel(), newAp.getChannel(), omadacId, siteId});
                changed = true;
            }
            oldRoamingRelatedApList.set(i, newAp);
        }
        for (RoamingRelatedAp unhandledRoamingRelatedAp : relatedApMap.values()) {
            if (!com.tplink.smb.omada.monitor.roaming.b.a.a(oldRoamingRelatedApList, unhandledRoamingRelatedAp)) continue;
            a.debug("updateApNeighborList: changed- add new ApNeighbor {}, omadacId={}, siteId={}", new Object[]{unhandledRoamingRelatedAp.getBssid(), omadacId, siteId});
            changed = true;
        }
        return changed;
    }

    private void a(String omadacId, String siteId, @Nonnull String bssid) {
        for (int i = 0; i < 2; ++i) {
            List<RoamingRelatedAp> apList;
            int regetNeighbor;
            RoamingAp roamingAp = this.b.a(omadacId, siteId, bssid);
            if (roamingAp == null) {
                return;
            }
            if (!roamingAp.isRegetingNeighbor()) {
                return;
            }
            String mac = roamingAp.getMac();
            RoamingAp newRoamingAp = new RoamingAp(mac, bssid, regetNeighbor = roamingAp.getRegetNeighbor() - 1, apList = roamingAp.getApList());
            if (!this.b.a(omadacId, siteId, bssid, roamingAp, newRoamingAp)) continue;
            return;
        }
    }

    @Nullable
    private RoamingClient a(String omadacId, String siteId, String clientMac, String ssid, RoamingRelatedAp reportAp) {
        RoamingClient roamingClient = this.f.a(omadacId, siteId, clientMac, ssid);
        ArrayList<RoamingRelatedAp> newRelatedApList = new ArrayList<RoamingRelatedAp>();
        if (roamingClient == null) {
            newRelatedApList.add(reportAp);
            RoamingClient newRoamingClient = new RoamingClient(clientMac, ssid, newRelatedApList);
            this.f.a(omadacId, siteId, clientMac, ssid, newRoamingClient);
            return newRoamingClient;
        }
        newRelatedApList.addAll(roamingClient.getApList());
        this.a(newRelatedApList, reportAp);
        roamingClient.setApList(newRelatedApList);
        this.f.a(omadacId, siteId, clientMac, ssid, roamingClient);
        return roamingClient;
    }

    private void a(List<RoamingRelatedAp> apList, RoamingRelatedAp newRelatedAp) {
        if (apList == null) {
            return;
        }
        apList.stream().filter(roamingRelatedAp -> roamingRelatedAp.getRecvTime() > System.currentTimeMillis() - 60000L).forEach(existAp -> {
            if (com.tplink.smb.omada.monitor.roaming.b.a.c(existAp, newRelatedAp)) {
                if (!Objects.equals(newRelatedAp.getChannel(), existAp.getChannel())) {
                    a.debug("Probe Client neighbor Ap change- channel ");
                }
                existAp.setChannel(newRelatedAp.getChannel());
                existAp.setMac(newRelatedAp.getMac());
                existAp.setRecvTime(newRelatedAp.getRecvTime());
            }
        });
        if (apList.size() < 12) {
            apList.add(newRelatedAp);
            a.debug("Probe Client neighbor Ap change- add new");
        } else {
            this.b(apList, newRelatedAp);
            a.debug("Probe Client neighbor Ap change- updateOldest neighbor Ap");
        }
    }

    private void b(List<RoamingRelatedAp> apList, RoamingRelatedAp relatedAp) {
        int oldestIndex = 0;
        if (CollectionUtils.isEmpty(apList)) {
            apList.add(relatedAp);
            a.debug("updateOldest: add new");
        } else {
            Long oldestRecvTime = apList.get(oldestIndex).getRecvTime();
            for (int i = 1; i < apList.size(); ++i) {
                Long recvTime = apList.get(i).getRecvTime();
                if (recvTime >= oldestRecvTime) continue;
                oldestIndex = i;
                oldestRecvTime = recvTime;
            }
            if (W.b((long)oldestRecvTime, (int)40)) {
                apList.set(oldestIndex, relatedAp);
                a.debug("updateOldestAp: replace oldest neighbor Ap");
            }
        }
    }

    private Set<String> a(String omadacId, String siteId, String deviceMac, Set<String> reportedBssidList, boolean aiRoamingEnableBySite) {
        Set<String> oldBssidList = this.b.d(omadacId, siteId, deviceMac);
        if (CollectionUtils.isEmpty(oldBssidList)) {
            return Collections.emptySet();
        }
        HashSet<String> needRemovedBssidSet = new HashSet<String>();
        for (String oldBssid : oldBssidList) {
            if (reportedBssidList.contains(oldBssid)) continue;
            needRemovedBssidSet.add(oldBssid);
        }
        this.b.b(omadacId, siteId, needRemovedBssidSet);
        return this.a(omadacId, siteId, needRemovedBssidSet, aiRoamingEnableBySite);
    }

    private Set<String> a(String omadacId, String siteId, Set<String> needRemovedBssidSet, boolean aiRoamingEnableBySite) {
        Set<String> relevantBssids = this.c.b(omadacId, siteId, needRemovedBssidSet);
        if (CollectionUtils.isEmpty(relevantBssids)) {
            return Collections.emptySet();
        }
        Set<String> aiRoamingMacs = this.b.c(omadacId, siteId);
        HashSet<String> roamingRelatedApMacs = new HashSet<String>();
        for (String relevantBssid : relevantBssids) {
            String apMac = this.a(omadacId, siteId, relevantBssid, needRemovedBssidSet, aiRoamingMacs, aiRoamingEnableBySite);
            if (apMac == null) continue;
            roamingRelatedApMacs.add(apMac);
        }
        return roamingRelatedApMacs;
    }

    private String a(String omadacId, String siteId, String relevantBssid, Set<String> invalidBssids, Set<String> aiRoamingMacs, boolean aiRoamingEnableBySite) {
        if (relevantBssid == null || CollectionUtils.isEmpty(invalidBssids)) {
            return null;
        }
        for (int i = 0; i < 2; ++i) {
            int regetNeighbor;
            RoamingAp newRoamingAp;
            RoamingAp roamingAp = this.b.a(omadacId, siteId, relevantBssid);
            if (roamingAp == null || CollectionUtils.isEmpty(roamingAp.getApList())) {
                return null;
            }
            ArrayList<RoamingRelatedAp> newApList = new ArrayList<RoamingRelatedAp>(roamingAp.getApList());
            boolean isRemoved = false;
            ListIterator each = newApList.listIterator();
            while (each.hasNext()) {
                if (!invalidBssids.contains(((RoamingRelatedAp)each.next()).getBssid())) continue;
                each.remove();
                isRemoved = true;
                break;
            }
            if (!isRemoved) {
                return null;
            }
            String mac = roamingAp.getMac();
            String bssid = roamingAp.getBssid();
            if (!this.b.a(omadacId, siteId, bssid, roamingAp, newRoamingAp = new RoamingAp(mac, bssid, regetNeighbor = roamingAp.getRegetNeighbor(), newApList))) continue;
            a.debug("updateRelatedApNeighborList issue: Related AP {} neighbor list is changed, issue {}, omadacId={}, siteId={}", new Object[]{newRoamingAp.getMac(), newRoamingAp, omadacId, siteId});
            this.c.a(omadacId, siteId, newRoamingAp.getMac(), newRoamingAp, aiRoamingMacs.contains(mac), aiRoamingEnableBySite, false);
            return newRoamingAp.getMac();
        }
        return null;
    }

    private void a(int regetNeighbor) {
        if (regetNeighbor > 0) {
            this.e.a(1);
        } else {
            this.e.b(1);
        }
    }
}

