/*
 * Decompiled with CFR 0.152.
 */
package com.tplink.smb.omada.monitor.roaming;

import com.google.common.util.concurrent.ThreadFactoryBuilder;
import com.tplink.smb.omada.monitor.roaming.RoamingProperties;
import com.tplink.smb.omada.monitor.roaming.b;
import com.tplink.smb.omada.monitor.roaming.port.a.a;
import io.micrometer.core.instrument.MeterRegistry;
import io.micrometer.core.instrument.Tag;
import io.micrometer.core.instrument.binder.jvm.ExecutorServiceMetrics;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Lazy;

@Configuration(proxyBeanMethods=false)
@EnableConfigurationProperties(value={RoamingProperties.class})
public class RoamingExecutorConfiguration {
    @Autowired
    @Lazy
    private a a;
    @Autowired
    private MeterRegistry b;
    @Autowired
    private RoamingProperties c;

    @Lazy
    @Bean(name={"roamingWorkGroup"})
    @ConditionalOnMissingBean(name={"roamingWorkGroup"})
    public ExecutorService roamingWorkGroup() {
        int coreSize = this.c.getCoreSize();
        int queueSize = this.c.getQueueSize();
        String poolName = "monitor-roaming-pool";
        ThreadPoolExecutor executor = new ThreadPoolExecutor(coreSize, coreSize, 2L, TimeUnit.MINUTES, new LinkedBlockingQueue<Runnable>(queueSize), new ThreadFactoryBuilder().setNameFormat(poolName + "-%d").build(), new com.tplink.smb.omada.monitor.roaming.a(this, poolName));
        executor.allowCoreThreadTimeOut(true);
        return ExecutorServiceMetrics.monitor((MeterRegistry)this.b, (ExecutorService)executor, (String)poolName, (String)"executor_metric", (Tag[])new Tag[0]);
    }

    @Lazy
    @Bean(name={"aiRoamingWorkGroup"})
    @ConditionalOnMissingBean(name={"aiRoamingWorkGroup"})
    public ExecutorService aiRoamingWorkGroup() {
        int coreSize = this.c.getAiCoreSize();
        String poolName = "monitor-schedule-ai-roaming-pool";
        ThreadPoolExecutor executor = new ThreadPoolExecutor(coreSize, coreSize, 10L, TimeUnit.MILLISECONDS, new LinkedBlockingQueue<Runnable>(this.c.getAiQueueSize()), new ThreadFactoryBuilder().setNameFormat(poolName + "-%d").build(), new b(this, poolName));
        executor.allowCoreThreadTimeOut(true);
        return ExecutorServiceMetrics.monitor((MeterRegistry)this.b, (ExecutorService)executor, (String)poolName, (String)"executor_metric", (Tag[])new Tag[0]);
    }
}

