/*
 * Decompiled with CFR 0.152.
 */
package com.tplink.smb.omada.dispatcher.common.util;

import com.tplink.smb.omada.dispatcher.common.util.StringUtils;
import java.net.URI;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.RequestEntity;
import org.springframework.util.CollectionUtils;
import org.springframework.util.MultiValueMap;
import org.springframework.web.util.UriComponents;
import org.springframework.web.util.UriComponentsBuilder;

public class XSSAttackUtils {
    private static final Logger log = LoggerFactory.getLogger(XSSAttackUtils.class);
    private static final Pattern BETWEEN_SCRIPT_PATTERN = Pattern.compile("<script>(.*?)</script>", 2);
    private static final Pattern SRC_PATTERN_SINGLE_QUOTE = Pattern.compile("src[\r\n]*=[\r\n]*\\'(.*?)\\'", 42);
    private static final Pattern SRC_PATTERN_DOUBLE_QUOTES = Pattern.compile("src[\r\n]*=[\r\n]*\\\"(.*?)\\\"", 42);
    private static final Pattern RIGHT_SCRIPT_PATTERN = Pattern.compile("</script>", 2);
    private static final Pattern LEFT_SCRIPT_PATTERN = Pattern.compile("<script(.*?)>", 42);
    private static final Pattern EVAL_PATTERN = Pattern.compile("eval\\((.*?)\\)", 42);
    private static final Pattern EXPRESSION_PATTERN = Pattern.compile("expression\\((.*?)\\)", 42);
    private static final Pattern JAVASCRIPT_PATTERN = Pattern.compile("javascript:", 2);
    private static final Pattern VBSCRIPT_PATTERN = Pattern.compile("vbscript:", 2);
    private static final Pattern ONLOAD_PATTERN = Pattern.compile("onload(.*?)=", 42);
    private static final Pattern BETWEEN_IFRAME_PATTERN = Pattern.compile("<(iframe|html|title|td|b)>(.*?)</(iframe|html|title|td|b)>", 2);
    private static final Pattern RIGHT_IFRAME_PATTERN = Pattern.compile("</(iframe|html|title|td|b)>", 2);
    private static final Pattern LEFT_IFRAME_PATTERN = Pattern.compile("<(iframe|html|title|td|b)(.*?)>", 42);

    public static boolean containXSS(RequestEntity<String> request) {
        String body = (String)request.getBody();
        if (XSSAttackUtils.containXSS(body)) {
            log.warn("Request body contain xss attack.");
            return true;
        }
        UriComponents uriComponents = UriComponentsBuilder.fromUri((URI)request.getUrl()).build();
        MultiValueMap queryParams = uriComponents.getQueryParams();
        if (!XSSAttackUtils.validateParameter((Map<String, List<String>>)queryParams)) {
            log.warn("Request parameter contain xss attack.");
            return true;
        }
        return false;
    }

    public static boolean validateParameter(Map<String, List<String>> paramMap) {
        boolean valid = true;
        if (CollectionUtils.isEmpty(paramMap)) {
            return true;
        }
        for (String key : paramMap.keySet()) {
            List<String> values = paramMap.get(key);
            if (CollectionUtils.isEmpty(values)) continue;
            for (String value : values) {
                valid = !XSSAttackUtils.containXSS(value);
            }
        }
        return valid;
    }

    public static boolean containXSS(String value) {
        boolean containXSS = false;
        if (!StringUtils.isNull(value)) {
            containXSS = BETWEEN_SCRIPT_PATTERN.matcher(value).find() || SRC_PATTERN_SINGLE_QUOTE.matcher(value).find() || SRC_PATTERN_DOUBLE_QUOTES.matcher(value).find() || RIGHT_SCRIPT_PATTERN.matcher(value).find() || LEFT_SCRIPT_PATTERN.matcher(value).find() || EVAL_PATTERN.matcher(value).find() || EXPRESSION_PATTERN.matcher(value).find() || JAVASCRIPT_PATTERN.matcher(value).find() || VBSCRIPT_PATTERN.matcher(value).find() || ONLOAD_PATTERN.matcher(value).find() || BETWEEN_IFRAME_PATTERN.matcher(value).find() || RIGHT_IFRAME_PATTERN.matcher(value).find() || LEFT_IFRAME_PATTERN.matcher(value).find();
        }
        return containXSS;
    }

    private XSSAttackUtils() {
    }
}

