/*
 * Decompiled with CFR 0.152.
 */
package com.tplink.smb.omada.dispatcher.common.util;

import com.tplink.smb.omada.dispatcher.common.util.StringUtils;
import jakarta.annotation.Nullable;
import java.util.Optional;

public abstract class UserIpUtils {
    private static final ThreadLocal<String> USER_IP_ADDR = new ThreadLocal();
    private static final ThreadLocal<String> OPEN_API_ADDR = new ThreadLocal();

    public static Optional<String> getLocalUserIp() {
        String ip = USER_IP_ADDR.get();
        if (StringUtils.isNull(ip)) {
            return Optional.ofNullable("");
        }
        return Optional.ofNullable(ip);
    }

    public static Optional<String> getOpenApiIp() {
        return Optional.ofNullable(OPEN_API_ADDR.get());
    }

    public static void setLocalUserIp(@Nullable String ip) {
        USER_IP_ADDR.set(ip);
    }

    public static void setOpenApiAddr(@Nullable String ip) {
        OPEN_API_ADDR.set(ip);
    }
}

