/*
 * Decompiled with CFR 0.152.
 */
package com.tplink.smb.omada.dispatcher.common.util;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.JsonToken;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.module.SimpleModule;
import com.tplink.smb.omada.dispatcher.common.util.StringUtils;
import jakarta.annotation.Nonnull;
import java.io.IOException;
import java.lang.reflect.Type;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.json.JSONArray;
import org.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.lang.Nullable;

public final class JsonUtils {
    private static final Logger log = LoggerFactory.getLogger(JsonUtils.class);
    private static final String EXCEPTION_LOG_PATTERN = "parse json exception. json: {}";
    private static final ObjectMapper MAPPER = new ObjectMapper();
    public static final ObjectMapper OBJECT_MAPPER = new ObjectMapper();

    public static ObjectMapper getMapper() {
        return MAPPER;
    }

    @Nullable
    public static String bean2Json(Object object) {
        try {
            return MAPPER.writeValueAsString(object);
        }
        catch (JsonProcessingException e) {
            log.warn("fail to transfer bean to Json. object: {}", object, (Object)e);
            return null;
        }
    }

    @Nullable
    public static <T> T json2bean(String json, Class<T> clazz) {
        try {
            return (T)MAPPER.readValue(json, clazz);
        }
        catch (IOException e) {
            log.warn(EXCEPTION_LOG_PATTERN, (Object)json, (Object)e);
            return null;
        }
    }

    @Nullable
    public static <T> T json2bean(String json, TypeReference<T> typeReference) {
        try {
            return (T)MAPPER.readValue(json, typeReference);
        }
        catch (IOException e) {
            log.warn(EXCEPTION_LOG_PATTERN, (Object)json, (Object)e);
            return null;
        }
    }

    @Nullable
    public static <T> List<T> json2list(String json, Class<T> clazz) {
        JavaType type = JsonUtils.getCollectionType(List.class, clazz);
        try {
            return (List)MAPPER.readValue(json, type);
        }
        catch (IOException e) {
            log.warn("fail to transfer json to list. json: {}", (Object)json, (Object)e);
            return null;
        }
    }

    @Nullable
    public static <T> Set<T> json2set(String json, Class<T> clazz) {
        JavaType type = JsonUtils.getCollectionType(Set.class, clazz);
        try {
            return (Set)MAPPER.readValue(json, type);
        }
        catch (IOException e) {
            log.warn("fail to transfer json to set. json: {}", (Object)json, (Object)e);
            return null;
        }
    }

    public static JavaType getCollectionType(Class<?> collectionClass, Class<?> elementClass) {
        return MAPPER.getTypeFactory().constructParametricType(collectionClass, new Class[]{elementClass});
    }

    @Nullable
    public static Map<String, Object> json2Map(String json) {
        TypeReference<Map<String, Object>> typeRef = new TypeReference<Map<String, Object>>(){};
        try {
            return (Map)MAPPER.readValue(json, (TypeReference)typeRef);
        }
        catch (IOException e) {
            log.warn("fail to transfer json to map. json: {}", (Object)json, (Object)e);
            return null;
        }
    }

    @Nullable
    public static Map<String, Long> json2MapLong(String json) {
        TypeReference<Map<String, Long>> typeRef = new TypeReference<Map<String, Long>>(){};
        try {
            return (Map)MAPPER.readValue(json, (TypeReference)typeRef);
        }
        catch (IOException e) {
            log.warn("fail to transfer json to map. json: {}", (Object)json, (Object)e);
            return null;
        }
    }

    public static <T> T object2bean(Object o, Class<?> clazz) {
        return (T)MAPPER.convertValue(o, clazz);
    }

    @Nullable
    public static <T> T parseJsonStr(String json, String key, Class<T> valueType) {
        if (key != null) {
            try {
                JsonNode jsonNode = JsonUtils.getMapper().readTree(json).findPath(key);
                json = jsonNode.toString();
            }
            catch (IOException e) {
                log.warn("parse json.key exception. json: {}, key: {}", new Object[]{json, key, e});
                return null;
            }
        }
        Object parseObj = null;
        try {
            parseObj = JsonUtils.getMapper().readValue(json, valueType);
        }
        catch (IOException e) {
            log.warn(EXCEPTION_LOG_PATTERN, (Object)json, (Object)e);
        }
        return (T)parseObj;
    }

    @Nullable
    public static JsonNode readTree(String json) {
        try {
            return JsonUtils.getMapper().readTree(json);
        }
        catch (IOException e) {
            log.warn(EXCEPTION_LOG_PATTERN, (Object)json, (Object)e);
            return null;
        }
    }

    @Nullable
    public static <T> T json2bean(String json, Type type) {
        try {
            return (T)MAPPER.readValue(json, MAPPER.constructType(type));
        }
        catch (IOException e) {
            log.warn("fail to transfer json to list. json: {}", (Object)json, (Object)e);
            return null;
        }
    }

    public static boolean checkJson(String str) {
        if (StringUtils.isNull(str)) {
            return false;
        }
        return str.startsWith("{") && str.endsWith("}") || str.startsWith("[") && str.endsWith("]");
    }

    public static <T> T obj2Obj(Object fromObj, Class<T> clazz) {
        return (T)OBJECT_MAPPER.convertValue(fromObj, clazz);
    }

    @Nullable
    public static JsonNode json2JsonNode(String jsonStr) {
        try {
            return OBJECT_MAPPER.readTree(jsonStr);
        }
        catch (IOException e) {
            JsonUtils.logParseException(e);
            return null;
        }
    }

    @Nonnull
    public static String pojo2Json(Object obj) {
        String jsonStr = "";
        try {
            jsonStr = OBJECT_MAPPER.writeValueAsString(obj);
        }
        catch (JsonProcessingException e) {
            JsonUtils.logParseException((IOException)((Object)e));
        }
        return jsonStr;
    }

    public static JSONObject fromObject(Object origin) {
        if (origin == null) {
            return null;
        }
        if (origin instanceof Map) {
            return new JSONObject((Map)origin);
        }
        if (origin instanceof String) {
            return new JSONObject((String)origin);
        }
        if (origin instanceof JSONObject) {
            return new JSONObject(((JSONObject)origin).toMap());
        }
        return new JSONObject(origin);
    }

    private static void logParseException(IOException e) {
        log.error("Parse json message exception.", (Throwable)e);
    }

    private JsonUtils() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }

    static {
        OBJECT_MAPPER.configure(JsonParser.Feature.ALLOW_SINGLE_QUOTES, true);
        OBJECT_MAPPER.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
        OBJECT_MAPPER.setSerializationInclusion(JsonInclude.Include.NON_NULL);
        SimpleModule module = new SimpleModule();
        module.addSerializer(JSONObject.class, (JsonSerializer)new JsonSerializer<JSONObject>(){

            public void serialize(JSONObject value, JsonGenerator gen, SerializerProvider serializers) throws IOException {
                gen.writeRawValue(value.toString());
            }
        });
        module.addSerializer(JSONArray.class, (JsonSerializer)new JsonSerializer<JSONArray>(){

            public void serialize(JSONArray value, JsonGenerator gen, SerializerProvider serializers) throws IOException {
                gen.writeRawValue(value.toString());
            }
        });
        module.addDeserializer(JSONObject.class, (JsonDeserializer)new JsonDeserializer<JSONObject>(){

            public JSONObject deserialize(JsonParser p, DeserializationContext ctxt) throws IOException {
                JsonToken currentToken = p.getCurrentToken();
                if (currentToken == JsonToken.START_OBJECT) {
                    Map map = (Map)p.readValueAs(Map.class);
                    return new JSONObject(map);
                }
                return (JSONObject)ctxt.handleUnexpectedToken(JSONObject.class, p);
            }
        });
        module.addDeserializer(JSONArray.class, (JsonDeserializer)new JsonDeserializer<JSONArray>(){

            public JSONArray deserialize(JsonParser p, DeserializationContext ctxt) throws IOException {
                JsonToken currentToken = p.getCurrentToken();
                if (currentToken == JsonToken.START_ARRAY) {
                    List list = (List)p.readValueAs(List.class);
                    return new JSONArray((Collection)list);
                }
                return (JSONArray)ctxt.handleUnexpectedToken(JSONArray.class, p);
            }
        });
        MAPPER.registerModule((Module)module);
        MAPPER.configure(DeserializationFeature.ACCEPT_EMPTY_STRING_AS_NULL_OBJECT, true);
        MAPPER.configure(JsonParser.Feature.ALLOW_UNQUOTED_CONTROL_CHARS, true);
        MAPPER.configure(DeserializationFeature.ACCEPT_SINGLE_VALUE_AS_ARRAY, true);
        MAPPER.configure(SerializationFeature.INDENT_OUTPUT, false);
        MAPPER.configure(SerializationFeature.FAIL_ON_EMPTY_BEANS, false);
        MAPPER.configure(SerializationFeature.WRITE_EMPTY_JSON_ARRAYS, true);
        MAPPER.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
    }
}

