/*
 * Decompiled with CFR 0.152.
 */
package com.tplink.smb.omada.dispatcher.common.util;

import com.tplink.smb.omada.dispatcher.common.error.DispatcherException;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.io.File;
import java.io.IOException;
import java.util.UUID;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.StringUtils;

public abstract class CreateTmpFileUtils {
    private static final Logger log = LoggerFactory.getLogger(CreateTmpFileUtils.class);
    public static final String TMP_DIR_PROPERTY = System.getProperty("java.io.tmpdir");

    private CreateTmpFileUtils() {
    }

    @Nonnull
    public static File createTmpFile(@Nullable String tmpDirPath) throws IOException {
        File tmpDir = new File(StringUtils.hasText((String)tmpDirPath) ? tmpDirPath : TMP_DIR_PROPERTY);
        if (!tmpDir.exists() || !tmpDir.isDirectory() || tmpDir.mkdirs()) {
            log.warn("tmp dir {} is not available to use", (Object)tmpDir);
            throw new DispatcherException("tmp dir: " + tmpDir + " is not available");
        }
        File file = new File(tmpDir.getPath() + File.separator + UUID.randomUUID() + ".tmp");
        for (int i = 1; i < 10 && file.exists(); ++i) {
            file = new File(tmpDir.getPath() + File.separator + UUID.randomUUID() + ".tmp");
        }
        if (file.exists() || !file.createNewFile()) {
            log.warn("Failed to create temp file for gRPC multipart file");
            throw new DispatcherException("Failed to create temp file for gRPC multipart file");
        }
        File inUse = file;
        inUse.deleteOnExit();
        return inUse;
    }
}

