/*
 * Decompiled with CFR 0.152.
 */
package com.tplink.smb.omada.dispatcher.common.util;

import com.google.common.collect.ImmutableMap;
import com.tplink.smb.omada.dispatcher.common.util.URLEncoderUtils;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;

public abstract class CollectionCommonUtils {
    private CollectionCommonUtils() {
    }

    public static String convertSetToString(Set<String> source) {
        String DELIMITER = ",";
        if (source == null) {
            return null;
        }
        if (source.size() == 0) {
            return "";
        }
        StringBuilder sb = new StringBuilder();
        int i = 0;
        for (String s : source) {
            if (i > 0) {
                sb.append(DELIMITER);
            }
            sb.append(s);
            ++i;
        }
        return sb.toString();
    }

    public static <T> List<T> iterable2List(Iterable<T> ti) {
        if (ti == null) {
            return Collections.emptyList();
        }
        ArrayList<T> tList = new ArrayList<T>();
        Iterator<T> iterator = ti.iterator();
        while (iterator.hasNext()) {
            tList.add(iterator.next());
        }
        return tList;
    }

    public static <K, V> Map<K, V> immutableMap2HashMap(ImmutableMap<K, V> immutableMap) {
        HashMap map = new HashMap(16);
        if (immutableMap == null) {
            return map;
        }
        for (Map.Entry entry : immutableMap.entrySet()) {
            map.put(entry.getKey(), entry.getValue());
        }
        return map;
    }

    public static Map<String, Object> convertRequestParamsToMap(Map<String, List<String>> paramMap) {
        LinkedHashMap<String, Object> result = new LinkedHashMap<String, Object>();
        for (Map.Entry<String, List<String>> entry : paramMap.entrySet()) {
            String paramKey = entry.getKey();
            List<String> paramValue = entry.getValue();
            String[] keys = paramKey.split("\\.");
            if (keys.length > 1) {
                Map<String, Object> currentMap = (LinkedHashMap<String, Object>)result.get(keys[0]);
                if (currentMap == null) {
                    currentMap = new LinkedHashMap<String, Object>();
                    result.put(keys[0], currentMap);
                }
                for (int i = 0; i <= keys.length - 2; ++i) {
                    String nextKey = keys[i + 1];
                    if (i + 1 == keys.length - 1) {
                        currentMap.put(nextKey, CollectionCommonUtils.decodeReqParamValue(paramValue));
                        continue;
                    }
                    currentMap = (Map)currentMap.computeIfAbsent(nextKey, key -> new LinkedHashMap());
                }
                continue;
            }
            result.put(keys[0], CollectionCommonUtils.decodeReqParamValue(paramValue));
        }
        return result;
    }

    private static Object decodeReqParamValue(List<String> paramValue) {
        if (paramValue.size() == 1) {
            return URLEncoderUtils.decode(paramValue.get(0));
        }
        return paramValue.stream().map(URLEncoderUtils::decode).collect(Collectors.toList());
    }

    public static List<String> transformIds(List<String> oldIds, Map<String, String> map) {
        ArrayList<String> newIds = new ArrayList<String>(oldIds.size());
        for (String oldId : oldIds) {
            newIds.add(map.get(oldId));
        }
        return newIds;
    }

    public static <T> List<T> createIfNullThenAdd(List<T> old, Object value) {
        if (old == null) {
            old = new ArrayList<T>();
        }
        old.add(value);
        return old;
    }
}

