/*
 * Decompiled with CFR 0.152.
 */
package com.tplink.smb.omada.dispatcher.common.util;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.multipart.MultipartFile;

public class BytesMultiPartFile
implements MultipartFile {
    private static final Logger log = LoggerFactory.getLogger(BytesMultiPartFile.class);
    private final String name;
    private final String originFileName;
    private final String contentType;
    private final byte[] content;
    private final long size;
    private final InputStream inputStream;

    public BytesMultiPartFile(String name, String fileName, String contentType, byte[] content) {
        this.name = name;
        this.originFileName = fileName;
        this.contentType = contentType;
        this.content = content != null ? content : new byte[0];
        this.size = this.content.length;
        this.inputStream = new ByteArrayInputStream(this.content);
    }

    public String getName() {
        return this.name;
    }

    public String getOriginalFilename() {
        return this.originFileName;
    }

    public String getContentType() {
        return this.contentType;
    }

    public boolean isEmpty() {
        return this.size == 0L;
    }

    public long getSize() {
        return this.size;
    }

    public byte[] getBytes() throws IOException {
        return this.content;
    }

    public InputStream getInputStream() throws IOException {
        return this.inputStream;
    }

    public void transferTo(File dest) throws IOException, IllegalStateException {
        if (dest.exists() && !dest.delete()) {
            throw new IOException("Destination file [" + dest.getAbsolutePath() + "] already exists and could not be deleted");
        }
        try (FileOutputStream destOutput = new FileOutputStream(dest);){
            destOutput.write(this.content);
        }
        catch (IOException ex) {
            log.warn("File content transfer failed.");
            throw ex;
        }
    }
}

