/*
 * Decompiled with CFR 0.152.
 */
package com.tplink.smb.omada.dispatcher.common.multipartfile;

import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.Paths;
import org.apache.commons.io.input.NullInputStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.FileCopyUtils;
import org.springframework.web.multipart.MultipartFile;

public class DiskMultipartFile
implements MultipartFile {
    private static final Logger log = LoggerFactory.getLogger(DiskMultipartFile.class);
    private final String name;
    private final String originFileName;
    private final String contentType;
    @Nonnull
    private final File file;
    @Nullable
    private FileInputStream inputStream;

    public DiskMultipartFile(String name, String originFileName, String contentType, @Nonnull File file) throws IOException {
        this.name = name;
        this.originFileName = originFileName;
        this.contentType = contentType;
        this.file = file;
    }

    @Nonnull
    public String getName() {
        return this.name;
    }

    public String getOriginalFilename() {
        return this.originFileName;
    }

    public String getContentType() {
        return this.contentType;
    }

    public boolean isEmpty() {
        if (!this.file.exists()) {
            return true;
        }
        return this.file.length() == 0L;
    }

    public long getSize() {
        return this.file.length();
    }

    public String getPath() {
        return this.file.getPath();
    }

    public void delete() throws IOException {
        if (this.inputStream != null) {
            this.inputStream.close();
        }
        Files.delete(Paths.get(this.file.getPath(), new String[0]));
    }

    @Nonnull
    public byte[] getBytes() throws IOException {
        log.warn("Reading {} bytes to memory. Note: should not use this method to read all file bytes to memory.", (Object)this.file.length());
        return FileCopyUtils.copyToByteArray((File)this.file);
    }

    @Nonnull
    public synchronized InputStream getInputStream() throws FileNotFoundException {
        if (this.isEmpty()) {
            return new NullInputStream();
        }
        if (this.inputStream == null) {
            this.inputStream = new FileInputStream(this.file);
        }
        return this.inputStream;
    }

    public void transferTo(File dest) throws IOException, IllegalStateException {
        if (dest.exists() && !dest.delete()) {
            throw new IOException("Destination file [" + dest.getAbsolutePath() + "] already exists and could not be deleted");
        }
        FileCopyUtils.copy((File)this.file, (File)dest);
    }
}

