/*
 * Decompiled with CFR 0.152.
 */
package com.tplink.smb.omada.dispatcher.common.error;

import jakarta.annotation.Nullable;

public enum HttpRespCode {
    OK(200, "Success."),
    MULTI_CHOICES(300, "Multi Choices."),
    MOVED_PERMANENTLY(301, "Moved Permanently."),
    REDIRECT(302, "Redirect."),
    NOT_FOUND(404, "Not found.");

    private final int respCode;
    private final String msg;

    public String toString() {
        return this.respCode + " " + this.name();
    }

    public int getStatusCode() {
        return this.respCode;
    }

    public String getMsg() {
        return this.msg;
    }

    private HttpRespCode(int respCode, String msg) {
        this.respCode = respCode;
        this.msg = msg;
    }

    @Nullable
    public static HttpRespCode valueOf(int httpRespCode) {
        HttpRespCode[] httpRespCodes;
        for (HttpRespCode respCode : httpRespCodes = HttpRespCode.values()) {
            if (respCode.getStatusCode() != httpRespCode) continue;
            return respCode;
        }
        return null;
    }
}

