/*
 * Decompiled with CFR 0.152.
 */
package com.tplink.smb.omada.dispatcher.common.access;

import com.tplink.smb.omada.dispatcher.common.error.ErrorCode;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;

public class OperationResponse<T> {
    public static final OperationResponse<Object> SUCCESS = new OperationResponse(0, "Success.");
    public static final OperationResponse<Object> GENERAL_ERROR = new OperationResponse(-1, "General error.");
    public static final OperationResponse<Object> PARAM_ERROR = new OperationResponse(-1001, "Invalid request parameters.");
    public static final OperationResponse<Object> DB_OPT_FAILED = new OperationResponse(-1100, "DB operation failed.");
    public static final OperationResponse<Object> INTERNAL_SERVER_ERROR = new OperationResponse(-1500, "Omada Cloud Server error.");
    public static final OperationResponse<Object> PLATFORM_SERVER_ERROR = new OperationResponse(-1501, "Omada Cloud Platform error.");
    public static final OperationResponse<Object> SERVICE_UNAVAILABLE = new OperationResponse(-1503, "Service unavailable.");
    public static final OperationResponse<Object> UNSUPPORTED_HTTP_PATH = new OperationResponse(-1600, "Unsupported request path.");
    public static final OperationResponse<Object> REQUEST_CONTAIN_XSS = new OperationResponse(-1610, "Request parameter contains XSS attack.");
    public static final OperationResponse<Object> SYSTEM_BUSY = new OperationResponse(-30028, "The system is busy. Please try again later.");
    private int errorCode;
    private String msg;
    private T result;

    public OperationResponse(ErrorCode errorCode) {
        this.errorCode = errorCode.getErrCode();
        this.msg = errorCode.getErrMsg();
        this.result = null;
    }

    public OperationResponse(OperationResponse<T> operationResponse) {
        this.errorCode = operationResponse.getErrorCode();
        this.msg = operationResponse.getMsg();
        this.result = operationResponse.getResult();
    }

    public OperationResponse(ErrorCode errorCode, T result) {
        this.errorCode = errorCode.getErrCode();
        this.msg = errorCode.getErrMsg();
        this.result = result;
    }

    public OperationResponse(ErrorCode errorCode, String msg, T result) {
        this.errorCode = errorCode.getErrCode();
        this.msg = msg;
        this.result = result;
    }

    public OperationResponse(int errorCode, String msg) {
        this.errorCode = errorCode;
        this.msg = msg;
        this.result = null;
    }

    public static <T> OperationResponse<T> success(T body) {
        return new OperationResponse<T>(0, "OK", body);
    }

    public static <T> OperationResponse<T> ok() {
        return new OperationResponse<Object>(0, "OK", null);
    }

    public static <T> OperationResponse<T> error(ErrorCode errorCode) {
        return new OperationResponse<T>(errorCode.getErrCode(), errorCode.getErrMsg());
    }

    public static <T> OperationResponse<T> error(ErrorCode errorCode, T t) {
        return new OperationResponse<T>(errorCode.getErrCode(), errorCode.getErrMsg(), t);
    }

    public boolean success() {
        return 0 == this.errorCode;
    }

    public <R> OperationResponse<R> map(Function<T, R> function) {
        if (this.success() && this.result != null) {
            return new OperationResponse<R>(this.errorCode, this.msg, function.apply(this.result));
        }
        return new OperationResponse<Object>(this.errorCode, this.msg, null);
    }

    public T elseGet(@Nonnull Supplier<T> supplier) {
        if (this.success() && this.result != null) {
            return this.result;
        }
        return supplier.get();
    }

    public T orElse(@Nullable T other) {
        if (this.success() && this.result != null) {
            return this.result;
        }
        return other;
    }

    public OperationResponse<T> ifSuccess(Consumer<T> consumer) {
        if (this.success()) {
            consumer.accept(this.result);
        }
        return this;
    }

    public OperationResponse<T> ifSuccessAndNonnull(Consumer<T> consumer) {
        if (this.success() && this.result != null) {
            consumer.accept(this.result);
        }
        return this;
    }

    public int getErrorCode() {
        return this.errorCode;
    }

    public String getMsg() {
        return this.msg;
    }

    public T getResult() {
        return this.result;
    }

    public void setErrorCode(int errorCode) {
        this.errorCode = errorCode;
    }

    public void setMsg(String msg) {
        this.msg = msg;
    }

    public void setResult(T result) {
        this.result = result;
    }

    public String toString() {
        return "OperationResponse(errorCode=" + this.getErrorCode() + ", msg=" + this.getMsg() + ", result=" + this.getResult() + ")";
    }

    public OperationResponse(int errorCode, String msg, T result) {
        this.errorCode = errorCode;
        this.msg = msg;
        this.result = result;
    }

    public OperationResponse() {
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof OperationResponse)) {
            return false;
        }
        OperationResponse other = (OperationResponse)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getErrorCode() != other.getErrorCode()) {
            return false;
        }
        String this$msg = this.getMsg();
        String other$msg = other.getMsg();
        if (this$msg == null ? other$msg != null : !this$msg.equals(other$msg)) {
            return false;
        }
        T this$result = this.getResult();
        T other$result = other.getResult();
        return !(this$result == null ? other$result != null : !this$result.equals(other$result));
    }

    protected boolean canEqual(Object other) {
        return other instanceof OperationResponse;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getErrorCode();
        String $msg = this.getMsg();
        result = result * 59 + ($msg == null ? 43 : $msg.hashCode());
        T $result = this.getResult();
        result = result * 59 + ($result == null ? 43 : $result.hashCode());
        return result;
    }
}

