/*
 * Decompiled with CFR 0.152.
 */
package com.tplink.smb.omada.dispatcher.common.access;

import com.tplink.smb.omada.dispatcher.common.access.HttpHeader;
import com.tplink.smb.omada.dispatcher.common.access.OperationResponse;
import com.tplink.smb.omada.dispatcher.common.error.ErrorCode;
import com.tplink.smb.omada.dispatcher.common.error.HttpRespCode;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;

public class HttpResponse<T>
implements Serializable {
    private HttpRespCode respCode = HttpRespCode.OK;
    @Nonnull
    private final List<HttpHeader> headers = new ArrayList<HttpHeader>();
    @Nonnull
    private OperationResponse<T> operationResponse = new OperationResponse();

    public HttpResponse(HttpRespCode httpRespCode) {
        this.respCode = httpRespCode;
        this.operationResponse = new OperationResponse(-1, "General error.");
    }

    public HttpResponse(HttpRespCode httpRespCode, @Nonnull OperationResponse<T> operationResponse) {
        Objects.requireNonNull(operationResponse);
        this.respCode = httpRespCode;
        this.operationResponse = operationResponse;
    }

    public HttpResponse(@Nonnull OperationResponse<T> operationResponse) {
        Objects.requireNonNull(operationResponse);
        this.respCode = HttpRespCode.OK;
        this.operationResponse = operationResponse;
    }

    public HttpResponse(HttpRespCode httpRespCode, ErrorCode resErrorCode, @Nullable T result) {
        this.respCode = httpRespCode;
        this.operationResponse = new OperationResponse<T>(resErrorCode, result);
    }

    public HttpResponse(HttpRespCode httpRespCode, ErrorCode resErrorCode) {
        this.respCode = httpRespCode;
        this.operationResponse = new OperationResponse(resErrorCode);
    }

    public HttpResponse<T> addHeader(String name, String value) {
        HttpHeader header = new HttpHeader(name, value);
        this.headers.add(header);
        return this;
    }

    public boolean success() {
        return HttpRespCode.OK == this.respCode;
    }

    public int getErrorCode() {
        return this.operationResponse.getErrorCode();
    }

    @Nonnull
    public String getMsg() {
        return Optional.ofNullable(this.operationResponse.getMsg()).orElse(this.respCode.getMsg());
    }

    @Nullable
    public T getResult() {
        return this.operationResponse.getResult();
    }

    public static <T> HttpResponseBuilder<T> builder() {
        return new HttpResponseBuilder();
    }

    public HttpResponseBuilder<T> toBuilder() {
        return new HttpResponseBuilder().respCode(this.respCode).operationResponse(this.operationResponse);
    }

    public HttpRespCode getRespCode() {
        return this.respCode;
    }

    @Nonnull
    public List<HttpHeader> getHeaders() {
        return this.headers;
    }

    @Nonnull
    public OperationResponse<T> getOperationResponse() {
        return this.operationResponse;
    }

    public String toString() {
        return "HttpResponse(respCode=" + this.getRespCode() + ", headers=" + this.getHeaders() + ", operationResponse=" + this.getOperationResponse() + ")";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof HttpResponse)) {
            return false;
        }
        HttpResponse other = (HttpResponse)o;
        if (!other.canEqual(this)) {
            return false;
        }
        HttpRespCode this$respCode = this.getRespCode();
        HttpRespCode other$respCode = other.getRespCode();
        if (this$respCode == null ? other$respCode != null : !((Object)((Object)this$respCode)).equals((Object)other$respCode)) {
            return false;
        }
        List<HttpHeader> this$headers = this.getHeaders();
        List<HttpHeader> other$headers = other.getHeaders();
        if (this$headers == null ? other$headers != null : !((Object)this$headers).equals(other$headers)) {
            return false;
        }
        OperationResponse<T> this$operationResponse = this.getOperationResponse();
        OperationResponse<T> other$operationResponse = other.getOperationResponse();
        return !(this$operationResponse == null ? other$operationResponse != null : !((Object)this$operationResponse).equals(other$operationResponse));
    }

    protected boolean canEqual(Object other) {
        return other instanceof HttpResponse;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        HttpRespCode $respCode = this.getRespCode();
        result = result * 59 + ($respCode == null ? 43 : ((Object)((Object)$respCode)).hashCode());
        List<HttpHeader> $headers = this.getHeaders();
        result = result * 59 + ($headers == null ? 43 : ((Object)$headers).hashCode());
        OperationResponse<T> $operationResponse = this.getOperationResponse();
        result = result * 59 + ($operationResponse == null ? 43 : ((Object)$operationResponse).hashCode());
        return result;
    }

    public void setRespCode(HttpRespCode respCode) {
        this.respCode = respCode;
    }

    public void setOperationResponse(@Nonnull OperationResponse<T> operationResponse) {
        if (operationResponse == null) {
            throw new NullPointerException("operationResponse is marked non-null but is null");
        }
        this.operationResponse = operationResponse;
    }

    public HttpResponse() {
    }

    public static class HttpResponseBuilder<T> {
        private HttpRespCode respCode;
        private OperationResponse<T> operationResponse;

        HttpResponseBuilder() {
        }

        public HttpResponseBuilder<T> respCode(HttpRespCode respCode) {
            this.respCode = respCode;
            return this;
        }

        public HttpResponseBuilder<T> operationResponse(@Nonnull OperationResponse<T> operationResponse) {
            if (operationResponse == null) {
                throw new NullPointerException("operationResponse is marked non-null but is null");
            }
            this.operationResponse = operationResponse;
            return this;
        }

        public HttpResponse<T> build() {
            return new HttpResponse<T>(this.respCode, this.operationResponse);
        }

        public String toString() {
            return "HttpResponse.HttpResponseBuilder(respCode=" + this.respCode + ", operationResponse=" + this.operationResponse + ")";
        }
    }
}

