/*
 * Decompiled with CFR 0.152.
 */
package com.tplink.smb.omada.manager.cluster.common;

import com.tplink.smb.omada.common.util.T;
import com.tplink.smb.omada.common.util.system.NodeInfo;
import com.tplink.smb.omada.manager.cluster.common.HaConfigDTO;
import com.tplink.smb.omada.manager.cluster.common.a;
import com.tplink.smb.omada.manager.cluster.common.d;
import com.tplink.smb.omada.manager.cluster.common.h;
import jakarta.annotation.Nullable;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Properties;
import lombok.Generated;
import org.apache.commons.lang3.ArrayUtils;
import org.bson.types.ObjectId;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class c {
    @Generated
    private static final Logger a = LoggerFactory.getLogger(c.class);
    private static Properties b;

    public static synchronized void a() throws IOException {
        String propertiesFilePath = System.getProperty("omada.cluster.properties.file");
        if (T.c((String)propertiesFilePath)) {
            return;
        }
        a.info("Loading cluster properties: {}", (Object)propertiesFilePath);
        File file = new File(propertiesFilePath);
        b = new Properties();
        try (FileInputStream inputStream = new FileInputStream(file);){
            b.load(inputStream);
        }
        Optional.ofNullable(System.getProperty("omada.cluster.distributed.mongo.username")).ifPresent(username -> {
            if (!T.c((String)username)) {
                b.setProperty("omada.cluster.distributed.mongo.username", (String)username);
            }
        });
        Optional.ofNullable(System.getProperty("omada.cluster.distributed.key")).ifPresent(key -> {
            if (!T.c((String)key)) {
                b.setProperty("omada.cluster.distributed.key", (String)key);
            }
        });
        c.c();
    }

    public static boolean b() {
        return b != null;
    }

    @Nullable
    public static String a(String key) {
        if (b == null) {
            return null;
        }
        return b.getProperty(key);
    }

    public static String a(String key, String defaultValue) {
        if (b == null) {
            return null;
        }
        return b.getProperty(key, defaultValue);
    }

    public static void c() {
        if (b == null) {
            return;
        }
        String clusterMode = c.a("omada.cluster.mode", "off");
        if (T.c((String)clusterMode)) {
            return;
        }
        String nodeName = System.getProperty("omada.cluster.node.id");
        switch (clusterMode) {
            case "distributed": {
                HaConfigDTO hsConfigDTO = new HaConfigDTO().setNodeId(ObjectId.get().toString()).setNodeName(nodeName).setNodeIp(c.b("omada.cluster.distributed.${node_id}.host")).setMongoUsername(c.a("omada.cluster.distributed.mongo.username")).setMongoKey(c.a("omada.cluster.distributed.key")).setReplicaSetName(c.a("omada.cluster.distributed.mongo.replset.name"));
                if ("internal".equals(c.a("omada.cluster.distributed.mongo.mode"))) {
                    a.debug("Update config from properties: horizontal, internal");
                    com.tplink.smb.omada.manager.cluster.common.a.a(hsConfigDTO.setInternalMongodUri(c.l()).setInternalDb(c.i()));
                    com.tplink.smb.omada.common.util.system.a.t = false;
                    break;
                }
                if ("external".equals(c.a("omada.cluster.distributed.mongo.mode"))) {
                    a.debug("Update config from properties: horizontal, external");
                    com.tplink.smb.omada.manager.cluster.common.a.a(hsConfigDTO.setExternalMongodUri(c.a("omada.cluster.distributed.mongodb.uri")).setInternalDb(false));
                    break;
                }
                a.error("Failed to update hsconfig, invalid data mode.");
                break;
            }
            case "hsb": {
                HaConfigDTO haConfigDTO = new HaConfigDTO();
                String hsbDeviceIp = c.b(nodeName, "omada.cluster.hsb.${node_id}.device.host");
                haConfigDTO.setFailoverClusterEnable(true).setNodeId("primary".equals(nodeName) ? "1" : "2").setLocalMongoHost(c.b("omada.cluster.hsb.${node_id}.host")).setLocalMongoPort("27217").setRemoteMongoHost(c.k()).setRemoteMongoPort("27217").setStartInit("primary".equals(System.getProperty("omada.cluster.node.id"))).setKey(c.a("omada.cluster.hsb.key")).setMongoKey(c.a("omada.cluster.hsb.key")).setReplicaSetName(d.m()).setDeviceIp(T.a((String)hsbDeviceIp) ? null : hsbDeviceIp);
                a.debug("Update config from properties: failover, external");
                com.tplink.smb.omada.manager.cluster.common.a.b(haConfigDTO);
                break;
            }
            default: {
                return;
            }
        }
    }

    private static String b(String nodeId, String key) {
        if (b == null || T.c((String)key)) {
            return null;
        }
        return c.a(key.replace("${node_id}", nodeId));
    }

    private static String b(String key) {
        if (b == null || T.c((String)key)) {
            return null;
        }
        String nodeId = System.getProperty("omada.cluster.node.id");
        return c.a(key.replace("${node_id}", nodeId));
    }

    private static boolean i() {
        if (b == null) {
            return false;
        }
        String nodeId = System.getProperty("omada.cluster.node.id");
        return h.a.b().equals(c.b(nodeId, "omada.cluster.distributed.${node_id}.role"));
    }

    public static boolean d() {
        if (b == null) {
            return false;
        }
        String nodeId = System.getProperty("omada.cluster.node.id");
        return h.b.b().equals(c.b(nodeId, "omada.cluster.distributed.${node_id}.role"));
    }

    private static String j() {
        if (b == null) {
            return null;
        }
        String nodeId = System.getProperty("omada.cluster.node.id");
        return c.a("omada.cluster.hsb.${node_id}.host".replace("${node_id}", nodeId));
    }

    private static String k() {
        if (b == null) {
            return null;
        }
        String nodeId = System.getProperty("omada.cluster.node.id");
        if ("primary".equals(nodeId)) {
            return c.a("omada.cluster.hsb.${node_id}.host".replace("${node_id}", "secondary"));
        }
        return c.a("omada.cluster.hsb.${node_id}.host".replace("${node_id}", "primary"));
    }

    private static String l() {
        if (b == null) {
            return null;
        }
        if ("internal".equals(c.a("omada.cluster.distributed.mongo.mode"))) {
            Object uri = "mongodb://";
            uri = (String)uri + c.a("omada.cluster.distributed.mongo.username") + ":" + c.a("omada.cluster.distributed.key") + "@";
            String[] ids = c.a("omada.cluster.distributed.names").split(",");
            Object memebrHostPort = "";
            for (int i2 = 0; i2 < ids.length; ++i2) {
                memebrHostPort = i2 == 0 ? c.b(ids[i2], "omada.cluster.distributed.${node_id}.host") + ":27217" : (String)memebrHostPort + "," + c.b(ids[i2], "omada.cluster.distributed.${node_id}.host") + ":27217";
            }
            uri = (String)uri + (String)memebrHostPort;
            uri = (String)uri + "/omada?authSource=admin&readPreference=primaryPreferred&maxIdleTimeMS=300000&minPoolSize=1&connectTimeoutMS=30000&socketTimeoutMS=30000";
            a.debug("Internal MongoDB URI: {}", uri);
            return uri;
        }
        return null;
    }

    public static boolean e() {
        if (b == null) {
            return false;
        }
        if (!c.i()) {
            return false;
        }
        String clusterMode = c.a("omada.cluster.mode", "off");
        if (T.c((String)clusterMode)) {
            return false;
        }
        return "distributed".equals(clusterMode) && "internal".equals(c.a("omada.cluster.distributed.mongo.mode"));
    }

    public static Collection<NodeInfo> f() {
        ArrayList<NodeInfo> nodeInfoCollection = new ArrayList<NodeInfo>();
        Object[] names = c.a("omada.cluster.distributed.names").split(",");
        if (ArrayUtils.isEmpty((Object[])names)) {
            a.error("Failed to get node info from properties.");
            return Collections.emptyList();
        }
        for (Object name : names) {
            String deviceIp = c.b((String)name, "omada.cluster.distributed.${node_id}.device.host");
            String devicePort = c.b((String)name, "omada.cluster.distributed.${node_id}.device.port");
            String deviceDiscPort = c.b((String)name, "omada.cluster.distributed.${node_id}.device.disc.port");
            String deviceMonitorPort = c.b((String)name, "omada.cluster.distributed.${node_id}.device.monitor.port");
            NodeInfo nodeInfo = NodeInfo.builder().a(ObjectId.get().toString()).c(c.b((String)name, "omada.cluster.distributed.${node_id}.host")).d(T.a((String)deviceIp) ? null : deviceIp).a(T.a((String)devicePort) ? null : Integer.valueOf(devicePort)).b(T.a((String)deviceDiscPort) ? null : Integer.valueOf(deviceDiscPort)).c(T.a((String)deviceMonitorPort) ? null : Integer.valueOf(deviceMonitorPort)).d(Integer.valueOf(h.a(c.b((String)name, "omada.cluster.distributed.${node_id}.role")).a())).b((String)name).a(Collections.emptySet()).a(Boolean.valueOf(true)).a();
            nodeInfoCollection.add(nodeInfo);
            if (!Objects.equals(com.tplink.smb.omada.common.util.system.a.j(), name)) continue;
            com.tplink.smb.omada.common.util.system.a.b = nodeInfo.getNodeId();
            HaConfigDTO haConfigDTO = com.tplink.smb.omada.manager.cluster.common.a.a();
            com.tplink.smb.omada.manager.cluster.common.a.a(haConfigDTO.setNodeId(nodeInfo.getNodeId()));
        }
        return nodeInfoCollection;
    }

    public static List<String> g() {
        String[] names;
        ArrayList<String> nodeIpCollection = new ArrayList<String>();
        for (String name : names = c.a("omada.cluster.distributed.names").split(",")) {
            String nodeIp = c.b(name, "omada.cluster.distributed.${node_id}.host");
            nodeIpCollection.add(nodeIp);
        }
        return nodeIpCollection;
    }

    @Generated
    private c() {
    }

    @Generated
    public static Properties h() {
        return b;
    }
}

