/*
 * Decompiled with CFR 0.152.
 */
package com.tplink.smb.omada.manager.cluster.api.web.dto;

import com.tplink.smb.omada.manager.cluster.api.web.dto.NodeManagedSiteBriefVO;
import jakarta.validation.constraints.Pattern;
import java.util.List;
import lombok.Generated;

public class NodeInfoVO {
    private String id;
    @Pattern(regexp="^[a-zA-Z0-9]{1,64}$")
    private @Pattern(regexp="^[a-zA-Z0-9]{1,64}$") String name;
    @Pattern(regexp="((\\d{1,2}|1\\d\\d|2[0-4]\\d|25[0-5])(\\.(\\d{1,2}|1\\d\\d|2[0-4]\\d|25[0-5])){3}|([a-zA-Z0-9]([a-zA-Z0-9\\-]{0,61}[a-zA-Z0-9])?\\.)+[a-zA-Z]{2,6})")
    private @Pattern(regexp="((\\d{1,2}|1\\d\\d|2[0-4]\\d|25[0-5])(\\.(\\d{1,2}|1\\d\\d|2[0-4]\\d|25[0-5])){3}|([a-zA-Z0-9]([a-zA-Z0-9\\-]{0,61}[a-zA-Z0-9])?\\.)+[a-zA-Z]{2,6})") String ip;
    @Pattern(regexp="((\\d{1,2}|1\\d\\d|2[0-4]\\d|25[0-5])(\\.(\\d{1,2}|1\\d\\d|2[0-4]\\d|25[0-5])){3}|([a-zA-Z0-9]([a-zA-Z0-9\\-]{0,61}[a-zA-Z0-9])?\\.)+[a-zA-Z]{2,6})")
    private @Pattern(regexp="((\\d{1,2}|1\\d\\d|2[0-4]\\d|25[0-5])(\\.(\\d{1,2}|1\\d\\d|2[0-4]\\d|25[0-5])){3}|([a-zA-Z0-9]([a-zA-Z0-9\\-]{0,61}[a-zA-Z0-9])?\\.)+[a-zA-Z]{2,6})") String deviceIp;
    private Integer devicePort;
    private Integer deviceDiscPort;
    private Integer deviceMonitorPort;
    private Integer role;
    private Integer status;
    private Boolean enable;
    private Integer weight;
    private Integer siteNum;
    private Integer cpu;
    private Integer mem;
    private Boolean currentNode;
    private String reason;
    private Boolean sysTimeOutOfSync;
    private List<NodeManagedSiteBriefVO> siteList;

    public static boolean checkTimeOutOfSync(Long otherNodeSysTime) {
        if (otherNodeSysTime == null) {
            return false;
        }
        return Math.abs(System.currentTimeMillis() - otherNodeSysTime) > 20000L;
    }

    @Generated
    public static NodeInfoVOBuilder builder() {
        return new NodeInfoVOBuilder();
    }

    @Generated
    public String getId() {
        return this.id;
    }

    @Generated
    public String getName() {
        return this.name;
    }

    @Generated
    public String getIp() {
        return this.ip;
    }

    @Generated
    public String getDeviceIp() {
        return this.deviceIp;
    }

    @Generated
    public Integer getDevicePort() {
        return this.devicePort;
    }

    @Generated
    public Integer getDeviceDiscPort() {
        return this.deviceDiscPort;
    }

    @Generated
    public Integer getDeviceMonitorPort() {
        return this.deviceMonitorPort;
    }

    @Generated
    public Integer getRole() {
        return this.role;
    }

    @Generated
    public Integer getStatus() {
        return this.status;
    }

    @Generated
    public Boolean getEnable() {
        return this.enable;
    }

    @Generated
    public Integer getWeight() {
        return this.weight;
    }

    @Generated
    public Integer getSiteNum() {
        return this.siteNum;
    }

    @Generated
    public Integer getCpu() {
        return this.cpu;
    }

    @Generated
    public Integer getMem() {
        return this.mem;
    }

    @Generated
    public Boolean getCurrentNode() {
        return this.currentNode;
    }

    @Generated
    public String getReason() {
        return this.reason;
    }

    @Generated
    public Boolean getSysTimeOutOfSync() {
        return this.sysTimeOutOfSync;
    }

    @Generated
    public List<NodeManagedSiteBriefVO> getSiteList() {
        return this.siteList;
    }

    @Generated
    public NodeInfoVO setId(String id) {
        this.id = id;
        return this;
    }

    @Generated
    public NodeInfoVO setName(String name) {
        this.name = name;
        return this;
    }

    @Generated
    public NodeInfoVO setIp(String ip) {
        this.ip = ip;
        return this;
    }

    @Generated
    public NodeInfoVO setDeviceIp(String deviceIp) {
        this.deviceIp = deviceIp;
        return this;
    }

    @Generated
    public NodeInfoVO setDevicePort(Integer devicePort) {
        this.devicePort = devicePort;
        return this;
    }

    @Generated
    public NodeInfoVO setDeviceDiscPort(Integer deviceDiscPort) {
        this.deviceDiscPort = deviceDiscPort;
        return this;
    }

    @Generated
    public NodeInfoVO setDeviceMonitorPort(Integer deviceMonitorPort) {
        this.deviceMonitorPort = deviceMonitorPort;
        return this;
    }

    @Generated
    public NodeInfoVO setRole(Integer role) {
        this.role = role;
        return this;
    }

    @Generated
    public NodeInfoVO setStatus(Integer status) {
        this.status = status;
        return this;
    }

    @Generated
    public NodeInfoVO setEnable(Boolean enable) {
        this.enable = enable;
        return this;
    }

    @Generated
    public NodeInfoVO setWeight(Integer weight) {
        this.weight = weight;
        return this;
    }

    @Generated
    public NodeInfoVO setSiteNum(Integer siteNum) {
        this.siteNum = siteNum;
        return this;
    }

    @Generated
    public NodeInfoVO setCpu(Integer cpu) {
        this.cpu = cpu;
        return this;
    }

    @Generated
    public NodeInfoVO setMem(Integer mem) {
        this.mem = mem;
        return this;
    }

    @Generated
    public NodeInfoVO setCurrentNode(Boolean currentNode) {
        this.currentNode = currentNode;
        return this;
    }

    @Generated
    public NodeInfoVO setReason(String reason) {
        this.reason = reason;
        return this;
    }

    @Generated
    public NodeInfoVO setSysTimeOutOfSync(Boolean sysTimeOutOfSync) {
        this.sysTimeOutOfSync = sysTimeOutOfSync;
        return this;
    }

    @Generated
    public NodeInfoVO setSiteList(List<NodeManagedSiteBriefVO> siteList) {
        this.siteList = siteList;
        return this;
    }

    @Generated
    public String toString() {
        return "NodeInfoVO(id=" + this.getId() + ", name=" + this.getName() + ", ip=" + this.getIp() + ", deviceIp=" + this.getDeviceIp() + ", devicePort=" + this.getDevicePort() + ", deviceDiscPort=" + this.getDeviceDiscPort() + ", deviceMonitorPort=" + this.getDeviceMonitorPort() + ", role=" + this.getRole() + ", status=" + this.getStatus() + ", enable=" + this.getEnable() + ", weight=" + this.getWeight() + ", siteNum=" + this.getSiteNum() + ", cpu=" + this.getCpu() + ", mem=" + this.getMem() + ", currentNode=" + this.getCurrentNode() + ", reason=" + this.getReason() + ", sysTimeOutOfSync=" + this.getSysTimeOutOfSync() + ", siteList=" + this.getSiteList() + ")";
    }

    @Generated
    public NodeInfoVO() {
    }

    @Generated
    public NodeInfoVO(String id, String name, String ip, String deviceIp, Integer devicePort, Integer deviceDiscPort, Integer deviceMonitorPort, Integer role, Integer status, Boolean enable, Integer weight, Integer siteNum, Integer cpu, Integer mem, Boolean currentNode, String reason, Boolean sysTimeOutOfSync, List<NodeManagedSiteBriefVO> siteList) {
        this.id = id;
        this.name = name;
        this.ip = ip;
        this.deviceIp = deviceIp;
        this.devicePort = devicePort;
        this.deviceDiscPort = deviceDiscPort;
        this.deviceMonitorPort = deviceMonitorPort;
        this.role = role;
        this.status = status;
        this.enable = enable;
        this.weight = weight;
        this.siteNum = siteNum;
        this.cpu = cpu;
        this.mem = mem;
        this.currentNode = currentNode;
        this.reason = reason;
        this.sysTimeOutOfSync = sysTimeOutOfSync;
        this.siteList = siteList;
    }

    @Generated
    public static class NodeInfoVOBuilder {
        @Generated
        private String id;
        @Generated
        private String name;
        @Generated
        private String ip;
        @Generated
        private String deviceIp;
        @Generated
        private Integer devicePort;
        @Generated
        private Integer deviceDiscPort;
        @Generated
        private Integer deviceMonitorPort;
        @Generated
        private Integer role;
        @Generated
        private Integer status;
        @Generated
        private Boolean enable;
        @Generated
        private Integer weight;
        @Generated
        private Integer siteNum;
        @Generated
        private Integer cpu;
        @Generated
        private Integer mem;
        @Generated
        private Boolean currentNode;
        @Generated
        private String reason;
        @Generated
        private Boolean sysTimeOutOfSync;
        @Generated
        private List<NodeManagedSiteBriefVO> siteList;

        @Generated
        NodeInfoVOBuilder() {
        }

        @Generated
        public NodeInfoVOBuilder id(String id) {
            this.id = id;
            return this;
        }

        @Generated
        public NodeInfoVOBuilder name(String name) {
            this.name = name;
            return this;
        }

        @Generated
        public NodeInfoVOBuilder ip(String ip) {
            this.ip = ip;
            return this;
        }

        @Generated
        public NodeInfoVOBuilder deviceIp(String deviceIp) {
            this.deviceIp = deviceIp;
            return this;
        }

        @Generated
        public NodeInfoVOBuilder devicePort(Integer devicePort) {
            this.devicePort = devicePort;
            return this;
        }

        @Generated
        public NodeInfoVOBuilder deviceDiscPort(Integer deviceDiscPort) {
            this.deviceDiscPort = deviceDiscPort;
            return this;
        }

        @Generated
        public NodeInfoVOBuilder deviceMonitorPort(Integer deviceMonitorPort) {
            this.deviceMonitorPort = deviceMonitorPort;
            return this;
        }

        @Generated
        public NodeInfoVOBuilder role(Integer role) {
            this.role = role;
            return this;
        }

        @Generated
        public NodeInfoVOBuilder status(Integer status) {
            this.status = status;
            return this;
        }

        @Generated
        public NodeInfoVOBuilder enable(Boolean enable) {
            this.enable = enable;
            return this;
        }

        @Generated
        public NodeInfoVOBuilder weight(Integer weight) {
            this.weight = weight;
            return this;
        }

        @Generated
        public NodeInfoVOBuilder siteNum(Integer siteNum) {
            this.siteNum = siteNum;
            return this;
        }

        @Generated
        public NodeInfoVOBuilder cpu(Integer cpu) {
            this.cpu = cpu;
            return this;
        }

        @Generated
        public NodeInfoVOBuilder mem(Integer mem) {
            this.mem = mem;
            return this;
        }

        @Generated
        public NodeInfoVOBuilder currentNode(Boolean currentNode) {
            this.currentNode = currentNode;
            return this;
        }

        @Generated
        public NodeInfoVOBuilder reason(String reason) {
            this.reason = reason;
            return this;
        }

        @Generated
        public NodeInfoVOBuilder sysTimeOutOfSync(Boolean sysTimeOutOfSync) {
            this.sysTimeOutOfSync = sysTimeOutOfSync;
            return this;
        }

        @Generated
        public NodeInfoVOBuilder siteList(List<NodeManagedSiteBriefVO> siteList) {
            this.siteList = siteList;
            return this;
        }

        @Generated
        public NodeInfoVO build() {
            return new NodeInfoVO(this.id, this.name, this.ip, this.deviceIp, this.devicePort, this.deviceDiscPort, this.deviceMonitorPort, this.role, this.status, this.enable, this.weight, this.siteNum, this.cpu, this.mem, this.currentNode, this.reason, this.sysTimeOutOfSync, this.siteList);
        }

        @Generated
        public String toString() {
            return "NodeInfoVO.NodeInfoVOBuilder(id=" + this.id + ", name=" + this.name + ", ip=" + this.ip + ", deviceIp=" + this.deviceIp + ", devicePort=" + this.devicePort + ", deviceDiscPort=" + this.deviceDiscPort + ", deviceMonitorPort=" + this.deviceMonitorPort + ", role=" + this.role + ", status=" + this.status + ", enable=" + this.enable + ", weight=" + this.weight + ", siteNum=" + this.siteNum + ", cpu=" + this.cpu + ", mem=" + this.mem + ", currentNode=" + this.currentNode + ", reason=" + this.reason + ", sysTimeOutOfSync=" + this.sysTimeOutOfSync + ", siteList=" + this.siteList + ")";
        }
    }
}

