/*
 * Decompiled with CFR 0.152.
 */
package com.tplink.smb.omada.monitor.port.mongo.statistic.ssid;

import com.tplink.smb.omada.common.constant.N;
import com.tplink.smb.omada.common.mongo.repository.s;
import com.tplink.smb.omada.monitor.port.mongo.statistic.c;
import com.tplink.smb.omada.monitor.port.mongo.statistic.ssid.BaseLiteSsidStatPO;
import com.tplink.smb.omada.monitor.report.dto.SsidNameDTO;
import com.tplink.smb.omada.monitor.report.dto.SsidNameTrafficDTO;
import com.tplink.smb.omada.monitor.statistic.common.dto.SsidStatQueryDTO;
import jakarta.annotation.Nonnull;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.data.mongodb.core.BulkOperations;
import org.springframework.data.mongodb.core.MongoTemplate;
import org.springframework.data.mongodb.core.aggregation.Aggregation;
import org.springframework.data.mongodb.core.aggregation.AggregationResults;
import org.springframework.data.mongodb.core.index.IndexDefinition;
import org.springframework.data.mongodb.core.query.Criteria;
import org.springframework.data.mongodb.core.query.CriteriaDefinition;
import org.springframework.data.mongodb.core.query.Query;
import org.springframework.util.CollectionUtils;

public abstract class a<P extends BaseLiteSsidStatPO>
extends s<P>
implements com.tplink.smb.omada.monitor.statistic.c.f.a {
    @Generated
    private static final Logger a = LoggerFactory.getLogger(a.class);
    @Autowired
    @Qualifier(value="dataMongoTemplate")
    protected MongoTemplate mongoTemplate;
    @Autowired
    private com.tplink.smb.omada.monitor.statistic.port.a.g.a b;

    protected MongoTemplate getMongoTemplate() {
        return this.mongoTemplate;
    }

    @Nonnull
    protected IndexDefinition[] getIndexDefinitions() {
        return BaseLiteSsidStatPO.INDEX_DEFINITIONS;
    }

    private Aggregation b(String omadacId, String siteId, long start, long end) {
        return c.h(omadacId, siteId, start, end);
    }

    public List<SsidNameTrafficDTO> a(String omadacId, String siteId, long start, long end) {
        List cachedSsidNameTrafficDTO;
        N granularity = null;
        switch (this.getCollectionNameOrPrefixIfSliced()) {
            case "ssidstat5min": {
                granularity = N.a;
                break;
            }
            case "ssidstathourly": {
                granularity = N.c;
                break;
            }
            case "ssidstatdaily": {
                granularity = N.d;
                break;
            }
        }
        if (Objects.nonNull(granularity) && !CollectionUtils.isEmpty((Collection)(cachedSsidNameTrafficDTO = this.b.d(omadacId, siteId, start, end, granularity)))) {
            return cachedSsidNameTrafficDTO;
        }
        Aggregation aggregation = this.b(omadacId, siteId, start, end);
        if (aggregation == null) {
            return Collections.emptyList();
        }
        N finalGranularity = granularity;
        HashMap topResMap = new HashMap();
        this.iteratorCollectionsByTimeAsc(start, end, collectionName -> {
            AggregationResults results = this.mongoTemplate.aggregate(aggregation, collectionName, SsidNameTrafficDTO.class);
            List ssidNameTrafficDTOList = results.getMappedResults();
            ssidNameTrafficDTOList.forEach(statDTO -> topResMap.compute(statDTO.getSsidName(), (ssidName, previous) -> {
                if (Objects.isNull(previous)) {
                    return statDTO;
                }
                SsidNameTrafficDTO copied = new SsidNameTrafficDTO();
                copied.setSsidName(statDTO.getSsidName());
                copied.setTraffic(Long.valueOf(statDTO.getTraffic() + previous.getTraffic()));
                return copied;
            }));
        });
        if (Objects.nonNull(finalGranularity)) {
            this.b.c(omadacId, siteId, start, end, finalGranularity, new ArrayList(topResMap.values()));
        }
        return topResMap.values().stream().filter(v2 -> Objects.nonNull(v2.getTraffic())).sorted(Comparator.comparing(SsidNameTrafficDTO::getTraffic).reversed()).collect(Collectors.toList());
    }

    public void a(String omadacId, String siteId, String ssidName) {
        Query query = Query.query((CriteriaDefinition)Criteria.where((String)"omadac_id").is((Object)omadacId).and("site").is((Object)siteId).and("ssid").is((Object)ssidName));
        this.iteratorCollections(collectionName -> this.a(query, (String)collectionName));
    }

    public void a(long time) {
        this.tryDropCollectionOrDeleteByTimeLessThan(time, () -> {
            Query query = Query.query((CriteriaDefinition)Criteria.where((String)"time").lt((Object)time));
            this.mongoTemplate.remove(query, this.getCollectionNameOrPrefixIfSliced());
        });
    }

    public void a(String omadacId) {
        Query query = Query.query((CriteriaDefinition)Criteria.where((String)"omadac_id").is((Object)omadacId));
        this.iteratorCollections(collectionName -> this.a(query, (String)collectionName));
    }

    public void a(String omadacId, String siteId) {
        Query query = Query.query((CriteriaDefinition)Criteria.where((String)"omadac_id").is((Object)omadacId).and("site").is((Object)siteId));
        this.iteratorCollections(collectionName -> this.a(query, (String)collectionName));
    }

    public void a(String omadacId, long time) {
        Query query = Query.query((CriteriaDefinition)Criteria.where((String)"omadac_id").is((Object)omadacId).and("time").lt((Object)time));
        this.iteratorCollectionsByTimeAsc(0L, time, collectionName -> this.a(query, (String)collectionName));
    }

    public Set<String> a(SsidStatQueryDTO statQueryDTO) {
        Aggregation aggregation = c.l(statQueryDTO.getOmadacId(), statQueryDTO.getSiteId(), statQueryDTO.getStart(), statQueryDTO.getEnd());
        HashSet<String> ssidName = new HashSet<String>();
        this.iteratorCollectionsByTimeAsc(statQueryDTO.getStart(), statQueryDTO.getEnd(), collectionName -> {
            AggregationResults results = this.mongoTemplate.aggregate(aggregation, collectionName, SsidNameDTO.class);
            if (com.tplink.smb.ecsp.common.util.CollectionUtils.isNotEmpty((Collection)results.getMappedResults())) {
                results.getMappedResults().forEach(v2 -> ssidName.add(v2.getSsidName()));
            }
        });
        return ssidName;
    }

    private void a(Query query, String collectionName) {
        BulkOperations bulkOperations = this.mongoTemplate.bulkOps(BulkOperations.BulkMode.UNORDERED, collectionName);
        bulkOperations.remove(query);
        bulkOperations.execute();
    }
}

