/*
 * Decompiled with CFR 0.152.
 */
package com.tplink.smb.omada.monitor.port.mongo.statistic.site.fivemin;

import com.tplink.smb.eventcenter.api.event.DomainEventSubscriber;
import com.tplink.smb.eventcenter.domain.DomainEventBusHolder;
import com.tplink.smb.omada.common.constant.N;
import com.tplink.smb.omada.common.mongo.repository.k;
import com.tplink.smb.omada.common.mongo.repository.u;
import com.tplink.smb.omada.common.util.x;
import com.tplink.smb.omada.monitor.api.web.report.v6.SiteTrafficSummaryDTO;
import com.tplink.smb.omada.monitor.api.web.statistic.dto.SiteDeviceNumDTO;
import com.tplink.smb.omada.monitor.api.web.statistic.dto.SiteSsidCountDTO;
import com.tplink.smb.omada.monitor.api.web.statistic.dto.SiteStatDTO;
import com.tplink.smb.omada.monitor.port.mongo.statistic.c;
import com.tplink.smb.omada.monitor.port.mongo.statistic.site.DeviceSummaryPO;
import com.tplink.smb.omada.monitor.port.mongo.statistic.site.b;
import com.tplink.smb.omada.monitor.port.mongo.statistic.site.f;
import com.tplink.smb.omada.monitor.port.mongo.statistic.site.fivemin.SiteStat5MinPO;
import com.tplink.smb.omada.monitor.port.mongo.statistic.site.fivemin.a;
import com.tplink.smb.omada.monitor.statistic.common.dto.SiteStatQueryDTO;
import com.tplink.smb.omada.monitor.task.e;
import jakarta.annotation.Nonnull;
import jakarta.annotation.PostConstruct;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Sort;
import org.springframework.data.mongodb.core.aggregation.Aggregation;
import org.springframework.data.mongodb.core.aggregation.AggregationOperation;
import org.springframework.data.mongodb.core.aggregation.AggregationResults;
import org.springframework.data.mongodb.core.query.Criteria;
import org.springframework.data.mongodb.core.query.Query;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;

@Component
public class SiteStat5MinMongoRepositoryImpl
extends b<SiteStat5MinPO>
implements DomainEventSubscriber<e>,
com.tplink.smb.omada.monitor.statistic.c.e.f {
    @Generated
    private static final Logger a = LoggerFactory.getLogger(SiteStat5MinMongoRepositoryImpl.class);
    @Autowired
    private com.tplink.smb.omada.monitor.statistic.port.a.g.a b;

    @PostConstruct
    public void a() {
        DomainEventBusHolder.getHandlerRegistry().registerSync(e.class, (DomainEventSubscriber)this);
    }

    public void a(com.tplink.smb.omada.monitor.statistic.port.a.h.a siteStat, long time) {
        SiteStat5MinPO siteStat5MinPO = com.tplink.smb.omada.monitor.port.mongo.statistic.site.fivemin.a.a(siteStat, time);
        if (a.isDebugEnabled()) {
            a.debug("save siteStat5minPO, connectedAP: {}, totalAP: {} omadacId: {}", new Object[]{Optional.ofNullable(siteStat5MinPO.getDeviceSummary().getConnectedAps()).map(Set::size).orElse(0), Optional.ofNullable(siteStat5MinPO.getDeviceSummary().getTotalAps()).map(Set::size).orElse(0), siteStat.a()});
        }
        siteStat5MinPO.setId(null);
        this.mongoTemplate.insert((Object)siteStat5MinPO, this.getCollectionNameForSave(siteStat5MinPO));
    }

    public void a(List<com.tplink.smb.omada.monitor.statistic.port.a.h.a> siteStats, long time) {
        if (CollectionUtils.isEmpty(siteStats)) {
            return;
        }
        ArrayList list = new ArrayList();
        siteStats.forEach(siteStat -> list.add(com.tplink.smb.omada.monitor.port.mongo.statistic.site.fivemin.a.a(siteStat, time)));
        list.stream().filter(Objects::nonNull).forEach(po -> po.setId(null));
        HashMap<String, List> collectionMap = new HashMap<String, List>();
        list.forEach(po -> {
            String collectionName = this.getCollectionNameForSave(po);
            List statList = collectionMap.computeIfAbsent(collectionName, k2 -> new ArrayList());
            statList.add(po);
        });
        collectionMap.forEach((collectionName, statList) -> this.mongoTemplate.insert((Collection)statList, collectionName));
    }

    public void a(e event) {
        this.dbMaintenance(event.a());
    }

    @Nonnull
    protected String getCollectionNameOrPrefixIfSliced() {
        return "sitestat5min";
    }

    protected u<SiteStat5MinPO> getStrategy() {
        return k.b();
    }

    protected Class<SiteStat5MinPO> getPOClass() {
        return SiteStat5MinPO.class;
    }

    public List<SiteStatDTO> a(SiteStatQueryDTO statQuery) {
        Query query = c.a(statQuery);
        ArrayList dtoList = new ArrayList();
        this.iteratorCollectionsByTimeAsc(statQuery.getStart(), statQuery.getEnd(), collectionName -> {
            List poList = this.mongoTemplate.find(query, this.getPOClass(), collectionName);
            if (!CollectionUtils.isEmpty((Collection)poList)) {
                poList.forEach(po -> dtoList.add(com.tplink.smb.omada.monitor.port.mongo.statistic.site.fivemin.a.a(po)));
            }
        });
        return dtoList.stream().sorted(Comparator.comparing(SiteStatDTO::getTime)).collect(Collectors.toList());
    }

    public List<SiteStatDTO.DeviceSummaryDTO> a(String omadacId, String siteId, long start, long end) {
        List cachedDtoList = this.b.a(omadacId, siteId, start, end, N.a);
        if (!CollectionUtils.isEmpty((Collection)cachedDtoList)) {
            return cachedDtoList;
        }
        SiteStatQueryDTO statQuery = new SiteStatQueryDTO(omadacId, siteId, Long.valueOf(start), Long.valueOf(end));
        Query query = c.a(statQuery);
        ArrayList dtoList = new ArrayList();
        this.iteratorCollectionsByTimeAsc(start, end, collectionName -> {
            List poList = this.mongoTemplate.find(query, this.getPOClass(), collectionName);
            if (!CollectionUtils.isEmpty((Collection)poList)) {
                poList.forEach(po -> {
                    SiteStatDTO.DeviceSummaryDTO deviceSummaryDTO = com.tplink.smb.omada.monitor.port.mongo.statistic.site.c.a(po.getDeviceSummary(), po.getTime());
                    if (Objects.nonNull(deviceSummaryDTO)) {
                        dtoList.add(deviceSummaryDTO);
                    }
                });
            }
        });
        this.b.a(omadacId, siteId, start, end, N.a, dtoList);
        return dtoList.stream().sorted(Comparator.comparing(SiteStatDTO.DeviceSummaryDTO::getTime)).collect(Collectors.toList());
    }

    public List<SiteStatDTO.SiteTrafficDTO> b(String omadacId, String siteId, long start, long end) {
        List cachedDtoList = this.b.b(omadacId, siteId, start, end, N.a);
        if (!CollectionUtils.isEmpty((Collection)cachedDtoList)) {
            return cachedDtoList;
        }
        SiteStatQueryDTO statQuery = new SiteStatQueryDTO(omadacId, siteId, Long.valueOf(start), Long.valueOf(end));
        Query query = c.a(statQuery);
        ArrayList dtoList = new ArrayList();
        this.iteratorCollectionsByTimeAsc(start, end, collectionName -> {
            List poList = this.mongoTemplate.find(query, this.getPOClass(), collectionName);
            if (!CollectionUtils.isEmpty((Collection)poList)) {
                poList.forEach(po -> {
                    SiteStatDTO.SiteTrafficDTO siteTrafficDTO = f.a(po.getSiteTraffic(), po.getTime());
                    if (Objects.nonNull(siteTrafficDTO)) {
                        dtoList.add(siteTrafficDTO);
                    }
                });
            }
        });
        this.b.b(omadacId, siteId, start, end, N.a, dtoList);
        return dtoList.stream().sorted(Comparator.comparing(SiteStatDTO.SiteTrafficDTO::getTime)).collect(Collectors.toList());
    }

    public SiteTrafficSummaryDTO c(String omadacId, String siteId, long start, long end) {
        SiteTrafficSummaryDTO cachedDtoList = this.b.c(omadacId, siteId, start, end, N.a);
        if (!Objects.isNull(cachedDtoList)) {
            return cachedDtoList;
        }
        SiteTrafficSummaryDTO siteTrafficSummaryDTO = new SiteTrafficSummaryDTO();
        Aggregation aggregation = Aggregation.newAggregation((AggregationOperation[])new AggregationOperation[]{Aggregation.match((Criteria)Criteria.where((String)"omadac_id").is((Object)omadacId).and("site").is((Object)siteId).and("time").gte((Object)start).lt((Object)end)), Aggregation.group((String[])new String[]{"site"}).sum("traffic.oswtx").as("oswTx").sum("traffic.oswrx").as("oswRx").sum("traffic.osgtx").as("osgTx").sum("traffic.osgrx").as("osgRx").sum("traffic.t2g").as("ap2gTraffic").sum("traffic.t5g").as("ap5gTraffic").sum("traffic.t6g").as("ap6gTraffic"), Aggregation.project((String[])new String[]{"oswTx", "oswRx", "osgTx", "osgRx", "ap2gTraffic", "ap5gTraffic", "ap6gTraffic"})});
        this.iteratorCollectionsByTimeDesc(start, end, collectionName -> {
            AggregationResults results = this.getMongoTemplate().aggregate(aggregation, collectionName, SiteTrafficSummaryDTO.class);
            SiteTrafficSummaryDTO dto = (SiteTrafficSummaryDTO)results.getUniqueMappedResult();
            if (Objects.isNull(dto)) {
                a.debug("Failed to query site traffic of Omadac:{}, Site:{}, collection:{}!", new Object[]{omadacId, siteId, collectionName});
                return;
            }
            siteTrafficSummaryDTO.addSome(dto.getOswTx(), dto.getOswRx(), dto.getOsgTx(), dto.getOsgRx(), dto.getAp2gTraffic(), dto.getAp5gTraffic(), dto.getAp6gTraffic());
        });
        this.b.a(omadacId, siteId, start, end, N.a, siteTrafficSummaryDTO);
        return siteTrafficSummaryDTO;
    }

    public List<SiteSsidCountDTO> d(String omadacId, String siteId, long start, long end) {
        SiteStatQueryDTO statQuery = new SiteStatQueryDTO(omadacId, siteId, Long.valueOf(start), Long.valueOf(end));
        Query query = c.a(statQuery);
        ArrayList dtoList = new ArrayList();
        this.iteratorCollectionsByTimeAsc(start, end, collectionName -> {
            List poList = this.mongoTemplate.find(query, this.getPOClass(), collectionName);
            if (!CollectionUtils.isEmpty((Collection)poList)) {
                poList.forEach(po -> dtoList.add(new SiteSsidCountDTO(po.getSsidCount(), po.getTime())));
            }
        });
        return dtoList.stream().sorted(Comparator.comparing(SiteSsidCountDTO::getTime)).collect(Collectors.toList());
    }

    public SiteDeviceNumDTO a(String omadacId, List<String> siteIds, long time) {
        long end = System.currentTimeMillis() / 1000L;
        long start = end - 1800L;
        Aggregation aggregation = Aggregation.newAggregation((AggregationOperation[])new AggregationOperation[]{Aggregation.match((Criteria)Criteria.where((String)"omadac_id").is((Object)omadacId).and("site").in(siteIds).and("time").gt((Object)start).lte((Object)end)), Aggregation.sort((Sort)Sort.by((Sort.Order[])new Sort.Order[]{Sort.Order.desc((String)"time")})), Aggregation.group((String[])new String[]{"site"}).first("time").as("time").first("device").as("deviceSummary")});
        HashMap devNumDTOMap = new HashMap();
        this.iteratorCollectionsByTimeDesc(start, end, collectionName -> {
            AggregationResults results = this.getMongoTemplate().aggregate(aggregation, collectionName, GroupedDevNumDTO.class);
            List mappedResults = results.getMappedResults();
            mappedResults.forEach(dto -> devNumDTOMap.putIfAbsent(dto.getId(), dto));
        });
        SiteDeviceNumDTO siteDeviceNumDTO = new SiteDeviceNumDTO(omadacId, time);
        devNumDTOMap.values().forEach(dto -> siteDeviceNumDTO.addSome(Optional.ofNullable(dto.getDeviceSummary().getConnectedSwitches()).map(Set::size).orElse(0).intValue(), Optional.ofNullable(dto.getDeviceSummary().getTotalSwitches()).map(Set::size).orElse(0).intValue(), Optional.ofNullable(dto.getDeviceSummary().getConnectedAps()).map(Set::size).orElse(0).intValue(), Optional.ofNullable(dto.getDeviceSummary().getIsolatedAps()).map(Set::size).orElse(0).intValue(), Optional.ofNullable(dto.getDeviceSummary().getTotalAps()).map(Set::size).orElse(0).intValue(), Optional.ofNullable(dto.getDeviceSummary().getConnectedOlts()).map(Set::size).orElse(0).intValue(), Optional.ofNullable(dto.getDeviceSummary().getTotalOlts()).map(Set::size).orElse(0).intValue()));
        if (a.isDebugEnabled()) {
            a.debug("get siteDevNum by siteIds : {} , omadacId : {}", (Object)x.a((Object)siteDeviceNumDTO), (Object)omadacId);
        }
        return siteDeviceNumDTO;
    }

    public SiteDeviceNumDTO b(String omadacId, long time) {
        long end = System.currentTimeMillis() / 1000L;
        long start = end - 1800L;
        Query query = c.a(omadacId, start, end);
        SiteDeviceNumDTO resultDTO = new SiteDeviceNumDTO(omadacId, time);
        this.iteratorCollectionsByTimeAsc(start, end, collectionName -> {
            List poList = this.mongoTemplate.find(query, this.getPOClass(), collectionName);
            if (!CollectionUtils.isEmpty((Collection)poList)) {
                poList.forEach(po -> {
                    SiteDeviceNumDTO siteDeviceNumDTO = com.tplink.smb.omada.monitor.port.mongo.statistic.site.fivemin.a.b(po);
                    resultDTO.addOne(siteDeviceNumDTO);
                });
            }
        });
        if (a.isDebugEnabled()) {
            a.debug("get siteDevNum : {} , omadacId : {}", (Object)x.a((Object)resultDTO), (Object)omadacId);
        }
        return resultDTO;
    }

    public /* synthetic */ void handleEvent(Object object) {
        this.a((e)object);
    }

    private static class GroupedDevNumDTO {
        private String id;
        private Long time;
        private DeviceSummaryPO deviceSummary;

        @Generated
        public GroupedDevNumDTO() {
        }

        @Generated
        public String getId() {
            return this.id;
        }

        @Generated
        public Long getTime() {
            return this.time;
        }

        @Generated
        public DeviceSummaryPO getDeviceSummary() {
            return this.deviceSummary;
        }

        @Generated
        public void setId(String id) {
            this.id = id;
        }

        @Generated
        public void setTime(Long time) {
            this.time = time;
        }

        @Generated
        public void setDeviceSummary(DeviceSummaryPO deviceSummary) {
            this.deviceSummary = deviceSummary;
        }

        @Generated
        public boolean equals(Object o2) {
            if (o2 == this) {
                return true;
            }
            if (!(o2 instanceof GroupedDevNumDTO)) {
                return false;
            }
            GroupedDevNumDTO other = (GroupedDevNumDTO)o2;
            if (!other.canEqual(this)) {
                return false;
            }
            Long this$time = this.getTime();
            Long other$time = other.getTime();
            if (this$time == null ? other$time != null : !((Object)this$time).equals(other$time)) {
                return false;
            }
            String this$id = this.getId();
            String other$id = other.getId();
            if (this$id == null ? other$id != null : !this$id.equals(other$id)) {
                return false;
            }
            DeviceSummaryPO this$deviceSummary = this.getDeviceSummary();
            DeviceSummaryPO other$deviceSummary = other.getDeviceSummary();
            return !(this$deviceSummary == null ? other$deviceSummary != null : !this$deviceSummary.equals(other$deviceSummary));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof GroupedDevNumDTO;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Long $time = this.getTime();
            result = result * 59 + ($time == null ? 43 : ((Object)$time).hashCode());
            String $id = this.getId();
            result = result * 59 + ($id == null ? 43 : $id.hashCode());
            DeviceSummaryPO $deviceSummary = this.getDeviceSummary();
            result = result * 59 + ($deviceSummary == null ? 43 : $deviceSummary.hashCode());
            return result;
        }

        @Generated
        public String toString() {
            return "SiteStat5MinMongoRepositoryImpl.GroupedDevNumDTO(id=" + this.getId() + ", time=" + this.getTime() + ", deviceSummary=" + this.getDeviceSummary() + ")";
        }
    }
}

