/*
 * Decompiled with CFR 0.152.
 */
package com.tplink.smb.omada.monitor.port.mongo.statistic;

import com.tplink.smb.omada.common.constant.DeviceTypeEnum;
import com.tplink.smb.omada.common.constant.N;
import com.tplink.smb.omada.common.mongo.repository.s;
import com.tplink.smb.omada.monitor.port.mongo.statistic.BaseDeviceStatPO;
import com.tplink.smb.omada.monitor.port.mongo.statistic.c;
import com.tplink.smb.omada.monitor.statistic.common.dto.DeviceStatQueryDTO;
import com.tplink.smb.omada.monitor.statistic.common.dto.MacRebootTimesDTO;
import com.tplink.smb.omada.monitor.statistic.common.dto.MacTrafficDTO;
import com.tplink.smb.omada.monitor.statistic.common.dto.MacUtilDTO;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.data.mongodb.core.BulkOperations;
import org.springframework.data.mongodb.core.MongoTemplate;
import org.springframework.data.mongodb.core.aggregation.Aggregation;
import org.springframework.data.mongodb.core.aggregation.AggregationResults;
import org.springframework.data.mongodb.core.index.IndexDefinition;
import org.springframework.data.mongodb.core.query.Query;
import org.springframework.util.CollectionUtils;

public abstract class a<P extends BaseDeviceStatPO>
extends s<P>
implements com.tplink.smb.omada.monitor.statistic.c.a {
    @Autowired
    @Qualifier(value="dataMongoTemplate")
    protected MongoTemplate mongoTemplate;
    @Autowired
    protected com.tplink.smb.omada.monitor.statistic.port.a.g.a a;

    protected MongoTemplate getMongoTemplate() {
        return this.mongoTemplate;
    }

    @Nonnull
    protected IndexDefinition[] getIndexDefinitions() {
        return BaseDeviceStatPO.INDEX_DEFINITIONS;
    }

    protected abstract Aggregation a(String var1, String var2, long var3, long var5);

    protected abstract Aggregation b(String var1, String var2, long var3, long var5);

    protected abstract Aggregation a(String var1, String var2, String var3, long var4, long var6);

    protected abstract Aggregation c(String var1, String var2, long var3, long var5);

    protected abstract Aggregation d(String var1, String var2, long var3, long var5);

    public List<MacTrafficDTO> e(String omadacId, String siteId, long start, long end) {
        List cachedMacTrafficList;
        AtomicInteger atomicInteger = new AtomicInteger(0);
        N granularity = null;
        DeviceTypeEnum deviceType = null;
        switch (this.getCollectionNameOrPrefixIfSliced()) {
            case "apstat5min": {
                granularity = N.a;
                deviceType = DeviceTypeEnum.a;
                break;
            }
            case "liteapstathourly": 
            case "apstathourly": {
                granularity = N.c;
                deviceType = DeviceTypeEnum.a;
                break;
            }
            case "liteapstatdaily": 
            case "apstatdaily": {
                granularity = N.d;
                deviceType = DeviceTypeEnum.a;
                break;
            }
            case "oswstat5min": {
                granularity = N.a;
                deviceType = DeviceTypeEnum.c;
                break;
            }
            case "oswstathourly": {
                granularity = N.c;
                deviceType = DeviceTypeEnum.c;
                break;
            }
            case "oswstatdaily": {
                granularity = N.d;
                deviceType = DeviceTypeEnum.c;
                break;
            }
        }
        if (Objects.nonNull(granularity) && !CollectionUtils.isEmpty((Collection)(cachedMacTrafficList = this.a.a(omadacId, siteId, start, end, granularity, deviceType)))) {
            return cachedMacTrafficList;
        }
        Aggregation aggregation = this.a(omadacId, siteId, start, end);
        if (aggregation == null) {
            return Collections.emptyList();
        }
        N finalGranularity = granularity;
        DeviceTypeEnum finalDeviceType = deviceType;
        HashMap topResMap = new HashMap();
        this.iteratorCollectionsByTimeAsc(start, end, collectionName -> {
            atomicInteger.incrementAndGet();
            AggregationResults results = this.mongoTemplate.aggregate(aggregation, collectionName, MacTrafficDTO.class);
            List mappedResults = results.getMappedResults();
            mappedResults.forEach(statDTO -> topResMap.compute(statDTO.getMac(), (mac, previous) -> {
                if (Objects.isNull(previous)) {
                    return statDTO;
                }
                MacTrafficDTO copied = new MacTrafficDTO();
                copied.setMac(statDTO.getMac());
                copied.setTraffic(Long.valueOf(statDTO.getTraffic() + previous.getTraffic()));
                return copied;
            }));
        });
        if (Objects.nonNull(finalGranularity)) {
            this.a.a(omadacId, siteId, start, end, finalGranularity, finalDeviceType, new ArrayList(topResMap.values()));
        }
        if (atomicInteger.get() <= 1) {
            atomicInteger.set(0);
            return new ArrayList<MacTrafficDTO>(topResMap.values());
        }
        atomicInteger.set(0);
        return topResMap.values().stream().sorted(Comparator.comparing(MacTrafficDTO::getTraffic).reversed()).collect(Collectors.toList());
    }

    public List<MacRebootTimesDTO> f(String omadacId, String siteId, long start, long end) {
        Aggregation aggregation = this.b(omadacId, siteId, start, end);
        if (aggregation == null) {
            return Collections.emptyList();
        }
        HashMap topResMap = new HashMap();
        this.iteratorCollectionsByTimeAsc(start, end, collectionName -> {
            AggregationResults results = this.mongoTemplate.aggregate(aggregation, collectionName, MacRebootTimesDTO.class);
            List mappedResults = results.getMappedResults();
            mappedResults.forEach(statDTO -> topResMap.compute(statDTO.getMac(), (mac, previous) -> {
                if (Objects.isNull(previous)) {
                    return statDTO;
                }
                MacRebootTimesDTO copied = new MacRebootTimesDTO();
                copied.setMac(statDTO.getMac());
                copied.setRebootTimes(Integer.valueOf(statDTO.getRebootTimes() + previous.getRebootTimes()));
                return copied;
            }));
        });
        return topResMap.values().stream().filter(v2 -> Objects.nonNull(v2.getRebootTimes())).sorted(Comparator.comparing(MacRebootTimesDTO::getRebootTimes).reversed()).collect(Collectors.toList());
    }

    public List<MacUtilDTO> g(String omadacId, String siteId, long start, long end) {
        Aggregation aggregation = this.c(omadacId, siteId, start, end);
        if (aggregation == null) {
            return Collections.emptyList();
        }
        HashMap topResMap = new HashMap();
        this.iteratorCollectionsByTimeAsc(start, end, collectionName -> {
            AggregationResults results = this.mongoTemplate.aggregate(aggregation, collectionName, MacUtilDTO.class);
            List mappedResults = results.getMappedResults();
            mappedResults.forEach(statDTO -> topResMap.compute(statDTO.getMac(), (mac, previous) -> {
                if (Objects.isNull(previous)) {
                    return statDTO;
                }
                MacUtilDTO copied = new MacUtilDTO();
                copied.setMac(statDTO.getMac());
                copied.setCount(Integer.valueOf(statDTO.getCount() + previous.getCount()));
                if (Objects.isNull(statDTO.getUtil())) {
                    copied.setUtil(previous.getUtil());
                } else if (Objects.isNull(previous.getUtil())) {
                    copied.setUtil(statDTO.getUtil());
                } else {
                    copied.setUtil(Integer.valueOf((statDTO.getUtil() * statDTO.getCount() + previous.getUtil() * previous.getCount()) / (statDTO.getCount() + previous.getCount())));
                }
                return copied;
            }));
        });
        return topResMap.values().stream().filter(v2 -> Objects.nonNull(v2.getUtil())).sorted(Comparator.comparing(MacUtilDTO::getUtil).reversed()).collect(Collectors.toList());
    }

    public List<MacUtilDTO> h(String omadacId, String siteId, long start, long end) {
        Aggregation aggregation = this.d(omadacId, siteId, start, end);
        if (aggregation == null) {
            return Collections.emptyList();
        }
        HashMap topResMap = new HashMap();
        this.iteratorCollectionsByTimeAsc(start, end, collectionName -> {
            AggregationResults results = this.mongoTemplate.aggregate(aggregation, collectionName, MacUtilDTO.class);
            List mappedResults = results.getMappedResults();
            mappedResults.forEach(statDTO -> topResMap.compute(statDTO.getMac(), (mac, previous) -> {
                if (Objects.isNull(previous)) {
                    return statDTO;
                }
                MacUtilDTO copied = new MacUtilDTO();
                copied.setMac(statDTO.getMac());
                copied.setCount(Integer.valueOf(statDTO.getCount() + previous.getCount()));
                if (Objects.isNull(statDTO.getUtil())) {
                    copied.setUtil(previous.getUtil());
                } else if (Objects.isNull(previous.getUtil())) {
                    copied.setUtil(statDTO.getUtil());
                } else {
                    copied.setUtil(Integer.valueOf((statDTO.getUtil() * statDTO.getCount() + previous.getUtil() * previous.getCount()) / (statDTO.getCount() + previous.getCount())));
                }
                return copied;
            }));
        });
        return topResMap.values().stream().filter(v2 -> Objects.nonNull(v2.getUtil())).sorted(Comparator.comparing(MacUtilDTO::getUtil).reversed()).collect(Collectors.toList());
    }

    @Nullable
    public MacTrafficDTO b(String omadacId, String siteId, String mac, long start, long end) {
        Aggregation aggregation = this.a(omadacId, siteId, mac, start, end);
        if (aggregation == null) {
            return null;
        }
        HashMap topResMap = new HashMap();
        this.iteratorCollectionsByTimeAsc(start, end, collectionName -> {
            AggregationResults results = this.mongoTemplate.aggregate(aggregation, collectionName, MacTrafficDTO.class);
            List mappedResults = results.getMappedResults();
            mappedResults.forEach(statDTO -> topResMap.compute(statDTO.getMac(), (deviceMac, previous) -> {
                if (Objects.isNull(previous)) {
                    return statDTO;
                }
                MacTrafficDTO copied = new MacTrafficDTO();
                copied.setMac(statDTO.getMac());
                copied.setTraffic(Long.valueOf(statDTO.getTraffic() + previous.getTraffic()));
                return copied;
            }));
        });
        ArrayList macTrafficDTOS = new ArrayList(topResMap.values());
        if (CollectionUtils.isEmpty(macTrafficDTOS)) {
            return null;
        }
        return (MacTrafficDTO)macTrafficDTOS.get(0);
    }

    public long a(String omadacId) {
        AtomicLong count = new AtomicLong(0L);
        Query query = c.a(omadacId);
        this.iteratorCollections(collectionName -> count.addAndGet(this.mongoTemplate.count(query, collectionName)));
        return count.get();
    }

    public boolean a(DeviceStatQueryDTO statQuery) {
        return statQuery.getAttrs() == null && statQuery.getPorts() == null;
    }

    protected abstract Class<P> getPOClass();

    private void a(Query query, String collectionName) {
        BulkOperations bulkOperations = this.mongoTemplate.bulkOps(BulkOperations.BulkMode.UNORDERED, collectionName);
        bulkOperations.remove(query);
        bulkOperations.execute();
    }
}

