/*
 * Decompiled with CFR 0.152.
 */
package com.tplink.smb.ecsp.transport.api.transport;

import com.tplink.smb.ecsp.common.util.CollectionUtils;
import com.tplink.smb.ecsp.transport.api.Channel;
import com.tplink.smb.ecsp.transport.api.ChannelHandler;
import java.util.Arrays;
import java.util.Collection;
import java.util.concurrent.CopyOnWriteArraySet;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ChannelHandlerDispatcher
implements ChannelHandler {
    private static final Logger log = LoggerFactory.getLogger(ChannelHandlerDispatcher.class);
    private final Collection<ChannelHandler> channelHandlers = new CopyOnWriteArraySet<ChannelHandler>();

    public ChannelHandlerDispatcher(ChannelHandler ... handlers) {
        this(handlers == null ? null : Arrays.asList(handlers));
    }

    public ChannelHandlerDispatcher(Collection<ChannelHandler> handlers) {
        if (CollectionUtils.isNotEmpty(handlers)) {
            this.channelHandlers.addAll(handlers);
        }
    }

    public Collection<ChannelHandler> getChannelHandlers() {
        return this.channelHandlers;
    }

    public ChannelHandlerDispatcher addChannelHandler(ChannelHandler handler) {
        this.channelHandlers.add(handler);
        return this;
    }

    public ChannelHandlerDispatcher removeChannelHandler(ChannelHandler handler) {
        this.channelHandlers.remove(handler);
        return this;
    }

    @Override
    public void connected(Channel channel) {
        for (ChannelHandler handler : this.channelHandlers) {
            try {
                handler.connected(channel);
            }
            catch (Exception e) {
                log.warn(e.getMessage(), (Throwable)e);
            }
        }
    }

    @Override
    public void disconnected(Channel channel) {
        for (ChannelHandler handler : this.channelHandlers) {
            try {
                handler.disconnected(channel);
            }
            catch (Exception e) {
                log.warn(e.getMessage(), (Throwable)e);
            }
        }
    }

    @Override
    public void sent(Channel channel, Object message) {
        for (ChannelHandler handler : this.channelHandlers) {
            try {
                handler.sent(channel, message);
            }
            catch (Exception e) {
                log.warn(e.getMessage(), (Throwable)e);
            }
        }
    }

    @Override
    public void received(Channel channel, Object message) {
        for (ChannelHandler handler : this.channelHandlers) {
            try {
                handler.received(channel, message);
            }
            catch (Exception e) {
                log.warn(e.getMessage(), (Throwable)e);
            }
        }
    }

    @Override
    public void caught(Channel channel, Throwable exception) {
        for (ChannelHandler handler : this.channelHandlers) {
            try {
                handler.caught(channel, exception);
            }
            catch (Exception e) {
                log.warn(e.getMessage(), (Throwable)e);
            }
        }
    }
}

