/*
 * Decompiled with CFR 0.152.
 */
package com.tplink.smb.ecsp.transport.api.transport;

import com.tplink.smb.ecsp.common.URL;
import com.tplink.smb.ecsp.common.util.NetUtils;
import com.tplink.smb.ecsp.transport.api.Channel;
import com.tplink.smb.ecsp.transport.api.ChannelHandler;
import com.tplink.smb.ecsp.transport.api.Server;
import com.tplink.smb.ecsp.transport.api.exception.RemotingException;
import com.tplink.smb.ecsp.transport.api.transport.AbstractEndpoint;
import java.net.InetSocketAddress;
import java.util.Collection;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractServer
extends AbstractEndpoint
implements Server {
    private static final Logger log = LoggerFactory.getLogger(AbstractServer.class);
    private final InetSocketAddress localAddress = this.getUrl().toInetSocketAddress();
    private final InetSocketAddress bindAddress;
    private final int accepts;

    protected AbstractServer(URL url, ChannelHandler handler) throws RemotingException {
        super(url, handler);
        String bindIp = this.getUrl().getParameter("bind-ip", this.getUrl().getHost());
        int bindPort = this.getUrl().getParameter("bind-port", this.getUrl().getPort());
        if (url.getParameter("anyhost", false) || NetUtils.isInvalidLocalHost((String)bindIp)) {
            bindIp = "0.0.0.0";
        }
        this.bindAddress = new InetSocketAddress(bindIp, bindPort);
        this.accepts = url.getParameter("accepts", 130000);
        try {
            this.doOpen();
            log.info("Start {} bind {}, export {}", new Object[]{this.getClass().getSimpleName(), this.getBindAddress(), this.getLocalAddress()});
        }
        catch (RemotingException t) {
            throw new RemotingException(this.getBindAddress(), null, "Failed to bind " + this.getClass().getSimpleName() + " on " + this.getBindAddress() + ", cause: " + t.getMessage(), t);
        }
    }

    protected abstract void doOpen() throws RemotingException;

    protected abstract void doClose() throws RemotingException;

    @Override
    public void close() {
        log.info("Close {}, bind {}, export {}", new Object[]{this.getClass().getSimpleName(), this.getBindAddress(), this.getLocalAddress()});
        try {
            super.close();
        }
        catch (Exception e) {
            log.warn(e.getMessage(), (Throwable)e);
        }
        try {
            this.doClose();
        }
        catch (RemotingException e) {
            log.warn(e.getMessage(), (Throwable)e);
        }
    }

    @Override
    public void connected(Channel ch) throws RemotingException {
        if (this.isClosing() || this.isClosed()) {
            log.warn("Close new channel {} , cause: server is closing or has been closed. For example, receive a new connect request while in shutdown process.", (Object)ch);
            ch.close();
            return;
        }
        Collection<Channel> channels = this.getChannels();
        if (this.accepts > 0 && channels.size() > this.accepts) {
            log.info("Close channel {}, cause: The server {} connections greater than max config {}", new Object[]{ch, ch.getLocalAddress(), this.accepts});
            ch.close();
            return;
        }
        super.connected(ch);
    }

    @Override
    public InetSocketAddress getLocalAddress() {
        return this.localAddress;
    }

    public InetSocketAddress getBindAddress() {
        return this.bindAddress;
    }
}

