/*
 * Decompiled with CFR 0.152.
 */
package com.tplink.smb.ecsp.transport.api.transport;

import com.tplink.smb.ecsp.common.URL;
import com.tplink.smb.ecsp.transport.api.Channel;
import com.tplink.smb.ecsp.transport.api.ChannelHandler;
import com.tplink.smb.ecsp.transport.api.Endpoint;
import com.tplink.smb.ecsp.transport.api.exception.RemotingException;
import io.reactivex.Single;

public abstract class AbstractEndpoint
implements Endpoint,
ChannelHandler {
    private final ChannelHandler handler;
    private final URL url;
    private volatile boolean closing;
    private volatile boolean closed;
    private final int connectTimeout;

    public AbstractEndpoint(URL url, ChannelHandler handler) {
        if (url == null) {
            throw new IllegalArgumentException("url == null");
        }
        if (handler == null) {
            throw new IllegalArgumentException("handler == null");
        }
        this.handler = handler;
        this.url = url;
        this.connectTimeout = url.getPositiveParameter("connect-timeout", 3000);
    }

    @Override
    public Single<Boolean> send(Object message) {
        return this.send(message, this.getUrl().getParameter("sent", true));
    }

    @Override
    public void close() {
        this.closed = true;
    }

    @Override
    public void close(int timeout) {
        this.close();
    }

    @Override
    public void startClose() {
        if (this.isClosed()) {
            return;
        }
        this.closing = true;
    }

    @Override
    public boolean isClosed() {
        return this.closed;
    }

    public boolean isClosing() {
        return this.closing && !this.closed;
    }

    @Override
    public void connected(Channel ch) throws RemotingException {
        if (this.closed) {
            return;
        }
        this.handler.connected(ch);
    }

    @Override
    public void disconnected(Channel ch) throws RemotingException {
        this.handler.disconnected(ch);
    }

    @Override
    public void sent(Channel ch, Object msg) throws RemotingException {
        if (this.closed) {
            return;
        }
        this.handler.sent(ch, msg);
    }

    @Override
    public void received(Channel ch, Object msg) throws RemotingException {
        if (this.closed) {
            return;
        }
        this.handler.received(ch, msg);
    }

    @Override
    public void caught(Channel ch, Throwable ex) throws RemotingException {
        this.handler.caught(ch, ex);
    }

    public ChannelHandler getHandler() {
        return this.handler;
    }

    public URL getUrl() {
        return this.url;
    }

    public int getConnectTimeout() {
        return this.connectTimeout;
    }
}

