/*
 * Decompiled with CFR 0.152.
 */
package com.tplink.smb.ecsp.transport.api.transport;

import com.tplink.smb.ecsp.common.URL;
import com.tplink.smb.ecsp.common.util.NetUtils;
import com.tplink.smb.ecsp.transport.api.Channel;
import com.tplink.smb.ecsp.transport.api.ChannelHandler;
import com.tplink.smb.ecsp.transport.api.Client;
import com.tplink.smb.ecsp.transport.api.exception.RemotingException;
import com.tplink.smb.ecsp.transport.api.transport.AbstractEndpoint;
import java.net.InetSocketAddress;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractClient
extends AbstractEndpoint
implements Client {
    private static final Logger log = LoggerFactory.getLogger(AbstractClient.class);
    private final boolean needReconnect;
    private final Lock connectLock = new ReentrantLock();

    protected AbstractClient(URL url, ChannelHandler handler) throws RemotingException {
        super(url, handler);
        this.needReconnect = url.getParameter("send-reconnect", false);
        try {
            this.doOpen();
        }
        catch (RemotingException t) {
            this.close();
        }
        try {
            this.connect();
        }
        catch (RemotingException t) {
            this.close();
            throw t;
        }
    }

    protected void connect() throws RemotingException {
        this.connectLock.lock();
        try {
            if (this.isConnected()) {
                return;
            }
            this.doConnect();
            if (!this.isConnected()) {
                throw new RemotingException((Channel)this, "Failed connect to server " + this.getRemoteAddress() + " from " + this.getClass().getSimpleName() + " " + NetUtils.getLocalAddress() + ", cause: Connect wait timeout: " + this.getConnectTimeout() + "ms.");
            }
            log.info("Succeed connect to server {} from {} {}, channel is {}", new Object[]{this.getRemoteAddress(), this.getClass().getSimpleName(), NetUtils.getLocalAddress(), this.getChannel()});
        }
        finally {
            this.connectLock.unlock();
        }
    }

    private void disconnect() {
        this.connectLock.lock();
        try {
            try {
                Channel channel = this.getChannel();
                if (channel != null) {
                    channel.close();
                }
            }
            catch (Exception e) {
                log.warn(e.getMessage(), (Throwable)e);
            }
            try {
                this.doDisConnect();
            }
            catch (RemotingException e) {
                log.warn(e.getMessage(), (Throwable)e);
            }
        }
        finally {
            this.connectLock.unlock();
        }
    }

    @Override
    public void reconnect() throws RemotingException {
        if (!this.isConnected()) {
            this.connectLock.lock();
            try {
                if (!this.isConnected()) {
                    this.disconnect();
                    this.connect();
                }
            }
            finally {
                this.connectLock.unlock();
            }
        }
    }

    protected InetSocketAddress getConnectAddress() {
        return new InetSocketAddress(NetUtils.filterLocalHost((String)this.getUrl().getHost()), this.getUrl().getPort());
    }

    @Override
    public InetSocketAddress getRemoteAddress() {
        Channel channel = this.getChannel();
        if (channel == null) {
            return this.getUrl().toInetSocketAddress();
        }
        return channel.getRemoteAddress();
    }

    @Override
    public InetSocketAddress getLocalAddress() {
        Channel channel = this.getChannel();
        if (channel == null) {
            return InetSocketAddress.createUnresolved(NetUtils.getLocalHost(), 0);
        }
        return channel.getLocalAddress();
    }

    @Override
    public boolean isConnected() {
        Channel channel = this.getChannel();
        if (channel == null) {
            return false;
        }
        return channel.isConnected();
    }

    @Override
    public void close() {
        try {
            super.close();
        }
        catch (Exception e) {
            log.warn(e.getMessage(), (Throwable)e);
        }
        try {
            this.disconnect();
        }
        catch (Exception e) {
            log.warn(e.getMessage(), (Throwable)e);
        }
        try {
            this.doClose();
        }
        catch (RemotingException e) {
            log.warn(e.getMessage(), (Throwable)e);
        }
    }

    protected abstract void doOpen() throws RemotingException;

    protected abstract void doClose() throws RemotingException;

    protected abstract void doConnect() throws RemotingException;

    protected abstract void doDisConnect() throws RemotingException;

    protected abstract Channel getChannel();

    public boolean isNeedReconnect() {
        return this.needReconnect;
    }
}

