/*
 * Decompiled with CFR 0.152.
 */
package com.tplink.smb.ecsp.transport.api.security;

import com.tplink.smb.ecsp.common.util.StringUtils;
import com.tplink.smb.ecsp.common.util.encrypt.Base64Utils;
import java.io.ByteArrayInputStream;
import java.io.FileInputStream;
import java.io.IOException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.cert.CertificateException;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManagerFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SslContexts {
    private static final Logger log = LoggerFactory.getLogger(SslContexts.class);
    private static final String KEY_MANAGER_TYPE = "SunX509";
    private static final String TLS_PROTOCOL = "TLSv1.2";
    private static final String CERT_FILE_TYPE = "PKCS12";
    private static final String KEYSTORE_TYPE = "JKS";

    private SslContexts() {
    }

    public static SSLContext buildSslContext(String certFile, String certPwd, String storeFile, String storePwd, String tlsProtocol) {
        SSLContext sslContext = null;
        try {
            KeyManagerFactory keyManagerFactory = KeyManagerFactory.getInstance(KEY_MANAGER_TYPE);
            KeyStore keyStore = SslContexts.getKeyStore(certFile, certPwd, CERT_FILE_TYPE);
            keyManagerFactory.init(keyStore, certPwd.toCharArray());
            TrustManagerFactory trustManagerFactory = TrustManagerFactory.getInstance(KEY_MANAGER_TYPE);
            KeyStore trustKeyStore = SslContexts.getKeyStore(storeFile, storePwd, KEYSTORE_TYPE);
            trustManagerFactory.init(trustKeyStore);
            sslContext = SSLContext.getInstance(StringUtils.isEmpty((String)tlsProtocol) ? TLS_PROTOCOL : tlsProtocol);
            sslContext.init(keyManagerFactory.getKeyManagers(), trustManagerFactory.getTrustManagers(), null);
        }
        catch (Exception e) {
            log.error("failed to init ssl handler, cause: sslCertificate params error : ", (Throwable)e);
        }
        return sslContext;
    }

    public static SSLContext buildSslContextFromFile(String certFilePath, String certPwd, String storeFilePath, String storePwd, String tlsProtocol) {
        SSLContext sslContext = null;
        try {
            KeyManagerFactory keyManagerFactory = KeyManagerFactory.getInstance(KEY_MANAGER_TYPE);
            KeyStore keyStore = SslContexts.getKeyStoreFile(certFilePath, certPwd, CERT_FILE_TYPE);
            keyManagerFactory.init(keyStore, certPwd.toCharArray());
            TrustManagerFactory trustManagerFactory = TrustManagerFactory.getInstance(KEY_MANAGER_TYPE);
            KeyStore trustKeyStore = SslContexts.getKeyStoreFile(storeFilePath, storePwd, KEYSTORE_TYPE);
            trustManagerFactory.init(trustKeyStore);
            sslContext = SSLContext.getInstance(StringUtils.isEmpty((String)tlsProtocol) ? TLS_PROTOCOL : tlsProtocol);
            sslContext.init(keyManagerFactory.getKeyManagers(), trustManagerFactory.getTrustManagers(), null);
        }
        catch (Exception e) {
            log.error("failed to init ssl handler, cause: sslCertificate params error : ", (Throwable)e);
        }
        return sslContext;
    }

    private static KeyStore getKeyStore(String keyStoreStr, String password, String type) throws IOException, KeyStoreException, CertificateException, NoSuchAlgorithmException {
        KeyStore keyStore = KeyStore.getInstance(type);
        byte[] keyStoreBytes = Base64Utils.base64DecoderCompatible((String)keyStoreStr);
        keyStore.load(new ByteArrayInputStream(keyStoreBytes), password.toCharArray());
        return keyStore;
    }

    private static KeyStore getKeyStoreFile(String filePath, String password, String type) throws IOException, KeyStoreException, CertificateException, NoSuchAlgorithmException {
        KeyStore keyStore = KeyStore.getInstance(type);
        keyStore.load(new FileInputStream(filePath), password.toCharArray());
        return keyStore;
    }
}

