/*
 * Decompiled with CFR 0.152.
 */
package com.tplink.smb.ecsp.transport.api.monitor;

import com.tplink.smb.ecsp.common.StringTags;
import com.tplink.smb.ecsp.common.monitor.MonitorConstants;
import com.tplink.smb.ecsp.common.monitor.MonitorHelper;
import com.tplink.smb.ecsp.protocol.packet.body.MessageType;
import com.tplink.smb.ecsp.protocol.packet.header.EcspVersion;
import com.tplink.smb.rtty.protocol.packet.RttyMessageType;
import io.micrometer.core.instrument.Counter;
import io.micrometer.core.instrument.Timer;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import javax.annotation.Nonnull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ServerMonitor {
    private static final Logger log = LoggerFactory.getLogger(ServerMonitor.class);
    private static final Map<StringTags, AtomicInteger> tcpConnections = new ConcurrentHashMap<StringTags, AtomicInteger>(1);
    private static final Map<StringTags, Counter> deviceDisconnectedCounters = new ConcurrentHashMap<StringTags, Counter>(8);
    private static final Map<StringTags, AtomicLong> nettyMemory = new ConcurrentHashMap<StringTags, AtomicLong>(2);
    private static final Map<StringTags, AtomicLong> nettyTraffic = new ConcurrentHashMap<StringTags, AtomicLong>(4);
    private static final Map<StringTags, Timer> serverWriteTimers = new ConcurrentHashMap<StringTags, Timer>(2);
    private static final Map<StringTags, Counter> serverDecodeFailedCounters = new ConcurrentHashMap<StringTags, Counter>(2);
    private static final Map<StringTags, Counter> serverUnderAttackCounters = new ConcurrentHashMap<StringTags, Counter>(1);
    private static final Map<StringTags, Counter> serverWriteFailedCounters = new ConcurrentHashMap<StringTags, Counter>(8);
    private static final Map<StringTags, Counter> ecspUdpPacketCounters = new ConcurrentHashMap<StringTags, Counter>(2);
    private static final Map<StringTags, Counter> ecspTcpPacketCounters = new ConcurrentHashMap<StringTags, Counter>(32);
    private static final Map<StringTags, Counter> v1UpgradeFileCounters = new ConcurrentHashMap<StringTags, Counter>(1);
    private static final Map<StringTags, Counter> rttyTcpPacketCounters = new ConcurrentHashMap<StringTags, Counter>(8);
    private static final Map<StringTags, Counter> monitorTcpMessageCounters = new ConcurrentHashMap<StringTags, Counter>(8);
    private static final Map<StringTags, Counter> monitorInvalidMessageCounters = new ConcurrentHashMap<StringTags, Counter>(8);
    private static final Map<StringTags, Counter> monitorVerifyResultCounters = new ConcurrentHashMap<StringTags, Counter>(8);
    private static final Map<StringTags, Counter> ecspVerifyFailedCounters = new ConcurrentHashMap<StringTags, Counter>(4);
    private static final Map<StringTags, Counter> ignoreDeviceDiscoveryCounters = new ConcurrentHashMap<StringTags, Counter>(1);
    private static final Map<StringTags, Counter> resetDeviceTimeoutCounters = new ConcurrentHashMap<StringTags, Counter>(1);
    private static final Map<StringTags, Counter> v1DeviceRebuildCounters = new ConcurrentHashMap<StringTags, Counter>(1);
    private static final Map<StringTags, Counter> v2DeviceReConnectCounters = new ConcurrentHashMap<StringTags, Counter>(1);
    private static final Map<StringTags, Counter> v2DeviceRebuildCounters = new ConcurrentHashMap<StringTags, Counter>(1);
    private static final Map<StringTags, Timer> deviceInformIntervalTimers = new ConcurrentHashMap<StringTags, Timer>(1);
    private static final Map<StringTags, Timer> ecspPacketWaitResponseTimers = new ConcurrentHashMap<StringTags, Timer>(4);
    private static final Map<StringTags, AtomicLong> deviceStatusGauge = new ConcurrentHashMap<StringTags, AtomicLong>(8);

    private ServerMonitor() {
    }

    public static AtomicInteger getV1AdoptConnectionsGauge() {
        return MonitorHelper.getIntegerGauge(tcpConnections, (String)"tcp.running.connection", (StringTags)MonitorConstants.V1_ADOPT_TAGS);
    }

    public static AtomicInteger getV1ManageConnectionsGauge() {
        return MonitorHelper.getIntegerGauge(tcpConnections, (String)"tcp.running.connection", (StringTags)MonitorConstants.V1_MANAGE_TAGS);
    }

    public static AtomicInteger getV1UpgradeConnectionsGauge() {
        return MonitorHelper.getIntegerGauge(tcpConnections, (String)"tcp.running.connection", (StringTags)MonitorConstants.V1_UPGRADE_TAGS);
    }

    public static AtomicInteger getV2ManageConnectionsGauge() {
        return MonitorHelper.getIntegerGauge(tcpConnections, (String)"tcp.running.connection", (StringTags)MonitorConstants.V2_MANAGE_TAGS);
    }

    public static AtomicInteger getV2TransferConnectionsGauge() {
        return MonitorHelper.getIntegerGauge(tcpConnections, (String)"tcp.running.connection", (StringTags)MonitorConstants.V2_TRANSFER_TAGS);
    }

    public static AtomicInteger getRttyConnectionsGauge() {
        return MonitorHelper.getIntegerGauge(tcpConnections, (String)"tcp.running.connection", (StringTags)MonitorConstants.RTTY_MANAGE_TAGS);
    }

    public static AtomicInteger getMonitorConnectionsGauge() {
        return MonitorHelper.getIntegerGauge(tcpConnections, (String)"tcp.running.connection", (StringTags)MonitorConstants.V2_MONITOR_TAGS);
    }

    public static void incDeviceDisconnectedCounter(@Nonnull EcspVersion ecspVersion, @Nonnull String end) {
        StringTags deviceDisconnectedTags = new StringTags(new String[]{"ecsp.version", ecspVersion.getVersion(), "ecsp.end", end});
        MonitorHelper.incCounter(deviceDisconnectedCounters, (String)"device_disconnected_total", (StringTags)deviceDisconnectedTags);
    }

    public static void incRttyDeviceDisconnectedCounter() {
        MonitorHelper.incCounter(deviceDisconnectedCounters, (String)"rtty_device_disconnected_total", (StringTags)MonitorConstants.RTTY_MANAGE_TAGS);
    }

    public static void incRefuseDeviceConnectCounter(@Nonnull EcspVersion ecspVersion) {
        StringTags refuseDeviceConnectTags = new StringTags(new String[]{"ecsp.version", ecspVersion.getVersion()});
        MonitorHelper.incCounter(deviceDisconnectedCounters, (String)"refuse_device_connect_total", (StringTags)refuseDeviceConnectTags);
    }

    public static void incRttyRefuseDeviceConnectCounter() {
        MonitorHelper.incCounter(deviceDisconnectedCounters, (String)"rtty_refuse_device_connect_total", (StringTags)MonitorConstants.RTTY_MANAGE_TAGS);
    }

    public static void incRefuseDeviceMonitorConnectCounter() {
        MonitorHelper.incCounter(deviceDisconnectedCounters, (String)"refuse_device_monitor_connect_total", (StringTags)MonitorConstants.V2_MONITOR_TAGS);
    }

    public static AtomicLong getNettyHeapMemoryGauge() {
        return MonitorHelper.getLongGauge(nettyMemory, (String)"netty.memory", (StringTags)MonitorConstants.HEAP_MEMORY_TAGS);
    }

    public static AtomicLong getNettyDirectMemoryGauge() {
        return MonitorHelper.getLongGauge(nettyMemory, (String)"netty.memory", (StringTags)MonitorConstants.DIRECT_MEMORY_TAGS);
    }

    public static AtomicLong getNettyTrafficQueueSize(int bindPort) {
        StringTags nettyTrafficTags = new StringTags(new String[]{"tcp.port", String.valueOf(bindPort)});
        return MonitorHelper.getLongGauge(nettyTraffic, (String)"netty.traffic.queue.size", (StringTags)nettyTrafficTags);
    }

    public static AtomicLong getNettyTrafficWriteThroughput(int bindPort) {
        StringTags nettyTrafficTags = new StringTags(new String[]{"tcp.port", String.valueOf(bindPort)});
        return MonitorHelper.getLongGauge(nettyTraffic, (String)"netty.traffic.write.throughput", (StringTags)nettyTrafficTags);
    }

    public static AtomicLong getNettyTrafficReadThroughput(int bindPort) {
        StringTags nettyTrafficTags = new StringTags(new String[]{"tcp.port", String.valueOf(bindPort)});
        return MonitorHelper.getLongGauge(nettyTraffic, (String)"netty.traffic.read.throughput", (StringTags)nettyTrafficTags);
    }

    public static Timer getServerWriteEcspTimer() {
        return MonitorHelper.getTimer(serverWriteTimers, (String)"server.write.time", (StringTags)MonitorConstants.SERVER_WRITE_ECSP_TAGS);
    }

    public static Timer getServerWriteFileTimer() {
        return MonitorHelper.getTimer(serverWriteTimers, (String)"server.write.time", (StringTags)MonitorConstants.SERVER_WRITE_FILE_TAGS);
    }

    public static void incUdpDecodeFailedCounter() {
        MonitorHelper.incCounter(serverDecodeFailedCounters, (String)"server.decode.fail", (StringTags)MonitorConstants.UDP_DECODE_TAGS);
    }

    public static void incTcpDecodeFailedCounter() {
        MonitorHelper.incCounter(serverDecodeFailedCounters, (String)"server.decode.fail", (StringTags)MonitorConstants.TCP_DECODE_TAGS);
    }

    public static void incRc4DecodeFailedCounter() {
        MonitorHelper.incCounter(serverDecodeFailedCounters, (String)"server.decode.fail", (StringTags)MonitorConstants.RC4_DECODE_TAGS);
    }

    public static void incTcpPacketDisassembleDecodeFailedCounter() {
        MonitorHelper.incCounter(serverDecodeFailedCounters, (String)"server.decode.fail", (StringTags)MonitorConstants.TCP_DISASSEMBLE_DECODE_TAGS);
    }

    public static void incXSSAttackCounter(@Nonnull MessageType messageType) {
        StringTags stringTags = new StringTags(new String[]{"attack.type", "xss", "message.type", messageType.getType()});
        MonitorHelper.incCounter(serverUnderAttackCounters, (String)"server.under.attack", (StringTags)stringTags);
    }

    public static void incChannelDisconnectCounter() {
        MonitorHelper.incCounter(serverWriteFailedCounters, (String)"server.write.failed", (StringTags)MonitorConstants.CHANNEL_DISCONNECT_TAGS);
    }

    public static void incHighWaterMarkCounter() {
        MonitorHelper.incCounter(serverWriteFailedCounters, (String)"server.write.failed", (StringTags)MonitorConstants.HIGH_WATER_MARK_TAGS);
    }

    public static void incWriteTaskCanceledCounter() {
        MonitorHelper.incCounter(serverWriteFailedCounters, (String)"server.write.failed", (StringTags)MonitorConstants.WRITE_TASK_CANCELED_TAGS);
    }

    public static void incWriteExceptionCounter() {
        MonitorHelper.incCounter(serverWriteFailedCounters, (String)"server.write.failed", (StringTags)MonitorConstants.WRITE_EXCEPTION_TAGS);
    }

    public static void incWriteTimeoutExceptionCounter() {
        MonitorHelper.incCounter(serverWriteFailedCounters, (String)"server.write.failed", (StringTags)MonitorConstants.WRITE_TIMEOUT_EXCEPTION_TAGS);
    }

    public static void incIncomingEcspUdpCounter(@Nonnull MessageType messageType, @Nonnull EcspVersion ecspVersion) {
        StringTags messageTags = new StringTags(new String[]{"data.flow", "incoming", "message.type", messageType.getType(), "ecsp.version", ecspVersion.getVersion()});
        MonitorHelper.incCounter(ecspUdpPacketCounters, (String)"ecsp.packet.udp", (StringTags)messageTags);
    }

    public static void incOutgoingEcspUdpCounter(@Nonnull MessageType messageType, @Nonnull EcspVersion ecspVersion) {
        StringTags messageTags = new StringTags(new String[]{"data.flow", "outgoing", "message.type", messageType.getType(), "ecsp.version", ecspVersion.getVersion()});
        MonitorHelper.incCounter(ecspUdpPacketCounters, (String)"ecsp.packet.udp", (StringTags)messageTags);
    }

    public static void incIncomingEcspTcpCounter(@Nonnull MessageType messageType, @Nonnull EcspVersion ecspVersion) {
        StringTags messageTags = new StringTags(new String[]{"data.flow", "incoming", "message.type", messageType.getType(), "ecsp.version", ecspVersion.getVersion()});
        MonitorHelper.incCounter(ecspTcpPacketCounters, (String)"ecsp.packet.tcp", (StringTags)messageTags);
    }

    public static void incOutgoingEcspTcpCounter(@Nonnull MessageType messageType, @Nonnull EcspVersion ecspVersion) {
        StringTags messageTags = new StringTags(new String[]{"data.flow", "outgoing", "message.type", messageType.getType(), "ecsp.version", ecspVersion.getVersion()});
        MonitorHelper.incCounter(ecspTcpPacketCounters, (String)"ecsp.packet.tcp", (StringTags)messageTags);
    }

    public static void incOutgoingUpgradeFileCounter() {
        StringTags messageTags = new StringTags(new String[]{"data.flow", "outgoing"});
        MonitorHelper.incCounter(v1UpgradeFileCounters, (String)"v1.upgrade.file", (StringTags)messageTags);
    }

    public static void incIncomingRttyTcpCounter(@Nonnull RttyMessageType rttyMessageType) {
        StringTags messageTags = new StringTags(new String[]{"data.flow", "incoming", "rtty.message.type", rttyMessageType.getType()});
        MonitorHelper.incCounter(rttyTcpPacketCounters, (String)"rtty.packet.tcp", (StringTags)messageTags);
    }

    public static void incOutgoingRttyTcpCounter(@Nonnull RttyMessageType rttyMessageType) {
        StringTags messageTags = new StringTags(new String[]{"data.flow", "outgoing", "rtty.message.type", rttyMessageType.getType()});
        MonitorHelper.incCounter(rttyTcpPacketCounters, (String)"rtty.packet.tcp", (StringTags)messageTags);
    }

    public static void incIncomingMonitorTcpCounter() {
        StringTags messageTags = new StringTags(new String[]{"data.flow", "incoming"});
        MonitorHelper.incCounter(monitorTcpMessageCounters, (String)"monitor.packet.tcp", (StringTags)messageTags);
    }

    public static void incMonitorInvalidMessageCounter() {
        StringTags messageTags = new StringTags(new String[]{"data.flow", "incoming"});
        MonitorHelper.incCounter(monitorInvalidMessageCounters, (String)"monitor.packet.tcp", (StringTags)messageTags);
    }

    public static void incMonitorVerifyResultCounter(@Nonnull String verifyResult) {
        StringTags resultTags = new StringTags(new String[]{"data.flow", "incoming", "monitor.verify.result.type", verifyResult});
        MonitorHelper.incCounter(monitorVerifyResultCounters, (String)"monitor.verify.result", (StringTags)resultTags);
    }

    public static void incEcspVerifyFailedCounter(@Nonnull MessageType messageType, @Nonnull String failedReason) {
        StringTags verifyFailedTags = new StringTags(new String[]{"failed.reason", failedReason, "message.type", messageType.getType()});
        MonitorHelper.incCounter(ecspVerifyFailedCounters, (String)"ecsp.verify.failed", (StringTags)verifyFailedTags);
    }

    public static void incIgnoreCoolDownDiscoveryCounter(@Nonnull EcspVersion ecspVersion) {
        StringTags ignoreDiscoveryTags = new StringTags(new String[]{"ecsp.version", ecspVersion.getVersion(), "reason", "cool.down.ignore"});
        MonitorHelper.incCounter(ignoreDeviceDiscoveryCounters, (String)"device.discovery.ignore", (StringTags)ignoreDiscoveryTags);
    }

    public static void incResetDeviceTimeoutCounter() {
        MonitorHelper.incCounter(resetDeviceTimeoutCounters, (String)"reset.device.timeout", (StringTags)MonitorConstants.STATUS_ALL_TAGS);
    }

    public static void incV1DeviceRebuildCounter() {
        MonitorHelper.incCounter(v1DeviceRebuildCounters, (String)"v1.rebuild.success", (StringTags)MonitorConstants.STATUS_ALL_TAGS);
    }

    public static void incV2DeviceReconnectCounter() {
        MonitorHelper.incCounter(v2DeviceReConnectCounters, (String)"v2.reconnect.success", (StringTags)MonitorConstants.STATUS_ALL_TAGS);
    }

    public static void incV2DeviceRebuildCounter() {
        MonitorHelper.incCounter(v2DeviceRebuildCounters, (String)"v2.rebuild.success", (StringTags)MonitorConstants.STATUS_ALL_TAGS);
    }

    public static Timer getDeviceInformIntervalTimer() {
        return MonitorHelper.getTimer(deviceInformIntervalTimers, (String)"inform_interval_seconds", (StringTags)MonitorConstants.STATUS_ALL_TAGS);
    }

    public static Timer getEcspWaitResponseTimer(@Nonnull MessageType messageType, @Nonnull EcspVersion ecspVersion) {
        StringTags waitResponseTags = new StringTags(new String[]{"message.type", messageType.getType(), "ecsp.version", ecspVersion.getVersion()});
        return MonitorHelper.getTimer(ecspPacketWaitResponseTimers, (String)"ecsp.wait.response.time", (StringTags)waitResponseTags);
    }

    public static AtomicLong getDeviceStatusGauge(@Nonnull String statusType) {
        StringTags deviceStatusTypeTags = new StringTags(new String[]{"status.type", statusType});
        return MonitorHelper.getLongGauge(deviceStatusGauge, (String)"device.context.status", (StringTags)deviceStatusTypeTags);
    }
}

