/*
 * Decompiled with CFR 0.152.
 */
package com.tplink.smb.ecsp.transport.api.monitor;

import com.tplink.smb.ecsp.common.StringTags;
import com.tplink.smb.ecsp.common.monitor.MonitorConstants;
import com.tplink.smb.ecsp.common.monitor.MonitorHelper;
import com.tplink.smb.ecsp.common.util.OmadaPIIUtils;
import io.micrometer.core.instrument.Counter;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DailyMonitor {
    private static final Logger log = LoggerFactory.getLogger(DailyMonitor.class);
    public static ConcurrentHashMap<String, Long> deviceLastConnectTime = new ConcurrentHashMap();
    public static ConcurrentHashMap<String, Long> deviceBlackList = new ConcurrentHashMap();
    public static final Map<String, AtomicInteger> deviceDailyConnectGaugeMap = new ConcurrentHashMap<String, AtomicInteger>(1);
    public static final Map<StringTags, Counter> deviceDailyConnectTimesInPeriod1Counter = new ConcurrentHashMap<StringTags, Counter>(1);
    public static final Map<StringTags, Counter> deviceDailyConnectTimesInPeriod2Counter = new ConcurrentHashMap<StringTags, Counter>(1);
    public static final Map<StringTags, Counter> deviceDailyConnectTimesInPeriod3Counter = new ConcurrentHashMap<StringTags, Counter>(1);
    public static final Map<StringTags, Counter> deviceDailyConnectTimesOverThresholdCounter = new ConcurrentHashMap<StringTags, Counter>(1);
    public static final long ONE_HOUR = TimeUnit.HOURS.toMillis(1L);
    public static final long TWENTY_FOUR_HOURS = TimeUnit.HOURS.toMillis(24L);

    public static int incAndGetDeviceConnectGauge(@Nonnull String deviceMac, int threshold, int period1, int period2, int period3, boolean enableBlackList) {
        int currentConnections = DailyMonitor.increment(deviceMac);
        if (enableBlackList && !deviceBlackList.containsKey(deviceMac) && !deviceLastConnectTime.containsKey(deviceMac)) {
            if (currentConnections > threshold) {
                long timestamp = System.currentTimeMillis();
                if (Objects.isNull(deviceBlackList.get(deviceMac))) {
                    DailyMonitor.incDeviceConnectOverThresholdCounter();
                    log.info("Device {} has been blacklisted due to exceeding the daily threshold of connection/disconnection attempts of {}.", (Object)OmadaPIIUtils.encryptWithCache((String)deviceMac), (Object)threshold);
                    deviceBlackList.put(deviceMac, timestamp);
                }
                deviceLastConnectTime.put(deviceMac, timestamp);
            } else if (currentConnections == period1) {
                DailyMonitor.incDeviceConnectInPeriod1Counter();
            } else if (currentConnections == period2) {
                DailyMonitor.incDeviceConnectInPeriod2Counter();
            } else if (currentConnections == period3) {
                DailyMonitor.incDeviceConnectInPeriod3Counter();
            }
        }
        return currentConnections;
    }

    public static int increment(String key) {
        return deviceDailyConnectGaugeMap.computeIfAbsent(key, k -> new AtomicInteger(0)).incrementAndGet();
    }

    public static int getDeviceConnectGauge(@Nonnull String deviceMac) {
        AtomicInteger atomicInteger = deviceDailyConnectGaugeMap.get(deviceMac);
        if (Objects.isNull(atomicInteger)) {
            return 0;
        }
        return deviceDailyConnectGaugeMap.get(deviceMac).get();
    }

    public static void incDeviceConnectOverThresholdCounter() {
        MonitorHelper.incCounter(deviceDailyConnectTimesOverThresholdCounter, (String)"device.daily.connections", (StringTags)MonitorConstants.DEVICE_CONNECT_TIMES_OVER_THRESHOLD_TAGS);
    }

    public static void incDeviceConnectInPeriod1Counter() {
        MonitorHelper.incCounter(deviceDailyConnectTimesInPeriod1Counter, (String)"device.daily.connections", (StringTags)MonitorConstants.DEVICE_CONNECT_TIMES_PERIOD1_TAGS);
    }

    public static void incDeviceConnectInPeriod2Counter() {
        MonitorHelper.incCounter(deviceDailyConnectTimesInPeriod2Counter, (String)"device.daily.connections", (StringTags)MonitorConstants.DEVICE_CONNECT_TIMES_PERIOD2_TAGS);
    }

    public static void incDeviceConnectInPeriod3Counter() {
        MonitorHelper.incCounter(deviceDailyConnectTimesInPeriod3Counter, (String)"device.daily.connections", (StringTags)MonitorConstants.DEVICE_CONNECT_TIMES_PERIOD3_TAGS);
    }

    public static boolean isDeviceBlackList(String deviceMac) {
        if (!deviceLastConnectTime.containsKey(deviceMac) || !deviceBlackList.containsKey(deviceMac)) {
            return false;
        }
        Long currentTime = System.currentTimeMillis();
        long lastConnectionTime = deviceLastConnectTime.get(deviceMac);
        if (currentTime - lastConnectionTime >= ONE_HOUR) {
            deviceBlackList.put(deviceMac, currentTime);
            log.debug("Device {} is in blacklist, try to connect for once an hour", (Object)OmadaPIIUtils.encryptWithCache((String)deviceMac));
            return false;
        }
        return true;
    }

    public static void removeDeviceFromBlackList(String deviceMac) {
        deviceDailyConnectGaugeMap.remove(deviceMac);
        deviceBlackList.remove(deviceMac);
        deviceLastConnectTime.remove(deviceMac);
        log.info("Remove device {} from blacklist, and clear the connect gauge", (Object)OmadaPIIUtils.encryptWithCache((String)deviceMac));
    }

    public static void addDeviceToBlackList(String deviceMac) {
        long timestamp = System.currentTimeMillis();
        deviceBlackList.put(deviceMac, timestamp);
        deviceLastConnectTime.put(deviceMac, timestamp);
        log.info("Add device {} into blacklist, connection will be limited", (Object)OmadaPIIUtils.encryptWithCache((String)deviceMac));
    }

    public static void clearAllDeviceBlackList() {
        for (String mac : deviceBlackList.keySet()) {
            deviceDailyConnectGaugeMap.remove(mac);
        }
        deviceBlackList.clear();
        deviceLastConnectTime.clear();
        log.info("All device blacklists and connectgauges have been cleared.");
    }

    public static List<String> listDeviceBlackList() {
        log.debug("Try to list device blacklist, list size is {}", (Object)deviceBlackList.size());
        return deviceBlackList.keySet().stream().map(OmadaPIIUtils::encryptWithoutCache).collect(Collectors.toList());
    }
}

