/*
 * Decompiled with CFR 0.152.
 */
package com.tplink.smb.ecsp.transport.api;

import com.tplink.nbu.common.pii.constant.PIIMaskStrategy;
import com.tplink.smb.ecsp.common.URL;
import com.tplink.smb.ecsp.transport.api.ChannelHandler;
import com.tplink.smb.ecsp.transport.api.Client;
import com.tplink.smb.ecsp.transport.api.Server;
import com.tplink.smb.ecsp.transport.api.Transporter;
import com.tplink.smb.ecsp.transport.api.exception.RemotingException;
import com.tplink.smb.ecsp.transport.api.transport.ChannelHandlerAdapter;
import com.tplink.smb.ecsp.transport.api.transport.ChannelHandlerDispatcher;
import java.util.Map;
import javax.annotation.Resource;

public class Transporters {
    @Resource
    private Transporter transporter;

    public Server bind(String url, ChannelHandler ... handler) throws RemotingException {
        return this.bind(URL.valueOf((String)url), handler);
    }

    public Server bind(URL url, ChannelHandler ... handlers) throws RemotingException {
        if (url == null) {
            throw new IllegalArgumentException("url == null");
        }
        if (handlers == null || handlers.length == 0) {
            throw new IllegalArgumentException("handlers == null");
        }
        ChannelHandler handler = handlers.length == 1 ? handlers[0] : new ChannelHandlerDispatcher(handlers);
        return this.transporter.bind(url, handler);
    }

    public Client connect(String url, ChannelHandler ... handler) throws RemotingException {
        return this.connect(URL.valueOf((String)url), handler);
    }

    public Client connect(URL url, ChannelHandler ... handlers) throws RemotingException {
        if (url == null) {
            throw new IllegalArgumentException("url == null");
        }
        ChannelHandler handler = handlers == null || handlers.length == 0 ? new ChannelHandlerAdapter() : (handlers.length == 1 ? handlers[0] : new ChannelHandlerDispatcher(handlers));
        return this.transporter.connect(url, handler);
    }

    public long usedHeapMemory() {
        return this.transporter.usedHeapMemory();
    }

    public long usedDirectMemory() {
        return this.transporter.usedDirectMemory();
    }

    public void setMaskMessageMap(Map<String, Map<String, PIIMaskStrategy>> maskMessageMap) {
        this.transporter.setMaskMessageMap(maskMessageMap);
    }
}

