/*
 * Decompiled with CFR 0.152.
 */
package com.tplink.smb.ecsp.transport.api;

import java.util.HashMap;
import java.util.Map;

public enum TransporterType {
    UDP("udp"),
    TCP("tcp"),
    MQTT("mqtt"),
    WEBSOCKET("websocket"),
    RTTY("rtty");

    private final String type;
    private static final Map<String, TransporterType> typeMap;

    private TransporterType(String type) {
        this.type = type;
    }

    public static TransporterType fromString(String type) {
        return typeMap.get(type);
    }

    public String getType() {
        return this.type;
    }

    static {
        typeMap = new HashMap<String, TransporterType>(4);
        for (TransporterType type : TransporterType.values()) {
            typeMap.put(type.getType(), type);
        }
    }
}

