/*
 * Decompiled with CFR 0.152.
 */
package com.tplink.smb.omada.system.api.util;

import com.tplink.smb.omada.common.util.b.b;
import com.tplink.smb.omada.system.api.util.a;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.math.BigInteger;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.Provider;
import java.security.PublicKey;
import java.security.SecureRandom;
import java.security.Security;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.Enumeration;
import java.util.List;
import java.util.Objects;
import java.util.Random;
import lombok.Generated;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.DERSequence;
import org.bouncycastle.asn1.x500.X500Name;
import org.bouncycastle.asn1.x509.BasicConstraints;
import org.bouncycastle.asn1.x509.ExtendedKeyUsage;
import org.bouncycastle.asn1.x509.Extension;
import org.bouncycastle.asn1.x509.GeneralName;
import org.bouncycastle.asn1.x509.GeneralNames;
import org.bouncycastle.asn1.x509.KeyPurposeId;
import org.bouncycastle.asn1.x509.KeyUsage;
import org.bouncycastle.asn1.x509.SubjectPublicKeyInfo;
import org.bouncycastle.cert.X509CertificateHolder;
import org.bouncycastle.cert.X509v3CertificateBuilder;
import org.bouncycastle.cert.jcajce.JcaX509CertificateConverter;
import org.bouncycastle.cert.jcajce.JcaX509v3CertificateBuilder;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.bouncycastle.operator.jcajce.JcaContentSignerBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class X509CertificateUtils {
    @Generated
    private static final Logger i = LoggerFactory.getLogger(X509CertificateUtils.class);
    public static final String a = "/data/keystore/eap.keystore";
    public static final String b = "/data/keystore/smb.keystore";
    public static final String c = "/data/keystore/user.jks";
    public static final String d = "/data/keystore/user";
    public static final String e = "/data/keystore/radiusServerCa.keystore";
    public static final String f = "/data/keystore/radiusServerSub.keystore";
    private static final String j = "CN=localhost,O=TP-Link,OU=TP-Link";
    private static final String k = "CN=radius,OU=TP-Link,O=TP-Link";
    private static final String l = "CN=radiusRoot,O=TP-Link,OU=TP-Link";
    private static final String m = "eap";
    public static final String g = "radiusServerCa";
    public static final String h = "radiusServerSub";
    private static final String n = "hZDS+0KJPkhSM2AXUEeGGQ==";
    private static final String o = "SHA256withRSA";
    private static final String p = "RSA";
    private static final String q = "Omada";
    private static final String r = "JKS";
    private static final int s = 4096;
    private static final int t = 825;
    private static final int u = 9125;
    private static final int v = 128;
    private static final String w = "BC";
    private static final String x = "X.509";

    public static KeyPair a() {
        KeyPairGenerator keyGen = null;
        try {
            keyGen = KeyPairGenerator.getInstance(p);
        }
        catch (NoSuchAlgorithmException e2) {
            i.error(e2.getMessage(), (Throwable)e2);
            return null;
        }
        keyGen.initialize(4096, new SecureRandom());
        return keyGen.generateKeyPair();
    }

    public static X509Certificate a(KeyPair keyPair, Date validFrom) {
        Security.addProvider((Provider)new BouncyCastleProvider());
        try {
            PrivateKey privateKey = keyPair.getPrivate();
            PublicKey publicKey = keyPair.getPublic();
            X500Name subjectList = new X500Name(j);
            SubjectPublicKeyInfo subPubKeyInfo = SubjectPublicKeyInfo.getInstance((Object)publicKey.getEncoded());
            validFrom.setTime(validFrom.getTime());
            Calendar cal = Calendar.getInstance();
            cal.setTime(validFrom);
            cal.add(5, 825);
            Date validTo = new Date();
            validTo.setTime(cal.getTime().getTime());
            BigInteger serialNumber = new BigInteger(128, new Random());
            X509v3CertificateBuilder builder = new X509v3CertificateBuilder(subjectList, serialNumber, validFrom, validTo, subjectList, subPubKeyInfo);
            builder.addExtension(Extension.extendedKeyUsage, false, (ASN1Encodable)new ExtendedKeyUsage(KeyPurposeId.id_kp_serverAuth));
            builder.addExtension(Extension.subjectAlternativeName, false, (ASN1Encodable)new DERSequence((ASN1Encodable[])new GeneralName[]{new GeneralName(2, q)}));
            X509CertificateHolder holder = builder.build(new JcaContentSignerBuilder(o).setProvider(w).build(privateKey));
            return new JcaX509CertificateConverter().getCertificate(holder);
        }
        catch (Exception e2) {
            i.error(e2.getMessage(), (Throwable)e2);
            return null;
        }
    }

    public static boolean a(X509Certificate x509Certificate, PrivateKey privateKey, String keystoreFile) {
        boolean bl;
        File file = new File(keystoreFile);
        if (!X509CertificateUtils.a(file)) {
            return false;
        }
        FileOutputStream fileOutputStream = new FileOutputStream(file);
        try {
            Certificate[] cert = new X509Certificate[]{x509Certificate};
            KeyStore ks = KeyStore.getInstance(r);
            ks.load(null, null);
            String keyPassword = com.tplink.smb.omada.common.util.b.b.e((String)n);
            ks.setKeyEntry(m, privateKey, keyPassword.toCharArray(), cert);
            ks.store(fileOutputStream, keyPassword.toCharArray());
            bl = true;
        }
        catch (Throwable throwable) {
            try {
                try {
                    fileOutputStream.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (Exception e2) {
                i.error(e2.getMessage(), (Throwable)e2);
                return false;
            }
        }
        fileOutputStream.close();
        return bl;
    }

    public static boolean a(String path, X509Certificate x509Certificate) {
        boolean bl;
        File file = new File(path);
        if (!X509CertificateUtils.a(file)) {
            return false;
        }
        FileOutputStream fileOutputStream = new FileOutputStream(file);
        try {
            byte[] cert = x509Certificate.getEncoded();
            fileOutputStream.write(cert);
            bl = true;
        }
        catch (Throwable throwable) {
            try {
                try {
                    fileOutputStream.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (Exception e2) {
                i.warn(e2.getMessage(), (Throwable)e2);
                return false;
            }
        }
        fileOutputStream.close();
        return bl;
    }

    private static boolean a(File file) {
        if (!file.getParentFile().exists()) {
            return file.getParentFile().mkdirs();
        }
        return true;
    }

    public static boolean a(String path) {
        KeyStore ks = null;
        Certificate certificate = null;
        try (FileInputStream inputStream = new FileInputStream(path);){
            ks = KeyStore.getInstance(r);
            String keyPassword = com.tplink.smb.omada.common.util.b.b.e((String)n);
            ks.load(inputStream, keyPassword.toCharArray());
            certificate = ks.getCertificate(m);
        }
        catch (Exception e2) {
            i.warn("Cannot load keystore");
            return false;
        }
        try {
            if (certificate instanceof X509Certificate) {
                X509Certificate x509Certificate = (X509Certificate)certificate;
                x509Certificate.checkValidity();
                List<String> extendedKeyUsage = x509Certificate.getExtendedKeyUsage();
                return extendedKeyUsage != null;
            }
            return false;
        }
        catch (CertificateException e3) {
            i.warn("Certificate is invalid");
        }
        catch (Exception e4) {
            i.error(e4.getMessage(), (Throwable)e4);
        }
        return false;
    }

    public static boolean b(String path) {
        File keystoreFile = new File(path);
        return keystoreFile.exists();
    }

    public static String b() {
        return com.tplink.smb.omada.common.util.b.b.e((String)n);
    }

    public static boolean a(InputStream fileInputStream, String keyPassword) throws KeyStoreException, CertificateException, NoSuchAlgorithmException, IOException {
        String keyAlias = null;
        KeyStore ks = KeyStore.getInstance(r);
        ks.load(fileInputStream, keyPassword.toCharArray());
        Enumeration<String> a2 = ks.aliases();
        if (a2.hasMoreElements()) {
            keyAlias = a2.nextElement();
        }
        if (keyAlias == null) {
            i.warn("Cannot get Certificate alias.");
            return false;
        }
        Certificate cert = ks.getCertificate(keyAlias);
        X509Certificate x509Certificate = (X509Certificate)CertificateFactory.getInstance("X509").generateCertificate(new ByteArrayInputStream(cert.getEncoded()));
        PublicKey pubKey = cert.getPublicKey();
        if (pubKey == null) {
            i.warn("Cannot get Certificate PublicKey.");
            return false;
        }
        return X509CertificateUtils.b(x509Certificate.getSigAlgName(), pubKey.getAlgorithm());
    }

    private static boolean b(String sigAlg, String keyAlg) {
        if (!com.tplink.smb.omada.system.api.util.a.g.contains(keyAlg)) {
            i.warn("Don't support {} key algorithm", (Object)keyAlg);
            return false;
        }
        if ("EC".equals(keyAlg) && sigAlg.contains(p) && !X509CertificateUtils.c()) {
            i.warn("Current Java Version don't support EC key and RSA Signature Algorithm");
            return false;
        }
        return true;
    }

    private static boolean c() {
        int classVersion = (int)Double.parseDouble(System.getProperty("java.class.version"));
        if (classVersion < 52) {
            return false;
        }
        if (classVersion > 52) {
            return true;
        }
        String jreVersion = System.getProperty("java.runtime.version");
        String[] strings = jreVersion.split("[-|_]");
        if (strings.length < 2) {
            return false;
        }
        String secondVersion = strings[1];
        try {
            int second = Integer.parseInt(secondVersion);
            return second >= 101;
        }
        catch (NumberFormatException e2) {
            return false;
        }
    }

    public static RadiusServerCertDTO a(KeyPair keyPair) {
        RadiusServerCertDTO radiusServerCertDTO;
        Security.addProvider((Provider)new BouncyCastleProvider());
        PrivateKey privateKey = keyPair.getPrivate();
        PublicKey publicKey = keyPair.getPublic();
        X500Name subjectList = new X500Name(l);
        Date validFrom = new Date();
        validFrom.setTime(validFrom.getTime());
        Calendar cal = Calendar.getInstance();
        cal.setTime(validFrom);
        cal.add(5, 9125);
        Date validTo = new Date();
        validTo.setTime(cal.getTime().getTime());
        BigInteger serialNumber = new BigInteger(128, new Random());
        JcaX509v3CertificateBuilder builder = new JcaX509v3CertificateBuilder(subjectList, serialNumber, validFrom, validTo, subjectList, publicKey);
        builder.addExtension(Extension.keyUsage, true, (ASN1Encodable)new KeyUsage(6));
        builder.addExtension(Extension.extendedKeyUsage, false, (ASN1Encodable)new ExtendedKeyUsage(KeyPurposeId.id_kp_serverAuth));
        builder.addExtension(Extension.subjectAlternativeName, false, (ASN1Encodable)new DERSequence((ASN1Encodable[])new GeneralName[]{new GeneralName(2, q)}));
        builder.addExtension(Extension.basicConstraints, true, (ASN1Encodable)new BasicConstraints(true));
        X509CertificateHolder holder = builder.build(new JcaContentSignerBuilder(o).setProvider(w).build(privateKey));
        ByteArrayInputStream cerIn = new ByteArrayInputStream(holder.toASN1Structure().getEncoded());
        try {
            CertificateFactory certificateFactory = CertificateFactory.getInstance(x);
            X509Certificate caCert = (X509Certificate)certificateFactory.generateCertificate(cerIn);
            radiusServerCertDTO = X509CertificateUtils.a(caCert, privateKey, k, validFrom, validTo);
        }
        catch (Throwable throwable) {
            try {
                try {
                    ((InputStream)cerIn).close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (Exception e2) {
                i.error("build radius server certificate failed: " + e2.getMessage(), (Throwable)e2);
                return null;
            }
        }
        ((InputStream)cerIn).close();
        return radiusServerCertDTO;
    }

    public static RadiusServerCertDTO a(X509Certificate caCert, PrivateKey caPrivateKey, String subject, Date notBefore, Date notAfter) throws Exception {
        KeyPair keyPair = X509CertificateUtils.a();
        if (Objects.isNull(keyPair)) {
            return null;
        }
        JcaX509v3CertificateBuilder builder = new JcaX509v3CertificateBuilder(caCert, new BigInteger(128, new Random()), notBefore, notAfter, new X500Name(subject), keyPair.getPublic());
        ArrayList<GeneralName> altNames = new ArrayList<GeneralName>();
        altNames.add(new GeneralName(2, q));
        GeneralNames generalNames = new GeneralNames(altNames.toArray(new GeneralName[0]));
        builder.addExtension(Extension.keyUsage, true, (ASN1Encodable)new KeyUsage(128));
        builder.addExtension(Extension.basicConstraints, false, (ASN1Encodable)new BasicConstraints(false));
        builder.addExtension(Extension.subjectAlternativeName, false, (ASN1Encodable)generalNames);
        X509Certificate subCert = new JcaX509CertificateConverter().getCertificate(builder.build(new JcaContentSignerBuilder(o).setProvider(w).build(caPrivateKey)));
        return new RadiusServerCertDTO(caCert, subCert, keyPair);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static boolean a(X509Certificate[] x509Certificates, PrivateKey privateKey, String keystoreFile, String alias) {
        File file = new File(keystoreFile);
        if (!X509CertificateUtils.a(file)) {
            return false;
        }
        try (FileOutputStream fileOutputStream = new FileOutputStream(file);){
            KeyStore ks = KeyStore.getInstance(r);
            ks.load(null, null);
            String keyPassword = com.tplink.smb.omada.common.util.b.b.f((String)n);
            if (null == keyPassword) {
                boolean bl = false;
                return bl;
            }
            ks.setKeyEntry(alias, privateKey, keyPassword.toCharArray(), x509Certificates);
            ks.store(fileOutputStream, keyPassword.toCharArray());
            boolean bl = true;
            return bl;
        }
        catch (Exception e2) {
            i.error(e2.getMessage(), (Throwable)e2);
            return false;
        }
    }

    public static void a(String radiusServerCaFile, String radiusServerSubFile) {
        i.warn("Valid radius server keystore is missing. Generating one ...");
        KeyPair keyPair = X509CertificateUtils.a();
        if (null == keyPair) {
            i.error("Cannot generate radius server keyPair");
            return;
        }
        RadiusServerCertDTO radiusServerCertDTO = X509CertificateUtils.a(keyPair);
        if (Objects.isNull(radiusServerCertDTO)) {
            i.error("Cannot generate radius server certificate");
            return;
        }
        if (!X509CertificateUtils.a(new X509Certificate[]{radiusServerCertDTO.getCaCert()}, keyPair.getPrivate(), radiusServerCaFile, g)) {
            i.error("Cannot save radius server ca keystore");
            return;
        }
        if (!X509CertificateUtils.a(new X509Certificate[]{radiusServerCertDTO.getSubCert(), radiusServerCertDTO.getCaCert()}, radiusServerCertDTO.getSubKeyPair().getPrivate(), radiusServerSubFile, h)) {
            i.error("Cannot save radius server sub keystore");
            return;
        }
        if (!X509CertificateUtils.a(new File(radiusServerCaFile).getParent() + File.separator + "radiusServerCa.cer", radiusServerCertDTO.getCaCert())) {
            i.warn("Cannot save radius ca cer certificate");
        }
        i.info("Radius Server Certificates generated!");
    }

    private X509CertificateUtils() {
    }

    public static class RadiusServerCertDTO {
        private X509Certificate caCert;
        private X509Certificate subCert;
        private KeyPair subKeyPair;

        @Generated
        public X509Certificate getCaCert() {
            return this.caCert;
        }

        @Generated
        public X509Certificate getSubCert() {
            return this.subCert;
        }

        @Generated
        public KeyPair getSubKeyPair() {
            return this.subKeyPair;
        }

        @Generated
        public void setCaCert(X509Certificate caCert) {
            this.caCert = caCert;
        }

        @Generated
        public void setSubCert(X509Certificate subCert) {
            this.subCert = subCert;
        }

        @Generated
        public void setSubKeyPair(KeyPair subKeyPair) {
            this.subKeyPair = subKeyPair;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof RadiusServerCertDTO)) {
                return false;
            }
            RadiusServerCertDTO other = (RadiusServerCertDTO)o;
            if (!other.canEqual(this)) {
                return false;
            }
            X509Certificate this$caCert = this.getCaCert();
            X509Certificate other$caCert = other.getCaCert();
            if (this$caCert == null ? other$caCert != null : !((Object)this$caCert).equals(other$caCert)) {
                return false;
            }
            X509Certificate this$subCert = this.getSubCert();
            X509Certificate other$subCert = other.getSubCert();
            if (this$subCert == null ? other$subCert != null : !((Object)this$subCert).equals(other$subCert)) {
                return false;
            }
            KeyPair this$subKeyPair = this.getSubKeyPair();
            KeyPair other$subKeyPair = other.getSubKeyPair();
            return !(this$subKeyPair == null ? other$subKeyPair != null : !this$subKeyPair.equals(other$subKeyPair));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof RadiusServerCertDTO;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            X509Certificate $caCert = this.getCaCert();
            result = result * 59 + ($caCert == null ? 43 : ((Object)$caCert).hashCode());
            X509Certificate $subCert = this.getSubCert();
            result = result * 59 + ($subCert == null ? 43 : ((Object)$subCert).hashCode());
            KeyPair $subKeyPair = this.getSubKeyPair();
            result = result * 59 + ($subKeyPair == null ? 43 : $subKeyPair.hashCode());
            return result;
        }

        @Generated
        public String toString() {
            return "X509CertificateUtils.RadiusServerCertDTO(caCert=" + this.getCaCert() + ", subCert=" + this.getSubCert() + ", subKeyPair=" + this.getSubKeyPair() + ")";
        }

        @Generated
        public RadiusServerCertDTO(X509Certificate caCert, X509Certificate subCert, KeyPair subKeyPair) {
            this.caCert = caCert;
            this.subCert = subCert;
            this.subKeyPair = subKeyPair;
        }
    }
}

