/*
 * Decompiled with CFR 0.152.
 */
package com.tplink.smb.omada.logmanager.port.mongo.log;

import com.mongodb.bulk.BulkWriteResult;
import com.mongodb.client.MongoIterable;
import com.tplink.smb.eventcenter.api.event.DomainEventSubscriber;
import com.tplink.smb.eventcenter.domain.DomainEventBusHolder;
import com.tplink.smb.omada.common.gridquery.e;
import com.tplink.smb.omada.common.gridquery.g;
import com.tplink.smb.omada.common.mongo.repository.p;
import com.tplink.smb.omada.common.mongo.repository.q;
import com.tplink.smb.omada.common.mongo.repository.u;
import com.tplink.smb.omada.common.util.T;
import com.tplink.smb.omada.logmanager.api.external.dto.ArchiveDTO;
import com.tplink.smb.omada.logmanager.api.internal.dto.LogClassifyInfoRequestDTO;
import com.tplink.smb.omada.logmanager.domain.model.e.i;
import com.tplink.smb.omada.logmanager.domain.model.log.AbstractOmadaLog;
import com.tplink.smb.omada.logmanager.domain.model.log.F;
import com.tplink.smb.omada.logmanager.domain.model.log.LogClassifyInfoDTO;
import com.tplink.smb.omada.logmanager.domain.model.log.LogClassifyNumberQueryDTO;
import com.tplink.smb.omada.logmanager.domain.model.log.LogGroupDTO;
import com.tplink.smb.omada.logmanager.domain.model.log.LogGroupInfoDTO;
import com.tplink.smb.omada.logmanager.domain.model.log.subscriber.AlertNumClassifyInfoDTO;
import com.tplink.smb.omada.logmanager.domain.model.log.w;
import com.tplink.smb.omada.logmanager.port.commom.c.b;
import com.tplink.smb.omada.logmanager.port.mongo.a.a;
import com.tplink.smb.omada.logmanager.port.mongo.a.c;
import com.tplink.smb.omada.logmanager.port.mongo.a.d;
import com.tplink.smb.omada.logmanager.port.mongo.data.a.n;
import com.tplink.smb.omada.logmanager.port.mongo.log.AbstractOmadaLogPO;
import com.tplink.smb.omada.logmanager.port.mongo.log.OmadaLogPO;
import com.tplink.smb.omada.logmanager.port.mongo.log.m;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import jakarta.annotation.PostConstruct;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.LongSummaryStatistics;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.commons.collections4.CollectionUtils;
import org.bson.conversions.Bson;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.context.annotation.Lazy;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;
import org.springframework.data.mongodb.core.BulkOperations;
import org.springframework.data.mongodb.core.MongoTemplate;
import org.springframework.data.mongodb.core.aggregation.Aggregation;
import org.springframework.data.mongodb.core.aggregation.AggregationOperation;
import org.springframework.data.mongodb.core.index.IndexDefinition;
import org.springframework.data.mongodb.core.query.Criteria;
import org.springframework.data.mongodb.core.query.CriteriaDefinition;
import org.springframework.data.mongodb.core.query.Query;
import org.springframework.data.mongodb.core.query.Update;
import org.springframework.data.mongodb.core.query.UpdateDefinition;
import org.springframework.stereotype.Component;

@Component
public class k
extends q<OmadaLogPO, com.tplink.smb.omada.logmanager.domain.model.e.g>
implements DomainEventSubscriber<com.tplink.smb.omada.logmanager.port.commom.service.a.c>,
F {
    @Generated
    private static final Logger a = LoggerFactory.getLogger(k.class);
    @Autowired
    @Qualifier(value="dataMongoTemplate")
    private MongoTemplate mongoTemplate;
    @Autowired
    private b b;
    @Autowired
    @Lazy
    private n c;
    private static final String d = "delete-log-by-omadac-site";
    private static final String e = "delete-log-by-omadac";
    private static final String f = "count-by-omadac";
    private static final String g = "count-alert-by-omadac-keys";
    private static final String h = "count-alert-by-omadac-site-keys";
    private static final String i = "get-grid";
    private static final String j = "count-logs-by-level";
    private static final String k = "archive-all-alerts";
    private static final String l = "count-logs";
    private static final String m = "find-logs-time-content-with-page";
    private static final String n = "delete-log-omadac-less-time";
    private static final String o = "delete-logs";
    private static final String p = "delete-site-logs-by-type";
    private static final String q = "delete-global-logs-by-type";
    private static final String r = "get-classify-log-info";
    private static final String s = "get-log-num-by-level";
    private static final int t = 10000;
    private static final int u = 5000;

    public void a(List<w> omadaLogs) {
        if (CollectionUtils.isEmpty(omadaLogs)) {
            return;
        }
        Map<String, List<OmadaLogPO>> collectionNameToPOsMap = omadaLogs.stream().map(m::a).collect(Collectors.groupingBy(x$0 -> this.getCollectionNameForSave(x$0)));
        collectionNameToPOsMap.forEach((collectionName, poList) -> {
            BulkOperations bulkOperations = this.mongoTemplate.bulkOps(BulkOperations.BulkMode.UNORDERED, collectionName);
            poList.forEach(omadaLogPO -> bulkOperations.insert(omadaLogPO));
            BulkWriteResult result = bulkOperations.execute();
            a.debug("Bulk write omada log result: {}", (Object)result);
        });
    }

    public Long a(com.tplink.smb.omada.logmanager.domain.model.e.g omadacId) {
        this.b.b(f);
        Query query = new Query((CriteriaDefinition)Criteria.where((String)"omadac_id").is((Object)omadacId.a()));
        AtomicLong total = new AtomicLong(0L);
        this.iteratorCollectionsBySliceKey(omadacId, collectionName -> total.addAndGet(this.mongoTemplate.count(query, collectionName)));
        return total.get();
    }

    public int a(com.tplink.smb.omada.logmanager.domain.model.e.g omadacId, Integer topNum) {
        AtomicInteger clearedNum = new AtomicInteger(0);
        this.iteratorCollectionsByTimeAsc(0L, System.currentTimeMillis(), collectionName -> {
            int loopCount = topNum / 10000;
            for (int i2 = 0; i2 <= loopCount; ++i2) {
                int removeLimit = Math.min(topNum - clearedNum.get(), 10000);
                if (clearedNum.get() >= topNum) {
                    return;
                }
                int removed = (int)this.mongoTemplate.remove(new Query((CriteriaDefinition)Criteria.where((String)"omadac_id").is((Object)omadacId.a())).with(Sort.by((Sort.Direction)Sort.Direction.ASC, (String[])new String[]{"time"})).limit(removeLimit), collectionName).getDeletedCount();
                clearedNum.addAndGet(removed);
            }
        });
        return clearedNum.get();
    }

    public long a(com.tplink.smb.omada.logmanager.domain.model.e.g omadacId, Long startTime, Long endTime) {
        this.b.b(g);
        Query query = new Query();
        Criteria criteria = Criteria.where((String)"omadac_id").is((Object)omadacId.a());
        criteria.and("site").is(null);
        criteria.and("alert").is((Object)Boolean.TRUE);
        criteria.and("archived").is((Object)Boolean.FALSE);
        criteria.and("time").gte((Object)startTime).lte((Object)endTime);
        query.addCriteria((CriteriaDefinition)criteria);
        AtomicLong total = new AtomicLong(0L);
        this.iteratorCollectionsByTimeAndSliceKey(Sort.Direction.DESC, startTime / 1000L, endTime / 1000L, omadacId, collectionName -> total.addAndGet(this.mongoTemplate.count(query, collectionName)));
        return total.get();
    }

    public long a(com.tplink.smb.omada.logmanager.domain.model.e.g omadacId, i siteId, Long startTime, Long endTime) {
        this.b.b(h);
        Query query = new Query();
        Criteria criteria = Criteria.where((String)"omadac_id").is((Object)omadacId.a());
        criteria.and("site").is((Object)siteId.a());
        criteria.and("alert").is((Object)Boolean.TRUE);
        criteria.and("archived").is((Object)Boolean.FALSE);
        criteria.and("time").gte((Object)startTime).lte((Object)endTime);
        query.addCriteria((CriteriaDefinition)criteria);
        AtomicLong total = new AtomicLong(0L);
        this.iteratorCollectionsByTimeAndSliceKey(Sort.Direction.DESC, startTime / 1000L, endTime / 1000L, omadacId, collectionName -> total.addAndGet(this.mongoTemplate.count(query, collectionName)));
        return total.get();
    }

    public long a(com.tplink.smb.omada.logmanager.domain.model.e.g omadacId, Long startTime, Long endTime, List<String> alertKeys) {
        this.b.b(h);
        Query query = new Query();
        Criteria criteria = Criteria.where((String)"omadac_id").is((Object)omadacId.a());
        criteria.and("site").is(null);
        criteria.and("archived").is((Object)Boolean.FALSE);
        criteria.and("time").gte((Object)startTime).lte((Object)endTime);
        criteria.and("key").in(alertKeys);
        query.addCriteria((CriteriaDefinition)criteria);
        AtomicLong total = new AtomicLong(0L);
        this.iteratorCollectionsByTimeAndSliceKey(Sort.Direction.DESC, startTime / 1000L, endTime / 1000L, omadacId, collectionName -> total.addAndGet(this.mongoTemplate.count(query, collectionName)));
        return total.get();
    }

    public long a(com.tplink.smb.omada.logmanager.domain.model.e.g omadacId, i siteId, Long startTime, Long endTime, List<String> alertKeys) {
        this.b.b(h);
        Query query = new Query();
        Criteria criteria = Criteria.where((String)"omadac_id").is((Object)omadacId.a());
        criteria.and("site").is((Object)siteId.a());
        criteria.and("archived").is((Object)Boolean.FALSE);
        criteria.and("time").gte((Object)startTime).lte((Object)endTime);
        criteria.and("key").in(alertKeys);
        query.addCriteria((CriteriaDefinition)criteria);
        AtomicLong total = new AtomicLong(0L);
        this.iteratorCollectionsByTimeAndSliceKey(Sort.Direction.DESC, startTime / 1000L, endTime / 1000L, omadacId, collectionName -> total.addAndGet(this.mongoTemplate.count(query, collectionName)));
        return total.get();
    }

    public com.tplink.smb.omada.common.gridquery.a<w> a(com.tplink.smb.omada.common.gridquery.a<w> grid, Boolean rootLag, String omadacId, String siteId) {
        this.b.b(i);
        long currentLogGet = System.currentTimeMillis();
        long currentCountTime = System.currentTimeMillis();
        long count = this.a((List<com.tplink.smb.omada.common.gridquery.c>)grid.getFilters(), (List<com.tplink.smb.omada.common.gridquery.c>)grid.getSearchFilters(), rootLag, omadacId, siteId, ((e)grid.getQuerySorts().get(0)).a());
        a.trace("Log count time:{}(s)", (Object)((System.currentTimeMillis() - currentCountTime) / 1000L));
        grid.setTotalRows(count);
        if (count < 1L) {
            grid.setData(Collections.EMPTY_LIST);
            return grid;
        }
        grid.setData(this.a(grid.getQueryPage(), grid.getQuerySorts(), grid.getFilters(), grid.getSearchFilters(), rootLag, omadacId, siteId, count));
        a.trace("Get log total time:{}(s)", (Object)((System.currentTimeMillis() - currentLogGet) / 1000L));
        return grid;
    }

    public Long a(LogClassifyNumberQueryDTO logClassifyNumberQueryDTO, Boolean oldCompatible) {
        this.b.b(j);
        Query query = new Query();
        Criteria criteria = Criteria.where((String)"omadac_id").is((Object)logClassifyNumberQueryDTO.getOmadacId());
        Boolean alert = logClassifyNumberQueryDTO.getAlert();
        Boolean event = logClassifyNumberQueryDTO.getEvent();
        if (Boolean.TRUE.equals(alert)) {
            criteria.and("alert").is((Object)true);
        }
        if (Boolean.TRUE.equals(event)) {
            criteria.and("event").is((Object)true);
        }
        criteria.and("level").is((Object)logClassifyNumberQueryDTO.getLevel());
        Long startTime = logClassifyNumberQueryDTO.getStartTime();
        Long endTime = logClassifyNumberQueryDTO.getEndTime();
        criteria.and("time").gte((Object)startTime).lte((Object)endTime);
        if (Objects.nonNull(logClassifyNumberQueryDTO.getArchived())) {
            criteria.and("archived").is((Object)logClassifyNumberQueryDTO.getArchived());
        }
        if (!T.a((String)logClassifyNumberQueryDTO.getModule())) {
            criteria.and("module").is((Object)logClassifyNumberQueryDTO.getModule());
        }
        if (oldCompatible.booleanValue()) {
            ArrayList<String> sites = new ArrayList<String>(2);
            sites.add(logClassifyNumberQueryDTO.getSiteId());
            if (logClassifyNumberQueryDTO.getRootLag().booleanValue()) {
                sites.add(null);
            }
            criteria.and("site").in(sites);
        } else {
            criteria.and("site").is((Object)logClassifyNumberQueryDTO.getSiteId());
        }
        if (!T.a((String)logClassifyNumberQueryDTO.getSearchKey())) {
            criteria.andOperator(new Criteria[]{com.tplink.smb.omada.logmanager.port.mongo.a.d.a(com.tplink.smb.omada.logmanager.port.mongo.a.d.b(logClassifyNumberQueryDTO.getSearchKey()))});
        }
        query.addCriteria((CriteriaDefinition)criteria);
        AtomicLong total = new AtomicLong(0L);
        this.iteratorCollectionsByTimeAndSliceKey(Sort.Direction.DESC, startTime / 1000L, endTime / 1000L, new com.tplink.smb.omada.logmanager.domain.model.e.g(logClassifyNumberQueryDTO.getOmadacId()), collectionName -> total.addAndGet(this.mongoTemplate.count(query, OmadaLogPO.class, collectionName)));
        return total.get();
    }

    public w a(String omadacId, String logId) {
        Query query = new Query();
        Criteria criteria = Criteria.where((String)"omadac_id").is((Object)omadacId);
        criteria.and("_id").is((Object)logId);
        query.addCriteria((CriteriaDefinition)criteria);
        ArrayList omadaLogPOS = new ArrayList();
        this.iteratorCollectionsBySliceKey(new com.tplink.smb.omada.logmanager.domain.model.e.g(omadacId), collectionName -> omadaLogPOS.addAll(this.mongoTemplate.find(query, OmadaLogPO.class, collectionName)));
        if (CollectionUtils.isEmpty(omadaLogPOS) || omadaLogPOS.size() > 1) {
            a.warn("fail to find omadaLog by omadacId :{}, logId :{}", (Object)omadacId, (Object)logId);
            return null;
        }
        return com.tplink.smb.omada.logmanager.port.mongo.log.m.a((OmadaLogPO)omadaLogPOS.get(0));
    }

    public void a(w omadaLog) {
        OmadaLogPO omadaLogPO = com.tplink.smb.omada.logmanager.port.mongo.log.m.a(omadaLog);
        String collectionName = this.getCollectionNameForSave(omadaLogPO);
        this.iteratorCollectionsBySliceKey(omadaLog.getOmadacId(), logPo -> this.mongoTemplate.save((Object)omadaLogPO, collectionName));
        if (omadaLog.getId() != null && omadaLog.getId().a() != null) {
            Query query = new Query((CriteriaDefinition)Criteria.where((String)"_id").is((Object)omadaLog.getId().a()));
            this.mongoTemplate.remove(query, "omadalog");
        }
    }

    public void b(w omadaLog) {
        if (Objects.isNull(omadaLog.getId()) || T.a((String)omadaLog.getId().a())) {
            a.warn("Failed to archived site omada log:{}", (Object)omadaLog.toString());
            return;
        }
        String collectionName = this.getCollectionNameForSave(com.tplink.smb.omada.logmanager.port.mongo.log.m.a(omadaLog));
        this.iteratorCollectionsBySliceKey(omadaLog.getOmadacId(), logPo -> this.mongoTemplate.updateFirst(new Query((CriteriaDefinition)Criteria.where((String)"_id").is((Object)omadaLog.getId().a())), (UpdateDefinition)Update.update((String)"archived", (Object)true), OmadaLogPO.class, collectionName));
        this.b.f(omadaLog.a(omadaLog.getOmadaLogEnum(), omadaLog.i()));
    }

    public void a(String omadacId, String siteId, Boolean rootLag, ArchiveDTO archiveDTO) {
        this.b.b(k);
        Criteria criteria = new Criteria("omadac_id").is((Object)omadacId);
        HashSet<String> siteIdQuery = new HashSet<String>(2);
        siteIdQuery.add(siteId);
        if (rootLag.booleanValue()) {
            siteIdQuery.add(null);
        }
        criteria.and("site").in(siteIdQuery);
        criteria.and("archived").is((Object)false);
        criteria.and("alert").is((Object)true);
        Query query = Query.query((CriteriaDefinition)criteria);
        Long startTime = archiveDTO.getTimeStart() / 1000L;
        Long endTime = archiveDTO.getTimeEnd() / 1000L;
        query.addCriteria((CriteriaDefinition)Criteria.where((String)"time").gte((Object)archiveDTO.getTimeStart()).lte((Object)archiveDTO.getTimeEnd()));
        this.iteratorCollectionsByTimeAndSliceKey(Sort.Direction.DESC, startTime, endTime, new com.tplink.smb.omada.logmanager.domain.model.e.g(omadacId), collectionName -> this.mongoTemplate.updateMulti(query, (UpdateDefinition)Update.update((String)"archived", (Object)true), OmadaLogPO.class, collectionName));
    }

    public void a(String omadacId, String siteId, Boolean rootLag, ArchiveDTO archiveDTO, com.tplink.smb.omada.common.gridquery.a<w> grid, List<String> alertKeys) {
        this.b.b(k);
        grid.setFilters(com.tplink.smb.omada.logmanager.port.mongo.a.c.a(grid.getFilters()));
        Query query = this.a((List<com.tplink.smb.omada.common.gridquery.c>)grid.getFilters(), (List<com.tplink.smb.omada.common.gridquery.c>)grid.getSearchFilters(), (boolean)rootLag, omadacId, siteId, alertKeys);
        Long startTime = archiveDTO.getTimeStart() / 1000L;
        Long endTime = archiveDTO.getTimeEnd() / 1000L;
        query.addCriteria((CriteriaDefinition)Criteria.where((String)"time").gte((Object)archiveDTO.getTimeStart()).lte((Object)archiveDTO.getTimeEnd()));
        this.iteratorCollectionsByTimeAndSliceKey(Sort.Direction.DESC, startTime, endTime, new com.tplink.smb.omada.logmanager.domain.model.e.g(omadacId), collectionName -> this.mongoTemplate.updateMulti(query, (UpdateDefinition)Update.update((String)"archived", (Object)true), OmadaLogPO.class, collectionName));
        if (!CollectionUtils.isEmpty((Collection)archiveDTO.getLogs())) {
            Criteria criteria = Criteria.where((String)"_id").in((Collection)archiveDTO.getLogs()).and("omadac_id").is((Object)omadacId).and("site").is((Object)siteId);
            Query idQuery = new Query((CriteriaDefinition)criteria);
            this.iteratorCollectionsByTimeAndSliceKey(Sort.Direction.DESC, startTime, endTime, new com.tplink.smb.omada.logmanager.domain.model.e.g(omadacId), collectionName -> this.mongoTemplate.updateMulti(idQuery, (UpdateDefinition)Update.update((String)"archived", (Object)false), OmadaLogPO.class, collectionName));
        }
    }

    public void a(String omadacId, String siteId, ArchiveDTO archiveDTO) {
        this.b.b(k);
        Criteria criteria = new Criteria("omadac_id").is((Object)omadacId);
        criteria.and("site").is((Object)siteId);
        criteria.and("alert").is((Object)true);
        criteria.and("archived").is((Object)false);
        Query query = Query.query((CriteriaDefinition)criteria);
        Long startTime = archiveDTO.getTimeStart() / 1000L;
        Long endTime = archiveDTO.getTimeEnd() / 1000L;
        query.addCriteria((CriteriaDefinition)Criteria.where((String)"time").gte((Object)archiveDTO.getTimeStart()).lte((Object)archiveDTO.getTimeEnd()));
        this.iteratorCollectionsByTimeAndSliceKey(Sort.Direction.DESC, startTime, endTime, new com.tplink.smb.omada.logmanager.domain.model.e.g(omadacId), collectionName -> this.mongoTemplate.updateMulti(query, (UpdateDefinition)Update.update((String)"archived", (Object)true), OmadaLogPO.class, collectionName));
    }

    public void a(String omadacId, String siteId, Boolean rootLag) {
        Criteria criteria = Criteria.where((String)"omadac_id").is((Object)omadacId);
        HashSet<String> siteIdQuery = new HashSet<String>(2);
        siteIdQuery.add(siteId);
        if (rootLag.booleanValue()) {
            siteIdQuery.add(null);
        }
        criteria.and("site").in(siteIdQuery);
        criteria.and("archived").is((Object)true);
        criteria.and("alert").is((Object)true);
        Query query = new Query((CriteriaDefinition)criteria);
        this.iteratorCollectionsBySliceKey(new com.tplink.smb.omada.logmanager.domain.model.e.g(omadacId), collectionName -> this.mongoTemplate.remove(query, OmadaLogPO.class, collectionName));
    }

    public void a(String omadacId, String site, Boolean deleteAlert, Long startTime, Long endTime) {
        Query query = new Query();
        query.addCriteria((CriteriaDefinition)Criteria.where((String)"site").is((Object)site));
        this.a(query, omadacId, deleteAlert, startTime, endTime);
    }

    public void a(String omadacId, Boolean deleteAlert, Long startTime, Long endTime) {
        Query query = new Query();
        query.addCriteria((CriteriaDefinition)Criteria.where((String)"site").is(null));
        this.a(query, omadacId, deleteAlert, startTime, endTime);
    }

    private void a(Query query, String omadacId, Boolean deleteAlert, Long startTime, Long endTime) {
        query.addCriteria((CriteriaDefinition)Criteria.where((String)"omadac_id").is((Object)omadacId));
        if (deleteAlert.booleanValue()) {
            query.addCriteria((CriteriaDefinition)Criteria.where((String)"alert").is((Object)true));
        } else {
            query.addCriteria((CriteriaDefinition)Criteria.where((String)"event").is((Object)true));
        }
        query.addCriteria((CriteriaDefinition)Criteria.where((String)"time").gte((Object)startTime).lte((Object)endTime));
        this.iteratorCollectionsByTimeAndSliceKey(Sort.Direction.DESC, startTime / 1000L, endTime / 1000L, new com.tplink.smb.omada.logmanager.domain.model.e.g(omadacId), collectionName -> this.mongoTemplate.remove(query, OmadaLogPO.class, collectionName));
    }

    public long b(String omadacId, String site, Boolean rootLag) {
        HashSet<String> siteIdQuery = new HashSet<String>(2);
        siteIdQuery.add(site);
        if (rootLag.booleanValue()) {
            siteIdQuery.add(null);
        }
        Query query = new Query();
        query.addCriteria((CriteriaDefinition)Criteria.where((String)"event").is((Object)true));
        query.addCriteria((CriteriaDefinition)Criteria.where((String)"omadac_id").is((Object)omadacId));
        query.addCriteria((CriteriaDefinition)Criteria.where((String)"site").in(siteIdQuery));
        this.iteratorCollectionsBySliceKey(new com.tplink.smb.omada.logmanager.domain.model.e.g(omadacId), collectionName -> this.mongoTemplate.remove(query, OmadaLogPO.class, collectionName));
        return 0L;
    }

    public long a(List<com.tplink.smb.omada.common.gridquery.c> filters, List<com.tplink.smb.omada.common.gridquery.c> searchFilters, Boolean rootLag, String omadacId, String siteKey, g direction) {
        this.b.b(l);
        if (Objects.isNull(filters)) {
            filters = new ArrayList<com.tplink.smb.omada.common.gridquery.c>();
        }
        Long[] times = com.tplink.smb.omada.logmanager.port.mongo.a.d.a(filters);
        Query query = this.a(filters, searchFilters, (boolean)rootLag, omadacId, siteKey);
        AtomicLong total = new AtomicLong(0L);
        this.iteratorCollectionsByTimeAndSliceKey(direction.a().equals("asc") ? Sort.Direction.ASC : Sort.Direction.DESC, times[0], times[1], new com.tplink.smb.omada.logmanager.domain.model.e.g(omadacId), collectionName -> total.addAndGet(this.mongoTemplate.count(query, OmadaLogPO.class, collectionName)));
        return total.get();
    }

    public Map<String, Long> a(String omadacId, List<String> siteIds) {
        Criteria criteria = Criteria.where((String)"omadac_id").is((Object)omadacId);
        criteria.and("site").in(siteIds);
        Aggregation aggregation = Aggregation.newAggregation((AggregationOperation[])new AggregationOperation[]{Aggregation.match((Criteria)criteria), Aggregation.group((String[])new String[]{"site"}).count().as("countNumber")});
        ArrayList numClassifyInfoDTOS = new ArrayList();
        this.iteratorCollectionsByTimeAndSliceKey(Sort.Direction.DESC, 0L, System.currentTimeMillis() / 1000L, new com.tplink.smb.omada.logmanager.domain.model.e.g(omadacId), collectionName -> numClassifyInfoDTOS.addAll(this.mongoTemplate.aggregate(aggregation, collectionName, LogClassifyInfoDTO.class).getMappedResults()));
        Map<String, LongSummaryStatistics> statisticsMap = numClassifyInfoDTOS.stream().collect(Collectors.groupingBy(LogClassifyInfoDTO::getId, Collectors.summarizingLong(LogClassifyInfoDTO::getCountNumber)));
        HashMap<String, Long> sitesLogNumMap = new HashMap<String, Long>(statisticsMap.size());
        for (Map.Entry<String, LongSummaryStatistics> entry : statisticsMap.entrySet()) {
            sitesLogNumMap.put(entry.getKey(), entry.getValue().getSum());
        }
        return sitesLogNumMap;
    }

    public long a(String omadacId) {
        Criteria criteria = new Criteria();
        criteria.and("omadac_id").is((Object)omadacId);
        criteria.and("site").isNull();
        Query query = new Query((CriteriaDefinition)criteria);
        AtomicLong total = new AtomicLong(0L);
        this.iteratorCollectionsByTimeAndSliceKey(Sort.Direction.DESC, 0L, System.currentTimeMillis() / 1000L, new com.tplink.smb.omada.logmanager.domain.model.e.g(omadacId), collectionName -> total.addAndGet(this.mongoTemplate.count(query, OmadaLogPO.class, collectionName)));
        return total.get();
    }

    public Long a(String omadacId, String siteId, com.tplink.smb.omada.common.gridquery.a<w> grid, Long startTime, Long endTime, List<String> alertKeys) {
        grid.setFilters(com.tplink.smb.omada.logmanager.port.mongo.a.c.b(grid.getFilters()));
        grid.setFilters(com.tplink.smb.omada.logmanager.port.mongo.a.c.c(grid.getFilters()));
        Criteria criteria = this.a(grid.getFilters(), grid.getSearchFilters(), omadacId, siteId);
        criteria.and("key").in(alertKeys);
        Query query = new Query((CriteriaDefinition)criteria);
        AtomicLong count = new AtomicLong();
        this.iteratorCollectionsByTimeAndSliceKey(Sort.Direction.DESC, startTime / 1000L, endTime / 1000L, new com.tplink.smb.omada.logmanager.domain.model.e.g(omadacId), collectionName -> count.addAndGet(this.mongoTemplate.count(query, OmadaLogPO.class, collectionName)));
        return count.get();
    }

    public Long b(String omadacId, String siteId, com.tplink.smb.omada.common.gridquery.a<w> grid, Long startTime, Long endTime, List<String> alertKeys) {
        grid.setFilters(com.tplink.smb.omada.logmanager.port.mongo.a.c.b(grid.getFilters()));
        grid.setFilters(com.tplink.smb.omada.logmanager.port.mongo.a.c.c(grid.getFilters()));
        Criteria criteria = this.a(grid.getFilters(), grid.getSearchFilters(), omadacId, siteId);
        criteria.and("key").in(alertKeys);
        criteria.and("archived").is((Object)true);
        Query query = new Query((CriteriaDefinition)criteria);
        AtomicLong count = new AtomicLong();
        this.iteratorCollectionsByTimeAndSliceKey(Sort.Direction.DESC, startTime / 1000L, endTime / 1000L, new com.tplink.smb.omada.logmanager.domain.model.e.g(omadacId), collectionName -> count.addAndGet(this.mongoTemplate.count(query, OmadaLogPO.class, collectionName)));
        return count.get();
    }

    public Long c(String omadacId, String siteId, com.tplink.smb.omada.common.gridquery.a<w> grid, Long startTime, Long endTime, List<String> alertKeys) {
        grid.setFilters(com.tplink.smb.omada.logmanager.port.mongo.a.c.b(grid.getFilters()));
        grid.setFilters(com.tplink.smb.omada.logmanager.port.mongo.a.c.c(grid.getFilters()));
        Criteria criteria = this.a(grid.getFilters(), grid.getSearchFilters(), omadacId, siteId);
        criteria.and("key").in(alertKeys);
        criteria.and("archived").is((Object)false);
        Query query = new Query((CriteriaDefinition)criteria);
        AtomicLong count = new AtomicLong();
        this.iteratorCollectionsByTimeAndSliceKey(Sort.Direction.DESC, startTime / 1000L, endTime / 1000L, new com.tplink.smb.omada.logmanager.domain.model.e.g(omadacId), collectionName -> count.addAndGet(this.mongoTemplate.count(query, OmadaLogPO.class, collectionName)));
        return count.get();
    }

    public Long d(String omadacId, String siteId, com.tplink.smb.omada.common.gridquery.a<w> grid, Long startTime, Long endTime, List<String> eventKeys) {
        grid.setFilters(com.tplink.smb.omada.logmanager.port.mongo.a.c.b(grid.getFilters()));
        grid.setFilters(com.tplink.smb.omada.logmanager.port.mongo.a.c.c(grid.getFilters()));
        Criteria criteria = this.b(grid.getFilters(), grid.getSearchFilters(), omadacId, siteId);
        criteria.and("key").in(eventKeys);
        Query query = new Query((CriteriaDefinition)criteria);
        AtomicLong count = new AtomicLong();
        this.iteratorCollectionsByTimeAndSliceKey(Sort.Direction.DESC, startTime / 1000L, endTime / 1000L, new com.tplink.smb.omada.logmanager.domain.model.e.g(omadacId), collectionName -> count.addAndGet(this.mongoTemplate.count(query, OmadaLogPO.class, collectionName)));
        return count.get();
    }

    public Long a(String omadacId, String siteId, com.tplink.smb.omada.common.gridquery.a<w> grid, Long startTime, Long endTime) {
        grid.setFilters(com.tplink.smb.omada.logmanager.port.mongo.a.c.b(grid.getFilters()));
        grid.setFilters(com.tplink.smb.omada.logmanager.port.mongo.a.c.c(grid.getFilters()));
        Criteria criteria = this.b(grid.getFilters(), grid.getSearchFilters(), omadacId, siteId);
        Query query = new Query((CriteriaDefinition)criteria);
        AtomicLong count = new AtomicLong();
        this.iteratorCollectionsByTimeAndSliceKey(Sort.Direction.DESC, startTime / 1000L, endTime / 1000L, new com.tplink.smb.omada.logmanager.domain.model.e.g(omadacId), collectionName -> count.addAndGet(this.mongoTemplate.count(query, OmadaLogPO.class, collectionName)));
        return count.get();
    }

    public List<LogClassifyInfoDTO> e(String omadacId, String siteId, com.tplink.smb.omada.common.gridquery.a<w> grid, Long startTime, Long endTime, List<String> alertKeys) {
        this.b.b(s);
        grid.setFilters(com.tplink.smb.omada.logmanager.port.mongo.a.c.b(grid.getFilters()));
        Criteria criteria = this.a(grid.getFilters(), grid.getSearchFilters(), omadacId, siteId);
        criteria.and("key").in(alertKeys);
        return this.a(criteria, "level", omadacId, startTime, endTime);
    }

    public List<LogClassifyInfoDTO> f(String omadacId, String siteId, com.tplink.smb.omada.common.gridquery.a<w> grid, Long startTime, Long endTime, List<String> alertKeys) {
        this.b.b(s);
        grid.setFilters(com.tplink.smb.omada.logmanager.port.mongo.a.c.b(grid.getFilters()));
        Criteria criteria = this.a(grid.getFilters(), grid.getSearchFilters(), omadacId, siteId);
        criteria.and("key").in(alertKeys);
        criteria.and("archived").is((Object)false);
        return this.a(criteria, "level", omadacId, startTime, endTime);
    }

    public List<LogClassifyInfoDTO> g(String omadacId, String siteId, com.tplink.smb.omada.common.gridquery.a<w> grid, Long startTime, Long endTime, List<String> alertKeys) {
        this.b.b(s);
        grid.setFilters(com.tplink.smb.omada.logmanager.port.mongo.a.c.b(grid.getFilters()));
        Criteria criteria = this.a(grid.getFilters(), grid.getSearchFilters(), omadacId, siteId);
        criteria.and("key").in(alertKeys);
        criteria.and("archived").is((Object)true);
        return this.a(criteria, "level", omadacId, startTime, endTime);
    }

    public List<LogClassifyInfoDTO> h(String omadacId, String siteId, com.tplink.smb.omada.common.gridquery.a<w> grid, Long startTime, Long endTime, List<String> alertKeys) {
        grid.setFilters(com.tplink.smb.omada.logmanager.port.mongo.a.c.b(grid.getFilters()));
        grid.setFilters(com.tplink.smb.omada.logmanager.port.mongo.a.c.c(grid.getFilters()));
        Criteria criteria = this.a(grid.getFilters(), grid.getSearchFilters(), omadacId, siteId);
        criteria.and("key").in(alertKeys);
        return this.a(criteria, "module", omadacId, startTime, endTime);
    }

    public List<LogClassifyInfoDTO> i(String omadacId, String siteId, com.tplink.smb.omada.common.gridquery.a<w> grid, Long startTime, Long endTime, List<String> alertKeys) {
        grid.setFilters(com.tplink.smb.omada.logmanager.port.mongo.a.c.b(grid.getFilters()));
        grid.setFilters(com.tplink.smb.omada.logmanager.port.mongo.a.c.c(grid.getFilters()));
        Criteria criteria = this.a(grid.getFilters(), grid.getSearchFilters(), omadacId, siteId);
        criteria.and("key").in(alertKeys);
        criteria.and("archived").is((Object)false);
        return this.a(criteria, "module", omadacId, startTime, endTime);
    }

    public List<LogClassifyInfoDTO> j(String omadacId, String siteId, com.tplink.smb.omada.common.gridquery.a<w> grid, Long startTime, Long endTime, List<String> alertKeys) {
        grid.setFilters(com.tplink.smb.omada.logmanager.port.mongo.a.c.b(grid.getFilters()));
        grid.setFilters(com.tplink.smb.omada.logmanager.port.mongo.a.c.c(grid.getFilters()));
        Criteria criteria = this.a(grid.getFilters(), grid.getSearchFilters(), omadacId, siteId);
        criteria.and("key").in(alertKeys);
        criteria.and("archived").is((Object)true);
        return this.a(criteria, "module", omadacId, startTime, endTime);
    }

    public List<LogClassifyInfoDTO> k(String omadacId, String siteId, com.tplink.smb.omada.common.gridquery.a<w> grid, Long startTime, Long endTime, List<String> eventKeys) {
        this.b.b(s);
        grid.setFilters(com.tplink.smb.omada.logmanager.port.mongo.a.c.b(grid.getFilters()));
        grid.setFilters(com.tplink.smb.omada.logmanager.port.mongo.a.c.c(grid.getFilters()));
        Criteria criteria = this.b(grid.getFilters(), grid.getSearchFilters(), omadacId, siteId);
        criteria.and("key").in(eventKeys);
        return this.a(criteria, "module", omadacId, startTime, endTime);
    }

    public List<w> a(Boolean globalLogExportPermission, String omadacId, String siteId, com.tplink.smb.omada.common.gridquery.d queryPage) {
        this.b.b(m);
        Query query = new Query();
        query.with((Pageable)PageRequest.of((int)queryPage.a(), (int)queryPage.b()));
        query.addCriteria((CriteriaDefinition)Criteria.where((String)"omadac_id").is((Object)omadacId));
        ArrayList<w> omadaLogs = new ArrayList<w>();
        if (globalLogExportPermission.booleanValue()) {
            query.addCriteria((CriteriaDefinition)Criteria.where((String)"site").is(null));
        } else {
            query.addCriteria((CriteriaDefinition)Criteria.where((String)"site").is((Object)siteId));
        }
        long endTime = System.currentTimeMillis() / 1000L;
        this.iteratorCollectionsByTimeAndSliceKeyWithSkip(Sort.Direction.DESC, 0L, endTime, new com.tplink.smb.omada.logmanager.domain.model.e.g(omadacId), query, (collectionName, queryCollection) -> omadaLogs.addAll(this.mongoTemplate.find(queryCollection, OmadaLogPO.class, collectionName).stream().map(m::a).collect(Collectors.toList())));
        return omadaLogs;
    }

    public void a(Boolean globalLogExportPermission, String omadacId, String siteId, com.tplink.smb.omada.common.util.c.a<w> consumer) {
        Query query = new Query();
        query.addCriteria((CriteriaDefinition)Criteria.where((String)"omadac_id").is((Object)omadacId));
        if (globalLogExportPermission.booleanValue()) {
            query.addCriteria((CriteriaDefinition)Criteria.where((String)"site").is(null));
        } else {
            query.addCriteria((CriteriaDefinition)Criteria.where((String)"site").is((Object)siteId));
        }
        long endTime = System.currentTimeMillis() / 1000L;
        this.iteratorCollectionsByTimeAndSliceKey(Sort.Direction.DESC, 0L, endTime, new com.tplink.smb.omada.logmanager.domain.model.e.g(omadacId), collectionName -> {
            MongoIterable iterable = this.mongoTemplate.getCollection(collectionName).find((Bson)query.getQueryObject()).batchSize(1000).map(src -> (OmadaLogPO)this.mongoTemplate.getConverter().read(OmadaLogPO.class, src));
            iterable.forEach(po -> consumer.a((Object)com.tplink.smb.omada.logmanager.port.mongo.log.m.a(po)));
        });
    }

    public void a(String omadacId, String siteId, Long startTime, Long endTime, List<String> logKeys) {
        Query query = new Query();
        query.addCriteria((CriteriaDefinition)Criteria.where((String)"omadac_id").is((Object)omadacId));
        query.addCriteria((CriteriaDefinition)Criteria.where((String)"time").gte((Object)startTime).lte((Object)endTime));
        query.addCriteria((CriteriaDefinition)Criteria.where((String)"site").is((Object)siteId));
        query.addCriteria((CriteriaDefinition)Criteria.where((String)"key").in(logKeys));
        ArrayList<String> collectionNames = new ArrayList<String>();
        this.iteratorCollectionsByTimeAndSliceKey(Sort.Direction.ASC, startTime / 1000L, endTime / 1000L, new com.tplink.smb.omada.logmanager.domain.model.e.g(omadacId), collectionName -> collectionNames.add((String)collectionName));
        com.tplink.smb.omada.logmanager.port.mongo.a.c.a(collectionNames, "omadalog");
        for (String c2 : collectionNames) {
            this.mongoTemplate.remove(query, OmadaLogPO.class, c2);
            a.debug("Iterating collection(delete by type): {}", (Object)c2);
        }
    }

    public void a(String omadacId, Long startTime, Long endTime, List<String> logKeys) {
        this.a(omadacId, null, startTime, endTime, logKeys);
    }

    public List<w> a(com.tplink.smb.omada.common.gridquery.d page, List<e> sort, List<com.tplink.smb.omada.common.gridquery.c> filters, List<com.tplink.smb.omada.common.gridquery.c> searchFilters, boolean isRoot, String omadacId, String siteKey, long count) {
        if (Objects.isNull(filters)) {
            filters = new ArrayList<com.tplink.smb.omada.common.gridquery.c>();
        }
        Long[] times = com.tplink.smb.omada.logmanager.port.mongo.a.d.a(filters);
        Query query = this.a(filters, searchFilters, isRoot, omadacId, siteKey);
        boolean reverse = this.a(page, query, sort, Sort.Direction.fromString((String)sort.get(0).a().a()), count);
        Sort.Direction direction = sort.get(0).a().a().equals("asc") ? Sort.Direction.ASC : Sort.Direction.DESC;
        com.tplink.smb.omada.logmanager.port.mongo.a.a.a(query, sort);
        ArrayList omadaLogPOS = new ArrayList();
        this.iteratorCollectionsByTimeAndSliceKeyWithSkip(direction, times[0], times[1], new com.tplink.smb.omada.logmanager.domain.model.e.g(omadacId), query, (collectionName, queryFilter) -> omadaLogPOS.addAll(this.mongoTemplate.find(queryFilter, OmadaLogPO.class, collectionName)));
        if (reverse) {
            return omadaLogPOS.stream().map(m::a).sorted(Comparator.comparing(AbstractOmadaLog::getTime).reversed()).collect(Collectors.toList());
        }
        return omadaLogPOS.stream().map(m::a).collect(Collectors.toList());
    }

    private boolean a(com.tplink.smb.omada.common.gridquery.d page, Query query, List<e> querySorts, Sort.Direction direction, long count) {
        int pageSize;
        if (Objects.isNull(page)) {
            return false;
        }
        int pageNum = page.a();
        if ((long)(pageNum * (pageSize = page.b()) * 2) < count) {
            query.limit(page.b()).skip((long)(page.a() * page.b()));
            return false;
        }
        int lastPageSize = (int)(count % (long)pageSize);
        int reversePageNum = (int)(count - (long)(pageNum * pageSize)) / pageSize;
        page.a(reversePageNum);
        if (lastPageSize > 0) {
            if (reversePageNum == 0) {
                query.limit(lastPageSize);
            } else {
                query.limit(page.b()).skip((long)(lastPageSize + (reversePageNum - 1) * page.b()));
            }
        } else {
            query.limit(page.b()).skip((long)(reversePageNum * page.b()));
        }
        if (!CollectionUtils.isEmpty(querySorts)) {
            for (e sort : querySorts) {
                if (direction.isAscending()) {
                    sort.a(com.tplink.smb.omada.common.gridquery.g.a);
                    continue;
                }
                sort.a(com.tplink.smb.omada.common.gridquery.g.b);
            }
        }
        return true;
    }

    public Query a(List<com.tplink.smb.omada.common.gridquery.c> filters, List<com.tplink.smb.omada.common.gridquery.c> searchFilters, boolean isRoot, String omadacId, String siteKey) {
        if (CollectionUtils.isEmpty(filters)) {
            filters = new ArrayList<com.tplink.smb.omada.common.gridquery.c>(4);
        }
        if (CollectionUtils.isEmpty(searchFilters)) {
            searchFilters = new ArrayList<com.tplink.smb.omada.common.gridquery.c>(4);
        }
        filters = com.tplink.smb.omada.logmanager.port.mongo.a.c.d(filters, searchFilters);
        Criteria criteria = com.tplink.smb.omada.logmanager.port.mongo.a.a.b(searchFilters, filters);
        criteria.and("omadac_id").is((Object)omadacId);
        if (isRoot && Objects.nonNull(siteKey)) {
            HashSet<String> siteIdQuery = new HashSet<String>(2);
            siteIdQuery.add(siteKey);
            siteIdQuery.add(null);
            criteria.and("site").in(siteIdQuery);
        } else {
            criteria.and("site").is((Object)siteKey);
        }
        return new Query((CriteriaDefinition)criteria);
    }

    public Criteria a(List<com.tplink.smb.omada.common.gridquery.c> filters, List<com.tplink.smb.omada.common.gridquery.c> searchFilters, String omadacId, String siteKey) {
        if (CollectionUtils.isEmpty(filters)) {
            filters = new ArrayList<com.tplink.smb.omada.common.gridquery.c>(4);
        }
        if (CollectionUtils.isEmpty(searchFilters)) {
            searchFilters = new ArrayList<com.tplink.smb.omada.common.gridquery.c>(4);
        }
        filters = com.tplink.smb.omada.logmanager.port.mongo.a.c.c(filters, searchFilters);
        Criteria criteria = com.tplink.smb.omada.logmanager.port.mongo.a.a.b(searchFilters, filters);
        criteria.and("omadac_id").is((Object)omadacId);
        criteria.and("site").is((Object)siteKey);
        return criteria;
    }

    public Criteria b(List<com.tplink.smb.omada.common.gridquery.c> filters, List<com.tplink.smb.omada.common.gridquery.c> searchFilters, String omadacId, String siteKey) {
        if (CollectionUtils.isEmpty(filters)) {
            filters = new ArrayList<com.tplink.smb.omada.common.gridquery.c>(4);
        }
        if (CollectionUtils.isEmpty(searchFilters)) {
            searchFilters = new ArrayList<com.tplink.smb.omada.common.gridquery.c>(4);
        }
        filters = com.tplink.smb.omada.logmanager.port.mongo.a.c.d(filters, searchFilters);
        Criteria criteria = com.tplink.smb.omada.logmanager.port.mongo.a.a.b(searchFilters, filters);
        criteria.and("omadac_id").is((Object)omadacId);
        criteria.and("site").is((Object)siteKey);
        return criteria;
    }

    public List<LogGroupInfoDTO> a(LogClassifyInfoRequestDTO logClassifyInfoRequestDTO, List<String> logKeys, String ... groupKeys) {
        Criteria criteria;
        Long endTime;
        Long startTime;
        String siteId;
        String omadacId;
        block8: {
            block7: {
                this.b.b(r);
                omadacId = logClassifyInfoRequestDTO.getOmadacId();
                siteId = logClassifyInfoRequestDTO.getSiteId();
                startTime = logClassifyInfoRequestDTO.getStartTime();
                endTime = logClassifyInfoRequestDTO.getEndTime();
                criteria = Criteria.where((String)"omadac_id").is((Object)omadacId);
                if (!CollectionUtils.isEmpty(logKeys)) break block7;
                switch (logClassifyInfoRequestDTO.getLogTypeEnum()) {
                    case a: {
                        criteria.and("alert").is((Object)Boolean.TRUE);
                        break block8;
                    }
                    case b: {
                        criteria.and("event").is((Object)Boolean.TRUE);
                        break block8;
                    }
                    case c: {
                        criteria.andOperator(new Criteria[]{new Criteria().orOperator(new Criteria[]{Criteria.where((String)"alert").is((Object)Boolean.TRUE), Criteria.where((String)"event").is((Object)Boolean.TRUE)})});
                        break block8;
                    }
                    default: {
                        a.warn("Unknown log type: {}", (Object)logClassifyInfoRequestDTO.getLogTypeEnum());
                        return new ArrayList<LogGroupInfoDTO>();
                    }
                }
            }
            criteria.and("key").in(logKeys);
        }
        criteria.and("time").gte((Object)startTime).lte((Object)endTime);
        criteria.and("site").is((Object)siteId);
        if (Objects.nonNull(logClassifyInfoRequestDTO.getDeviceType()) && T.b((String)logClassifyInfoRequestDTO.getDeviceType().b())) {
            criteria.and("device_type").is((Object)logClassifyInfoRequestDTO.getDeviceType().c());
        }
        Aggregation aggregation = Aggregation.newAggregation((AggregationOperation[])new AggregationOperation[]{Aggregation.match((Criteria)criteria), Aggregation.group((String[])groupKeys).count().as("countNumber")});
        ArrayList logGroupInfoDTOS = new ArrayList();
        this.iteratorCollectionsByTimeAndSliceKey(Sort.Direction.DESC, startTime / 1000L, endTime / 1000L, new com.tplink.smb.omada.logmanager.domain.model.e.g(omadacId), collectionName -> logGroupInfoDTOS.addAll(this.mongoTemplate.aggregate(aggregation, collectionName, LogGroupInfoDTO.class).getMappedResults()));
        Map<LogGroupDTO, LongSummaryStatistics> statisticsMap = logGroupInfoDTOS.stream().collect(Collectors.groupingBy(LogGroupInfoDTO::getId, Collectors.summarizingLong(LogGroupInfoDTO::getCountNumber)));
        ArrayList<LogGroupInfoDTO> logGroupList = new ArrayList<LogGroupInfoDTO>();
        for (Map.Entry<LogGroupDTO, LongSummaryStatistics> entry : statisticsMap.entrySet()) {
            logGroupList.add(LogGroupInfoDTO.builder().id(entry.getKey()).countNumber(Long.valueOf(entry.getValue().getSum())).build());
        }
        return logGroupList;
    }

    public List<LogClassifyInfoDTO> a(LogClassifyNumberQueryDTO logClassifyNumberQueryDTO) {
        this.b.b(s);
        String omadacId = logClassifyNumberQueryDTO.getOmadacId();
        Criteria criteria = Criteria.where((String)"omadac_id").is((Object)omadacId);
        Boolean alert = logClassifyNumberQueryDTO.getAlert();
        Boolean event = logClassifyNumberQueryDTO.getEvent();
        if (Boolean.TRUE.equals(alert)) {
            criteria.and("alert").is((Object)true);
        }
        if (Boolean.TRUE.equals(event)) {
            criteria.and("event").is((Object)true);
        }
        long startTime = logClassifyNumberQueryDTO.getStartTime();
        long endTime = logClassifyNumberQueryDTO.getEndTime();
        criteria.and("time").gte((Object)startTime).lte((Object)endTime);
        if (Objects.nonNull(logClassifyNumberQueryDTO.getArchived())) {
            criteria.and("archived").is((Object)logClassifyNumberQueryDTO.getArchived());
        }
        if (!T.a((String)logClassifyNumberQueryDTO.getModule())) {
            criteria.and("module").is((Object)logClassifyNumberQueryDTO.getModule());
        }
        HashSet<String> siteIdQuery = new HashSet<String>(2);
        siteIdQuery.add(logClassifyNumberQueryDTO.getSiteId());
        if (logClassifyNumberQueryDTO.getRootLag().booleanValue()) {
            siteIdQuery.add(null);
        }
        criteria.and("site").in(siteIdQuery);
        if (!T.a((String)logClassifyNumberQueryDTO.getSearchKey())) {
            criteria.andOperator(new Criteria[]{com.tplink.smb.omada.logmanager.port.mongo.a.d.a(com.tplink.smb.omada.logmanager.port.mongo.a.d.b(logClassifyNumberQueryDTO.getSearchKey()))});
        }
        Aggregation aggregation = Aggregation.newAggregation((AggregationOperation[])new AggregationOperation[]{Aggregation.match((Criteria)criteria), Aggregation.group((String[])new String[]{logClassifyNumberQueryDTO.getGroupKey()}).count().as("countNumber")});
        ArrayList logGroupInfoDTOS = new ArrayList();
        this.iteratorCollectionsByTimeAndSliceKey(Sort.Direction.DESC, startTime / 1000L, endTime / 1000L, new com.tplink.smb.omada.logmanager.domain.model.e.g(omadacId), collectionName -> logGroupInfoDTOS.addAll(this.mongoTemplate.aggregate(aggregation, collectionName, LogClassifyInfoDTO.class).getMappedResults()));
        Map<String, LongSummaryStatistics> statisticsMap = logGroupInfoDTOS.stream().collect(Collectors.groupingBy(LogClassifyInfoDTO::getId, Collectors.summarizingLong(LogClassifyInfoDTO::getCountNumber)));
        ArrayList<LogClassifyInfoDTO> logGroupInfo = new ArrayList<LogClassifyInfoDTO>();
        for (Map.Entry<String, LongSummaryStatistics> entry : statisticsMap.entrySet()) {
            logGroupInfo.add(LogClassifyInfoDTO.builder().id(entry.getKey()).countNumber(Long.valueOf(entry.getValue().getSum())).build());
        }
        return logGroupInfo;
    }

    public Long b(com.tplink.smb.omada.logmanager.domain.model.e.g omadacId, Long startTime, Long endTime) {
        Query query = new Query();
        Criteria criteria = Criteria.where((String)"omadac_id").is((Object)omadacId.a());
        criteria.and("time").gte((Object)startTime).lte((Object)endTime);
        criteria.and("archived").is((Object)Boolean.FALSE);
        query.addCriteria((CriteriaDefinition)criteria);
        AtomicLong count = new AtomicLong();
        this.iteratorCollectionsByTimeAndSliceKey(Sort.Direction.DESC, startTime / 1000L, endTime / 1000L, omadacId, collectionName -> count.addAndGet(this.mongoTemplate.count(query, OmadaLogPO.class, collectionName)));
        return count.get();
    }

    public Map<String, Long> a(com.tplink.smb.omada.logmanager.domain.model.e.g omadacId, Set<String> sites, Long startTime, Long endTime) {
        Criteria criteria = Criteria.where((String)"omadac_id").is((Object)omadacId.a());
        criteria.and("site").in(sites);
        criteria.and("time").gte((Object)startTime).lte((Object)endTime);
        criteria.and("archived").is((Object)Boolean.FALSE);
        criteria.and("alert").is((Object)Boolean.TRUE);
        Aggregation aggregation = Aggregation.newAggregation((AggregationOperation[])new AggregationOperation[]{Aggregation.match((Criteria)criteria), Aggregation.group((String[])new String[]{"site"}).count().as("alertNumber")});
        ArrayList numClassifyInfoDTOS = new ArrayList();
        this.iteratorCollectionsByTimeAndSliceKey(Sort.Direction.DESC, startTime / 1000L, endTime / 1000L, omadacId, collectionName -> numClassifyInfoDTOS.addAll(this.mongoTemplate.aggregate(aggregation, collectionName, AlertNumClassifyInfoDTO.class).getMappedResults()));
        Map<String, LongSummaryStatistics> statisticsMap = numClassifyInfoDTOS.stream().collect(Collectors.groupingBy(AlertNumClassifyInfoDTO::getId, Collectors.summarizingLong(AlertNumClassifyInfoDTO::getAlertNumber)));
        HashMap<String, Long> sitesAlertNumMap = new HashMap<String, Long>(statisticsMap.size());
        for (Map.Entry<String, LongSummaryStatistics> entry : statisticsMap.entrySet()) {
            sitesAlertNumMap.put(entry.getKey(), entry.getValue().getSum());
        }
        return sitesAlertNumMap;
    }

    public Map<String, Long> a(com.tplink.smb.omada.logmanager.domain.model.e.g omadacId, Set<String> sites, Long startTime, Long endTime, List<String> alertKeys) {
        Criteria criteria = Criteria.where((String)"omadac_id").is((Object)omadacId.a());
        criteria.and("site").in(sites);
        criteria.and("time").gte((Object)startTime).lte((Object)endTime);
        criteria.and("archived").is((Object)Boolean.FALSE);
        criteria.and("key").in(alertKeys);
        Aggregation aggregation = Aggregation.newAggregation((AggregationOperation[])new AggregationOperation[]{Aggregation.match((Criteria)criteria), Aggregation.group((String[])new String[]{"site"}).count().as("alertNumber")});
        ArrayList numClassifyInfoDTOS = new ArrayList();
        this.iteratorCollectionsByTimeAndSliceKey(Sort.Direction.DESC, startTime / 1000L, endTime / 1000L, omadacId, collectionName -> numClassifyInfoDTOS.addAll(this.mongoTemplate.aggregate(aggregation, collectionName, AlertNumClassifyInfoDTO.class).getMappedResults()));
        Map<String, LongSummaryStatistics> statisticsMap = numClassifyInfoDTOS.stream().collect(Collectors.groupingBy(AlertNumClassifyInfoDTO::getId, Collectors.summarizingLong(AlertNumClassifyInfoDTO::getAlertNumber)));
        HashMap<String, Long> sitesAlertNumMap = new HashMap<String, Long>(statisticsMap.size());
        for (Map.Entry<String, LongSummaryStatistics> entry : statisticsMap.entrySet()) {
            sitesAlertNumMap.put(entry.getKey(), entry.getValue().getSum());
        }
        return sitesAlertNumMap;
    }

    public Map<String, Long> a(Set<String> customers, Long startTime, Long endTime) {
        Criteria criteria = Criteria.where((String)"omadac_id").in(customers);
        criteria.and("time").gte((Object)startTime).lte((Object)endTime);
        criteria.and("archived").is((Object)Boolean.FALSE);
        criteria.and("alert").is((Object)Boolean.TRUE);
        Aggregation aggregation = Aggregation.newAggregation((AggregationOperation[])new AggregationOperation[]{Aggregation.match((Criteria)criteria), Aggregation.group((String[])new String[]{"omadac_id"}).count().as("alertNumber")});
        ArrayList numClassifyInfoDTOS = new ArrayList();
        this.iteratorCollectionsByTime(Sort.Direction.DESC, startTime / 1000L, endTime / 1000L, collectionName -> numClassifyInfoDTOS.addAll(this.mongoTemplate.aggregate(aggregation, collectionName, AlertNumClassifyInfoDTO.class).getMappedResults()));
        Map<String, LongSummaryStatistics> statisticsMap = numClassifyInfoDTOS.stream().collect(Collectors.groupingBy(AlertNumClassifyInfoDTO::getId, Collectors.summarizingLong(AlertNumClassifyInfoDTO::getAlertNumber)));
        HashMap<String, Long> customersAlertNumMap = new HashMap<String, Long>(statisticsMap.size());
        for (Map.Entry<String, LongSummaryStatistics> entry : statisticsMap.entrySet()) {
            customersAlertNumMap.put(entry.getKey(), entry.getValue().getSum());
        }
        return customersAlertNumMap;
    }

    public List<String> a(String omadacId, Long startTime, Long endTime, g direction) {
        ArrayList<String> collectionNames = new ArrayList<String>();
        this.iteratorCollectionsByTimeAndSliceKey(com.tplink.smb.omada.common.gridquery.g.a.equals((Object)direction) ? Sort.Direction.DESC : Sort.Direction.ASC, startTime, endTime, new com.tplink.smb.omada.logmanager.domain.model.e.g(omadacId), collectionName -> collectionNames.add((String)collectionName));
        return collectionNames;
    }

    public void a(com.tplink.smb.omada.logmanager.domain.model.e.g omadacId, String siteId, List<String> ids, Long startTime, Long endTime) {
        Query query = new Query();
        query.addCriteria((CriteriaDefinition)Criteria.where((String)"site").is((Object)siteId));
        this.a(omadacId, ids, startTime, endTime, query);
    }

    public void a(com.tplink.smb.omada.logmanager.domain.model.e.g omadacId, String siteId, com.tplink.smb.omada.common.gridquery.a<w> grid, List<String> ids, List<String> alertKeys, Long startTime, Long endTime, Boolean isAlert) {
        ArrayList<w> omadaLogs = new ArrayList<w>();
        if (!CollectionUtils.isEmpty(ids)) {
            Criteria criteria = Criteria.where((String)"_id").in(ids).and("omadac_id").is((Object)omadacId.a()).and("site").is((Object)siteId);
            Query idQuery = new Query((CriteriaDefinition)criteria);
            this.iteratorCollectionsByTimeAndSliceKey(Sort.Direction.DESC, startTime / 1000L, endTime / 1000L, omadacId, collectionName -> omadaLogs.addAll(this.mongoTemplate.find(idQuery, OmadaLogPO.class, collectionName).stream().map(m::a).collect(Collectors.toList())));
        }
        for (w omadalog : omadaLogs) {
            ids.remove(omadalog.getId().a());
        }
        grid.setFilters(com.tplink.smb.omada.logmanager.port.mongo.a.c.a(grid.getFilters()));
        Query query = this.a(grid.getFilters(), grid.getSearchFilters(), false, omadacId.a(), siteId);
        if (isAlert.booleanValue()) {
            query.addCriteria((CriteriaDefinition)Criteria.where((String)"key").in(alertKeys));
        }
        query.fields().include("_id");
        query.limit(5000).with(Sort.by((Sort.Direction)Sort.Direction.ASC, (String[])new String[]{"_id"}));
        long debugStartTime = System.currentTimeMillis();
        this.iteratorCollectionsByTimeAndSliceKey(Sort.Direction.DESC, startTime / 1000L, endTime / 1000L, omadacId, collectionName -> {
            List listRemove = this.mongoTemplate.find(query, OmadaLogPO.class, collectionName);
            while (!CollectionUtils.isEmpty((Collection)listRemove)) {
                this.mongoTemplate.remove(Query.query((CriteriaDefinition)Criteria.where((String)"_id").in(listRemove.stream().map(AbstractOmadaLogPO::getId).toList())), collectionName);
                try {
                    Thread.sleep(100L);
                }
                catch (InterruptedException e2) {
                    a.error("InterruptedException while sleeping,e=", (Throwable)e2);
                    Thread.currentThread().interrupt();
                }
                listRemove = this.mongoTemplate.find(query, OmadaLogPO.class, collectionName);
            }
        });
        long cost = System.currentTimeMillis() - debugStartTime;
        a.debug("deleteAllLogsForSite remove cost={} ,omadacId={} , siteId ={}", new Object[]{cost, omadacId, siteId});
        if (!CollectionUtils.isEmpty(omadaLogs)) {
            this.a(omadaLogs);
        }
    }

    public void a(com.tplink.smb.omada.logmanager.domain.model.e.g omadacId, List<String> ids, Long startTime, Long endTime) {
        Query query = new Query();
        query.addCriteria((CriteriaDefinition)Criteria.where((String)"site").is(null));
        this.a(omadacId, ids, startTime, endTime, query);
    }

    public void a(com.tplink.smb.omada.logmanager.domain.model.e.g omadacId, com.tplink.smb.omada.common.gridquery.a<w> grid, List<String> ids, List<String> alertKeys, Long startTime, Long endTime, Boolean isAlert) {
        ArrayList<w> omadaLogs = new ArrayList<w>();
        if (!CollectionUtils.isEmpty(ids)) {
            Criteria criteria = Criteria.where((String)"_id").in(ids).and("omadac_id").is((Object)omadacId.a());
            Query idQuery = new Query((CriteriaDefinition)criteria);
            this.iteratorCollectionsByTimeAndSliceKey(Sort.Direction.DESC, startTime / 1000L, endTime / 1000L, omadacId, collectionName -> omadaLogs.addAll(this.mongoTemplate.find(idQuery, OmadaLogPO.class, collectionName).stream().map(m::a).collect(Collectors.toList())));
        }
        for (w omadalog : omadaLogs) {
            ids.remove(omadalog.getId().a());
        }
        grid.setFilters(com.tplink.smb.omada.logmanager.port.mongo.a.c.a(grid.getFilters()));
        Query query = this.a(grid.getFilters(), grid.getSearchFilters(), true, omadacId.a(), null);
        if (isAlert.booleanValue()) {
            query.addCriteria((CriteriaDefinition)Criteria.where((String)"key").in(alertKeys));
        }
        this.iteratorCollectionsByTimeAndSliceKey(Sort.Direction.DESC, startTime / 1000L, endTime / 1000L, omadacId, collectionName -> this.mongoTemplate.remove(query, collectionName));
        if (!CollectionUtils.isEmpty(omadaLogs)) {
            this.a(omadaLogs);
        }
    }

    private void a(com.tplink.smb.omada.logmanager.domain.model.e.g omadacId, List<String> ids, Long startTime, Long endTime, Query query) {
        AtomicInteger clearedNum = new AtomicInteger(0);
        int topNum = ids.size();
        query.addCriteria((CriteriaDefinition)Criteria.where((String)"omadac_id").is((Object)omadacId.a()));
        query.addCriteria((CriteriaDefinition)Criteria.where((String)"_id").in(ids));
        this.iteratorCollectionsByTimeAndSliceKey(Sort.Direction.DESC, startTime / 1000L, endTime / 1000L, omadacId, collectionName -> {
            if (clearedNum.get() >= topNum) {
                return;
            }
            int removed = (int)this.mongoTemplate.remove(query, collectionName).getDeletedCount();
            clearedNum.addAndGet(removed);
        });
    }

    public void b(com.tplink.smb.omada.logmanager.domain.model.e.g omadacId, String siteId, List<String> ids, Long startTime, Long endTime) {
        Query query = new Query();
        query.addCriteria((CriteriaDefinition)Criteria.where((String)"site").is((Object)siteId));
        this.b(omadacId, ids, startTime, endTime, query);
    }

    public void b(com.tplink.smb.omada.logmanager.domain.model.e.g omadacId, List<String> ids, Long startTime, Long endTime) {
        Query query = new Query();
        query.addCriteria((CriteriaDefinition)Criteria.where((String)"site").is(null));
        this.b(omadacId, ids, startTime, endTime, query);
    }

    private void b(com.tplink.smb.omada.logmanager.domain.model.e.g omadacId, List<String> ids, Long startTime, Long endTime, Query query) {
        query.addCriteria((CriteriaDefinition)Criteria.where((String)"omadac_id").is((Object)omadacId.a()));
        query.addCriteria((CriteriaDefinition)Criteria.where((String)"_id").in(ids));
        Update update = new Update();
        update.set("archived", (Object)true);
        this.iteratorCollectionsByTimeAndSliceKey(Sort.Direction.DESC, startTime / 1000L, endTime / 1000L, omadacId, collectionName -> this.mongoTemplate.updateMulti(query, (UpdateDefinition)update, OmadaLogPO.class, collectionName));
    }

    public Long a(String omadacId, String siteId, String collectionName, com.tplink.smb.omada.common.gridquery.a grid) {
        return this.mongoTemplate.count(this.a(grid.getFilters(), grid.getSearchFilters(), (boolean)Boolean.TRUE, omadacId, siteId), OmadaLogPO.class, collectionName);
    }

    public Long a(String omadacId, String siteId, String collectionName, com.tplink.smb.omada.common.gridquery.a grid, List<String> eventKeys) {
        return this.mongoTemplate.count(this.b(grid.getFilters(), grid.getSearchFilters(), Boolean.TRUE, omadacId, null, eventKeys), OmadaLogPO.class, collectionName);
    }

    public Long b(String omadacId, String siteId, String collectionName, com.tplink.smb.omada.common.gridquery.a grid, List<String> eventKeys) {
        return this.mongoTemplate.count(this.b(grid.getFilters(), grid.getSearchFilters(), Boolean.FALSE, omadacId, siteId, eventKeys), OmadaLogPO.class, collectionName);
    }

    public Long c(String omadacId, String siteId, String collectionName, com.tplink.smb.omada.common.gridquery.a grid, List<String> alertKeys) {
        return this.mongoTemplate.count(this.a((List<com.tplink.smb.omada.common.gridquery.c>)grid.getFilters(), (List<com.tplink.smb.omada.common.gridquery.c>)grid.getSearchFilters(), (boolean)Boolean.FALSE, omadacId, siteId, alertKeys), OmadaLogPO.class, collectionName);
    }

    public Long d(String omadacId, String siteId, String collectionName, com.tplink.smb.omada.common.gridquery.a grid, List<String> alertKeys) {
        return this.mongoTemplate.count(this.a((List<com.tplink.smb.omada.common.gridquery.c>)grid.getFilters(), (List<com.tplink.smb.omada.common.gridquery.c>)grid.getSearchFilters(), (boolean)Boolean.TRUE, omadacId, null, alertKeys), OmadaLogPO.class, collectionName);
    }

    public List<w> a(String omadacId, String siteId, String collectionName, com.tplink.smb.omada.common.gridquery.a grid, Long skip, Integer limit) {
        Query query = this.a(grid.getFilters(), grid.getSearchFilters(), (boolean)Boolean.TRUE, omadacId, siteId);
        com.tplink.smb.omada.logmanager.port.mongo.a.a.a(query, grid.getQuerySorts());
        query.skip(skip.longValue());
        query.limit(limit.intValue());
        return this.mongoTemplate.find(query, OmadaLogPO.class, collectionName).stream().map(m::a).collect(Collectors.toList());
    }

    public List<w> b(String omadacId, String siteId, String collectionName, com.tplink.smb.omada.common.gridquery.a grid, Long skip, Integer limit) {
        Query query = this.a(grid.getFilters(), grid.getSearchFilters(), (boolean)Boolean.FALSE, omadacId, siteId);
        com.tplink.smb.omada.logmanager.port.mongo.a.a.a(query, grid.getQuerySorts());
        query.skip(skip.longValue());
        query.limit(limit.intValue());
        return this.mongoTemplate.find(query, OmadaLogPO.class, collectionName).stream().map(m::a).collect(Collectors.toList());
    }

    public List<w> a(String omadacId, String siteId, String collectionName, com.tplink.smb.omada.common.gridquery.a grid, Long skip, Integer limit, List<String> alertKeys) {
        Query query = this.a((List<com.tplink.smb.omada.common.gridquery.c>)grid.getFilters(), (List<com.tplink.smb.omada.common.gridquery.c>)grid.getSearchFilters(), (boolean)Boolean.TRUE, omadacId, siteId, alertKeys);
        com.tplink.smb.omada.logmanager.port.mongo.a.a.a(query, grid.getQuerySorts());
        query.skip(skip.longValue());
        query.limit(limit.intValue());
        return this.mongoTemplate.find(query, OmadaLogPO.class, collectionName).stream().map(m::a).collect(Collectors.toList());
    }

    public List<w> b(String omadacId, String siteId, String collectionName, com.tplink.smb.omada.common.gridquery.a grid, Long skip, Integer limit, List<String> alertKeys) {
        Query query = this.a((List<com.tplink.smb.omada.common.gridquery.c>)grid.getFilters(), (List<com.tplink.smb.omada.common.gridquery.c>)grid.getSearchFilters(), (boolean)Boolean.FALSE, omadacId, siteId, alertKeys);
        com.tplink.smb.omada.logmanager.port.mongo.a.a.a(query, grid.getQuerySorts());
        query.skip(skip.longValue());
        query.limit(limit.intValue());
        return this.mongoTemplate.find(query, OmadaLogPO.class, collectionName).stream().map(m::a).collect(Collectors.toList());
    }

    public List<w> c(String omadacId, String siteId, String collectionName, com.tplink.smb.omada.common.gridquery.a grid, Long skip, Integer limit, List<String> eventKeys) {
        Query query = this.b(grid.getFilters(), grid.getSearchFilters(), Boolean.TRUE, omadacId, siteId, eventKeys);
        com.tplink.smb.omada.logmanager.port.mongo.a.a.a(query, grid.getQuerySorts());
        query.skip(skip.longValue());
        query.limit(limit.intValue());
        return this.mongoTemplate.find(query, OmadaLogPO.class, collectionName).stream().map(m::a).collect(Collectors.toList());
    }

    public List<w> d(String omadacId, String siteId, String collectionName, com.tplink.smb.omada.common.gridquery.a grid, Long skip, Integer limit, List<String> eventKeys) {
        Query query = this.b(grid.getFilters(), grid.getSearchFilters(), Boolean.FALSE, omadacId, siteId, eventKeys);
        com.tplink.smb.omada.logmanager.port.mongo.a.a.a(query, grid.getQuerySorts());
        query.skip(skip.longValue());
        query.limit(limit.intValue());
        return this.mongoTemplate.find(query, OmadaLogPO.class, collectionName).stream().map(m::a).collect(Collectors.toList());
    }

    public List<String> b(String omadacId, String siteId) {
        Query query = new Query();
        query.addCriteria((CriteriaDefinition)Criteria.where((String)"omadac_id").is((Object)omadacId));
        query.addCriteria((CriteriaDefinition)Criteria.where((String)"site").is((Object)siteId));
        query.addCriteria((CriteriaDefinition)Criteria.where((String)"alert").is((Object)true));
        return this.mongoTemplate.query(OmadaLogPO.class).distinct("key").matching(query).as(String.class).all();
    }

    public List<String> c(String omadacId, String siteId) {
        Query query = new Query();
        query.addCriteria((CriteriaDefinition)Criteria.where((String)"omadac_id").is((Object)omadacId));
        query.addCriteria((CriteriaDefinition)Criteria.where((String)"site").is((Object)siteId));
        query.addCriteria((CriteriaDefinition)Criteria.where((String)"event").is((Object)true));
        return this.mongoTemplate.query(OmadaLogPO.class).distinct("key").matching(query).as(String.class).all();
    }

    public void a(ArchiveDTO archiveDTO) {
        Criteria criteria = new Criteria("alert").is((Object)true);
        criteria.and("archived").is((Object)false);
        Query query = Query.query((CriteriaDefinition)criteria);
        Long startTime = archiveDTO.getTimeStart() / 1000L;
        Long endTime = archiveDTO.getTimeEnd() / 1000L;
        query.addCriteria((CriteriaDefinition)Criteria.where((String)"time").gte((Object)archiveDTO.getTimeStart()).lte((Object)archiveDTO.getTimeEnd()));
        this.iteratorCollectionsByTime(Sort.Direction.DESC, startTime, endTime, collectionName -> this.mongoTemplate.updateMulti(query, (UpdateDefinition)Update.update((String)"archived", (Object)true), OmadaLogPO.class, collectionName));
    }

    public void a() {
        long currentTime = System.currentTimeMillis() / 1000L;
        long timeEnd = currentTime - 604800L;
        long timeStart = currentTime - 2592000L;
        this.iteratorCollectionsByTime(Sort.Direction.DESC, timeStart, timeEnd, collectionName -> this.checkThenEnsureIndexes((String)collectionName, this.getIndexDefinitions()));
    }

    private Query a(List<com.tplink.smb.omada.common.gridquery.c> filters, List<com.tplink.smb.omada.common.gridquery.c> searchFilters, boolean isRoot, String omadacId, String siteKey, List<String> alertKeys) {
        if (CollectionUtils.isEmpty(filters)) {
            filters = new ArrayList<com.tplink.smb.omada.common.gridquery.c>(4);
        }
        if (CollectionUtils.isEmpty(searchFilters)) {
            searchFilters = new ArrayList<com.tplink.smb.omada.common.gridquery.c>(4);
        }
        filters = com.tplink.smb.omada.logmanager.port.mongo.a.c.c(filters, searchFilters);
        Criteria criteria = com.tplink.smb.omada.logmanager.port.mongo.a.a.b(searchFilters, filters);
        criteria.and("omadac_id").is((Object)omadacId);
        if (isRoot && Objects.nonNull(siteKey)) {
            HashSet<String> siteIdQuery = new HashSet<String>(2);
            siteIdQuery.add(siteKey);
            siteIdQuery.add(null);
            criteria.and("site").in(siteIdQuery);
        } else {
            criteria.and("site").is((Object)siteKey);
        }
        criteria.and("key").in(alertKeys);
        return new Query((CriteriaDefinition)criteria);
    }

    private Query b(List<com.tplink.smb.omada.common.gridquery.c> filters, List<com.tplink.smb.omada.common.gridquery.c> searchFilters, boolean isRoot, String omadacId, String siteKey, List<String> eventKeys) {
        if (CollectionUtils.isEmpty(filters)) {
            filters = new ArrayList<com.tplink.smb.omada.common.gridquery.c>(4);
        }
        if (CollectionUtils.isEmpty(searchFilters)) {
            searchFilters = new ArrayList<com.tplink.smb.omada.common.gridquery.c>(4);
        }
        filters = com.tplink.smb.omada.logmanager.port.mongo.a.c.d(filters, searchFilters);
        Criteria criteria = com.tplink.smb.omada.logmanager.port.mongo.a.a.b(searchFilters, filters);
        criteria.and("omadac_id").is((Object)omadacId);
        if (isRoot && Objects.nonNull(siteKey)) {
            HashSet<String> siteIdQuery = new HashSet<String>(2);
            siteIdQuery.add(siteKey);
            siteIdQuery.add(null);
            criteria.and("site").in(siteIdQuery);
        } else {
            criteria.and("site").is((Object)siteKey);
        }
        criteria.and("key").in(eventKeys);
        return new Query((CriteriaDefinition)criteria);
    }

    private List<LogClassifyInfoDTO> a(Criteria criteria, String groupKey, String omadacId, Long startTime, Long endTime) {
        Aggregation aggregation = Aggregation.newAggregation((AggregationOperation[])new AggregationOperation[]{Aggregation.match((Criteria)criteria), Aggregation.group((String[])new String[]{groupKey}).count().as("countNumber")});
        ArrayList logGroupInfoDTOS = new ArrayList();
        this.iteratorCollectionsByTimeAndSliceKey(Sort.Direction.DESC, startTime / 1000L, endTime / 1000L, new com.tplink.smb.omada.logmanager.domain.model.e.g(omadacId), collectionName -> logGroupInfoDTOS.addAll(this.mongoTemplate.aggregate(aggregation, collectionName, LogClassifyInfoDTO.class).getMappedResults()));
        Map<String, LongSummaryStatistics> statisticsMap = logGroupInfoDTOS.stream().collect(Collectors.groupingBy(LogClassifyInfoDTO::getId, Collectors.summarizingLong(LogClassifyInfoDTO::getCountNumber)));
        ArrayList<LogClassifyInfoDTO> logGroupInfo = new ArrayList<LogClassifyInfoDTO>();
        for (Map.Entry<String, LongSummaryStatistics> entry : statisticsMap.entrySet()) {
            logGroupInfo.add(LogClassifyInfoDTO.builder().id(entry.getKey()).countNumber(Long.valueOf(entry.getValue().getSum())).build());
        }
        return logGroupInfo;
    }

    public void b(com.tplink.smb.omada.logmanager.domain.model.e.g omadacId) {
        a.debug("start to delete all site level logs of omadacId: {}", (Object)omadacId);
        long start = System.currentTimeMillis();
        this.iteratorCollectionsBySliceKey(omadacId, collectionName -> this.mongoTemplate.dropCollection(collectionName));
        a.debug("delete all global level log by drop collection of omadacId : {} use {} ms", (Object)omadacId, (Object)(System.currentTimeMillis() - start));
    }

    protected int c(@Nullable com.tplink.smb.omada.logmanager.domain.model.e.g key) {
        if (Objects.isNull(key)) {
            return 0;
        }
        return key.a().hashCode();
    }

    protected n b() {
        return this.c;
    }

    protected Class getPOClass() {
        return OmadaLogPO.class;
    }

    protected MongoTemplate getMongoTemplate() {
        return this.mongoTemplate;
    }

    @Nonnull
    protected String getCollectionNameOrPrefixIfSliced() {
        return "omadalog";
    }

    @Nonnull
    protected IndexDefinition[] getIndexDefinitions() {
        return OmadaLogPO.INDEX_DEFINITIONS;
    }

    public void a(com.tplink.smb.omada.logmanager.port.commom.service.a.c event) {
        this.dbMaintenance(event.a());
    }

    @PostConstruct
    public void c() {
        DomainEventBusHolder.getHandlerRegistry().registerSync(com.tplink.smb.omada.logmanager.port.commom.service.a.c.class, (DomainEventSubscriber)this);
    }

    protected /* synthetic */ p getStrategy() {
        return this.b();
    }

    protected /* synthetic */ int hashCodeOfKey(@Nullable Object object) {
        return this.c((com.tplink.smb.omada.logmanager.domain.model.e.g)object);
    }

    protected /* synthetic */ u getStrategy() {
        return this.b();
    }

    public /* synthetic */ void handleEvent(Object object) {
        this.a((com.tplink.smb.omada.logmanager.port.commom.service.a.c)object);
    }
}

