/*
 * Decompiled with CFR 0.152.
 */
package com.tplink.smb.omada.logmanager.port.mongo.log.f;

import com.mongodb.bulk.BulkWriteResult;
import com.tplink.nbu.common.utils.CollectionUtil;
import com.tplink.smb.eventcenter.api.event.DomainEventSubscriber;
import com.tplink.smb.eventcenter.domain.DomainEventBusHolder;
import com.tplink.smb.omada.common.gridquery.e;
import com.tplink.smb.omada.common.gridquery.g;
import com.tplink.smb.omada.common.mongo.repository.p;
import com.tplink.smb.omada.common.mongo.repository.q;
import com.tplink.smb.omada.common.mongo.repository.u;
import com.tplink.smb.omada.common.util.T;
import com.tplink.smb.omada.logmanager.api.external.dto.ArchiveDTO;
import com.tplink.smb.omada.logmanager.api.internal.dto.LogClassifyInfoRequestDTO;
import com.tplink.smb.omada.logmanager.api.internal.dto.OmadaLogDTO;
import com.tplink.smb.omada.logmanager.domain.model.e.i;
import com.tplink.smb.omada.logmanager.domain.model.log.AbstractOmadaLog;
import com.tplink.smb.omada.logmanager.domain.model.log.LogClassifyInfoDTO;
import com.tplink.smb.omada.logmanager.domain.model.log.LogClassifyNumberQueryDTO;
import com.tplink.smb.omada.logmanager.domain.model.log.LogGroupDTO;
import com.tplink.smb.omada.logmanager.domain.model.log.LogGroupInfoDTO;
import com.tplink.smb.omada.logmanager.domain.model.log.subscriber.AlertNumClassifyInfoDTO;
import com.tplink.smb.omada.logmanager.domain.model.log.w;
import com.tplink.smb.omada.logmanager.port.commom.c.b;
import com.tplink.smb.omada.logmanager.port.mongo.a.c;
import com.tplink.smb.omada.logmanager.port.mongo.a.d;
import com.tplink.smb.omada.logmanager.port.mongo.log.LiteOmadaLogPO;
import com.tplink.smb.omada.logmanager.port.mongo.log.OmadaLogPO;
import com.tplink.smb.omada.logmanager.port.mongo.log.m;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import jakarta.annotation.PostConstruct;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.LongSummaryStatistics;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import java.util.stream.Collectors;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;
import org.springframework.data.mongodb.core.BulkOperations;
import org.springframework.data.mongodb.core.MongoTemplate;
import org.springframework.data.mongodb.core.aggregation.Aggregation;
import org.springframework.data.mongodb.core.aggregation.AggregationOperation;
import org.springframework.data.mongodb.core.index.IndexDefinition;
import org.springframework.data.mongodb.core.query.Criteria;
import org.springframework.data.mongodb.core.query.CriteriaDefinition;
import org.springframework.data.mongodb.core.query.Query;
import org.springframework.data.mongodb.core.query.Update;
import org.springframework.data.mongodb.core.query.UpdateDefinition;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;

@Component
public class a
extends q<LiteOmadaLogPO, com.tplink.smb.omada.logmanager.domain.model.e.g>
implements DomainEventSubscriber<com.tplink.smb.omada.logmanager.port.commom.service.a.c>,
com.tplink.smb.omada.logmanager.domain.model.log.subscriber.a {
    @Generated
    private static final Logger a = LoggerFactory.getLogger(a.class);
    @Autowired
    @Qualifier(value="dataMongoTemplate")
    private MongoTemplate mongoTemplate;
    @Autowired
    private b b;
    @Autowired
    private com.tplink.smb.omada.logmanager.port.mongo.data.a.e c;
    private static final String d = "delete-log-by-omadac-site";
    private static final String e = "delete-log-by-omadac";
    private static final String f = "count-by-omadac";
    private static final String g = "count-alert-by-omadac-keys";
    private static final String h = "count-alert-by-omadac-site-keys";
    private static final String i = "get-grid";
    private static final String j = "count-logs-by-level";
    private static final String k = "archive-all-alerts";
    private static final String l = "count-logs";
    private static final String m = "find-logs-time-content-with-page";
    private static final String n = "delete-log-omadac-less-time";
    private static final String o = "delete-logs";
    private static final String p = "delete-site-logs-by-type";
    private static final String q = "delete-global-logs-by-type";
    private static final String r = "get-classify-log-info";
    private static final String s = "get-log-num-by-level";
    private static final int t = 100000;

    public List<w> a(List<w> omadaLogs) {
        if (CollectionUtils.isEmpty(omadaLogs)) {
            return new ArrayList<w>(2);
        }
        Map<String, List<LiteOmadaLogPO>> collectionNameToPOsMap = omadaLogs.stream().map(m::c).collect(Collectors.groupingBy(x$0 -> this.getCollectionNameForSave(x$0)));
        collectionNameToPOsMap.forEach((collectionName, poList) -> {
            BulkOperations bulkOperations = this.mongoTemplate.bulkOps(BulkOperations.BulkMode.UNORDERED, collectionName);
            poList.forEach(liteOmadaLogPO -> bulkOperations.insert(liteOmadaLogPO));
            BulkWriteResult result = bulkOperations.execute();
            a.debug("Bulk write omada log result: {}", (Object)result);
        });
        return omadaLogs;
    }

    public void a(com.tplink.smb.omada.logmanager.domain.model.e.g omadacId, i siteId) {
        this.b.b(d);
        Query query = new Query();
        Criteria criteria = Criteria.where((String)"omadac_id").is((Object)omadacId.a());
        criteria.and("site").is((Object)siteId.a());
        query.addCriteria((CriteriaDefinition)criteria);
        this.iteratorCollectionsBySliceKey(omadacId, collectionName -> this.mongoTemplate.remove(query, LiteOmadaLogPO.class, collectionName));
    }

    public void a(com.tplink.smb.omada.logmanager.domain.model.e.g omadacId) {
        this.b.b(e);
        Query query = new Query();
        Criteria criteria = Criteria.where((String)"omadac_id").is((Object)omadacId.a());
        query.addCriteria((CriteriaDefinition)criteria);
        this.iteratorCollectionsBySliceKey(omadacId, collectionName -> this.mongoTemplate.remove(query, LiteOmadaLogPO.class, collectionName));
    }

    public Long b(com.tplink.smb.omada.logmanager.domain.model.e.g omadacId) {
        this.b.b(f);
        Query query = new Query((CriteriaDefinition)Criteria.where((String)"omadac_id").is((Object)omadacId.a()));
        AtomicLong total = new AtomicLong(0L);
        this.iteratorCollectionsBySliceKey(omadacId, collectionName -> total.addAndGet(this.mongoTemplate.count(query, collectionName)));
        return total.get();
    }

    public void a(com.tplink.smb.omada.logmanager.domain.model.e.g omadacId, Integer topNum) {
        AtomicInteger clearedNum = new AtomicInteger(0);
        this.iteratorCollectionsByTimeAsc(0L, System.currentTimeMillis(), collectionName -> {
            int loopCount = topNum / 100000;
            for (int i2 = 0; i2 <= loopCount; ++i2) {
                int removeLimit = Math.min(topNum - clearedNum.get(), 100000);
                if (clearedNum.get() >= topNum) {
                    return;
                }
                int removed = (int)this.mongoTemplate.remove(new Query((CriteriaDefinition)Criteria.where((String)"omadac_id").is((Object)omadacId.a())).with(Sort.by((Sort.Direction)Sort.Direction.ASC, (String[])new String[]{"time"})).limit(removeLimit), collectionName).getDeletedCount();
                clearedNum.addAndGet(removed);
            }
        });
    }

    public long a(com.tplink.smb.omada.logmanager.domain.model.e.g omadacId, Long startTime, Long endTime) {
        this.b.b(g);
        Query query = new Query();
        Criteria criteria = Criteria.where((String)"omadac_id").is((Object)omadacId.a());
        criteria.and("site").is(null);
        criteria.and("global").is((Object)Boolean.TRUE);
        criteria.and("alert").is((Object)Boolean.TRUE);
        criteria.and("archived").is((Object)Boolean.FALSE);
        criteria.and("time").gte((Object)startTime).lte((Object)endTime);
        query.addCriteria((CriteriaDefinition)criteria);
        AtomicLong total = new AtomicLong(0L);
        this.iteratorCollectionsByTimeAndSliceKey(Sort.Direction.DESC, startTime / 1000L, endTime / 1000L, omadacId, collectionName -> total.addAndGet(this.mongoTemplate.count(query, collectionName)));
        return total.get();
    }

    public long a(com.tplink.smb.omada.logmanager.domain.model.e.g omadacId, i siteId, Long startTime, Long endTime) {
        this.b.b(h);
        Query query = new Query();
        Criteria criteria = Criteria.where((String)"omadac_id").is((Object)omadacId.a());
        criteria.and("site").is((Object)siteId.a());
        criteria.and("global").is((Object)Boolean.FALSE);
        criteria.and("alert").is((Object)Boolean.TRUE);
        criteria.and("archived").is((Object)Boolean.FALSE);
        criteria.and("time").gte((Object)startTime).lte((Object)endTime);
        query.addCriteria((CriteriaDefinition)criteria);
        AtomicLong total = new AtomicLong(0L);
        this.iteratorCollectionsByTimeAndSliceKey(Sort.Direction.DESC, startTime / 1000L, endTime / 1000L, omadacId, collectionName -> total.addAndGet(this.mongoTemplate.count(query, collectionName)));
        return total.get();
    }

    public List<OmadaLogDTO> b(com.tplink.smb.omada.logmanager.domain.model.e.g omadacId, i siteId) {
        Query query = new Query();
        Criteria criteria = Criteria.where((String)"omadac_id").is((Object)omadacId.a());
        criteria.and("site").is((Object)siteId.a());
        criteria.and("global").is((Object)Boolean.FALSE);
        ArrayList liteOmadaLogPOS = new ArrayList();
        this.iteratorCollectionsBySliceKey(omadacId, collectionName -> liteOmadaLogPOS.addAll(this.mongoTemplate.find(query, LiteOmadaLogPO.class, collectionName)));
        return liteOmadaLogPOS.stream().map(m::b).collect(Collectors.toList());
    }

    public com.tplink.smb.omada.common.gridquery.a<w> a(com.tplink.smb.omada.common.gridquery.a<w> grid, Boolean rootLag, String omadacId, String siteId) {
        this.b.b(i);
        long currentLogGet = System.currentTimeMillis();
        long currentCountTime = System.currentTimeMillis();
        long count = this.a(grid.getFilters(), grid.getSearchFilters(), rootLag, omadacId, siteId, ((e)grid.getQuerySorts().get(0)).a());
        a.trace("Log count time:{}(s)", (Object)((System.currentTimeMillis() - currentCountTime) / 1000L));
        grid.setTotalRows(count);
        if (count < 1L) {
            grid.setData(Collections.EMPTY_LIST);
            return grid;
        }
        grid.setData(this.a(grid.getQueryPage(), grid.getQuerySorts(), grid.getFilters(), grid.getSearchFilters(), rootLag, omadacId, siteId, count));
        a.trace("Get log total time:{}(s)", (Object)((System.currentTimeMillis() - currentLogGet) / 1000L));
        return grid;
    }

    public Long a(LogClassifyNumberQueryDTO logClassifyNumberQueryDTO) {
        this.b.b(j);
        Query query = new Query();
        Criteria criteria = Criteria.where((String)"omadac_id").is((Object)logClassifyNumberQueryDTO.getOmadacId());
        Boolean alert = logClassifyNumberQueryDTO.getAlert();
        Boolean event = logClassifyNumberQueryDTO.getEvent();
        if (Boolean.TRUE.equals(alert)) {
            criteria.and("alert").is((Object)true);
        }
        if (Boolean.TRUE.equals(event)) {
            criteria.and("event").is((Object)true);
        }
        criteria.and("level").is((Object)logClassifyNumberQueryDTO.getLevel());
        Long startTime = logClassifyNumberQueryDTO.getStartTime();
        Long endTime = logClassifyNumberQueryDTO.getEndTime();
        criteria.and("time").gte((Object)startTime).lte((Object)endTime);
        if (Objects.nonNull(logClassifyNumberQueryDTO.getArchived())) {
            criteria.and("archived").is((Object)logClassifyNumberQueryDTO.getArchived());
        }
        if (!T.a((String)logClassifyNumberQueryDTO.getModule())) {
            criteria.and("module").is((Object)logClassifyNumberQueryDTO.getModule());
        }
        ArrayList<String> sites = new ArrayList<String>(2);
        sites.add(logClassifyNumberQueryDTO.getSiteId());
        if (logClassifyNumberQueryDTO.getRootLag().booleanValue()) {
            sites.add(null);
            criteria.and("global").is((Object)Boolean.TRUE);
        } else {
            criteria.and("global").is((Object)Boolean.FALSE);
        }
        criteria.and("site").in(sites);
        if (!T.a((String)logClassifyNumberQueryDTO.getSearchKey())) {
            criteria.andOperator(new Criteria[]{com.tplink.smb.omada.logmanager.port.mongo.a.d.a(com.tplink.smb.omada.logmanager.port.mongo.a.d.b(logClassifyNumberQueryDTO.getSearchKey()))});
        }
        query.addCriteria((CriteriaDefinition)criteria);
        AtomicLong total = new AtomicLong(0L);
        this.iteratorCollectionsByTimeAndSliceKey(Sort.Direction.DESC, startTime / 1000L, endTime / 1000L, new com.tplink.smb.omada.logmanager.domain.model.e.g(logClassifyNumberQueryDTO.getOmadacId()), collectionName -> total.addAndGet(this.mongoTemplate.count(query, LiteOmadaLogPO.class, collectionName)));
        return total.get();
    }

    public w a(String omadacId, String logId) {
        Query query = new Query();
        Criteria criteria = Criteria.where((String)"omadac_id").is((Object)omadacId);
        criteria.and("_id").is((Object)logId);
        query.addCriteria((CriteriaDefinition)criteria);
        ArrayList liteOmadaLogPOS = new ArrayList();
        this.iteratorCollectionsBySliceKey(new com.tplink.smb.omada.logmanager.domain.model.e.g(omadacId), collectionName -> liteOmadaLogPOS.addAll(this.mongoTemplate.find(query, LiteOmadaLogPO.class, collectionName)));
        if (CollectionUtils.isEmpty(liteOmadaLogPOS) || liteOmadaLogPOS.size() > 1) {
            a.warn("fail to find omadaLog by omadacId :{}, logId :{}", (Object)omadacId, (Object)logId);
            return null;
        }
        return com.tplink.smb.omada.logmanager.port.mongo.log.m.a((OmadaLogPO)liteOmadaLogPOS.get(0));
    }

    public void a(w omadaLog) {
        LiteOmadaLogPO liteOmadaLogPO = com.tplink.smb.omada.logmanager.port.mongo.log.m.c(omadaLog);
        String collectionName = this.getCollectionNameForSave(liteOmadaLogPO);
        this.iteratorCollectionsBySliceKey(omadaLog.getOmadacId(), logPo -> this.mongoTemplate.save((Object)liteOmadaLogPO, collectionName));
        if (omadaLog.getId() != null && omadaLog.getId().a() != null) {
            Query query = new Query((CriteriaDefinition)Criteria.where((String)"_id").is((Object)omadaLog.getId().a()));
            this.mongoTemplate.remove(query, "liteomadalog");
        }
    }

    public void a(String omadacId, String siteId, Boolean rootLag, ArchiveDTO archiveDTO) {
        this.b.b(k);
        HashSet<String> siteIdQuery = new HashSet<String>(2);
        siteIdQuery.add(siteId);
        Criteria criteria = new Criteria("omadac_id").is((Object)omadacId);
        if (rootLag.booleanValue()) {
            criteria.and("global").is((Object)Boolean.TRUE);
            siteIdQuery.add(null);
        } else {
            criteria.and("global").is((Object)Boolean.FALSE);
        }
        criteria.and("site").in(siteIdQuery);
        criteria.and("archived").is((Object)false);
        criteria.and("alert").is((Object)true);
        Query query = Query.query((CriteriaDefinition)criteria);
        Long startTime = archiveDTO.getTimeStart() / 1000L;
        Long endTime = archiveDTO.getTimeEnd() / 1000L;
        query.addCriteria((CriteriaDefinition)Criteria.where((String)"time").gte((Object)archiveDTO.getTimeStart()).lte((Object)archiveDTO.getTimeEnd()));
        this.iteratorCollectionsByTimeAndSliceKey(Sort.Direction.DESC, startTime, endTime, new com.tplink.smb.omada.logmanager.domain.model.e.g(omadacId), collectionName -> this.mongoTemplate.updateMulti(query, (UpdateDefinition)Update.update((String)"archived", (Object)true), LiteOmadaLogPO.class, collectionName));
    }

    public void a(String omadacId, String siteId, Boolean rootLag) {
        Criteria criteria = Criteria.where((String)"omadac_id").is((Object)omadacId);
        HashSet<String> siteIdQuery = new HashSet<String>(2);
        siteIdQuery.add(siteId);
        if (rootLag.booleanValue()) {
            siteIdQuery.add(null);
            criteria.and("global").is((Object)Boolean.TRUE);
        } else {
            criteria.and("global").is((Object)Boolean.FALSE);
        }
        criteria.and("site").in(siteIdQuery);
        criteria.and("archived").is((Object)true);
        criteria.and("alert").is((Object)true);
        Query query = new Query((CriteriaDefinition)criteria);
        this.iteratorCollectionsBySliceKey(new com.tplink.smb.omada.logmanager.domain.model.e.g(omadacId), collectionName -> this.mongoTemplate.remove(query, LiteOmadaLogPO.class, collectionName));
    }

    public void a(String omadacId, String site, Boolean deleteAlert, Long startTime, Long endTime) {
        Query query = new Query();
        query.addCriteria((CriteriaDefinition)Criteria.where((String)"site").is((Object)site));
        query.addCriteria((CriteriaDefinition)Criteria.where((String)"global").is((Object)Boolean.FALSE));
        this.a(query, omadacId, deleteAlert, startTime, endTime);
    }

    public void a(String omadacId, Boolean deleteAlert, Long startTime, Long endTime) {
        Query query = new Query();
        query.addCriteria((CriteriaDefinition)Criteria.where((String)"site").is(null));
        query.addCriteria((CriteriaDefinition)Criteria.where((String)"global").is((Object)Boolean.TRUE));
        this.a(query, omadacId, deleteAlert, startTime, endTime);
    }

    private void a(Query query, String omadacId, Boolean deleteAlert, Long startTime, Long endTime) {
        query.addCriteria((CriteriaDefinition)Criteria.where((String)"omadac_id").is((Object)omadacId));
        if (deleteAlert.booleanValue()) {
            query.addCriteria((CriteriaDefinition)Criteria.where((String)"alert").is((Object)true));
        } else {
            query.addCriteria((CriteriaDefinition)Criteria.where((String)"event").is((Object)true));
        }
        query.addCriteria((CriteriaDefinition)Criteria.where((String)"time").gte((Object)startTime).lte((Object)endTime));
        this.iteratorCollectionsByTimeAndSliceKey(Sort.Direction.DESC, startTime / 1000L, endTime / 1000L, new com.tplink.smb.omada.logmanager.domain.model.e.g(omadacId), collectionName -> this.mongoTemplate.remove(query, LiteOmadaLogPO.class, collectionName));
    }

    public long b(String omadacId, String site, Boolean rootLag) {
        HashSet<String> siteIdQuery = new HashSet<String>(2);
        siteIdQuery.add(site);
        if (rootLag.booleanValue()) {
            siteIdQuery.add(null);
        }
        Query query = new Query();
        query.addCriteria((CriteriaDefinition)Criteria.where((String)"event").is((Object)true));
        query.addCriteria((CriteriaDefinition)Criteria.where((String)"omadac_id").is((Object)omadacId));
        query.addCriteria((CriteriaDefinition)Criteria.where((String)"site").in(siteIdQuery));
        this.iteratorCollectionsBySliceKey(new com.tplink.smb.omada.logmanager.domain.model.e.g(omadacId), collectionName -> this.mongoTemplate.remove(query, LiteOmadaLogPO.class, collectionName));
        return 0L;
    }

    public long a(List<com.tplink.smb.omada.common.gridquery.c> filters, List<com.tplink.smb.omada.common.gridquery.c> searchFilters, Boolean rootLag, String omadacId, String siteKey, g direction) {
        this.b.b(l);
        if (Objects.isNull(filters)) {
            filters = new ArrayList<com.tplink.smb.omada.common.gridquery.c>();
        }
        Long[] times = com.tplink.smb.omada.logmanager.port.mongo.a.d.a(filters);
        Query query = this.a(filters, searchFilters, (boolean)rootLag, omadacId, siteKey);
        AtomicLong total = new AtomicLong(0L);
        this.iteratorCollectionsByTimeAndSliceKey(direction.a().equals("asc") ? Sort.Direction.ASC : Sort.Direction.DESC, times[0], times[1], new com.tplink.smb.omada.logmanager.domain.model.e.g(omadacId), collectionName -> total.addAndGet(this.mongoTemplate.count(query, LiteOmadaLogPO.class, collectionName)));
        return total.get();
    }

    public List<w> a(Boolean globalLogExportPermission, String omadacId, String siteId, com.tplink.smb.omada.common.gridquery.d queryPage) {
        this.b.b(m);
        Query query = new Query();
        query.with((Pageable)PageRequest.of((int)queryPage.a(), (int)queryPage.b()));
        query.addCriteria((CriteriaDefinition)Criteria.where((String)"omadac_id").is((Object)omadacId));
        query.with(Sort.by((Sort.Order[])new Sort.Order[]{Sort.Order.desc((String)"time")}));
        ArrayList<w> omadaLogs = new ArrayList<w>();
        if (globalLogExportPermission.booleanValue()) {
            query.addCriteria((CriteriaDefinition)Criteria.where((String)"global").is((Object)Boolean.TRUE));
        } else {
            query.addCriteria((CriteriaDefinition)Criteria.where((String)"global").is((Object)Boolean.FALSE));
            query.addCriteria((CriteriaDefinition)Criteria.where((String)"site").is((Object)siteId));
        }
        long endTime = System.currentTimeMillis() / 1000L;
        this.iteratorCollectionsByTimeAndSliceKeyWithSkip(Sort.Direction.DESC, 0L, endTime, new com.tplink.smb.omada.logmanager.domain.model.e.g(omadacId), query, (collectionName, queryCollection) -> omadaLogs.addAll(this.mongoTemplate.find(queryCollection, LiteOmadaLogPO.class, collectionName).stream().map(m::a).collect(Collectors.toList())));
        return omadaLogs;
    }

    public void a(String omadacId, long time) {
        this.b.b(n);
        this.mongoTemplate.remove(new Query((CriteriaDefinition)Criteria.where((String)"omadac_id").is((Object)omadacId).and("time").lt((Object)time)), LiteOmadaLogPO.class);
    }

    public void a(String omadacId, String siteId, long time, List<String> logKeys, Boolean rootLag) {
        this.b.b(o);
        Query query = new Query();
        query.addCriteria((CriteriaDefinition)Criteria.where((String)"omadac_id").is((Object)omadacId));
        query.addCriteria((CriteriaDefinition)Criteria.where((String)"time").lt((Object)time));
        if (rootLag.booleanValue()) {
            query.addCriteria((CriteriaDefinition)new Criteria().orOperator(new Criteria[]{Criteria.where((String)"site").is((Object)siteId), Criteria.where((String)"site").exists(false)}));
        } else {
            query.addCriteria((CriteriaDefinition)Criteria.where((String)"site").is((Object)siteId));
        }
        if (!CollectionUtil.isEmpty(logKeys)) {
            query.addCriteria((CriteriaDefinition)Criteria.where((String)"key").in(logKeys));
        }
        this.mongoTemplate.remove(query, LiteOmadaLogPO.class);
    }

    public void a(String omadacId, String siteId, Long startTime, Long endTime, List<String> logKeys) {
        Query query = new Query();
        if (Objects.nonNull(siteId)) {
            this.b.b(p);
            query.addCriteria((CriteriaDefinition)Criteria.where((String)"global").is((Object)Boolean.FALSE));
        } else {
            this.b.b(q);
            query.addCriteria((CriteriaDefinition)Criteria.where((String)"global").is((Object)Boolean.TRUE));
        }
        query.addCriteria((CriteriaDefinition)Criteria.where((String)"omadac_id").is((Object)omadacId));
        query.addCriteria((CriteriaDefinition)Criteria.where((String)"time").gte((Object)startTime).lte((Object)endTime));
        query.addCriteria((CriteriaDefinition)Criteria.where((String)"site").is((Object)siteId));
        query.addCriteria((CriteriaDefinition)Criteria.where((String)"key").in(logKeys));
        ArrayList<String> collectionNames = new ArrayList<String>();
        this.iteratorCollectionsByTimeAndSliceKey(Sort.Direction.ASC, startTime / 1000L, endTime / 1000L, new com.tplink.smb.omada.logmanager.domain.model.e.g(omadacId), collectionName -> collectionNames.add((String)collectionName));
        com.tplink.smb.omada.logmanager.port.mongo.a.c.a(collectionNames, "liteomadalog");
        for (String c2 : collectionNames) {
            this.mongoTemplate.remove(query, LiteOmadaLogPO.class, c2);
            a.debug("Iterating collection(delete by type): {}", (Object)c2);
        }
    }

    public void a(String omadacId, Long startTime, Long endTime, List<String> logKeys) {
        this.a(omadacId, null, startTime, endTime, logKeys);
    }

    public List<w> a(com.tplink.smb.omada.common.gridquery.d page, List<e> sort, List<com.tplink.smb.omada.common.gridquery.c> filters, List<com.tplink.smb.omada.common.gridquery.c> searchFilters, boolean isRoot, String omadacId, String siteKey, long count) {
        if (Objects.isNull(filters)) {
            filters = new ArrayList<com.tplink.smb.omada.common.gridquery.c>();
        }
        Query query = this.a(filters, searchFilters, isRoot, omadacId, siteKey);
        Long[] times = com.tplink.smb.omada.logmanager.port.mongo.a.d.a(filters);
        boolean reverse = this.a(page, query, sort, Sort.Direction.fromString((String)sort.get(0).a().a()), count);
        Sort.Direction direction = sort.get(0).a().a().equals("asc") ? Sort.Direction.ASC : Sort.Direction.DESC;
        com.tplink.smb.omada.logmanager.port.mongo.a.a.a(query, sort);
        ArrayList liteOmmadaLogPOS = new ArrayList();
        this.iteratorCollectionsByTimeAndSliceKeyWithSkip(direction, times[0], times[1], new com.tplink.smb.omada.logmanager.domain.model.e.g(omadacId), query, (collectionName, queryFilter) -> liteOmmadaLogPOS.addAll(this.mongoTemplate.find(queryFilter, LiteOmadaLogPO.class, collectionName)));
        if (reverse) {
            return liteOmmadaLogPOS.stream().map(m::a).sorted(Comparator.comparing(AbstractOmadaLog::getTime).reversed()).collect(Collectors.toList());
        }
        return liteOmmadaLogPOS.stream().map(m::a).collect(Collectors.toList());
    }

    private boolean a(com.tplink.smb.omada.common.gridquery.d page, Query query, List<e> querySorts, Sort.Direction direction, long count) {
        int pageSize;
        if (Objects.isNull(page)) {
            return false;
        }
        int pageNum = page.a();
        if ((long)(pageNum * (pageSize = page.b()) * 2) < count) {
            query.limit(page.b()).skip((long)(page.a() * page.b()));
            return false;
        }
        int lastPageSize = (int)(count % (long)pageSize);
        int reversePageNum = (int)(count - (long)(pageNum * pageSize)) / pageSize;
        page.a(reversePageNum);
        if (lastPageSize > 0) {
            if (reversePageNum == 0) {
                query.limit(lastPageSize);
            } else {
                query.limit(page.b()).skip((long)(lastPageSize + (reversePageNum - 1) * page.b()));
            }
        } else {
            query.limit(page.b()).skip((long)(reversePageNum * page.b()));
        }
        if (!CollectionUtils.isEmpty(querySorts)) {
            for (e sort : querySorts) {
                if (direction.isAscending()) {
                    sort.a(com.tplink.smb.omada.common.gridquery.g.a);
                    continue;
                }
                sort.a(com.tplink.smb.omada.common.gridquery.g.b);
            }
        }
        return true;
    }

    public Query a(List<com.tplink.smb.omada.common.gridquery.c> filters, List<com.tplink.smb.omada.common.gridquery.c> searchFilters, boolean isRoot, String omadacId, String siteKey) {
        if (CollectionUtils.isEmpty(filters)) {
            filters = new ArrayList<com.tplink.smb.omada.common.gridquery.c>(4);
        }
        Criteria criteria = com.tplink.smb.omada.logmanager.port.mongo.a.a.b(searchFilters, filters);
        HashSet<String> siteIdQuery = new HashSet<String>(2);
        siteIdQuery.add(siteKey);
        if (isRoot) {
            criteria.and("global").is((Object)Boolean.TRUE);
        } else {
            criteria.and("global").is((Object)Boolean.FALSE);
        }
        return new Query((CriteriaDefinition)new Criteria().andOperator(new Criteria[]{criteria, new Criteria("omadac_id").is((Object)omadacId), new Criteria("site").in(siteIdQuery)}));
    }

    public List<LogGroupInfoDTO> a(LogClassifyInfoRequestDTO logClassifyInfoRequestDTO, String ... groupKeys) {
        this.b.b(r);
        String omadacId = logClassifyInfoRequestDTO.getOmadacId();
        String siteId = logClassifyInfoRequestDTO.getSiteId();
        Long startTime = logClassifyInfoRequestDTO.getStartTime();
        Long endTime = logClassifyInfoRequestDTO.getEndTime();
        Criteria criteria = Criteria.where((String)"omadac_id").is((Object)omadacId);
        switch (logClassifyInfoRequestDTO.getLogTypeEnum()) {
            case a: {
                criteria.and("alert").is((Object)Boolean.TRUE);
                break;
            }
            case b: {
                criteria.and("event").is((Object)Boolean.TRUE);
                break;
            }
            case c: {
                criteria.andOperator(new Criteria[]{new Criteria().orOperator(new Criteria[]{Criteria.where((String)"alert").is((Object)Boolean.TRUE), Criteria.where((String)"event").is((Object)Boolean.TRUE)})});
                break;
            }
            default: {
                a.warn("Unknown log type: {}", (Object)logClassifyInfoRequestDTO.getLogTypeEnum());
                return new ArrayList<LogGroupInfoDTO>();
            }
        }
        criteria.and("time").gte((Object)startTime).lte((Object)endTime);
        criteria.and("site").is((Object)siteId);
        if (Objects.nonNull(logClassifyInfoRequestDTO.getDeviceType()) && T.b((String)logClassifyInfoRequestDTO.getDeviceType().b())) {
            criteria.and("device_type").is((Object)logClassifyInfoRequestDTO.getDeviceType().c());
        }
        Aggregation aggregation = Aggregation.newAggregation((AggregationOperation[])new AggregationOperation[]{Aggregation.match((Criteria)criteria), Aggregation.group((String[])groupKeys).count().as("countNumber")});
        ArrayList logGroupInfoDTOS = new ArrayList();
        this.iteratorCollectionsByTimeAndSliceKey(Sort.Direction.DESC, startTime / 1000L, endTime / 1000L, new com.tplink.smb.omada.logmanager.domain.model.e.g(omadacId), collectionName -> logGroupInfoDTOS.addAll(this.mongoTemplate.aggregate(aggregation, collectionName, LogGroupInfoDTO.class).getMappedResults()));
        Map<LogGroupDTO, LongSummaryStatistics> statisticsMap = logGroupInfoDTOS.stream().collect(Collectors.groupingBy(LogGroupInfoDTO::getId, Collectors.summarizingLong(LogGroupInfoDTO::getCountNumber)));
        ArrayList<LogGroupInfoDTO> logGroupList = new ArrayList<LogGroupInfoDTO>();
        for (Map.Entry<LogGroupDTO, LongSummaryStatistics> entry : statisticsMap.entrySet()) {
            logGroupList.add(LogGroupInfoDTO.builder().id(entry.getKey()).countNumber(Long.valueOf(entry.getValue().getSum())).build());
        }
        return logGroupList;
    }

    public List<LogClassifyInfoDTO> b(LogClassifyNumberQueryDTO logClassifyNumberQueryDTO) {
        this.b.b(s);
        String omadacId = logClassifyNumberQueryDTO.getOmadacId();
        Criteria criteria = Criteria.where((String)"omadac_id").is((Object)omadacId);
        Boolean alert = logClassifyNumberQueryDTO.getAlert();
        Boolean event = logClassifyNumberQueryDTO.getEvent();
        if (Boolean.TRUE.equals(alert)) {
            criteria.and("alert").is((Object)true);
        }
        if (Boolean.TRUE.equals(event)) {
            criteria.and("event").is((Object)true);
        }
        long startTime = logClassifyNumberQueryDTO.getStartTime();
        long endTime = logClassifyNumberQueryDTO.getEndTime();
        criteria.and("time").gte((Object)startTime).lte((Object)endTime);
        if (Objects.nonNull(logClassifyNumberQueryDTO.getArchived())) {
            criteria.and("archived").is((Object)logClassifyNumberQueryDTO.getArchived());
        }
        if (!T.a((String)logClassifyNumberQueryDTO.getModule())) {
            criteria.and("module").is((Object)logClassifyNumberQueryDTO.getModule());
        }
        HashSet<String> siteIdQuery = new HashSet<String>(2);
        siteIdQuery.add(logClassifyNumberQueryDTO.getSiteId());
        if (logClassifyNumberQueryDTO.getRootLag().booleanValue()) {
            criteria.and("global").is((Object)Boolean.TRUE);
            siteIdQuery.add(null);
        } else {
            criteria.and("global").is((Object)Boolean.FALSE);
        }
        criteria.and("site").in(siteIdQuery);
        if (!T.a((String)logClassifyNumberQueryDTO.getSearchKey())) {
            criteria.andOperator(new Criteria[]{com.tplink.smb.omada.logmanager.port.mongo.a.d.a(com.tplink.smb.omada.logmanager.port.mongo.a.d.b(logClassifyNumberQueryDTO.getSearchKey()))});
        }
        Aggregation aggregation = Aggregation.newAggregation((AggregationOperation[])new AggregationOperation[]{Aggregation.match((Criteria)criteria), Aggregation.group((String[])new String[]{logClassifyNumberQueryDTO.getGroupKey()}).count().as("countNumber")});
        ArrayList logGroupInfoDTOS = new ArrayList();
        this.iteratorCollectionsByTimeAndSliceKey(Sort.Direction.DESC, startTime / 1000L, endTime / 1000L, new com.tplink.smb.omada.logmanager.domain.model.e.g(omadacId), collectionName -> logGroupInfoDTOS.addAll(this.mongoTemplate.aggregate(aggregation, collectionName, LogClassifyInfoDTO.class).getMappedResults()));
        Map<String, LongSummaryStatistics> statisticsMap = logGroupInfoDTOS.stream().collect(Collectors.groupingBy(LogClassifyInfoDTO::getId, Collectors.summarizingLong(LogClassifyInfoDTO::getCountNumber)));
        ArrayList<LogClassifyInfoDTO> logGroupInfo = new ArrayList<LogClassifyInfoDTO>();
        for (Map.Entry<String, LongSummaryStatistics> entry : statisticsMap.entrySet()) {
            logGroupInfo.add(LogClassifyInfoDTO.builder().id(entry.getKey()).countNumber(Long.valueOf(entry.getValue().getSum())).build());
        }
        return logGroupInfo;
    }

    public AtomicLong b(com.tplink.smb.omada.logmanager.domain.model.e.g omadacId, Long startTime, Long endTime) {
        Query query = new Query();
        Criteria criteria = Criteria.where((String)"omadac_id").is((Object)omadacId);
        criteria.and("time").gte((Object)startTime).lte((Object)endTime);
        criteria.and("archived").is((Object)Boolean.FALSE);
        query.addCriteria((CriteriaDefinition)criteria);
        AtomicLong count = new AtomicLong();
        this.iteratorCollectionsByTimeAndSliceKey(Sort.Direction.DESC, startTime / 1000L, endTime / 1000L, omadacId, collectionName -> count.addAndGet(this.mongoTemplate.count(query, LiteOmadaLogPO.class, collectionName)));
        return count;
    }

    public Long c(com.tplink.smb.omada.logmanager.domain.model.e.g omadacId, Long startTime, Long endTime) {
        Query query = new Query();
        Criteria criteria = Criteria.where((String)"omadac_id").is((Object)omadacId.a());
        criteria.and("time").gte((Object)startTime).lte((Object)endTime);
        criteria.and("archived").is((Object)Boolean.FALSE);
        criteria.and("global").is((Object)Boolean.FALSE);
        query.addCriteria((CriteriaDefinition)criteria);
        AtomicLong count = new AtomicLong();
        this.iteratorCollectionsByTimeAndSliceKey(Sort.Direction.DESC, startTime / 1000L, endTime / 1000L, omadacId, collectionName -> count.addAndGet(this.mongoTemplate.count(query, LiteOmadaLogPO.class, collectionName)));
        return count.get();
    }

    public Map<String, Long> a(com.tplink.smb.omada.logmanager.domain.model.e.g omadacId, Set<String> sites, Long startTime, Long endTime) {
        Criteria criteria = Criteria.where((String)"omadac_id").is((Object)omadacId.a());
        criteria.and("site").in(sites);
        criteria.and("global").is((Object)Boolean.FALSE);
        criteria.and("time").gte((Object)startTime).lte((Object)endTime);
        criteria.and("archived").is((Object)Boolean.FALSE);
        criteria.and("alert").is((Object)Boolean.TRUE);
        Aggregation aggregation = Aggregation.newAggregation((AggregationOperation[])new AggregationOperation[]{Aggregation.match((Criteria)criteria), Aggregation.group((String[])new String[]{"site"}).count().as("alertNumber")});
        ArrayList numClassifyInfoDTOS = new ArrayList();
        this.iteratorCollectionsByTimeAndSliceKey(Sort.Direction.DESC, startTime / 1000L, endTime / 1000L, omadacId, collectionName -> numClassifyInfoDTOS.addAll(this.mongoTemplate.aggregate(aggregation, collectionName, AlertNumClassifyInfoDTO.class).getMappedResults()));
        Map<String, LongSummaryStatistics> statisticsMap = numClassifyInfoDTOS.stream().collect(Collectors.groupingBy(AlertNumClassifyInfoDTO::getId, Collectors.summarizingLong(AlertNumClassifyInfoDTO::getAlertNumber)));
        HashMap<String, Long> sitesAlertNumMap = new HashMap<String, Long>(statisticsMap.size());
        for (Map.Entry<String, LongSummaryStatistics> entry : statisticsMap.entrySet()) {
            sitesAlertNumMap.put(entry.getKey(), entry.getValue().getSum());
        }
        return sitesAlertNumMap;
    }

    public void a(com.tplink.smb.omada.logmanager.domain.model.e.g omadacId, String siteId, List<String> ids, Long startTime, Long endTime) {
        Query query = new Query();
        query.addCriteria((CriteriaDefinition)Criteria.where((String)"site").is((Object)siteId));
        query.addCriteria((CriteriaDefinition)Criteria.where((String)"global").is((Object)Boolean.FALSE));
        this.a(omadacId, ids, startTime, endTime, query);
    }

    public void a(com.tplink.smb.omada.logmanager.domain.model.e.g omadacId, List<String> ids, Long startTime, Long endTime) {
        Query query = new Query();
        query.addCriteria((CriteriaDefinition)Criteria.where((String)"site").is(null));
        query.addCriteria((CriteriaDefinition)Criteria.where((String)"global").is((Object)Boolean.TRUE));
        this.a(omadacId, ids, startTime, endTime, query);
    }

    private void a(com.tplink.smb.omada.logmanager.domain.model.e.g omadacId, List<String> ids, Long startTime, Long endTime, Query query) {
        AtomicInteger clearedNum = new AtomicInteger(0);
        int topNum = ids.size();
        query.addCriteria((CriteriaDefinition)Criteria.where((String)"omadac_id").is((Object)omadacId.a()));
        query.addCriteria((CriteriaDefinition)Criteria.where((String)"_id").in(ids));
        this.iteratorCollectionsByTimeAndSliceKey(Sort.Direction.DESC, startTime / 1000L, endTime / 1000L, omadacId, collectionName -> {
            if (clearedNum.get() >= topNum) {
                return;
            }
            int removed = (int)this.mongoTemplate.remove(query, collectionName).getDeletedCount();
            clearedNum.addAndGet(removed);
        });
    }

    public void b(com.tplink.smb.omada.logmanager.domain.model.e.g omadacId, String siteId, List<String> ids, Long startTime, Long endTime) {
        Query query = new Query();
        query.addCriteria((CriteriaDefinition)Criteria.where((String)"site").is((Object)siteId));
        this.b(omadacId, ids, startTime, endTime, query);
    }

    public void b(com.tplink.smb.omada.logmanager.domain.model.e.g omadacId, List<String> ids, Long startTime, Long endTime) {
        Query query = new Query();
        query.addCriteria((CriteriaDefinition)Criteria.where((String)"site").is(null));
        this.b(omadacId, ids, startTime, endTime, query);
    }

    private void b(com.tplink.smb.omada.logmanager.domain.model.e.g omadacId, List<String> ids, Long startTime, Long endTime, Query query) {
        query.addCriteria((CriteriaDefinition)Criteria.where((String)"omadac_id").is((Object)omadacId.a()));
        query.addCriteria((CriteriaDefinition)Criteria.where((String)"_id").in(ids));
        Update update = new Update();
        update.set("archived", (Object)true);
        this.iteratorCollectionsByTimeAndSliceKey(Sort.Direction.DESC, startTime / 1000L, endTime / 1000L, omadacId, collectionName -> this.mongoTemplate.updateMulti(query, (UpdateDefinition)update, LiteOmadaLogPO.class, collectionName));
    }

    protected int c(@Nullable com.tplink.smb.omada.logmanager.domain.model.e.g key) {
        if (Objects.isNull(key)) {
            return 0;
        }
        return key.a().hashCode();
    }

    protected com.tplink.smb.omada.logmanager.port.mongo.data.a.e a() {
        return this.c;
    }

    protected Class getPOClass() {
        return LiteOmadaLogPO.class;
    }

    protected MongoTemplate getMongoTemplate() {
        return this.mongoTemplate;
    }

    @Nonnull
    protected String getCollectionNameOrPrefixIfSliced() {
        return "liteomadalog";
    }

    @Nonnull
    protected IndexDefinition[] getIndexDefinitions() {
        return LiteOmadaLogPO.INDEX_DEFINITIONS;
    }

    public void a(com.tplink.smb.omada.logmanager.port.commom.service.a.c event) {
        this.dbMaintenance(event.a());
    }

    @PostConstruct
    public void b() {
        DomainEventBusHolder.getHandlerRegistry().registerSync(com.tplink.smb.omada.logmanager.port.commom.service.a.c.class, (DomainEventSubscriber)this);
    }

    protected /* synthetic */ p getStrategy() {
        return this.a();
    }

    protected /* synthetic */ int hashCodeOfKey(@Nullable Object object) {
        return this.c((com.tplink.smb.omada.logmanager.domain.model.e.g)object);
    }

    protected /* synthetic */ u getStrategy() {
        return this.a();
    }

    public /* synthetic */ void handleEvent(Object object) {
        this.a((com.tplink.smb.omada.logmanager.port.commom.service.a.c)object);
    }
}

