/*
 * Decompiled with CFR 0.152.
 */
package com.tplink.smb.omada.logmanager.port.mongo.log.e;

import com.mongodb.bulk.BulkWriteResult;
import com.mongodb.client.MongoIterable;
import com.tplink.smb.eventcenter.api.event.DomainEventSubscriber;
import com.tplink.smb.eventcenter.domain.DomainEventBusHolder;
import com.tplink.smb.omada.common.gridquery.e;
import com.tplink.smb.omada.common.gridquery.g;
import com.tplink.smb.omada.common.mongo.repository.p;
import com.tplink.smb.omada.common.mongo.repository.q;
import com.tplink.smb.omada.common.mongo.repository.u;
import com.tplink.smb.omada.common.util.T;
import com.tplink.smb.omada.logmanager.api.internal.dto.LogClassifyInfoRequestDTO;
import com.tplink.smb.omada.logmanager.domain.model.log.AbstractOmadaLog;
import com.tplink.smb.omada.logmanager.domain.model.log.EventGroupDTO;
import com.tplink.smb.omada.logmanager.domain.model.log.LogClassifyInfoDTO;
import com.tplink.smb.omada.logmanager.domain.model.log.LogClassifyNumberQueryDTO;
import com.tplink.smb.omada.logmanager.domain.model.log.LogGroupDTO;
import com.tplink.smb.omada.logmanager.domain.model.log.LogGroupInfoDTO;
import com.tplink.smb.omada.logmanager.domain.model.log.s;
import com.tplink.smb.omada.logmanager.domain.model.log.subscriber.AlertNumClassifyInfoDTO;
import com.tplink.smb.omada.logmanager.domain.model.log.w;
import com.tplink.smb.omada.logmanager.port.mongo.a.a;
import com.tplink.smb.omada.logmanager.port.mongo.a.c;
import com.tplink.smb.omada.logmanager.port.mongo.a.d;
import com.tplink.smb.omada.logmanager.port.mongo.data.a.k;
import com.tplink.smb.omada.logmanager.port.mongo.log.AbstractOmadaEventPO;
import com.tplink.smb.omada.logmanager.port.mongo.log.OmadaEventSitePO;
import com.tplink.smb.omada.logmanager.port.mongo.log.i;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import jakarta.annotation.PostConstruct;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.LongSummaryStatistics;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.commons.collections4.CollectionUtils;
import org.bson.conversions.Bson;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.context.annotation.Lazy;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;
import org.springframework.data.mongodb.core.BulkOperations;
import org.springframework.data.mongodb.core.MongoTemplate;
import org.springframework.data.mongodb.core.aggregation.Aggregation;
import org.springframework.data.mongodb.core.aggregation.AggregationOperation;
import org.springframework.data.mongodb.core.index.IndexDefinition;
import org.springframework.data.mongodb.core.query.Criteria;
import org.springframework.data.mongodb.core.query.CriteriaDefinition;
import org.springframework.data.mongodb.core.query.Query;
import org.springframework.data.mongodb.core.query.Update;
import org.springframework.data.mongodb.core.query.UpdateDefinition;
import org.springframework.stereotype.Component;

@Component
public class b
extends q<OmadaEventSitePO, com.tplink.smb.omada.logmanager.domain.model.e.g>
implements DomainEventSubscriber<com.tplink.smb.omada.logmanager.port.commom.service.a.c>,
com.tplink.smb.omada.logmanager.domain.model.log.e.b {
    @Generated
    private static final Logger a = LoggerFactory.getLogger(b.class);
    @Autowired
    @Qualifier(value="dataMongoTemplate")
    private MongoTemplate mongoTemplate;
    @Autowired
    private com.tplink.smb.omada.logmanager.port.commom.c.b b;
    @Autowired
    @Lazy
    private k c;
    private static final String d = "delete-log-by-omadac-site";
    private static final String e = "delete-log-by-omadac";
    private static final String f = "count-by-omadac";
    private static final String g = "count-alert-by-omadac-keys";
    private static final String h = "count-alert-by-omadac-site-keys";
    private static final String i = "get-grid";
    private static final String j = "count-logs-by-level";
    private static final String k = "archive-all-alerts";
    private static final String l = "count-logs";
    private static final String m = "find-logs-time-content-with-page";
    private static final String n = "delete-log-omadac-less-time";
    private static final String o = "delete-logs";
    private static final String p = "delete-site-logs-by-type";
    private static final String q = "delete-global-logs-by-type";
    private static final String r = "get-classify-log-info";
    private static final String s = "get-log-num-by-level";
    private static final int t = 10000;
    private static final int u = 5000;

    public void a(List<w> omadaLogs) {
        if (CollectionUtils.isEmpty(omadaLogs)) {
            return;
        }
        Map<String, List<OmadaEventSitePO>> collectionNameToPOsMap = omadaLogs.stream().map(i::a).filter(omadaEventSitePO -> T.b((String)omadaEventSitePO.getSiteId())).collect(Collectors.groupingBy(x$0 -> this.getCollectionNameForSave(x$0)));
        collectionNameToPOsMap.forEach((collectionName, poList) -> {
            BulkOperations bulkOperations = this.mongoTemplate.bulkOps(BulkOperations.BulkMode.UNORDERED, collectionName);
            poList.forEach(omadaLogPO -> bulkOperations.insert(omadaLogPO));
            BulkWriteResult result = bulkOperations.execute();
            a.debug("Bulk write omada log result: {}", (Object)result);
        });
    }

    public Long a(com.tplink.smb.omada.logmanager.domain.model.e.g omadacId) {
        this.b.b(f);
        Query query = new Query((CriteriaDefinition)Criteria.where((String)"omadac_id").is((Object)omadacId.a()));
        AtomicLong total = new AtomicLong(0L);
        this.iteratorCollectionsBySliceKey(omadacId, collectionName -> total.addAndGet(this.mongoTemplate.count(query, collectionName)));
        return total.get();
    }

    public int a(com.tplink.smb.omada.logmanager.domain.model.e.g omadacId, Integer topNum) {
        AtomicInteger clearedNum = new AtomicInteger(0);
        this.iteratorCollectionsByTimeAsc(0L, System.currentTimeMillis(), collectionName -> {
            int loopCount = topNum / 10000;
            for (int i2 = 0; i2 <= loopCount; ++i2) {
                int removeLimit = Math.min(topNum - clearedNum.get(), 10000);
                if (clearedNum.get() >= topNum) {
                    return;
                }
                int removed = (int)this.mongoTemplate.remove(new Query((CriteriaDefinition)Criteria.where((String)"omadac_id").is((Object)omadacId.a())).with(Sort.by((Sort.Direction)Sort.Direction.ASC, (String[])new String[]{"time"})).limit(removeLimit), collectionName).getDeletedCount();
                clearedNum.addAndGet(removed);
            }
        });
        return clearedNum.get();
    }

    public com.tplink.smb.omada.common.gridquery.a<w> a(com.tplink.smb.omada.common.gridquery.a<w> grid, Boolean rootLag, String omadacId, String siteId) {
        this.b.b(i);
        long currentLogGet = System.currentTimeMillis();
        long currentCountTime = System.currentTimeMillis();
        long count = this.a(grid.getFilters(), grid.getSearchFilters(), rootLag, omadacId, siteId, ((e)grid.getQuerySorts().get(0)).a());
        a.trace("Log count time:{}(s)", (Object)((System.currentTimeMillis() - currentCountTime) / 1000L));
        grid.setTotalRows(count);
        if (count < 1L) {
            grid.setData(Collections.EMPTY_LIST);
            return grid;
        }
        grid.setData(this.a(grid.getQueryPage(), grid.getQuerySorts(), grid.getFilters(), grid.getSearchFilters(), rootLag, omadacId, siteId, count));
        a.trace("Get log total time:{}(s)", (Object)((System.currentTimeMillis() - currentLogGet) / 1000L));
        return grid;
    }

    public Long a(LogClassifyNumberQueryDTO logClassifyNumberQueryDTO, Boolean oldCompatible) {
        this.b.b(j);
        Query query = new Query();
        Criteria criteria = Criteria.where((String)"omadac_id").is((Object)logClassifyNumberQueryDTO.getOmadacId());
        Boolean alert = logClassifyNumberQueryDTO.getAlert();
        Boolean event = logClassifyNumberQueryDTO.getEvent();
        if (Boolean.TRUE.equals(alert)) {
            criteria.and("alert").is((Object)true);
        }
        if (Boolean.TRUE.equals(event)) {
            criteria.and("event").is((Object)true);
        }
        criteria.and("level").is((Object)logClassifyNumberQueryDTO.getLevel());
        Long startTime = logClassifyNumberQueryDTO.getStartTime();
        Long endTime = logClassifyNumberQueryDTO.getEndTime();
        criteria.and("time").gte((Object)startTime).lte((Object)endTime);
        if (Objects.nonNull(logClassifyNumberQueryDTO.getArchived())) {
            criteria.and("archived").is((Object)logClassifyNumberQueryDTO.getArchived());
        }
        if (!T.a((String)logClassifyNumberQueryDTO.getModule())) {
            criteria.and("module").is((Object)logClassifyNumberQueryDTO.getModule());
        }
        if (oldCompatible.booleanValue()) {
            ArrayList<String> sites = new ArrayList<String>(2);
            sites.add(logClassifyNumberQueryDTO.getSiteId());
            if (logClassifyNumberQueryDTO.getRootLag().booleanValue()) {
                sites.add(null);
                criteria.and("global").is((Object)Boolean.TRUE);
            } else {
                criteria.and("global").is((Object)Boolean.FALSE);
            }
            criteria.and("site_id").in(sites);
        } else {
            criteria.and("site_id").is((Object)logClassifyNumberQueryDTO.getSiteId());
        }
        if (!T.a((String)logClassifyNumberQueryDTO.getSearchKey())) {
            criteria.andOperator(new Criteria[]{com.tplink.smb.omada.logmanager.port.mongo.a.d.a(com.tplink.smb.omada.logmanager.port.mongo.a.d.b(logClassifyNumberQueryDTO.getSearchKey()))});
        }
        query.addCriteria((CriteriaDefinition)criteria);
        AtomicLong total = new AtomicLong(0L);
        this.iteratorCollectionsByTimeAndSliceKey(Sort.Direction.DESC, startTime / 1000L, endTime / 1000L, new com.tplink.smb.omada.logmanager.domain.model.e.g(logClassifyNumberQueryDTO.getOmadacId()), collectionName -> total.addAndGet(this.mongoTemplate.count(query, OmadaEventSitePO.class, collectionName)));
        return total.get();
    }

    public w a(String omadacId, String logId) {
        Query query = new Query();
        Criteria criteria = Criteria.where((String)"omadac_id").is((Object)omadacId);
        criteria.and("_id").is((Object)logId);
        query.addCriteria((CriteriaDefinition)criteria);
        ArrayList omadaLogPOS = new ArrayList();
        this.iteratorCollectionsBySliceKey(new com.tplink.smb.omada.logmanager.domain.model.e.g(omadacId), collectionName -> omadaLogPOS.addAll(this.mongoTemplate.find(query, OmadaEventSitePO.class, collectionName)));
        if (CollectionUtils.isEmpty(omadaLogPOS) || omadaLogPOS.size() > 1) {
            return null;
        }
        return com.tplink.smb.omada.logmanager.port.mongo.log.i.a((OmadaEventSitePO)omadaLogPOS.get(0));
    }

    public void a(w omadaLog) {
    }

    public void b(w omadaLog) {
        if (Objects.isNull(omadaLog.getId()) || T.a((String)omadaLog.getId().a())) {
            a.warn("Failed to archived site omada log:{}", (Object)omadaLog.toString());
            return;
        }
        String collectionName = this.getCollectionNameForSave(com.tplink.smb.omada.logmanager.port.mongo.log.i.a(omadaLog));
        this.iteratorCollectionsBySliceKey(omadaLog.getOmadacId(), logPo -> this.mongoTemplate.updateFirst(new Query((CriteriaDefinition)Criteria.where((String)"_id").is((Object)omadaLog.getId().a())), (UpdateDefinition)Update.update((String)"archived", (Object)true), OmadaEventSitePO.class, collectionName));
    }

    public void a(String omadacId, String site, Boolean deleteAlert, Long startTime, Long endTime) {
        Query query = new Query();
        query.addCriteria((CriteriaDefinition)Criteria.where((String)"site_id").is((Object)site));
        query.addCriteria((CriteriaDefinition)Criteria.where((String)"global").is((Object)Boolean.FALSE));
        this.a(query, omadacId, deleteAlert, startTime, endTime);
    }

    public void a(String omadacId, Boolean deleteAlert, Long startTime, Long endTime) {
        Query query = new Query();
        query.addCriteria((CriteriaDefinition)Criteria.where((String)"site_id").is(null));
        query.addCriteria((CriteriaDefinition)Criteria.where((String)"global").is((Object)Boolean.TRUE));
        this.a(query, omadacId, deleteAlert, startTime, endTime);
    }

    private void a(Query query, String omadacId, Boolean deleteAlert, Long startTime, Long endTime) {
        query.addCriteria((CriteriaDefinition)Criteria.where((String)"omadac_id").is((Object)omadacId));
        if (deleteAlert.booleanValue()) {
            query.addCriteria((CriteriaDefinition)Criteria.where((String)"alert").is((Object)true));
        } else {
            query.addCriteria((CriteriaDefinition)Criteria.where((String)"event").is((Object)true));
        }
        query.addCriteria((CriteriaDefinition)Criteria.where((String)"time").gte((Object)startTime).lte((Object)endTime));
        this.iteratorCollectionsByTimeAndSliceKey(Sort.Direction.DESC, startTime / 1000L, endTime / 1000L, new com.tplink.smb.omada.logmanager.domain.model.e.g(omadacId), collectionName -> this.mongoTemplate.remove(query, OmadaEventSitePO.class, collectionName));
    }

    public long a(String omadacId, String site, Boolean rootLag) {
        HashSet<String> siteIdQuery = new HashSet<String>(2);
        siteIdQuery.add(site);
        if (rootLag.booleanValue()) {
            siteIdQuery.add(null);
        }
        Query query = new Query();
        query.addCriteria((CriteriaDefinition)Criteria.where((String)"event").is((Object)true));
        query.addCriteria((CriteriaDefinition)Criteria.where((String)"omadac_id").is((Object)omadacId));
        query.addCriteria((CriteriaDefinition)Criteria.where((String)"site_id").in(siteIdQuery));
        this.iteratorCollectionsBySliceKey(new com.tplink.smb.omada.logmanager.domain.model.e.g(omadacId), collectionName -> this.mongoTemplate.remove(query, OmadaEventSitePO.class, collectionName));
        return 0L;
    }

    public long a(List<com.tplink.smb.omada.common.gridquery.c> filters, List<com.tplink.smb.omada.common.gridquery.c> searchFilters, Boolean rootLag, String omadacId, String siteKey, g direction) {
        this.b.b(l);
        if (Objects.isNull(filters)) {
            filters = new ArrayList<com.tplink.smb.omada.common.gridquery.c>();
        }
        Long[] times = com.tplink.smb.omada.logmanager.port.mongo.a.d.a(filters);
        Query query = this.a(filters, searchFilters, (boolean)rootLag, omadacId, siteKey);
        AtomicLong total = new AtomicLong(0L);
        this.iteratorCollectionsByTimeAndSliceKey(direction.a().equals("asc") ? Sort.Direction.ASC : Sort.Direction.DESC, times[0], times[1], new com.tplink.smb.omada.logmanager.domain.model.e.g(omadacId), collectionName -> total.addAndGet(this.mongoTemplate.count(query, OmadaEventSitePO.class, collectionName)));
        return total.get();
    }

    public Map<String, Long> a(String omadacId, List<String> siteIds) {
        Criteria criteria = Criteria.where((String)"omadac_id").is((Object)omadacId);
        criteria.and("site_id").in(siteIds);
        Aggregation aggregation = Aggregation.newAggregation((AggregationOperation[])new AggregationOperation[]{Aggregation.match((Criteria)criteria), Aggregation.group((String[])new String[]{"site_id"}).count().as("countNumber")});
        ArrayList numClassifyInfoDTOS = new ArrayList();
        this.iteratorCollectionsByTimeAndSliceKey(Sort.Direction.DESC, 0L, System.currentTimeMillis() / 1000L, new com.tplink.smb.omada.logmanager.domain.model.e.g(omadacId), collectionName -> numClassifyInfoDTOS.addAll(this.mongoTemplate.aggregate(aggregation, collectionName, LogClassifyInfoDTO.class).getMappedResults()));
        Map<String, LongSummaryStatistics> statisticsMap = numClassifyInfoDTOS.stream().collect(Collectors.groupingBy(LogClassifyInfoDTO::getId, Collectors.summarizingLong(LogClassifyInfoDTO::getCountNumber)));
        HashMap<String, Long> sitesLogNumMap = new HashMap<String, Long>(statisticsMap.size());
        for (Map.Entry<String, LongSummaryStatistics> entry : statisticsMap.entrySet()) {
            sitesLogNumMap.put(entry.getKey(), entry.getValue().getSum());
        }
        return sitesLogNumMap;
    }

    public List<w> a(Boolean globalLogExportPermission, String omadacId, String siteId, com.tplink.smb.omada.common.gridquery.d queryPage) {
        this.b.b(m);
        Query query = new Query();
        query.with((Pageable)PageRequest.of((int)queryPage.a(), (int)queryPage.b()));
        query.addCriteria((CriteriaDefinition)Criteria.where((String)"omadac_id").is((Object)omadacId));
        ArrayList<w> omadaLogs = new ArrayList<w>();
        if (globalLogExportPermission.booleanValue()) {
            query.addCriteria((CriteriaDefinition)Criteria.where((String)"site_id").is(null));
        } else {
            query.addCriteria((CriteriaDefinition)Criteria.where((String)"site_id").is((Object)siteId));
        }
        long endTime = System.currentTimeMillis() / 1000L;
        this.iteratorCollectionsByTimeAndSliceKeyWithSkip(Sort.Direction.DESC, 0L, endTime, new com.tplink.smb.omada.logmanager.domain.model.e.g(omadacId), query, (collectionName, queryCollection) -> omadaLogs.addAll(this.mongoTemplate.find(queryCollection, OmadaEventSitePO.class, collectionName).stream().map(i::a).collect(Collectors.toList())));
        return omadaLogs;
    }

    public void a(String omadacId, String siteId, com.tplink.smb.omada.common.util.c.a<w> consumer) {
        Query query = new Query();
        query.addCriteria((CriteriaDefinition)Criteria.where((String)"omadac_id").is((Object)omadacId));
        query.addCriteria((CriteriaDefinition)Criteria.where((String)"site_id").is((Object)siteId));
        long endTime = System.currentTimeMillis() / 1000L;
        this.iteratorCollectionsByTimeAndSliceKey(Sort.Direction.DESC, 0L, endTime, new com.tplink.smb.omada.logmanager.domain.model.e.g(omadacId), collectionName -> {
            MongoIterable iterable = this.mongoTemplate.getCollection(collectionName).find((Bson)query.getQueryObject()).batchSize(1000).map(src -> (OmadaEventSitePO)this.mongoTemplate.getConverter().read(OmadaEventSitePO.class, src));
            iterable.forEach(po -> consumer.a((Object)com.tplink.smb.omada.logmanager.port.mongo.log.i.a(po)));
        });
    }

    public void a(String omadacId, String siteId, Long startTime, Long endTime, List<String> logKeys) {
        Query query = new Query();
        query.addCriteria((CriteriaDefinition)Criteria.where((String)"omadac_id").is((Object)omadacId));
        query.addCriteria((CriteriaDefinition)Criteria.where((String)"time").gte((Object)startTime).lte((Object)endTime));
        query.addCriteria((CriteriaDefinition)Criteria.where((String)"site_id").is((Object)siteId));
        query.addCriteria((CriteriaDefinition)Criteria.where((String)"key").in(logKeys));
        ArrayList<String> collectionNames = new ArrayList<String>();
        this.iteratorCollectionsByTimeAndSliceKey(Sort.Direction.ASC, startTime / 1000L, endTime / 1000L, new com.tplink.smb.omada.logmanager.domain.model.e.g(omadacId), collectionName -> collectionNames.add((String)collectionName));
        com.tplink.smb.omada.logmanager.port.mongo.a.c.a(collectionNames, "omadalog");
        for (String c2 : collectionNames) {
            this.mongoTemplate.remove(query, OmadaEventSitePO.class, c2);
            a.debug("Iterating collection(delete by type): {}", (Object)c2);
        }
    }

    public void a(String omadacId, Long startTime, Long endTime, List<String> logKeys) {
        this.a(omadacId, null, startTime, endTime, logKeys);
    }

    public List<w> a(com.tplink.smb.omada.common.gridquery.d page, List<e> sort, List<com.tplink.smb.omada.common.gridquery.c> filters, List<com.tplink.smb.omada.common.gridquery.c> searchFilters, boolean isRoot, String omadacId, String siteKey, long count) {
        if (Objects.isNull(filters)) {
            filters = new ArrayList<com.tplink.smb.omada.common.gridquery.c>();
        }
        Long[] times = com.tplink.smb.omada.logmanager.port.mongo.a.d.a(filters);
        Query query = this.a(filters, searchFilters, isRoot, omadacId, siteKey);
        boolean reverse = this.a(page, query, sort, Sort.Direction.fromString((String)sort.get(0).a().a()), count);
        Sort.Direction direction = sort.get(0).a().a().equals("asc") ? Sort.Direction.ASC : Sort.Direction.DESC;
        com.tplink.smb.omada.logmanager.port.mongo.a.a.a(query, sort);
        ArrayList omadaLogPOS = new ArrayList();
        this.iteratorCollectionsByTimeAndSliceKeyWithSkip(direction, times[0], times[1], new com.tplink.smb.omada.logmanager.domain.model.e.g(omadacId), query, (collectionName, queryFilter) -> omadaLogPOS.addAll(this.mongoTemplate.find(queryFilter, OmadaEventSitePO.class, collectionName)));
        if (reverse) {
            return omadaLogPOS.stream().map(i::a).sorted(Comparator.comparing(AbstractOmadaLog::getTime).reversed()).collect(Collectors.toList());
        }
        return omadaLogPOS.stream().map(i::a).collect(Collectors.toList());
    }

    private boolean a(com.tplink.smb.omada.common.gridquery.d page, Query query, List<e> querySorts, Sort.Direction direction, long count) {
        int pageSize;
        if (Objects.isNull(page)) {
            return false;
        }
        int pageNum = page.a();
        if ((long)(pageNum * (pageSize = page.b()) * 2) < count) {
            query.limit(page.b()).skip((long)(page.a() * page.b()));
            return false;
        }
        int lastPageSize = (int)(count % (long)pageSize);
        int reversePageNum = (int)(count - (long)(pageNum * pageSize)) / pageSize;
        page.a(reversePageNum);
        if (lastPageSize > 0) {
            if (reversePageNum == 0) {
                query.limit(lastPageSize);
            } else {
                query.limit(page.b()).skip((long)(lastPageSize + (reversePageNum - 1) * page.b()));
            }
        } else {
            query.limit(page.b()).skip((long)(reversePageNum * page.b()));
        }
        if (!CollectionUtils.isEmpty(querySorts)) {
            for (e sort : querySorts) {
                if (direction.isAscending()) {
                    sort.a(com.tplink.smb.omada.common.gridquery.g.a);
                    continue;
                }
                sort.a(com.tplink.smb.omada.common.gridquery.g.b);
            }
        }
        return true;
    }

    public Query a(List<com.tplink.smb.omada.common.gridquery.c> filters, List<com.tplink.smb.omada.common.gridquery.c> searchFilters, boolean isRoot, String omadacId, String siteKey) {
        if (CollectionUtils.isEmpty(filters)) {
            filters = new ArrayList<com.tplink.smb.omada.common.gridquery.c>(4);
        }
        if (CollectionUtils.isEmpty(searchFilters)) {
            searchFilters = new ArrayList<com.tplink.smb.omada.common.gridquery.c>(4);
        }
        filters = com.tplink.smb.omada.logmanager.port.mongo.a.c.b(filters, searchFilters);
        Criteria criteria = com.tplink.smb.omada.logmanager.port.mongo.a.a.b(searchFilters, filters);
        criteria.and("omadac_id").is((Object)omadacId);
        if (isRoot && Objects.nonNull(siteKey)) {
            HashSet<String> siteIdQuery = new HashSet<String>(2);
            siteIdQuery.add(siteKey);
            siteIdQuery.add(null);
            criteria.and("site_id").in(siteIdQuery);
        } else {
            criteria.and("site_id").is((Object)siteKey);
        }
        return new Query((CriteriaDefinition)criteria);
    }

    public Criteria a(List<com.tplink.smb.omada.common.gridquery.c> filters, List<com.tplink.smb.omada.common.gridquery.c> searchFilters, String omadacId, String siteKey) {
        if (CollectionUtils.isEmpty(filters)) {
            filters = new ArrayList<com.tplink.smb.omada.common.gridquery.c>(4);
        }
        if (CollectionUtils.isEmpty(searchFilters)) {
            searchFilters = new ArrayList<com.tplink.smb.omada.common.gridquery.c>(4);
        }
        filters = com.tplink.smb.omada.logmanager.port.mongo.a.c.b(filters, searchFilters);
        Criteria criteria = com.tplink.smb.omada.logmanager.port.mongo.a.a.b(searchFilters, filters);
        criteria.and("omadac_id").is((Object)omadacId);
        criteria.and("site_id").is((Object)siteKey);
        return criteria;
    }

    public List<LogGroupInfoDTO> a(LogClassifyInfoRequestDTO logClassifyInfoRequestDTO, String ... groupKeys) {
        this.b.b(r);
        String omadacId = logClassifyInfoRequestDTO.getOmadacId();
        String siteId = logClassifyInfoRequestDTO.getSiteId();
        Long startTime = logClassifyInfoRequestDTO.getStartTime();
        Long endTime = logClassifyInfoRequestDTO.getEndTime();
        Criteria criteria = Criteria.where((String)"omadac_id").is((Object)omadacId);
        criteria.and("time").gte((Object)startTime).lte((Object)endTime);
        criteria.and("site_id").is((Object)siteId);
        if (Objects.nonNull(logClassifyInfoRequestDTO.getDeviceType()) && T.b((String)logClassifyInfoRequestDTO.getDeviceType().b())) {
            criteria.and("device_type").is((Object)logClassifyInfoRequestDTO.getDeviceType().c());
        }
        Aggregation aggregation = Aggregation.newAggregation((AggregationOperation[])new AggregationOperation[]{Aggregation.match((Criteria)criteria), Aggregation.group((String[])new String[]{"module"}).count().as("countNumber"), Aggregation.project((String[])new String[0]).and("_id").as("module").and("countNumber").as("countNumber")});
        ArrayList eventGroupResult = new ArrayList();
        this.iteratorCollectionsByTimeAndSliceKey(Sort.Direction.DESC, startTime / 1000L, endTime / 1000L, new com.tplink.smb.omada.logmanager.domain.model.e.g(omadacId), collectionName -> eventGroupResult.addAll(this.mongoTemplate.aggregate(aggregation, collectionName, EventGroupDTO.class).getMappedResults()));
        HashMap<String, Long> mergedResult = new HashMap<String, Long>();
        for (EventGroupDTO eventGroupDTO : eventGroupResult) {
            if (!eventGroupDTO.valid()) continue;
            String module = eventGroupDTO.getModule();
            Long count = eventGroupDTO.getCountNumber();
            Long oldCount = mergedResult.getOrDefault(module, 0L);
            mergedResult.put(module, count + oldCount);
        }
        ArrayList<LogGroupInfoDTO> logGroupList = new ArrayList<LogGroupInfoDTO>();
        for (Map.Entry entry : mergedResult.entrySet()) {
            LogGroupDTO logGroupDTO = new LogGroupDTO();
            logGroupDTO.setModule((String)entry.getKey());
            logGroupDTO.setLevel(com.tplink.smb.omada.logmanager.domain.model.log.s.c.a());
            logGroupList.add(LogGroupInfoDTO.builder().id(logGroupDTO).countNumber((Long)entry.getValue()).build());
        }
        return logGroupList;
    }

    public List<LogClassifyInfoDTO> a(LogClassifyNumberQueryDTO logClassifyNumberQueryDTO) {
        this.b.b(s);
        String omadacId = logClassifyNumberQueryDTO.getOmadacId();
        Criteria criteria = Criteria.where((String)"omadac_id").is((Object)omadacId);
        Boolean alert = logClassifyNumberQueryDTO.getAlert();
        Boolean event = logClassifyNumberQueryDTO.getEvent();
        if (Boolean.TRUE.equals(alert)) {
            criteria.and("alert").is((Object)true);
        }
        if (Boolean.TRUE.equals(event)) {
            criteria.and("event").is((Object)true);
        }
        long startTime = logClassifyNumberQueryDTO.getStartTime();
        long endTime = logClassifyNumberQueryDTO.getEndTime();
        criteria.and("time").gte((Object)startTime).lte((Object)endTime);
        if (Objects.nonNull(logClassifyNumberQueryDTO.getArchived())) {
            criteria.and("archived").is((Object)logClassifyNumberQueryDTO.getArchived());
        }
        if (!T.a((String)logClassifyNumberQueryDTO.getModule())) {
            criteria.and("module").is((Object)logClassifyNumberQueryDTO.getModule());
        }
        HashSet<String> siteIdQuery = new HashSet<String>(2);
        siteIdQuery.add(logClassifyNumberQueryDTO.getSiteId());
        if (logClassifyNumberQueryDTO.getRootLag().booleanValue()) {
            siteIdQuery.add(null);
        }
        criteria.and("site_id").in(siteIdQuery);
        if (!T.a((String)logClassifyNumberQueryDTO.getSearchKey())) {
            criteria.andOperator(new Criteria[]{com.tplink.smb.omada.logmanager.port.mongo.a.d.a(com.tplink.smb.omada.logmanager.port.mongo.a.d.b(logClassifyNumberQueryDTO.getSearchKey()))});
        }
        Aggregation aggregation = Aggregation.newAggregation((AggregationOperation[])new AggregationOperation[]{Aggregation.match((Criteria)criteria), Aggregation.group((String[])new String[]{logClassifyNumberQueryDTO.getGroupKey()}).count().as("countNumber")});
        ArrayList logGroupInfoDTOS = new ArrayList();
        this.iteratorCollectionsByTimeAndSliceKey(Sort.Direction.DESC, startTime / 1000L, endTime / 1000L, new com.tplink.smb.omada.logmanager.domain.model.e.g(omadacId), collectionName -> logGroupInfoDTOS.addAll(this.mongoTemplate.aggregate(aggregation, collectionName, LogClassifyInfoDTO.class).getMappedResults()));
        Map<String, LongSummaryStatistics> statisticsMap = logGroupInfoDTOS.stream().collect(Collectors.groupingBy(LogClassifyInfoDTO::getId, Collectors.summarizingLong(LogClassifyInfoDTO::getCountNumber)));
        ArrayList<LogClassifyInfoDTO> logGroupInfo = new ArrayList<LogClassifyInfoDTO>();
        for (Map.Entry<String, LongSummaryStatistics> entry : statisticsMap.entrySet()) {
            logGroupInfo.add(LogClassifyInfoDTO.builder().id(entry.getKey()).countNumber(Long.valueOf(entry.getValue().getSum())).build());
        }
        return logGroupInfo;
    }

    public Long a(String omadacId, String siteId, com.tplink.smb.omada.common.gridquery.a<w> grid, Long startTime, Long endTime) {
        grid.setFilters(com.tplink.smb.omada.logmanager.port.mongo.a.c.b(grid.getFilters()));
        grid.setFilters(com.tplink.smb.omada.logmanager.port.mongo.a.c.c(grid.getFilters()));
        Query query = this.a(grid.getFilters(), grid.getSearchFilters(), false, omadacId, siteId);
        AtomicLong count = new AtomicLong();
        this.iteratorCollectionsByTimeAndSliceKey(Sort.Direction.DESC, startTime / 1000L, endTime / 1000L, new com.tplink.smb.omada.logmanager.domain.model.e.g(omadacId), collectionName -> count.addAndGet(this.mongoTemplate.count(query, OmadaEventSitePO.class, collectionName)));
        return count.get();
    }

    public List<LogClassifyInfoDTO> b(String omadacId, String siteId, com.tplink.smb.omada.common.gridquery.a<w> grid, Long startTime, Long endTime) {
        this.b.b(s);
        grid.setFilters(com.tplink.smb.omada.logmanager.port.mongo.a.c.b(grid.getFilters()));
        grid.setFilters(com.tplink.smb.omada.logmanager.port.mongo.a.c.c(grid.getFilters()));
        Criteria criteria = this.a(grid.getFilters(), grid.getSearchFilters(), omadacId, siteId);
        return this.a(criteria, "module", omadacId, startTime, endTime);
    }

    public Long a(com.tplink.smb.omada.logmanager.domain.model.e.g omadacId, Long startTime, Long endTime) {
        Query query = new Query();
        Criteria criteria = Criteria.where((String)"omadac_id").is((Object)omadacId.a());
        criteria.and("time").gte((Object)startTime).lte((Object)endTime);
        criteria.and("archived").is((Object)Boolean.FALSE);
        criteria.and("global").is((Object)Boolean.FALSE);
        query.addCriteria((CriteriaDefinition)criteria);
        AtomicLong count = new AtomicLong();
        this.iteratorCollectionsByTimeAndSliceKey(Sort.Direction.DESC, startTime / 1000L, endTime / 1000L, omadacId, collectionName -> count.addAndGet(this.mongoTemplate.count(query, OmadaEventSitePO.class, collectionName)));
        return count.get();
    }

    public Map<String, Long> a(com.tplink.smb.omada.logmanager.domain.model.e.g omadacId, Set<String> sites, Long startTime, Long endTime) {
        Criteria criteria = Criteria.where((String)"omadac_id").is((Object)omadacId.a());
        criteria.and("site_id").in(sites);
        criteria.and("time").gte((Object)startTime).lte((Object)endTime);
        criteria.and("archived").is((Object)Boolean.FALSE);
        criteria.and("alert").is((Object)Boolean.TRUE);
        Aggregation aggregation = Aggregation.newAggregation((AggregationOperation[])new AggregationOperation[]{Aggregation.match((Criteria)criteria), Aggregation.group((String[])new String[]{"site_id"}).count().as("alertNumber")});
        ArrayList numClassifyInfoDTOS = new ArrayList();
        this.iteratorCollectionsByTimeAndSliceKey(Sort.Direction.DESC, startTime / 1000L, endTime / 1000L, omadacId, collectionName -> numClassifyInfoDTOS.addAll(this.mongoTemplate.aggregate(aggregation, collectionName, AlertNumClassifyInfoDTO.class).getMappedResults()));
        Map<String, LongSummaryStatistics> statisticsMap = numClassifyInfoDTOS.stream().collect(Collectors.groupingBy(AlertNumClassifyInfoDTO::getId, Collectors.summarizingLong(AlertNumClassifyInfoDTO::getAlertNumber)));
        HashMap<String, Long> sitesAlertNumMap = new HashMap<String, Long>(statisticsMap.size());
        for (Map.Entry<String, LongSummaryStatistics> entry : statisticsMap.entrySet()) {
            sitesAlertNumMap.put(entry.getKey(), entry.getValue().getSum());
        }
        return sitesAlertNumMap;
    }

    public Map<String, Long> a(Set<String> customers, Long startTime, Long endTime) {
        Criteria criteria = Criteria.where((String)"omadac_id").in(customers);
        criteria.and("time").gte((Object)startTime).lte((Object)endTime);
        criteria.and("archived").is((Object)Boolean.FALSE);
        criteria.and("alert").is((Object)Boolean.TRUE);
        Aggregation aggregation = Aggregation.newAggregation((AggregationOperation[])new AggregationOperation[]{Aggregation.match((Criteria)criteria), Aggregation.group((String[])new String[]{"omadac_id"}).count().as("alertNumber")});
        ArrayList numClassifyInfoDTOS = new ArrayList();
        this.iteratorCollectionsByTime(Sort.Direction.DESC, startTime / 1000L, endTime / 1000L, collectionName -> numClassifyInfoDTOS.addAll(this.mongoTemplate.aggregate(aggregation, collectionName, AlertNumClassifyInfoDTO.class).getMappedResults()));
        Map<String, LongSummaryStatistics> statisticsMap = numClassifyInfoDTOS.stream().collect(Collectors.groupingBy(AlertNumClassifyInfoDTO::getId, Collectors.summarizingLong(AlertNumClassifyInfoDTO::getAlertNumber)));
        HashMap<String, Long> customersAlertNumMap = new HashMap<String, Long>(statisticsMap.size());
        for (Map.Entry<String, LongSummaryStatistics> entry : statisticsMap.entrySet()) {
            customersAlertNumMap.put(entry.getKey(), entry.getValue().getSum());
        }
        return customersAlertNumMap;
    }

    public List<String> a(String omadacId, Long startTime, Long endTime, g direction) {
        ArrayList<String> collectionNames = new ArrayList<String>();
        this.iteratorCollectionsByTimeAndSliceKey(com.tplink.smb.omada.common.gridquery.g.a.equals((Object)direction) ? Sort.Direction.DESC : Sort.Direction.ASC, startTime, endTime, new com.tplink.smb.omada.logmanager.domain.model.e.g(omadacId), collectionName -> collectionNames.add((String)collectionName));
        return collectionNames;
    }

    public int a(com.tplink.smb.omada.logmanager.domain.model.e.g omadacId, String siteId, List<String> ids, Long startTime, Long endTime) {
        Query query = new Query();
        query.addCriteria((CriteriaDefinition)Criteria.where((String)"site_id").is((Object)siteId));
        return this.a(omadacId, ids, startTime, endTime, query);
    }

    public void a(com.tplink.smb.omada.logmanager.domain.model.e.g omadacId, String siteId, com.tplink.smb.omada.common.gridquery.a<w> grid, List<String> ids, Long startTime, Long endTime) {
        ArrayList<w> omadaLogs = new ArrayList<w>();
        if (!CollectionUtils.isEmpty(ids)) {
            Criteria criteria = Criteria.where((String)"_id").in(ids).and("omadac_id").is((Object)omadacId.a()).and("site_id").is((Object)siteId);
            Query idQuery = new Query((CriteriaDefinition)criteria);
            this.iteratorCollectionsByTimeAndSliceKey(Sort.Direction.DESC, startTime / 1000L, endTime / 1000L, omadacId, collectionName -> omadaLogs.addAll(this.mongoTemplate.find(idQuery, OmadaEventSitePO.class, collectionName).stream().map(i::a).collect(Collectors.toList())));
        }
        for (w omadalog : omadaLogs) {
            ids.remove(omadalog.getId().a());
        }
        grid.setFilters(com.tplink.smb.omada.logmanager.port.mongo.a.c.a(grid.getFilters()));
        Query query = this.a(grid.getFilters(), grid.getSearchFilters(), false, omadacId.a(), siteId);
        query.addCriteria((CriteriaDefinition)Criteria.where((String)"time").gte((Object)startTime).lte((Object)endTime));
        query.fields().include("_id");
        query.limit(5000).with(Sort.by((Sort.Direction)Sort.Direction.ASC, (String[])new String[]{"_id"}));
        long debugStartTime = System.currentTimeMillis();
        this.iteratorCollectionsByTimeAndSliceKey(Sort.Direction.DESC, startTime / 1000L, endTime / 1000L, omadacId, collectionName -> {
            List listRemove = this.mongoTemplate.find(query, OmadaEventSitePO.class, collectionName);
            while (!CollectionUtils.isEmpty((Collection)listRemove)) {
                this.mongoTemplate.remove(Query.query((CriteriaDefinition)Criteria.where((String)"_id").in(listRemove.stream().map(AbstractOmadaEventPO::getId).toList())), collectionName);
                try {
                    Thread.sleep(100L);
                }
                catch (InterruptedException e2) {
                    a.error("InterruptedException while sleeping,e=", (Throwable)e2);
                    Thread.currentThread().interrupt();
                }
                listRemove = this.mongoTemplate.find(query, OmadaEventSitePO.class, collectionName);
            }
        });
        long cost = System.currentTimeMillis() - debugStartTime;
        a.debug("deleteAllLogsForSite remove cost={} ,omadacId={} , siteId ={}", new Object[]{cost, omadacId, siteId});
        if (!CollectionUtils.isEmpty(omadaLogs)) {
            this.a(omadaLogs);
        }
    }

    public int a(com.tplink.smb.omada.logmanager.domain.model.e.g omadacId, List<String> ids, Long startTime, Long endTime) {
        Query query = new Query();
        query.addCriteria((CriteriaDefinition)Criteria.where((String)"site_id").is(null));
        return this.a(omadacId, ids, startTime, endTime, query);
    }

    private int a(com.tplink.smb.omada.logmanager.domain.model.e.g omadacId, List<String> ids, Long startTime, Long endTime, Query query) {
        AtomicInteger clearedNum = new AtomicInteger(0);
        int topNum = ids.size();
        query.addCriteria((CriteriaDefinition)Criteria.where((String)"omadac_id").is((Object)omadacId.a()));
        query.addCriteria((CriteriaDefinition)Criteria.where((String)"_id").in(ids));
        this.iteratorCollectionsByTimeAndSliceKey(Sort.Direction.DESC, startTime / 1000L, endTime / 1000L, omadacId, collectionName -> {
            if (clearedNum.get() >= topNum) {
                return;
            }
            int removed = (int)this.mongoTemplate.remove(query, collectionName).getDeletedCount();
            clearedNum.addAndGet(removed);
        });
        return clearedNum.get();
    }

    private void b(com.tplink.smb.omada.logmanager.domain.model.e.g omadacId, List<String> ids, Long startTime, Long endTime, Query query) {
        query.addCriteria((CriteriaDefinition)Criteria.where((String)"omadac_id").is((Object)omadacId.a()));
        query.addCriteria((CriteriaDefinition)Criteria.where((String)"_id").in(ids));
        Update update = new Update();
        update.set("archived", (Object)true);
        this.iteratorCollectionsByTimeAndSliceKey(Sort.Direction.DESC, startTime / 1000L, endTime / 1000L, omadacId, collectionName -> this.mongoTemplate.updateMulti(query, (UpdateDefinition)update, OmadaEventSitePO.class, collectionName));
    }

    public Long a(String omadacId, String siteId, String collectionName, com.tplink.smb.omada.common.gridquery.a grid) {
        return this.mongoTemplate.count(this.a(grid.getFilters(), grid.getSearchFilters(), (boolean)Boolean.FALSE, omadacId, siteId), OmadaEventSitePO.class, collectionName);
    }

    public List<w> a(String omadacId, String siteId, String collectionName, com.tplink.smb.omada.common.gridquery.a grid, Long skip, Integer limit) {
        Query query = this.a(grid.getFilters(), grid.getSearchFilters(), (boolean)Boolean.FALSE, omadacId, siteId);
        com.tplink.smb.omada.logmanager.port.mongo.a.a.a(query, grid.getQuerySorts());
        query.skip(skip.longValue());
        query.limit(limit.intValue());
        return this.mongoTemplate.find(query, OmadaEventSitePO.class, collectionName).stream().map(i::a).collect(Collectors.toList());
    }

    public void b(com.tplink.smb.omada.logmanager.domain.model.e.g omadacId) {
        this.iteratorCollectionsBySliceKey(omadacId, collectionName -> this.mongoTemplate.dropCollection(collectionName));
    }

    private List<LogClassifyInfoDTO> a(Criteria criteria, String groupKey, String omadacId, Long startTime, Long endTime) {
        Aggregation aggregation = Aggregation.newAggregation((AggregationOperation[])new AggregationOperation[]{Aggregation.match((Criteria)criteria), Aggregation.group((String[])new String[]{groupKey}).count().as("countNumber")});
        ArrayList logGroupInfoDTOS = new ArrayList();
        this.iteratorCollectionsByTimeAndSliceKey(Sort.Direction.DESC, startTime / 1000L, endTime / 1000L, new com.tplink.smb.omada.logmanager.domain.model.e.g(omadacId), collectionName -> logGroupInfoDTOS.addAll(this.mongoTemplate.aggregate(aggregation, collectionName, LogClassifyInfoDTO.class).getMappedResults()));
        Map<String, LongSummaryStatistics> statisticsMap = logGroupInfoDTOS.stream().collect(Collectors.groupingBy(LogClassifyInfoDTO::getId, Collectors.summarizingLong(LogClassifyInfoDTO::getCountNumber)));
        ArrayList<LogClassifyInfoDTO> logGroupInfo = new ArrayList<LogClassifyInfoDTO>();
        for (Map.Entry<String, LongSummaryStatistics> entry : statisticsMap.entrySet()) {
            logGroupInfo.add(LogClassifyInfoDTO.builder().id(entry.getKey()).countNumber(Long.valueOf(entry.getValue().getSum())).build());
        }
        return logGroupInfo;
    }

    protected int c(@Nullable com.tplink.smb.omada.logmanager.domain.model.e.g key) {
        if (Objects.isNull(key)) {
            return 0;
        }
        return key.a().hashCode();
    }

    protected k a() {
        return this.c;
    }

    protected Class getPOClass() {
        return OmadaEventSitePO.class;
    }

    protected MongoTemplate getMongoTemplate() {
        return this.mongoTemplate;
    }

    @Nonnull
    protected String getCollectionNameOrPrefixIfSliced() {
        return "siteomadaevent";
    }

    @Nonnull
    protected IndexDefinition[] getIndexDefinitions() {
        return OmadaEventSitePO.INDEX_DEFINITIONS;
    }

    public void a(com.tplink.smb.omada.logmanager.port.commom.service.a.c event) {
        this.dbMaintenance(event.a());
    }

    @PostConstruct
    public void b() {
        DomainEventBusHolder.getHandlerRegistry().registerSync(com.tplink.smb.omada.logmanager.port.commom.service.a.c.class, (DomainEventSubscriber)this);
    }

    protected /* synthetic */ p getStrategy() {
        return this.a();
    }

    protected /* synthetic */ int hashCodeOfKey(@Nullable Object object) {
        return this.c((com.tplink.smb.omada.logmanager.domain.model.e.g)object);
    }

    protected /* synthetic */ u getStrategy() {
        return this.a();
    }

    public /* synthetic */ void handleEvent(Object object) {
        this.a((com.tplink.smb.omada.logmanager.port.commom.service.a.c)object);
    }
}

