/*
 * Decompiled with CFR 0.152.
 */
package com.tplink.smb.omada.logmanager.port.mongo.log.e;

import com.mongodb.bulk.BulkWriteResult;
import com.mongodb.client.MongoIterable;
import com.tplink.nbu.common.utils.CollectionUtil;
import com.tplink.smb.eventcenter.api.event.DomainEventSubscriber;
import com.tplink.smb.eventcenter.domain.DomainEventBusHolder;
import com.tplink.smb.omada.common.gridquery.e;
import com.tplink.smb.omada.common.gridquery.g;
import com.tplink.smb.omada.common.mongo.repository.p;
import com.tplink.smb.omada.common.mongo.repository.q;
import com.tplink.smb.omada.common.mongo.repository.u;
import com.tplink.smb.omada.common.util.T;
import com.tplink.smb.omada.logmanager.api.external.dto.AlertResolveDTO;
import com.tplink.smb.omada.logmanager.api.external.dto.ArchiveDTO;
import com.tplink.smb.omada.logmanager.api.internal.dto.LogClassifyInfoRequestDTO;
import com.tplink.smb.omada.logmanager.domain.model.e.i;
import com.tplink.smb.omada.logmanager.domain.model.log.AbstractOmadaLog;
import com.tplink.smb.omada.logmanager.domain.model.log.AlertNumTrendDTO;
import com.tplink.smb.omada.logmanager.domain.model.log.LogClassifyInfoDTO;
import com.tplink.smb.omada.logmanager.domain.model.log.LogClassifyNumberQueryDTO;
import com.tplink.smb.omada.logmanager.domain.model.log.LogGroupDTO;
import com.tplink.smb.omada.logmanager.domain.model.log.LogGroupInfoDTO;
import com.tplink.smb.omada.logmanager.domain.model.log.subscriber.AlertNumClassifyInfoDTO;
import com.tplink.smb.omada.logmanager.domain.model.log.w;
import com.tplink.smb.omada.logmanager.port.commom.c.b;
import com.tplink.smb.omada.logmanager.port.mongo.a.c;
import com.tplink.smb.omada.logmanager.port.mongo.a.d;
import com.tplink.smb.omada.logmanager.port.mongo.log.OmadaAlertSitePO;
import com.tplink.smb.omada.logmanager.port.mongo.log.h;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import jakarta.annotation.PostConstruct;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.LongSummaryStatistics;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import java.util.stream.Collectors;
import lombok.Generated;
import org.bson.conversions.Bson;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.context.annotation.Lazy;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;
import org.springframework.data.mongodb.core.BulkOperations;
import org.springframework.data.mongodb.core.MongoTemplate;
import org.springframework.data.mongodb.core.aggregation.Aggregation;
import org.springframework.data.mongodb.core.aggregation.AggregationOperation;
import org.springframework.data.mongodb.core.index.IndexDefinition;
import org.springframework.data.mongodb.core.query.Criteria;
import org.springframework.data.mongodb.core.query.CriteriaDefinition;
import org.springframework.data.mongodb.core.query.Query;
import org.springframework.data.mongodb.core.query.Update;
import org.springframework.data.mongodb.core.query.UpdateDefinition;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;

@Component
public class a
extends q<OmadaAlertSitePO, com.tplink.smb.omada.logmanager.domain.model.e.g>
implements DomainEventSubscriber<com.tplink.smb.omada.logmanager.port.commom.service.a.c>,
com.tplink.smb.omada.logmanager.domain.model.log.e.a {
    @Generated
    private static final Logger a = LoggerFactory.getLogger(a.class);
    @Autowired
    @Qualifier(value="dataMongoTemplate")
    private MongoTemplate mongoTemplate;
    @Autowired
    private b b;
    @Autowired
    @Lazy
    private com.tplink.smb.omada.logmanager.port.mongo.data.a.h c;
    private static final String d = "delete-log-by-omadac-site";
    private static final String e = "delete-log-by-omadac";
    private static final String f = "count-by-omadac";
    private static final String g = "count-alert-by-omadac-keys";
    private static final String h = "count-alert-by-omadac-site-keys";
    private static final String i = "get-grid";
    private static final String j = "count-logs-by-level";
    private static final String k = "archive-all-alerts";
    private static final String l = "count-logs";
    private static final String m = "find-logs-time-content-with-page";
    private static final String n = "delete-log-omadac-less-time";
    private static final String o = "delete-logs";
    private static final String p = "delete-site-logs-by-type";
    private static final String q = "delete-global-logs-by-type";
    private static final String r = "get-classify-log-info";
    private static final String s = "get-log-num-by-level";
    private static final int t = 10000;

    public void a(List<w> omadaLogs) {
        if (CollectionUtils.isEmpty(omadaLogs)) {
            return;
        }
        Map<String, List<OmadaAlertSitePO>> collectionNameToPOsMap = omadaLogs.stream().map(h::a).filter(omadaEventSitePO -> T.b((String)omadaEventSitePO.getSiteId())).collect(Collectors.groupingBy(x$0 -> this.getCollectionNameForSave(x$0)));
        collectionNameToPOsMap.forEach((collectionName, poList) -> {
            BulkOperations bulkOperations = this.mongoTemplate.bulkOps(BulkOperations.BulkMode.UNORDERED, collectionName);
            poList.forEach(omadaLogPO -> bulkOperations.insert(omadaLogPO));
            BulkWriteResult result = bulkOperations.execute();
            a.debug("Bulk write omada log result: {}", (Object)result);
        });
    }

    public Long a(com.tplink.smb.omada.logmanager.domain.model.e.g omadacId) {
        this.b.b(f);
        Query query = new Query((CriteriaDefinition)Criteria.where((String)"omadac_id").is((Object)omadacId.a()));
        AtomicLong total = new AtomicLong(0L);
        this.iteratorCollectionsBySliceKey(omadacId, collectionName -> total.addAndGet(this.mongoTemplate.count(query, collectionName)));
        return total.get();
    }

    public int a(com.tplink.smb.omada.logmanager.domain.model.e.g omadacId, Integer topNum) {
        AtomicInteger clearedNum = new AtomicInteger(0);
        this.iteratorCollectionsByTimeAsc(0L, System.currentTimeMillis(), collectionName -> {
            int loopCount = topNum / 10000;
            for (int i2 = 0; i2 <= loopCount; ++i2) {
                int removeLimit = Math.min(topNum - clearedNum.get(), 10000);
                if (clearedNum.get() >= topNum) {
                    return;
                }
                int removed = (int)this.mongoTemplate.remove(new Query((CriteriaDefinition)Criteria.where((String)"omadac_id").is((Object)omadacId.a())).with(Sort.by((Sort.Direction)Sort.Direction.ASC, (String[])new String[]{"time"})).limit(removeLimit), collectionName).getDeletedCount();
                clearedNum.addAndGet(removed);
            }
        });
        return clearedNum.get();
    }

    public long a(com.tplink.smb.omada.logmanager.domain.model.e.g omadacId, Long startTime, Long endTime) {
        this.b.b(g);
        Query query = new Query();
        Criteria criteria = Criteria.where((String)"omadac_id").is((Object)omadacId.a());
        criteria.and("site_id").is(null);
        criteria.and("global").is((Object)Boolean.TRUE);
        criteria.and("alert").is((Object)Boolean.TRUE);
        criteria.and("archived").is((Object)Boolean.FALSE);
        criteria.and("time").gte((Object)startTime).lte((Object)endTime);
        query.addCriteria((CriteriaDefinition)criteria);
        AtomicLong total = new AtomicLong(0L);
        this.iteratorCollectionsByTimeAndSliceKey(Sort.Direction.DESC, startTime / 1000L, endTime / 1000L, omadacId, collectionName -> total.addAndGet(this.mongoTemplate.count(query, collectionName)));
        return total.get();
    }

    public long a(com.tplink.smb.omada.logmanager.domain.model.e.g omadacId, i siteId, Long startTime, Long endTime) {
        this.b.b(h);
        Query query = new Query();
        Criteria criteria = Criteria.where((String)"omadac_id").is((Object)omadacId.a());
        criteria.and("site_id").is((Object)siteId.a());
        criteria.and("resolved").is((Object)Boolean.FALSE);
        criteria.and("time").gte((Object)startTime).lte((Object)endTime);
        query.addCriteria((CriteriaDefinition)criteria);
        AtomicLong total = new AtomicLong(0L);
        this.iteratorCollectionsByTimeAndSliceKey(Sort.Direction.DESC, startTime / 1000L, endTime / 1000L, omadacId, collectionName -> total.addAndGet(this.mongoTemplate.count(query, collectionName)));
        return total.get();
    }

    public com.tplink.smb.omada.common.gridquery.a<w> a(com.tplink.smb.omada.common.gridquery.a<w> grid, Boolean rootLag, String omadacId, String siteId) {
        this.b.b(i);
        long currentLogGet = System.currentTimeMillis();
        long currentCountTime = System.currentTimeMillis();
        long count = this.a(grid.getFilters(), grid.getSearchFilters(), rootLag, omadacId, siteId, ((e)grid.getQuerySorts().get(0)).a());
        a.trace("Log count time:{}(s)", (Object)((System.currentTimeMillis() - currentCountTime) / 1000L));
        grid.setTotalRows(count);
        if (count < 1L) {
            grid.setData(Collections.EMPTY_LIST);
            return grid;
        }
        grid.setData(this.a(grid.getQueryPage(), grid.getQuerySorts(), grid.getFilters(), grid.getSearchFilters(), rootLag, omadacId, siteId, count));
        a.trace("Get log total time:{}(s)", (Object)((System.currentTimeMillis() - currentLogGet) / 1000L));
        return grid;
    }

    public Long a(LogClassifyNumberQueryDTO logClassifyNumberQueryDTO, Boolean oldCompatible) {
        this.b.b(j);
        Query query = new Query();
        Criteria criteria = Criteria.where((String)"omadac_id").is((Object)logClassifyNumberQueryDTO.getOmadacId());
        Boolean alert = logClassifyNumberQueryDTO.getAlert();
        Boolean event = logClassifyNumberQueryDTO.getEvent();
        if (Boolean.TRUE.equals(alert)) {
            criteria.and("alert").is((Object)true);
        }
        if (Boolean.TRUE.equals(event)) {
            criteria.and("event").is((Object)true);
        }
        criteria.and("level").is((Object)logClassifyNumberQueryDTO.getLevel());
        Long startTime = logClassifyNumberQueryDTO.getStartTime();
        Long endTime = logClassifyNumberQueryDTO.getEndTime();
        criteria.and("time").gte((Object)startTime).lte((Object)endTime);
        if (Objects.nonNull(logClassifyNumberQueryDTO.getArchived())) {
            criteria.and("archived").is((Object)logClassifyNumberQueryDTO.getArchived());
        }
        if (!T.a((String)logClassifyNumberQueryDTO.getModule())) {
            criteria.and("module").is((Object)logClassifyNumberQueryDTO.getModule());
        }
        if (oldCompatible.booleanValue()) {
            ArrayList<String> sites = new ArrayList<String>(2);
            sites.add(logClassifyNumberQueryDTO.getSiteId());
            if (logClassifyNumberQueryDTO.getRootLag().booleanValue()) {
                sites.add(null);
                criteria.and("global").is((Object)Boolean.TRUE);
            } else {
                criteria.and("global").is((Object)Boolean.FALSE);
            }
            criteria.and("site_id").in(sites);
        } else {
            criteria.and("site_id").is((Object)logClassifyNumberQueryDTO.getSiteId());
        }
        if (!T.a((String)logClassifyNumberQueryDTO.getSearchKey())) {
            criteria.andOperator(new Criteria[]{com.tplink.smb.omada.logmanager.port.mongo.a.d.a(com.tplink.smb.omada.logmanager.port.mongo.a.d.b(logClassifyNumberQueryDTO.getSearchKey()))});
        }
        query.addCriteria((CriteriaDefinition)criteria);
        AtomicLong total = new AtomicLong(0L);
        this.iteratorCollectionsByTimeAndSliceKey(Sort.Direction.DESC, startTime / 1000L, endTime / 1000L, new com.tplink.smb.omada.logmanager.domain.model.e.g(logClassifyNumberQueryDTO.getOmadacId()), collectionName -> total.addAndGet(this.mongoTemplate.count(query, OmadaAlertSitePO.class, collectionName)));
        return total.get();
    }

    public w a(String omadacId, String logId) {
        Query query = new Query();
        Criteria criteria = Criteria.where((String)"omadac_id").is((Object)omadacId);
        criteria.and("_id").is((Object)logId);
        query.addCriteria((CriteriaDefinition)criteria);
        ArrayList omadaLogPOS = new ArrayList();
        this.iteratorCollectionsBySliceKey(new com.tplink.smb.omada.logmanager.domain.model.e.g(omadacId), collectionName -> omadaLogPOS.addAll(this.mongoTemplate.find(query, OmadaAlertSitePO.class, collectionName)));
        if (CollectionUtils.isEmpty(omadaLogPOS) || omadaLogPOS.size() > 1) {
            return null;
        }
        return com.tplink.smb.omada.logmanager.port.mongo.log.h.a((OmadaAlertSitePO)omadaLogPOS.get(0));
    }

    public void a(w omadaLog) {
    }

    public Boolean b(w omadaLog) {
        if (Objects.isNull(omadaLog.getId()) || T.a((String)omadaLog.getId().a())) {
            a.warn("Failed to resolve site omada log:{}", (Object)omadaLog.toString());
            return Boolean.FALSE;
        }
        String collectionName = this.getCollectionNameForSave(com.tplink.smb.omada.logmanager.port.mongo.log.h.a(omadaLog));
        if (CollectionUtil.isEmpty((Collection)this.mongoTemplate.find(Query.query((CriteriaDefinition)Criteria.where((String)"_id").is((Object)omadaLog.getId().a())), OmadaAlertSitePO.class, collectionName))) {
            return Boolean.FALSE;
        }
        this.iteratorCollectionsBySliceKey(omadaLog.getOmadacId(), logPo -> this.mongoTemplate.updateFirst(new Query((CriteriaDefinition)Criteria.where((String)"_id").is((Object)omadaLog.getId().a())), (UpdateDefinition)Update.update((String)"resolved", (Object)true).set("resolve_time", (Object)omadaLog.v().getTime()).set("resolve_type", (Object)omadaLog.y()), OmadaAlertSitePO.class, collectionName));
        this.b.f(omadaLog.a(omadaLog.getOmadaLogEnum(), omadaLog.i()));
        return Boolean.TRUE;
    }

    public void a(String omadacId, String siteId, Boolean rootLag, ArchiveDTO archiveDTO, com.tplink.smb.omada.common.gridquery.a<w> grid) {
        this.b.b(k);
        grid.setFilters(com.tplink.smb.omada.logmanager.port.mongo.a.c.a(grid.getFilters()));
        Query query = this.a(grid.getFilters(), grid.getSearchFilters(), (boolean)rootLag, omadacId, siteId);
        Long startTime = archiveDTO.getTimeStart() / 1000L;
        Long endTime = archiveDTO.getTimeEnd() / 1000L;
        query.addCriteria((CriteriaDefinition)Criteria.where((String)"time").gte((Object)archiveDTO.getTimeStart()).lte((Object)archiveDTO.getTimeEnd()));
        this.iteratorCollectionsByTimeAndSliceKey(Sort.Direction.DESC, startTime, endTime, new com.tplink.smb.omada.logmanager.domain.model.e.g(omadacId), collectionName -> this.mongoTemplate.updateMulti(query, (UpdateDefinition)Update.update((String)"resolved", (Object)true).set("resolve_time", (Object)System.currentTimeMillis()).set("resolve_type", (Object)0), OmadaAlertSitePO.class, collectionName));
        if (!CollectionUtils.isEmpty((Collection)archiveDTO.getLogs())) {
            Criteria criteria = Criteria.where((String)"_id").in((Collection)archiveDTO.getLogs()).and("omadac_id").is((Object)omadacId).and("site_id").is((Object)siteId);
            Query idQuery = new Query((CriteriaDefinition)criteria);
            this.iteratorCollectionsByTimeAndSliceKey(Sort.Direction.DESC, startTime, endTime, new com.tplink.smb.omada.logmanager.domain.model.e.g(omadacId), collectionName -> this.mongoTemplate.updateMulti(idQuery, (UpdateDefinition)Update.update((String)"resolved", (Object)false), OmadaAlertSitePO.class, collectionName));
        }
    }

    public void a(String omadacId, String siteId, ArchiveDTO archiveDTO) {
        this.b.b(k);
        Criteria criteria = new Criteria("omadac_id").is((Object)omadacId);
        criteria.and("site_id").is((Object)siteId);
        criteria.and("resolved").is((Object)false);
        Query query = Query.query((CriteriaDefinition)criteria);
        Long startTime = archiveDTO.getTimeStart() / 1000L;
        Long endTime = archiveDTO.getTimeEnd() / 1000L;
        query.addCriteria((CriteriaDefinition)Criteria.where((String)"time").gte((Object)archiveDTO.getTimeStart()).lte((Object)archiveDTO.getTimeEnd()));
        this.iteratorCollectionsByTimeAndSliceKey(Sort.Direction.DESC, startTime, endTime, new com.tplink.smb.omada.logmanager.domain.model.e.g(omadacId), collectionName -> this.mongoTemplate.updateMulti(query, (UpdateDefinition)Update.update((String)"resolved", (Object)true).set("resolve_time", (Object)System.currentTimeMillis()).set("resolve_type", (Object)5), OmadaAlertSitePO.class, collectionName));
    }

    public void a(ArchiveDTO archiveDTO) {
        this.b.b(k);
        Criteria criteria = new Criteria("resolved").is((Object)false);
        Query query = Query.query((CriteriaDefinition)criteria);
        Long startTime = archiveDTO.getTimeStart() / 1000L;
        Long endTime = archiveDTO.getTimeEnd() / 1000L;
        query.addCriteria((CriteriaDefinition)Criteria.where((String)"time").gte((Object)archiveDTO.getTimeStart()).lte((Object)archiveDTO.getTimeEnd()));
        this.iteratorCollectionsByTime(Sort.Direction.DESC, startTime, endTime, collectionName -> this.mongoTemplate.updateMulti(query, (UpdateDefinition)Update.update((String)"resolved", (Object)true).set("resolve_time", (Object)System.currentTimeMillis()).set("resolve_type", (Object)5), OmadaAlertSitePO.class, collectionName));
    }

    public void b(ArchiveDTO archiveDTO) {
        Criteria criteria = new Criteria("resolved").is((Object)false);
        Query query = Query.query((CriteriaDefinition)criteria);
        Long startTime = archiveDTO.getTimeStart() / 1000L;
        Long endTime = archiveDTO.getTimeEnd() / 1000L;
        query.addCriteria((CriteriaDefinition)Criteria.where((String)"time").gte((Object)archiveDTO.getTimeStart()).lte((Object)archiveDTO.getTimeEnd()));
        this.iteratorCollectionsByTime(Sort.Direction.DESC, startTime, endTime, collectionName -> this.mongoTemplate.updateMulti(query, (UpdateDefinition)Update.update((String)"resolved", (Object)true).set("resolve_type", (Object)5).set("resolve_time", (Object)System.currentTimeMillis()), OmadaAlertSitePO.class, collectionName));
    }

    public boolean a(AlertResolveDTO alertResolveDTO) {
        AtomicBoolean anyResolved = new AtomicBoolean(false);
        Query query = new Query();
        query.addCriteria((CriteriaDefinition)Criteria.where((String)"omadac_id").is((Object)alertResolveDTO.getOmadacId()));
        query.addCriteria((CriteriaDefinition)Criteria.where((String)"site_id").is((Object)alertResolveDTO.getSiteId()));
        query.addCriteria((CriteriaDefinition)Criteria.where((String)"resolved").is((Object)false));
        query.addCriteria((CriteriaDefinition)Criteria.where((String)"device_mac").is((Object)alertResolveDTO.getDeviceMac()));
        if (!CollectionUtils.isEmpty((Collection)alertResolveDTO.getResolvedLogKeys()) && Objects.isNull(alertResolveDTO.getAlertId())) {
            query.addCriteria((CriteriaDefinition)Criteria.where((String)"key").in((Collection)alertResolveDTO.getResolvedLogKeys()));
        }
        if (Objects.nonNull(alertResolveDTO.getAlertId())) {
            query.addCriteria((CriteriaDefinition)Criteria.where((String)"alert_id").is((Object)alertResolveDTO.getAlertId()));
        }
        if (T.b((String)alertResolveDTO.getSearchContent())) {
            query.addCriteria((CriteriaDefinition)Criteria.where((String)"content").regex(T.g((String)String.valueOf(alertResolveDTO.getSearchContent())), "i"));
        }
        Long startTime = com.tplink.smb.omada.logmanager.domain.model.a.b.a((Long)alertResolveDTO.getTime(), (Integer)7) / 1000L;
        Long endTime = alertResolveDTO.getTime() / 1000L;
        query.addCriteria((CriteriaDefinition)Criteria.where((String)"time").gte((Object)(startTime * 1000L)).lte((Object)(endTime * 1000L)));
        this.iteratorCollectionsByTimeAndSliceKey(Sort.Direction.DESC, startTime, endTime, new com.tplink.smb.omada.logmanager.domain.model.e.g(alertResolveDTO.getOmadacId()), collectionName -> {
            List alertSitePOS = this.mongoTemplate.find(query, OmadaAlertSitePO.class, collectionName);
            alertSitePOS.forEach(alertSitePO -> {
                if (Objects.equals(alertResolveDTO.getAlertId(), alertSitePO.getAlertId()) && Boolean.TRUE.equals(alertResolveDTO.getResolved())) {
                    anyResolved.set(true);
                    alertSitePO.setResolved(Boolean.valueOf(true));
                    alertSitePO.setResolveType(alertResolveDTO.getResolveType());
                    alertSitePO.setResolveTime(alertResolveDTO.getTime());
                    this.b.a(alertSitePO.getKey(), true, alertResolveDTO.getResolveType().intValue());
                    this.mongoTemplate.save(alertSitePO, collectionName);
                    return;
                }
                if (!CollectionUtils.isEmpty((Collection)alertResolveDTO.getResolvedLogKeys()) && Objects.isNull(alertResolveDTO.getAlertId())) {
                    if (CollectionUtils.isEmpty((Collection)alertResolveDTO.getAlertPorts()) || alertResolveDTO.getAlertPorts().containsAll(alertSitePO.getAlertPorts())) {
                        anyResolved.set(true);
                        alertSitePO.setResolved(Boolean.valueOf(true));
                        alertSitePO.setResolveType(alertResolveDTO.getResolveType());
                        alertSitePO.setResolveTime(alertResolveDTO.getTime());
                        this.b.a(alertSitePO.getKey(), false, alertResolveDTO.getResolveType().intValue());
                        this.mongoTemplate.save(alertSitePO, collectionName);
                    } else {
                        alertSitePO.getAlertPorts().removeAll(alertResolveDTO.getAlertPorts());
                        this.mongoTemplate.save(alertSitePO, collectionName);
                    }
                }
            });
        });
        return anyResolved.get();
    }

    public void a(String omadacId, String siteId, Boolean rootLag) {
        Criteria criteria = Criteria.where((String)"omadac_id").is((Object)omadacId);
        HashSet<String> siteIdQuery = new HashSet<String>(2);
        siteIdQuery.add(siteId);
        if (rootLag.booleanValue()) {
            siteIdQuery.add(null);
            criteria.and("global").is((Object)Boolean.TRUE);
        } else {
            criteria.and("global").is((Object)Boolean.FALSE);
        }
        criteria.and("site_id").in(siteIdQuery);
        criteria.and("archived").is((Object)true);
        criteria.and("alert").is((Object)true);
        Query query = new Query((CriteriaDefinition)criteria);
        this.iteratorCollectionsBySliceKey(new com.tplink.smb.omada.logmanager.domain.model.e.g(omadacId), collectionName -> this.mongoTemplate.remove(query, OmadaAlertSitePO.class, collectionName));
    }

    public void a(String omadacId, String site, Boolean deleteAlert, Long startTime, Long endTime) {
        Query query = new Query();
        query.addCriteria((CriteriaDefinition)Criteria.where((String)"site_id").is((Object)site));
        query.addCriteria((CriteriaDefinition)Criteria.where((String)"global").is((Object)Boolean.FALSE));
        this.a(query, omadacId, deleteAlert, startTime, endTime);
    }

    public void a(String omadacId, Boolean deleteAlert, Long startTime, Long endTime) {
        Query query = new Query();
        query.addCriteria((CriteriaDefinition)Criteria.where((String)"site_id").is(null));
        query.addCriteria((CriteriaDefinition)Criteria.where((String)"global").is((Object)Boolean.TRUE));
        this.a(query, omadacId, deleteAlert, startTime, endTime);
    }

    private void a(Query query, String omadacId, Boolean deleteAlert, Long startTime, Long endTime) {
        query.addCriteria((CriteriaDefinition)Criteria.where((String)"omadac_id").is((Object)omadacId));
        if (deleteAlert.booleanValue()) {
            query.addCriteria((CriteriaDefinition)Criteria.where((String)"alert").is((Object)true));
        } else {
            query.addCriteria((CriteriaDefinition)Criteria.where((String)"event").is((Object)true));
        }
        query.addCriteria((CriteriaDefinition)Criteria.where((String)"time").gte((Object)startTime).lte((Object)endTime));
        this.iteratorCollectionsByTimeAndSliceKey(Sort.Direction.DESC, startTime / 1000L, endTime / 1000L, new com.tplink.smb.omada.logmanager.domain.model.e.g(omadacId), collectionName -> this.mongoTemplate.remove(query, OmadaAlertSitePO.class, collectionName));
    }

    public long b(String omadacId, String site, Boolean rootLag) {
        HashSet<String> siteIdQuery = new HashSet<String>(2);
        siteIdQuery.add(site);
        if (rootLag.booleanValue()) {
            siteIdQuery.add(null);
        }
        Query query = new Query();
        query.addCriteria((CriteriaDefinition)Criteria.where((String)"event").is((Object)true));
        query.addCriteria((CriteriaDefinition)Criteria.where((String)"omadac_id").is((Object)omadacId));
        query.addCriteria((CriteriaDefinition)Criteria.where((String)"site_id").in(siteIdQuery));
        this.iteratorCollectionsBySliceKey(new com.tplink.smb.omada.logmanager.domain.model.e.g(omadacId), collectionName -> this.mongoTemplate.remove(query, OmadaAlertSitePO.class, collectionName));
        return 0L;
    }

    public long a(List<com.tplink.smb.omada.common.gridquery.c> filters, List<com.tplink.smb.omada.common.gridquery.c> searchFilters, Boolean rootLag, String omadacId, String siteKey, g direction) {
        this.b.b(l);
        if (Objects.isNull(filters)) {
            filters = new ArrayList<com.tplink.smb.omada.common.gridquery.c>();
        }
        Long[] times = com.tplink.smb.omada.logmanager.port.mongo.a.d.a(filters);
        Query query = this.a(filters, searchFilters, (boolean)rootLag, omadacId, siteKey);
        AtomicLong total = new AtomicLong(0L);
        this.iteratorCollectionsByTimeAndSliceKey(direction.a().equals("asc") ? Sort.Direction.ASC : Sort.Direction.DESC, times[0], times[1], new com.tplink.smb.omada.logmanager.domain.model.e.g(omadacId), collectionName -> total.addAndGet(this.mongoTemplate.count(query, OmadaAlertSitePO.class, collectionName)));
        return total.get();
    }

    public Map<String, Long> a(String omadacId, List<String> siteIds) {
        Criteria criteria = Criteria.where((String)"omadac_id").is((Object)omadacId);
        criteria.and("site_id").in(siteIds);
        Aggregation aggregation = Aggregation.newAggregation((AggregationOperation[])new AggregationOperation[]{Aggregation.match((Criteria)criteria), Aggregation.group((String[])new String[]{"site_id"}).count().as("countNumber")});
        ArrayList numClassifyInfoDTOS = new ArrayList();
        this.iteratorCollectionsByTimeAndSliceKey(Sort.Direction.DESC, 0L, System.currentTimeMillis() / 1000L, new com.tplink.smb.omada.logmanager.domain.model.e.g(omadacId), collectionName -> numClassifyInfoDTOS.addAll(this.mongoTemplate.aggregate(aggregation, collectionName, LogClassifyInfoDTO.class).getMappedResults()));
        Map<String, LongSummaryStatistics> statisticsMap = numClassifyInfoDTOS.stream().collect(Collectors.groupingBy(LogClassifyInfoDTO::getId, Collectors.summarizingLong(LogClassifyInfoDTO::getCountNumber)));
        HashMap<String, Long> sitesLogNumMap = new HashMap<String, Long>(statisticsMap.size());
        for (Map.Entry<String, LongSummaryStatistics> entry : statisticsMap.entrySet()) {
            sitesLogNumMap.put(entry.getKey(), entry.getValue().getSum());
        }
        return sitesLogNumMap;
    }

    public List<w> a(Boolean globalLogExportPermission, String omadacId, String siteId, com.tplink.smb.omada.common.gridquery.d queryPage) {
        this.b.b(m);
        Query query = new Query();
        query.with((Pageable)PageRequest.of((int)queryPage.a(), (int)queryPage.b()));
        query.addCriteria((CriteriaDefinition)Criteria.where((String)"omadac_id").is((Object)omadacId));
        ArrayList<w> omadaLogs = new ArrayList<w>();
        if (globalLogExportPermission.booleanValue()) {
            query.addCriteria((CriteriaDefinition)Criteria.where((String)"site_id").is(null));
        } else {
            query.addCriteria((CriteriaDefinition)Criteria.where((String)"site_id").is((Object)siteId));
        }
        long endTime = System.currentTimeMillis() / 1000L;
        this.iteratorCollectionsByTimeAndSliceKeyWithSkip(Sort.Direction.DESC, 0L, endTime, new com.tplink.smb.omada.logmanager.domain.model.e.g(omadacId), query, (collectionName, queryCollection) -> omadaLogs.addAll(this.mongoTemplate.find(queryCollection, OmadaAlertSitePO.class, collectionName).stream().map(h::a).collect(Collectors.toList())));
        return omadaLogs;
    }

    public void a(String omadacId, String siteId, com.tplink.smb.omada.common.util.c.a<w> consumer) {
        Query query = new Query();
        query.addCriteria((CriteriaDefinition)Criteria.where((String)"omadac_id").is((Object)omadacId));
        query.addCriteria((CriteriaDefinition)Criteria.where((String)"site_id").is((Object)siteId));
        long endTime = System.currentTimeMillis() / 1000L;
        this.iteratorCollectionsByTimeAndSliceKey(Sort.Direction.DESC, 0L, endTime, new com.tplink.smb.omada.logmanager.domain.model.e.g(omadacId), collectionName -> {
            MongoIterable iterable = this.mongoTemplate.getCollection(collectionName).find((Bson)query.getQueryObject()).batchSize(1000).map(src -> (OmadaAlertSitePO)this.mongoTemplate.getConverter().read(OmadaAlertSitePO.class, src));
            iterable.forEach(po -> consumer.a((Object)com.tplink.smb.omada.logmanager.port.mongo.log.h.a(po)));
        });
    }

    public void a(String omadacId, String siteId, Long startTime, Long endTime, List<String> logKeys) {
        Query query = new Query();
        query.addCriteria((CriteriaDefinition)Criteria.where((String)"omadac_id").is((Object)omadacId));
        query.addCriteria((CriteriaDefinition)Criteria.where((String)"time").gte((Object)startTime).lte((Object)endTime));
        query.addCriteria((CriteriaDefinition)Criteria.where((String)"site_id").is((Object)siteId));
        query.addCriteria((CriteriaDefinition)Criteria.where((String)"key").in(logKeys));
        ArrayList<String> collectionNames = new ArrayList<String>();
        this.iteratorCollectionsByTimeAndSliceKey(Sort.Direction.ASC, startTime / 1000L, endTime / 1000L, new com.tplink.smb.omada.logmanager.domain.model.e.g(omadacId), collectionName -> collectionNames.add((String)collectionName));
        com.tplink.smb.omada.logmanager.port.mongo.a.c.a(collectionNames, "omadalog");
        for (String c2 : collectionNames) {
            this.mongoTemplate.remove(query, OmadaAlertSitePO.class, c2);
            a.debug("Iterating collection(delete by type): {}", (Object)c2);
        }
    }

    public void a(String omadacId, Long startTime, Long endTime, List<String> logKeys) {
        this.a(omadacId, null, startTime, endTime, logKeys);
    }

    public List<w> a(com.tplink.smb.omada.common.gridquery.d page, List<e> sort, List<com.tplink.smb.omada.common.gridquery.c> filters, List<com.tplink.smb.omada.common.gridquery.c> searchFilters, boolean isRoot, String omadacId, String siteKey, long count) {
        if (Objects.isNull(filters)) {
            filters = new ArrayList<com.tplink.smb.omada.common.gridquery.c>();
        }
        Long[] times = com.tplink.smb.omada.logmanager.port.mongo.a.d.a(filters);
        Query query = this.a(filters, searchFilters, isRoot, omadacId, siteKey);
        boolean reverse = this.a(page, query, sort, Sort.Direction.fromString((String)sort.get(0).a().a()), count);
        Sort.Direction direction = sort.get(0).a().a().equals("asc") ? Sort.Direction.ASC : Sort.Direction.DESC;
        com.tplink.smb.omada.logmanager.port.mongo.a.a.a(query, sort);
        ArrayList omadaLogPOS = new ArrayList();
        this.iteratorCollectionsByTimeAndSliceKeyWithSkip(direction, times[0], times[1], new com.tplink.smb.omada.logmanager.domain.model.e.g(omadacId), query, (collectionName, queryFilter) -> omadaLogPOS.addAll(this.mongoTemplate.find(queryFilter, OmadaAlertSitePO.class, collectionName)));
        if (reverse) {
            return omadaLogPOS.stream().map(h::a).sorted(Comparator.comparing(AbstractOmadaLog::getTime).reversed()).collect(Collectors.toList());
        }
        return omadaLogPOS.stream().map(h::a).collect(Collectors.toList());
    }

    private boolean a(com.tplink.smb.omada.common.gridquery.d page, Query query, List<e> querySorts, Sort.Direction direction, long count) {
        int pageSize;
        if (Objects.isNull(page)) {
            return false;
        }
        int pageNum = page.a();
        if ((long)(pageNum * (pageSize = page.b()) * 2) < count) {
            query.limit(page.b()).skip((long)(page.a() * page.b()));
            return false;
        }
        int lastPageSize = (int)(count % (long)pageSize);
        int reversePageNum = (int)(count - (long)(pageNum * pageSize)) / pageSize;
        page.a(reversePageNum);
        if (lastPageSize > 0) {
            if (reversePageNum == 0) {
                query.limit(lastPageSize);
            } else {
                query.limit(page.b()).skip((long)(lastPageSize + (reversePageNum - 1) * page.b()));
            }
        } else {
            query.limit(page.b()).skip((long)(reversePageNum * page.b()));
        }
        if (!CollectionUtils.isEmpty(querySorts)) {
            for (e sort : querySorts) {
                if (direction.isAscending()) {
                    sort.a(com.tplink.smb.omada.common.gridquery.g.a);
                    continue;
                }
                sort.a(com.tplink.smb.omada.common.gridquery.g.b);
            }
        }
        return true;
    }

    public Query a(List<com.tplink.smb.omada.common.gridquery.c> filters, List<com.tplink.smb.omada.common.gridquery.c> searchFilters, boolean isRoot, String omadacId, String siteKey) {
        if (CollectionUtils.isEmpty(filters)) {
            filters = new ArrayList<com.tplink.smb.omada.common.gridquery.c>(4);
        }
        if (CollectionUtils.isEmpty(searchFilters)) {
            searchFilters = new ArrayList<com.tplink.smb.omada.common.gridquery.c>(4);
        }
        filters = com.tplink.smb.omada.logmanager.port.mongo.a.c.a(filters, searchFilters);
        Criteria criteria = com.tplink.smb.omada.logmanager.port.mongo.a.a.b(searchFilters, filters);
        criteria.and("omadac_id").is((Object)omadacId);
        if (isRoot && Objects.nonNull(siteKey)) {
            HashSet<String> siteIdQuery = new HashSet<String>(2);
            siteIdQuery.add(siteKey);
            siteIdQuery.add(null);
            criteria.and("site_id").in(siteIdQuery);
        } else {
            criteria.and("site_id").is((Object)siteKey);
        }
        return new Query((CriteriaDefinition)criteria);
    }

    public Criteria a(List<com.tplink.smb.omada.common.gridquery.c> filters, List<com.tplink.smb.omada.common.gridquery.c> searchFilters, String omadacId, String siteKey) {
        if (CollectionUtils.isEmpty(filters)) {
            filters = new ArrayList<com.tplink.smb.omada.common.gridquery.c>(4);
        }
        if (CollectionUtils.isEmpty(searchFilters)) {
            searchFilters = new ArrayList<com.tplink.smb.omada.common.gridquery.c>(4);
        }
        filters = com.tplink.smb.omada.logmanager.port.mongo.a.c.a(filters, searchFilters);
        Criteria criteria = com.tplink.smb.omada.logmanager.port.mongo.a.a.b(searchFilters, filters);
        criteria.and("omadac_id").is((Object)omadacId);
        criteria.and("site_id").is((Object)siteKey);
        return criteria;
    }

    public List<LogGroupInfoDTO> a(LogClassifyInfoRequestDTO logClassifyInfoRequestDTO, String ... groupKeys) {
        this.b.b(r);
        String omadacId = logClassifyInfoRequestDTO.getOmadacId();
        String siteId = logClassifyInfoRequestDTO.getSiteId();
        Long startTime = logClassifyInfoRequestDTO.getStartTime();
        Long endTime = logClassifyInfoRequestDTO.getEndTime();
        Criteria criteria = Criteria.where((String)"omadac_id").is((Object)omadacId);
        criteria.and("time").gte((Object)startTime).lte((Object)endTime);
        criteria.and("site_id").is((Object)siteId);
        if (Objects.nonNull(logClassifyInfoRequestDTO.getDeviceType()) && T.b((String)logClassifyInfoRequestDTO.getDeviceType().b())) {
            criteria.and("device_type").is((Object)logClassifyInfoRequestDTO.getDeviceType().c());
        }
        Aggregation aggregation = Aggregation.newAggregation((AggregationOperation[])new AggregationOperation[]{Aggregation.match((Criteria)criteria), Aggregation.group((String[])groupKeys).count().as("countNumber")});
        ArrayList logGroupInfoDTOS = new ArrayList();
        this.iteratorCollectionsByTimeAndSliceKey(Sort.Direction.DESC, startTime / 1000L, endTime / 1000L, new com.tplink.smb.omada.logmanager.domain.model.e.g(omadacId), collectionName -> logGroupInfoDTOS.addAll(this.mongoTemplate.aggregate(aggregation, collectionName, LogGroupInfoDTO.class).getMappedResults()));
        Map<LogGroupDTO, LongSummaryStatistics> statisticsMap = logGroupInfoDTOS.stream().collect(Collectors.groupingBy(LogGroupInfoDTO::getId, Collectors.summarizingLong(LogGroupInfoDTO::getCountNumber)));
        ArrayList<LogGroupInfoDTO> logGroupList = new ArrayList<LogGroupInfoDTO>();
        for (Map.Entry<LogGroupDTO, LongSummaryStatistics> entry : statisticsMap.entrySet()) {
            logGroupList.add(LogGroupInfoDTO.builder().id(entry.getKey()).countNumber(Long.valueOf(entry.getValue().getSum())).build());
        }
        return logGroupList;
    }

    public List<LogClassifyInfoDTO> a(LogClassifyNumberQueryDTO logClassifyNumberQueryDTO) {
        this.b.b(s);
        String omadacId = logClassifyNumberQueryDTO.getOmadacId();
        Criteria criteria = Criteria.where((String)"omadac_id").is((Object)omadacId);
        Boolean alert = logClassifyNumberQueryDTO.getAlert();
        Boolean event = logClassifyNumberQueryDTO.getEvent();
        if (Boolean.TRUE.equals(alert)) {
            criteria.and("alert").is((Object)true);
        }
        if (Boolean.TRUE.equals(event)) {
            criteria.and("event").is((Object)true);
        }
        long startTime = logClassifyNumberQueryDTO.getStartTime();
        long endTime = logClassifyNumberQueryDTO.getEndTime();
        criteria.and("time").gte((Object)startTime).lte((Object)endTime);
        if (Objects.nonNull(logClassifyNumberQueryDTO.getArchived())) {
            criteria.and("archived").is((Object)logClassifyNumberQueryDTO.getArchived());
        }
        if (!T.a((String)logClassifyNumberQueryDTO.getModule())) {
            criteria.and("module").is((Object)logClassifyNumberQueryDTO.getModule());
        }
        HashSet<String> siteIdQuery = new HashSet<String>(2);
        siteIdQuery.add(logClassifyNumberQueryDTO.getSiteId());
        if (logClassifyNumberQueryDTO.getRootLag().booleanValue()) {
            siteIdQuery.add(null);
        }
        criteria.and("site_id").in(siteIdQuery);
        if (!T.a((String)logClassifyNumberQueryDTO.getSearchKey())) {
            criteria.andOperator(new Criteria[]{com.tplink.smb.omada.logmanager.port.mongo.a.d.a(com.tplink.smb.omada.logmanager.port.mongo.a.d.b(logClassifyNumberQueryDTO.getSearchKey()))});
        }
        Aggregation aggregation = Aggregation.newAggregation((AggregationOperation[])new AggregationOperation[]{Aggregation.match((Criteria)criteria), Aggregation.group((String[])new String[]{logClassifyNumberQueryDTO.getGroupKey()}).count().as("countNumber")});
        ArrayList logGroupInfoDTOS = new ArrayList();
        this.iteratorCollectionsByTimeAndSliceKey(Sort.Direction.DESC, startTime / 1000L, endTime / 1000L, new com.tplink.smb.omada.logmanager.domain.model.e.g(omadacId), collectionName -> logGroupInfoDTOS.addAll(this.mongoTemplate.aggregate(aggregation, collectionName, LogClassifyInfoDTO.class).getMappedResults()));
        Map<String, LongSummaryStatistics> statisticsMap = logGroupInfoDTOS.stream().collect(Collectors.groupingBy(LogClassifyInfoDTO::getId, Collectors.summarizingLong(LogClassifyInfoDTO::getCountNumber)));
        ArrayList<LogClassifyInfoDTO> logGroupInfo = new ArrayList<LogClassifyInfoDTO>();
        for (Map.Entry<String, LongSummaryStatistics> entry : statisticsMap.entrySet()) {
            logGroupInfo.add(LogClassifyInfoDTO.builder().id(entry.getKey()).countNumber(Long.valueOf(entry.getValue().getSum())).build());
        }
        return logGroupInfo;
    }

    public Long a(String omadacId, String siteId, com.tplink.smb.omada.common.gridquery.a<w> grid, Long startTime, Long endTime) {
        grid.setFilters(com.tplink.smb.omada.logmanager.port.mongo.a.c.b(grid.getFilters()));
        grid.setFilters(com.tplink.smb.omada.logmanager.port.mongo.a.c.c(grid.getFilters()));
        Query query = this.a(grid.getFilters(), grid.getSearchFilters(), false, omadacId, siteId);
        AtomicLong count = new AtomicLong();
        this.iteratorCollectionsByTimeAndSliceKey(Sort.Direction.DESC, startTime / 1000L, endTime / 1000L, new com.tplink.smb.omada.logmanager.domain.model.e.g(omadacId), collectionName -> count.addAndGet(this.mongoTemplate.count(query, OmadaAlertSitePO.class, collectionName)));
        return count.get();
    }

    public Long b(String omadacId, String siteId, com.tplink.smb.omada.common.gridquery.a<w> grid, Long startTime, Long endTime) {
        grid.setFilters(com.tplink.smb.omada.logmanager.port.mongo.a.c.b(grid.getFilters()));
        grid.setFilters(com.tplink.smb.omada.logmanager.port.mongo.a.c.c(grid.getFilters()));
        Criteria criteria = this.a(grid.getFilters(), grid.getSearchFilters(), omadacId, siteId);
        criteria.and("resolved").is((Object)true);
        Query query = new Query((CriteriaDefinition)criteria);
        AtomicLong count = new AtomicLong();
        this.iteratorCollectionsByTimeAndSliceKey(Sort.Direction.DESC, startTime / 1000L, endTime / 1000L, new com.tplink.smb.omada.logmanager.domain.model.e.g(omadacId), collectionName -> count.addAndGet(this.mongoTemplate.count(query, OmadaAlertSitePO.class, collectionName)));
        return count.get();
    }

    public Long c(String omadacId, String siteId, com.tplink.smb.omada.common.gridquery.a<w> grid, Long startTime, Long endTime) {
        grid.setFilters(com.tplink.smb.omada.logmanager.port.mongo.a.c.b(grid.getFilters()));
        grid.setFilters(com.tplink.smb.omada.logmanager.port.mongo.a.c.c(grid.getFilters()));
        Criteria criteria = this.a(grid.getFilters(), grid.getSearchFilters(), omadacId, siteId);
        criteria.and("resolved").is((Object)false);
        Query query = new Query((CriteriaDefinition)criteria);
        AtomicLong count = new AtomicLong();
        this.iteratorCollectionsByTimeAndSliceKey(Sort.Direction.DESC, startTime / 1000L, endTime / 1000L, new com.tplink.smb.omada.logmanager.domain.model.e.g(omadacId), collectionName -> count.addAndGet(this.mongoTemplate.count(query, OmadaAlertSitePO.class, collectionName)));
        return count.get();
    }

    public List<LogClassifyInfoDTO> d(String omadacId, String siteId, com.tplink.smb.omada.common.gridquery.a<w> grid, Long startTime, Long endTime) {
        this.b.b(s);
        grid.setFilters(com.tplink.smb.omada.logmanager.port.mongo.a.c.b(grid.getFilters()));
        Criteria criteria = this.a(grid.getFilters(), grid.getSearchFilters(), omadacId, siteId);
        return this.a(criteria, "level", omadacId, startTime, endTime);
    }

    public List<LogClassifyInfoDTO> e(String omadacId, String siteId, com.tplink.smb.omada.common.gridquery.a<w> grid, Long startTime, Long endTime) {
        this.b.b(s);
        grid.setFilters(com.tplink.smb.omada.logmanager.port.mongo.a.c.b(grid.getFilters()));
        Criteria criteria = this.a(grid.getFilters(), grid.getSearchFilters(), omadacId, siteId);
        criteria.and("resolved").is((Object)false);
        return this.a(criteria, "level", omadacId, startTime, endTime);
    }

    public List<LogClassifyInfoDTO> f(String omadacId, String siteId, com.tplink.smb.omada.common.gridquery.a<w> grid, Long startTime, Long endTime) {
        this.b.b(s);
        grid.setFilters(com.tplink.smb.omada.logmanager.port.mongo.a.c.b(grid.getFilters()));
        Criteria criteria = this.a(grid.getFilters(), grid.getSearchFilters(), omadacId, siteId);
        criteria.and("resolved").is((Object)true);
        return this.a(criteria, "level", omadacId, startTime, endTime);
    }

    public List<LogClassifyInfoDTO> a(LogClassifyInfoRequestDTO logClassifyInfoRequestDTO) {
        this.b.b(s);
        String omadacId = logClassifyInfoRequestDTO.getOmadacId();
        String siteId = logClassifyInfoRequestDTO.getSiteId();
        Criteria criteria = Criteria.where((String)"omadac_id").is((Object)omadacId);
        criteria.and("site_id").is((Object)siteId);
        long startTime = logClassifyInfoRequestDTO.getStartTime();
        long endTime = logClassifyInfoRequestDTO.getEndTime();
        criteria.and("time").gte((Object)startTime).lte((Object)endTime);
        criteria.and("resolved").is((Object)false);
        return this.a(criteria, "level", omadacId, (Long)startTime, (Long)endTime);
    }

    public List<LogClassifyInfoDTO> b(LogClassifyInfoRequestDTO logClassifyInfoRequestDTO) {
        this.b.b(s);
        String omadacId = logClassifyInfoRequestDTO.getOmadacId();
        String siteId = logClassifyInfoRequestDTO.getSiteId();
        Criteria criteria = Criteria.where((String)"omadac_id").is((Object)omadacId);
        criteria.and("site_id").is((Object)siteId);
        long startTime = logClassifyInfoRequestDTO.getStartTime();
        long endTime = logClassifyInfoRequestDTO.getEndTime();
        criteria.and("time").gte((Object)startTime).lte((Object)endTime);
        criteria.and("resolved").is((Object)true);
        return this.a(criteria, "level", omadacId, (Long)startTime, (Long)endTime);
    }

    public List<LogClassifyInfoDTO> g(String omadacId, String siteId, com.tplink.smb.omada.common.gridquery.a<w> grid, Long startTime, Long endTime) {
        this.b.b(s);
        grid.setFilters(com.tplink.smb.omada.logmanager.port.mongo.a.c.b(grid.getFilters()));
        grid.setFilters(com.tplink.smb.omada.logmanager.port.mongo.a.c.c(grid.getFilters()));
        Criteria criteria = this.a(grid.getFilters(), grid.getSearchFilters(), omadacId, siteId);
        return this.a(criteria, "module", omadacId, startTime, endTime);
    }

    public List<LogClassifyInfoDTO> h(String omadacId, String siteId, com.tplink.smb.omada.common.gridquery.a<w> grid, Long startTime, Long endTime) {
        this.b.b(s);
        grid.setFilters(com.tplink.smb.omada.logmanager.port.mongo.a.c.b(grid.getFilters()));
        grid.setFilters(com.tplink.smb.omada.logmanager.port.mongo.a.c.c(grid.getFilters()));
        Criteria criteria = this.a(grid.getFilters(), grid.getSearchFilters(), omadacId, siteId);
        criteria.and("resolved").is((Object)false);
        return this.a(criteria, "module", omadacId, startTime, endTime);
    }

    public List<LogClassifyInfoDTO> i(String omadacId, String siteId, com.tplink.smb.omada.common.gridquery.a<w> grid, Long startTime, Long endTime) {
        this.b.b(s);
        grid.setFilters(com.tplink.smb.omada.logmanager.port.mongo.a.c.b(grid.getFilters()));
        grid.setFilters(com.tplink.smb.omada.logmanager.port.mongo.a.c.c(grid.getFilters()));
        Criteria criteria = this.a(grid.getFilters(), grid.getSearchFilters(), omadacId, siteId);
        criteria.and("resolved").is((Object)true);
        return this.a(criteria, "module", omadacId, startTime, endTime);
    }

    public List<LogClassifyInfoDTO> c(LogClassifyInfoRequestDTO logClassifyInfoRequestDTO) {
        this.b.b(s);
        String omadacId = logClassifyInfoRequestDTO.getOmadacId();
        String siteId = logClassifyInfoRequestDTO.getSiteId();
        Criteria criteria = Criteria.where((String)"omadac_id").is((Object)omadacId);
        criteria.and("site_id").is((Object)siteId);
        long startTime = logClassifyInfoRequestDTO.getStartTime();
        long endTime = logClassifyInfoRequestDTO.getEndTime();
        criteria.and("time").gte((Object)startTime).lte((Object)endTime);
        criteria.and("resolved").is((Object)false);
        return this.a(criteria, "key", omadacId, (Long)startTime, (Long)endTime);
    }

    public List<LogClassifyInfoDTO> d(LogClassifyInfoRequestDTO logClassifyInfoRequestDTO) {
        this.b.b(s);
        String omadacId = logClassifyInfoRequestDTO.getOmadacId();
        String siteId = logClassifyInfoRequestDTO.getSiteId();
        Criteria criteria = Criteria.where((String)"omadac_id").is((Object)omadacId);
        criteria.and("site_id").is((Object)siteId);
        long startTime = logClassifyInfoRequestDTO.getStartTime();
        long endTime = logClassifyInfoRequestDTO.getEndTime();
        criteria.and("time").gte((Object)startTime).lte((Object)endTime);
        criteria.and("resolved").is((Object)false);
        criteria.and("device_mac").exists(true);
        return this.a(criteria, "device_mac", omadacId, (Long)startTime, (Long)endTime);
    }

    public List<AlertNumTrendDTO> e(LogClassifyInfoRequestDTO logClassifyInfoRequestDTO) {
        HashMap alertNumTrendMap = new HashMap();
        String omadacId = logClassifyInfoRequestDTO.getOmadacId();
        String siteId = logClassifyInfoRequestDTO.getSiteId();
        long startTime = logClassifyInfoRequestDTO.getStartTime();
        long endTime = logClassifyInfoRequestDTO.getEndTime();
        long startTimeSec = TimeUnit.SECONDS.convert(startTime, TimeUnit.MILLISECONDS);
        long endTimeSec = TimeUnit.SECONDS.convert(endTime, TimeUnit.MILLISECONDS);
        long granularity = com.tplink.smb.omada.logmanager.port.mongo.log.e.a.a(startTimeSec, endTimeSec);
        long start = startTimeSec / granularity * granularity;
        if (Math.floorMod(endTimeSec, granularity) != 0L) {
            endTimeSec += granularity;
        }
        for (long time = start; time < endTimeSec; time += granularity) {
            long queryStartTime = time * 1000L;
            long queryEndTime = (time + granularity) * 1000L - 1L;
            Criteria criteria = Criteria.where((String)"omadac_id").is((Object)omadacId);
            criteria.and("site_id").is((Object)siteId);
            criteria.and("time").gte((Object)queryStartTime).lte((Object)queryEndTime);
            criteria.and("resolved").is((Object)false);
            Query query = new Query((CriteriaDefinition)criteria);
            this.iteratorCollectionsByTimeAndSliceKey(Sort.Direction.DESC, queryStartTime / 1000L, queryEndTime / 1000L, new com.tplink.smb.omada.logmanager.domain.model.e.g(omadacId), collectionName -> {
                if (alertNumTrendMap.containsKey(queryStartTime)) {
                    AlertNumTrendDTO alertNumTrendDTO = (AlertNumTrendDTO)alertNumTrendMap.get(queryStartTime);
                    alertNumTrendDTO.setCountNumber(Long.valueOf(alertNumTrendDTO.getCountNumber() + this.mongoTemplate.count(query, collectionName)));
                } else {
                    AlertNumTrendDTO alertNumTrendDTO = AlertNumTrendDTO.builder().time(Long.valueOf(queryStartTime)).countNumber(Long.valueOf(this.mongoTemplate.count(query, collectionName))).build();
                    alertNumTrendMap.put(queryStartTime, alertNumTrendDTO);
                }
            });
        }
        ArrayList<AlertNumTrendDTO> alertNumTrendDTO = new ArrayList<AlertNumTrendDTO>(alertNumTrendMap.values());
        alertNumTrendDTO.sort(Comparator.comparingLong(AlertNumTrendDTO::getTime));
        return alertNumTrendDTO;
    }

    public List<AlertNumTrendDTO> f(LogClassifyInfoRequestDTO logClassifyInfoRequestDTO) {
        HashMap alertNumTrendMap = new HashMap();
        String omadacId = logClassifyInfoRequestDTO.getOmadacId();
        String siteId = logClassifyInfoRequestDTO.getSiteId();
        long startTime = logClassifyInfoRequestDTO.getStartTime();
        long endTime = logClassifyInfoRequestDTO.getEndTime();
        long startTimeSec = TimeUnit.SECONDS.convert(startTime, TimeUnit.MILLISECONDS);
        long endTimeSec = TimeUnit.SECONDS.convert(endTime, TimeUnit.MILLISECONDS);
        long granularity = com.tplink.smb.omada.logmanager.port.mongo.log.e.a.a(startTimeSec, endTimeSec);
        long start = startTimeSec / granularity * granularity;
        if (Math.floorMod(endTimeSec, granularity) != 0L) {
            endTimeSec += granularity;
        }
        for (long time = start; time < endTimeSec; time += granularity) {
            long queryStartTime = time * 1000L;
            long queryEndTime = (time + granularity) * 1000L - 1L;
            Criteria criteria = Criteria.where((String)"omadac_id").is((Object)omadacId);
            criteria.and("site_id").is((Object)siteId);
            criteria.and("time").gte((Object)queryStartTime).lte((Object)queryEndTime);
            Query query = new Query((CriteriaDefinition)criteria);
            this.iteratorCollectionsByTimeAndSliceKey(Sort.Direction.DESC, queryStartTime / 1000L, queryEndTime / 1000L, new com.tplink.smb.omada.logmanager.domain.model.e.g(omadacId), collectionName -> {
                if (alertNumTrendMap.containsKey(queryStartTime)) {
                    AlertNumTrendDTO alertNumTrendDTO = (AlertNumTrendDTO)alertNumTrendMap.get(queryStartTime);
                    alertNumTrendDTO.setCountNumber(Long.valueOf(alertNumTrendDTO.getCountNumber() + this.mongoTemplate.count(query, collectionName)));
                } else {
                    AlertNumTrendDTO alertNumTrendDTO = AlertNumTrendDTO.builder().time(Long.valueOf(queryStartTime)).countNumber(Long.valueOf(this.mongoTemplate.count(query, collectionName))).build();
                    alertNumTrendMap.put(queryStartTime, alertNumTrendDTO);
                }
            });
        }
        ArrayList<AlertNumTrendDTO> alertNumTrendDTO = new ArrayList<AlertNumTrendDTO>(alertNumTrendMap.values());
        alertNumTrendDTO.sort(Comparator.comparingLong(AlertNumTrendDTO::getTime));
        return alertNumTrendDTO;
    }

    public Long b(com.tplink.smb.omada.logmanager.domain.model.e.g omadacId, Long startTime, Long endTime) {
        Query query = new Query();
        Criteria criteria = Criteria.where((String)"omadac_id").is((Object)omadacId.a());
        criteria.and("time").gte((Object)startTime).lte((Object)endTime);
        criteria.and("archived").is((Object)Boolean.FALSE);
        criteria.and("global").is((Object)Boolean.FALSE);
        query.addCriteria((CriteriaDefinition)criteria);
        AtomicLong count = new AtomicLong();
        this.iteratorCollectionsByTimeAndSliceKey(Sort.Direction.DESC, startTime / 1000L, endTime / 1000L, omadacId, collectionName -> count.addAndGet(this.mongoTemplate.count(query, OmadaAlertSitePO.class, collectionName)));
        return count.get();
    }

    public Map<String, Long> a(com.tplink.smb.omada.logmanager.domain.model.e.g omadacId, Set<String> sites, Long startTime, Long endTime) {
        Criteria criteria = Criteria.where((String)"omadac_id").is((Object)omadacId.a());
        criteria.and("site_id").in(sites);
        criteria.and("time").gte((Object)startTime).lte((Object)endTime);
        criteria.and("resolved").is((Object)Boolean.FALSE);
        Aggregation aggregation = Aggregation.newAggregation((AggregationOperation[])new AggregationOperation[]{Aggregation.match((Criteria)criteria), Aggregation.group((String[])new String[]{"site_id"}).count().as("alertNumber")});
        ArrayList numClassifyInfoDTOS = new ArrayList();
        this.iteratorCollectionsByTimeAndSliceKey(Sort.Direction.DESC, startTime / 1000L, endTime / 1000L, omadacId, collectionName -> numClassifyInfoDTOS.addAll(this.mongoTemplate.aggregate(aggregation, collectionName, AlertNumClassifyInfoDTO.class).getMappedResults()));
        Map<String, LongSummaryStatistics> statisticsMap = numClassifyInfoDTOS.stream().collect(Collectors.groupingBy(AlertNumClassifyInfoDTO::getId, Collectors.summarizingLong(AlertNumClassifyInfoDTO::getAlertNumber)));
        HashMap<String, Long> sitesAlertNumMap = new HashMap<String, Long>(statisticsMap.size());
        for (Map.Entry<String, LongSummaryStatistics> entry : statisticsMap.entrySet()) {
            sitesAlertNumMap.put(entry.getKey(), entry.getValue().getSum());
        }
        return sitesAlertNumMap;
    }

    public Map<String, Long> a(Set<String> customers, Long startTime, Long endTime) {
        Criteria criteria = Criteria.where((String)"omadac_id").in(customers);
        criteria.and("time").gte((Object)startTime).lte((Object)endTime);
        criteria.and("archived").is((Object)Boolean.FALSE);
        criteria.and("alert").is((Object)Boolean.TRUE);
        Aggregation aggregation = Aggregation.newAggregation((AggregationOperation[])new AggregationOperation[]{Aggregation.match((Criteria)criteria), Aggregation.group((String[])new String[]{"omadac_id"}).count().as("alertNumber")});
        ArrayList numClassifyInfoDTOS = new ArrayList();
        this.iteratorCollectionsByTime(Sort.Direction.DESC, startTime / 1000L, endTime / 1000L, collectionName -> numClassifyInfoDTOS.addAll(this.mongoTemplate.aggregate(aggregation, collectionName, AlertNumClassifyInfoDTO.class).getMappedResults()));
        Map<String, LongSummaryStatistics> statisticsMap = numClassifyInfoDTOS.stream().collect(Collectors.groupingBy(AlertNumClassifyInfoDTO::getId, Collectors.summarizingLong(AlertNumClassifyInfoDTO::getAlertNumber)));
        HashMap<String, Long> customersAlertNumMap = new HashMap<String, Long>(statisticsMap.size());
        for (Map.Entry<String, LongSummaryStatistics> entry : statisticsMap.entrySet()) {
            customersAlertNumMap.put(entry.getKey(), entry.getValue().getSum());
        }
        return customersAlertNumMap;
    }

    public List<String> a(String omadacId, Long startTime, Long endTime, g direction) {
        ArrayList<String> collectionNames = new ArrayList<String>();
        this.iteratorCollectionsByTimeAndSliceKey(com.tplink.smb.omada.common.gridquery.g.a.equals((Object)direction) ? Sort.Direction.DESC : Sort.Direction.ASC, startTime, endTime, new com.tplink.smb.omada.logmanager.domain.model.e.g(omadacId), collectionName -> collectionNames.add((String)collectionName));
        return collectionNames;
    }

    public int a(com.tplink.smb.omada.logmanager.domain.model.e.g omadacId, String siteId, List<String> ids, Long startTime, Long endTime) {
        Query query = new Query();
        query.addCriteria((CriteriaDefinition)Criteria.where((String)"site_id").is((Object)siteId));
        return this.a(omadacId, ids, startTime, endTime, query);
    }

    public void a(com.tplink.smb.omada.logmanager.domain.model.e.g omadacId, String siteId, com.tplink.smb.omada.common.gridquery.a<w> grid, List<String> ids, Long startTime, Long endTime) {
        ArrayList<w> omadaLogs = new ArrayList<w>();
        if (!CollectionUtils.isEmpty(ids)) {
            Criteria criteria = Criteria.where((String)"_id").in(ids).and("omadac_id").is((Object)omadacId.a()).and("site_id").is((Object)siteId);
            Query idQuery = new Query((CriteriaDefinition)criteria);
            this.iteratorCollectionsByTimeAndSliceKey(Sort.Direction.DESC, startTime / 1000L, endTime / 1000L, omadacId, collectionName -> omadaLogs.addAll(this.mongoTemplate.find(idQuery, OmadaAlertSitePO.class, collectionName).stream().map(h::a).collect(Collectors.toList())));
        }
        for (w omadalog : omadaLogs) {
            ids.remove(omadalog.getId().a());
        }
        grid.setFilters(com.tplink.smb.omada.logmanager.port.mongo.a.c.a(grid.getFilters()));
        Query query = this.a(grid.getFilters(), grid.getSearchFilters(), false, omadacId.a(), siteId);
        query.addCriteria((CriteriaDefinition)Criteria.where((String)"time").gte((Object)startTime).lte((Object)endTime));
        this.iteratorCollectionsByTimeAndSliceKey(Sort.Direction.DESC, startTime / 1000L, endTime / 1000L, omadacId, collectionName -> this.mongoTemplate.remove(query, collectionName));
        if (!CollectionUtils.isEmpty(omadaLogs)) {
            this.a(omadaLogs);
        }
    }

    public int a(com.tplink.smb.omada.logmanager.domain.model.e.g omadacId, List<String> ids, Long startTime, Long endTime) {
        Query query = new Query();
        query.addCriteria((CriteriaDefinition)Criteria.where((String)"site_id").is(null));
        return this.a(omadacId, ids, startTime, endTime, query);
    }

    private int a(com.tplink.smb.omada.logmanager.domain.model.e.g omadacId, List<String> ids, Long startTime, Long endTime, Query query) {
        AtomicInteger clearedNum = new AtomicInteger(0);
        int topNum = ids.size();
        query.addCriteria((CriteriaDefinition)Criteria.where((String)"omadac_id").is((Object)omadacId.a()));
        query.addCriteria((CriteriaDefinition)Criteria.where((String)"_id").in(ids));
        this.iteratorCollectionsByTimeAndSliceKey(Sort.Direction.DESC, startTime / 1000L, endTime / 1000L, omadacId, collectionName -> {
            if (clearedNum.get() >= topNum) {
                return;
            }
            int removed = (int)this.mongoTemplate.remove(query, collectionName).getDeletedCount();
            clearedNum.addAndGet(removed);
        });
        return clearedNum.get();
    }

    public void b(com.tplink.smb.omada.logmanager.domain.model.e.g omadacId, String siteId, List<String> ids, Long startTime, Long endTime) {
        Query query = new Query();
        query.addCriteria((CriteriaDefinition)Criteria.where((String)"site_id").is((Object)siteId));
        this.b(omadacId, ids, startTime, endTime, query);
    }

    public void b(com.tplink.smb.omada.logmanager.domain.model.e.g omadacId, List<String> ids, Long startTime, Long endTime) {
        Query query = new Query();
        query.addCriteria((CriteriaDefinition)Criteria.where((String)"site_id").is(null));
        this.b(omadacId, ids, startTime, endTime, query);
    }

    private void b(com.tplink.smb.omada.logmanager.domain.model.e.g omadacId, List<String> ids, Long startTime, Long endTime, Query query) {
        query.addCriteria((CriteriaDefinition)Criteria.where((String)"omadac_id").is((Object)omadacId.a()));
        query.addCriteria((CriteriaDefinition)Criteria.where((String)"_id").in(ids));
        Update update = new Update();
        update.set("archived", (Object)true);
        this.iteratorCollectionsByTimeAndSliceKey(Sort.Direction.DESC, startTime / 1000L, endTime / 1000L, omadacId, collectionName -> this.mongoTemplate.updateMulti(query, (UpdateDefinition)update, OmadaAlertSitePO.class, collectionName));
    }

    private static long a(long startTime, long endTime) {
        long interval = endTime - startTime;
        if (interval >= 1814400L) {
            return 259200L;
        }
        if (interval >= 1209600L) {
            return 172800L;
        }
        if (interval >= 604800L) {
            return 86400L;
        }
        if (interval >= 172800L) {
            return 21600L;
        }
        return 14400L;
    }

    public Long a(String omadacId, String siteId, String collectionName, com.tplink.smb.omada.common.gridquery.a grid) {
        return this.mongoTemplate.count(this.a(grid.getFilters(), grid.getSearchFilters(), (boolean)Boolean.FALSE, omadacId, siteId), OmadaAlertSitePO.class, collectionName);
    }

    public List<w> a(String omadacId, String siteId, String collectionName, com.tplink.smb.omada.common.gridquery.a grid, Long skip, Integer limit) {
        Query query = this.a(grid.getFilters(), grid.getSearchFilters(), (boolean)Boolean.FALSE, omadacId, siteId);
        com.tplink.smb.omada.logmanager.port.mongo.a.a.a(query, grid.getQuerySorts());
        query.skip(skip.longValue());
        query.limit(limit.intValue());
        return this.mongoTemplate.find(query, OmadaAlertSitePO.class, collectionName).stream().map(h::a).collect(Collectors.toList());
    }

    public void c(w omadaLog) {
        String logKey = omadaLog.a(omadaLog.getOmadaLogEnum(), omadaLog.i());
        String logModule = omadaLog.b(omadaLog.getOmadaLogEnum(), omadaLog.j());
        Query query = new Query();
        Criteria criteria = Criteria.where((String)"omadac_id").is((Object)omadaLog.getOmadacId().a());
        criteria.and("site_id").is((Object)omadaLog.getSiteId().a());
        criteria.and("key").is((Object)logKey);
        criteria.and("device_mac").is((Object)omadaLog.r());
        criteria.and("resolved").is((Object)false);
        Long endTime = System.currentTimeMillis();
        Long startTime = com.tplink.smb.omada.logmanager.domain.model.a.b.a((Long)endTime, (Integer)7);
        criteria.and("time").gte((Object)startTime).lte((Object)endTime);
        query.addCriteria((CriteriaDefinition)criteria);
        Update update = new Update();
        update.set("omadac_id", (Object)omadaLog.getOmadacId().a());
        update.set("site_id", (Object)omadaLog.getSiteId().a());
        update.set("device_type", (Object)omadaLog.h());
        update.set("device_name", (Object)omadaLog.q());
        update.set("device_mac", (Object)omadaLog.r());
        update.set("device_model", (Object)omadaLog.s());
        update.set("device_model_version", (Object)omadaLog.t());
        update.set("content", (Object)omadaLog.getContent());
        update.set("level", (Object)omadaLog.o());
        update.set("resolved", (Object)false);
        update.set("module", (Object)logModule);
        update.set("key", (Object)logKey);
        update.set("time", (Object)omadaLog.getTime().getTime());
        update.set("auto_resolve", (Object)omadaLog.x());
        update.set("alert_id", (Object)omadaLog.K());
        AtomicBoolean exist = new AtomicBoolean(false);
        this.iteratorCollectionsByTimeAndSliceKey(Sort.Direction.DESC, startTime / 1000L, endTime / 1000L, omadaLog.getOmadacId(), collectionName -> {
            if (exist.get()) {
                return;
            }
            if (this.mongoTemplate.exists(query, collectionName)) {
                this.mongoTemplate.updateFirst(query, (UpdateDefinition)update, collectionName);
                exist.set(true);
            }
        });
        if (!exist.get()) {
            String collectionName2 = this.getCollectionNameForSave(com.tplink.smb.omada.logmanager.port.mongo.log.h.a(omadaLog));
            if (Boolean.TRUE.equals(omadaLog.L())) {
                update.set("first_time", (Object)omadaLog.getTime().getTime());
            }
            this.mongoTemplate.upsert(query, (UpdateDefinition)update, collectionName2);
        }
        omadaLog.e(Boolean.valueOf(false));
    }

    public void a() {
        long currentTime = System.currentTimeMillis() / 1000L;
        long timeEnd = currentTime - 604800L;
        long timeStart = currentTime - 2592000L;
        this.iteratorCollectionsByTime(Sort.Direction.DESC, timeStart, timeEnd, collectionName -> this.checkThenEnsureIndexes((String)collectionName, this.getIndexDefinitions()));
    }

    public void b(com.tplink.smb.omada.logmanager.domain.model.e.g omadacId) {
        this.iteratorCollectionsBySliceKey(omadacId, collectionName -> this.mongoTemplate.dropCollection(collectionName));
    }

    private List<LogClassifyInfoDTO> a(Criteria criteria, String groupKey, String omadacId, Long startTime, Long endTime) {
        Aggregation aggregation = Aggregation.newAggregation((AggregationOperation[])new AggregationOperation[]{Aggregation.match((Criteria)criteria), Aggregation.group((String[])new String[]{groupKey}).count().as("countNumber")});
        ArrayList logGroupInfoDTOS = new ArrayList();
        this.iteratorCollectionsByTimeAndSliceKey(Sort.Direction.DESC, startTime / 1000L, endTime / 1000L, new com.tplink.smb.omada.logmanager.domain.model.e.g(omadacId), collectionName -> logGroupInfoDTOS.addAll(this.mongoTemplate.aggregate(aggregation, collectionName, LogClassifyInfoDTO.class).getMappedResults()));
        Map<String, LongSummaryStatistics> statisticsMap = logGroupInfoDTOS.stream().collect(Collectors.groupingBy(LogClassifyInfoDTO::getId, Collectors.summarizingLong(LogClassifyInfoDTO::getCountNumber)));
        ArrayList<LogClassifyInfoDTO> logGroupInfo = new ArrayList<LogClassifyInfoDTO>();
        for (Map.Entry<String, LongSummaryStatistics> entry : statisticsMap.entrySet()) {
            logGroupInfo.add(LogClassifyInfoDTO.builder().id(entry.getKey()).countNumber(Long.valueOf(entry.getValue().getSum())).build());
        }
        return logGroupInfo;
    }

    protected int c(@Nullable com.tplink.smb.omada.logmanager.domain.model.e.g key) {
        if (Objects.isNull(key)) {
            return 0;
        }
        return key.a().hashCode();
    }

    protected com.tplink.smb.omada.logmanager.port.mongo.data.a.h b() {
        return this.c;
    }

    protected Class getPOClass() {
        return OmadaAlertSitePO.class;
    }

    protected MongoTemplate getMongoTemplate() {
        return this.mongoTemplate;
    }

    @Nonnull
    protected String getCollectionNameOrPrefixIfSliced() {
        return "siteomadaalert";
    }

    @Nonnull
    protected IndexDefinition[] getIndexDefinitions() {
        return OmadaAlertSitePO.INDEX_DEFINITIONS;
    }

    public void a(com.tplink.smb.omada.logmanager.port.commom.service.a.c event) {
        this.dbMaintenance(event.a());
    }

    @PostConstruct
    public void c() {
        DomainEventBusHolder.getHandlerRegistry().registerSync(com.tplink.smb.omada.logmanager.port.commom.service.a.c.class, (DomainEventSubscriber)this);
    }

    protected /* synthetic */ p getStrategy() {
        return this.b();
    }

    protected /* synthetic */ int hashCodeOfKey(@Nullable Object object) {
        return this.c((com.tplink.smb.omada.logmanager.domain.model.e.g)object);
    }

    protected /* synthetic */ u getStrategy() {
        return this.b();
    }

    public /* synthetic */ void handleEvent(Object object) {
        this.a((com.tplink.smb.omada.logmanager.port.commom.service.a.c)object);
    }
}

