/*
 * Decompiled with CFR 0.152.
 */
package com.tplink.smb.omada.logmanager.port.mongo.log;

import com.mongodb.bulk.BulkWriteResult;
import com.tplink.smb.eventcenter.api.event.DomainEventSubscriber;
import com.tplink.smb.eventcenter.domain.DomainEventBusHolder;
import com.tplink.smb.omada.common.gridquery.e;
import com.tplink.smb.omada.common.gridquery.g;
import com.tplink.smb.omada.common.mongo.repository.p;
import com.tplink.smb.omada.common.mongo.repository.q;
import com.tplink.smb.omada.common.mongo.repository.u;
import com.tplink.smb.omada.common.util.T;
import com.tplink.smb.omada.logmanager.api.external.dto.ArchiveDTO;
import com.tplink.smb.omada.logmanager.api.internal.dto.LogClassifyInfoRequestDTO;
import com.tplink.smb.omada.logmanager.api.internal.dto.LogTypeEnum;
import com.tplink.smb.omada.logmanager.domain.model.e.i;
import com.tplink.smb.omada.logmanager.domain.model.log.AbstractOmadaLog;
import com.tplink.smb.omada.logmanager.domain.model.log.LogClassifyInfoDTO;
import com.tplink.smb.omada.logmanager.domain.model.log.LogClassifyNumberQueryDTO;
import com.tplink.smb.omada.logmanager.domain.model.log.LogGroupDTO;
import com.tplink.smb.omada.logmanager.domain.model.log.LogGroupInfoDTO;
import com.tplink.smb.omada.logmanager.domain.model.log.o;
import com.tplink.smb.omada.logmanager.domain.model.log.subscriber.AlertNumClassifyInfoDTO;
import com.tplink.smb.omada.logmanager.domain.model.log.w;
import com.tplink.smb.omada.logmanager.port.mongo.a.a;
import com.tplink.smb.omada.logmanager.port.mongo.a.c;
import com.tplink.smb.omada.logmanager.port.mongo.log.LiteOmadaLogSitePO;
import com.tplink.smb.omada.logmanager.port.mongo.log.m;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.LongSummaryStatistics;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.PostConstruct;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;
import org.springframework.data.mongodb.core.BulkOperations;
import org.springframework.data.mongodb.core.MongoTemplate;
import org.springframework.data.mongodb.core.aggregation.Aggregation;
import org.springframework.data.mongodb.core.aggregation.AggregationOperation;
import org.springframework.data.mongodb.core.index.IndexDefinition;
import org.springframework.data.mongodb.core.query.Criteria;
import org.springframework.data.mongodb.core.query.CriteriaDefinition;
import org.springframework.data.mongodb.core.query.Query;
import org.springframework.data.mongodb.core.query.Update;
import org.springframework.data.mongodb.core.query.UpdateDefinition;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;

@Component
public class d
extends q<LiteOmadaLogSitePO, com.tplink.smb.omada.logmanager.domain.model.e.g>
implements DomainEventSubscriber<com.tplink.smb.omada.logmanager.port.commom.service.a.c>,
o {
    @Generated
    private static final Logger a = LoggerFactory.getLogger(d.class);
    @Autowired
    @Qualifier(value="dataMongoTemplate")
    private MongoTemplate mongoTemplate;
    @Autowired
    private com.tplink.smb.omada.logmanager.port.mongo.data.a.d b;

    public void a(List<w> omadaLogs) {
        if (CollectionUtils.isEmpty(omadaLogs)) {
            return;
        }
        Map<String, List<LiteOmadaLogSitePO>> collectionNameToPOsMap = omadaLogs.stream().map(m::d).collect(Collectors.groupingBy(x$0 -> this.getCollectionNameForSave(x$0)));
        collectionNameToPOsMap.forEach((collectionName, poList) -> {
            BulkOperations bulkOperations = this.mongoTemplate.bulkOps(BulkOperations.BulkMode.UNORDERED, collectionName);
            poList.forEach(liteOmadaLogPO -> bulkOperations.insert(liteOmadaLogPO));
            BulkWriteResult result = bulkOperations.execute();
            a.debug("Bulk write lite site omada log result: {}", (Object)result);
        });
    }

    public long a(com.tplink.smb.omada.logmanager.domain.model.e.g omadacId, i siteId, Long startTime, Long endTime) {
        Query query = new Query();
        Criteria criteria = Criteria.where((String)"omadac_id").is((Object)omadacId.a());
        criteria.and("site").is((Object)siteId.a());
        criteria.and("alert").is((Object)Boolean.TRUE);
        criteria.and("archived").is((Object)Boolean.FALSE);
        criteria.and("time").gte((Object)startTime).lte((Object)endTime);
        query.addCriteria((CriteriaDefinition)criteria);
        AtomicLong total = new AtomicLong(0L);
        this.iteratorCollectionsByTimeAndSliceKey(Sort.Direction.DESC, startTime / 1000L, endTime / 1000L, omadacId, collectionName -> total.addAndGet(this.mongoTemplate.count(query, collectionName)));
        return total.get();
    }

    public com.tplink.smb.omada.common.gridquery.a<w> a(com.tplink.smb.omada.common.gridquery.a<w> grid, String omadacId, String siteId) {
        long count = this.a((List<com.tplink.smb.omada.common.gridquery.c>)grid.getFilters(), (List<com.tplink.smb.omada.common.gridquery.c>)grid.getSearchFilters(), omadacId, siteId, ((e)grid.getQuerySorts().get(0)).a());
        grid.setTotalRows(count);
        if (count < 1L) {
            grid.setData(Collections.EMPTY_LIST);
            return grid;
        }
        grid.setData(this.a(grid.getQueryPage(), grid.getQuerySorts(), grid.getFilters(), grid.getSearchFilters(), omadacId, siteId, count));
        return grid;
    }

    public List<String> a(String omadacId, Long startTime, Long endTime, g direction) {
        ArrayList<String> collectionNames = new ArrayList<String>();
        this.iteratorCollectionsByTimeAndSliceKey(g.a.equals((Object)direction) ? Sort.Direction.DESC : Sort.Direction.ASC, startTime, endTime, new com.tplink.smb.omada.logmanager.domain.model.e.g(omadacId), collectionName -> collectionNames.add((String)collectionName));
        return collectionNames;
    }

    public Long a(LogClassifyNumberQueryDTO logClassifyNumberQueryDTO) {
        Query query = new Query();
        Criteria criteria = Criteria.where((String)"omadac_id").is((Object)logClassifyNumberQueryDTO.getOmadacId());
        Boolean alert = logClassifyNumberQueryDTO.getAlert();
        if (Boolean.TRUE.equals(alert)) {
            criteria.and("alert").is((Object)true);
        }
        criteria.and("level").is((Object)logClassifyNumberQueryDTO.getLevel());
        Long startTime = logClassifyNumberQueryDTO.getStartTime();
        Long endTime = logClassifyNumberQueryDTO.getEndTime();
        criteria.and("time").gte((Object)startTime).lte((Object)endTime);
        if (Objects.nonNull(logClassifyNumberQueryDTO.getArchived())) {
            criteria.and("archived").is((Object)logClassifyNumberQueryDTO.getArchived());
        }
        if (!T.a((String)logClassifyNumberQueryDTO.getModule())) {
            criteria.and("module").is((Object)logClassifyNumberQueryDTO.getModule());
        }
        criteria.and("site").is((Object)logClassifyNumberQueryDTO.getSiteId());
        if (!T.a((String)logClassifyNumberQueryDTO.getSearchKey())) {
            criteria.andOperator(new Criteria[]{com.tplink.smb.omada.logmanager.port.mongo.a.d.a(com.tplink.smb.omada.logmanager.port.mongo.a.d.b(logClassifyNumberQueryDTO.getSearchKey()))});
        }
        query.addCriteria((CriteriaDefinition)criteria);
        AtomicLong total = new AtomicLong(0L);
        this.iteratorCollectionsByTimeAndSliceKey(Sort.Direction.DESC, startTime / 1000L, endTime / 1000L, new com.tplink.smb.omada.logmanager.domain.model.e.g(logClassifyNumberQueryDTO.getOmadacId()), collectionName -> total.addAndGet(this.mongoTemplate.count(query, LiteOmadaLogSitePO.class, collectionName)));
        return total.get();
    }

    public w a(String omadacId, String logId) {
        Query query = new Query();
        Criteria criteria = Criteria.where((String)"omadac_id").is((Object)omadacId);
        criteria.and("_id").is((Object)logId);
        query.addCriteria((CriteriaDefinition)criteria);
        ArrayList liteOmadaLogPOS = new ArrayList();
        this.iteratorCollectionsBySliceKey(new com.tplink.smb.omada.logmanager.domain.model.e.g(omadacId), collectionName -> liteOmadaLogPOS.addAll(this.mongoTemplate.find(query, LiteOmadaLogSitePO.class, collectionName)));
        if (CollectionUtils.isEmpty(liteOmadaLogPOS) || liteOmadaLogPOS.size() > 1) {
            a.warn("fail to find lite site omada Log by omadacId :{}, logId :{}", (Object)omadacId, (Object)logId);
            return null;
        }
        return m.a((LiteOmadaLogSitePO)liteOmadaLogPOS.get(0));
    }

    public void a(w omadaLog) {
        LiteOmadaLogSitePO liteOmadaLogPO = m.d(omadaLog);
        String collectionName = this.getCollectionNameForSave(liteOmadaLogPO);
        this.iteratorCollectionsBySliceKey(omadaLog.getOmadacId(), logPo -> this.mongoTemplate.save((Object)liteOmadaLogPO, collectionName));
    }

    public void a(String omadacId, String siteId, ArchiveDTO archiveDTO) {
        Criteria criteria = new Criteria("omadac_id").is((Object)omadacId);
        criteria.and("site").is((Object)siteId);
        criteria.and("archived").is((Object)false);
        criteria.and("alert").is((Object)true);
        Query query = Query.query((CriteriaDefinition)criteria);
        Long startTime = archiveDTO.getTimeStart() / 1000L;
        Long endTime = archiveDTO.getTimeEnd() / 1000L;
        query.addCriteria((CriteriaDefinition)Criteria.where((String)"time").gte((Object)archiveDTO.getTimeStart()).lte((Object)archiveDTO.getTimeEnd()));
        this.iteratorCollectionsByTimeAndSliceKey(Sort.Direction.DESC, startTime, endTime, new com.tplink.smb.omada.logmanager.domain.model.e.g(omadacId), collectionName -> this.mongoTemplate.updateMulti(query, (UpdateDefinition)Update.update((String)"archived", (Object)true), LiteOmadaLogSitePO.class, collectionName));
    }

    public void a(String omadacId, String site, Boolean deleteAlert, Long startTime, Long endTime) {
        Query query = new Query();
        query.addCriteria((CriteriaDefinition)Criteria.where((String)"omadac_id").is((Object)omadacId));
        query.addCriteria((CriteriaDefinition)Criteria.where((String)"site").is((Object)site));
        if (deleteAlert.booleanValue()) {
            query.addCriteria((CriteriaDefinition)Criteria.where((String)"alert").is((Object)true));
        }
        query.addCriteria((CriteriaDefinition)Criteria.where((String)"time").gte((Object)startTime).lte((Object)endTime));
        this.iteratorCollectionsByTimeAndSliceKey(Sort.Direction.DESC, startTime / 1000L, endTime / 1000L, new com.tplink.smb.omada.logmanager.domain.model.e.g(omadacId), collectionName -> this.mongoTemplate.remove(query, LiteOmadaLogSitePO.class, collectionName));
    }

    public long a(List<com.tplink.smb.omada.common.gridquery.c> filters, List<com.tplink.smb.omada.common.gridquery.c> searchFilters, String omadacId, String siteId, g direction) {
        if (Objects.isNull(filters)) {
            filters = new ArrayList<com.tplink.smb.omada.common.gridquery.c>();
        }
        Long[] times = com.tplink.smb.omada.logmanager.port.mongo.a.d.a(filters);
        Query query = this.a(filters, searchFilters, omadacId, siteId);
        AtomicLong total = new AtomicLong(0L);
        this.iteratorCollectionsByTimeAndSliceKey(direction.a().equals("asc") ? Sort.Direction.ASC : Sort.Direction.DESC, times[0], times[1], new com.tplink.smb.omada.logmanager.domain.model.e.g(omadacId), collectionName -> total.addAndGet(this.mongoTemplate.count(query, LiteOmadaLogSitePO.class, collectionName)));
        return total.get();
    }

    public List<w> a(String omadacId, String siteId, com.tplink.smb.omada.common.gridquery.d queryPage) {
        Query query = new Query();
        query.with((Pageable)PageRequest.of((int)queryPage.a(), (int)queryPage.b()));
        query.addCriteria((CriteriaDefinition)Criteria.where((String)"omadac_id").is((Object)omadacId));
        query.with(Sort.by((Sort.Order[])new Sort.Order[]{Sort.Order.desc((String)"time")}));
        ArrayList<w> omadaLogs = new ArrayList<w>();
        long endTime = System.currentTimeMillis() / 1000L;
        this.iteratorCollectionsByTimeAndSliceKeyWithSkip(Sort.Direction.DESC, 0L, endTime, new com.tplink.smb.omada.logmanager.domain.model.e.g(omadacId), query, (collectionName, queryCollection) -> omadaLogs.addAll(this.mongoTemplate.find(queryCollection, LiteOmadaLogSitePO.class, collectionName).stream().map(m::a).collect(Collectors.toList())));
        return omadaLogs;
    }

    public List<w> a(com.tplink.smb.omada.common.gridquery.d page, List<e> sort, List<com.tplink.smb.omada.common.gridquery.c> filters, List<com.tplink.smb.omada.common.gridquery.c> searchFilters, String omadacId, String siteKey, long count) {
        if (Objects.isNull(filters)) {
            filters = new ArrayList<com.tplink.smb.omada.common.gridquery.c>();
        }
        Query query = this.a(filters, searchFilters, omadacId, siteKey);
        Long[] times = com.tplink.smb.omada.logmanager.port.mongo.a.d.a(filters);
        boolean reverse = this.a(page, query, sort, Sort.Direction.fromString((String)sort.get(0).a().a()), count);
        Sort.Direction direction = sort.get(0).a().a().equals("asc") ? Sort.Direction.ASC : Sort.Direction.DESC;
        com.tplink.smb.omada.logmanager.port.mongo.a.a.a(query, sort);
        ArrayList liteOmmadaLogPOS = new ArrayList();
        this.iteratorCollectionsByTimeAndSliceKeyWithSkip(direction, times[0], times[1], new com.tplink.smb.omada.logmanager.domain.model.e.g(omadacId), query, (collectionName, queryFilter) -> liteOmmadaLogPOS.addAll(this.mongoTemplate.find(queryFilter, LiteOmadaLogSitePO.class, collectionName)));
        if (reverse) {
            return liteOmmadaLogPOS.stream().map(m::a).sorted(Comparator.comparing(AbstractOmadaLog::getTime).reversed()).collect(Collectors.toList());
        }
        return liteOmmadaLogPOS.stream().map(m::a).collect(Collectors.toList());
    }

    private boolean a(com.tplink.smb.omada.common.gridquery.d page, Query query, List<e> querySorts, Sort.Direction direction, long count) {
        int pageSize;
        if (Objects.isNull(page)) {
            return false;
        }
        int pageNum = page.a();
        if ((long)(pageNum * (pageSize = page.b()) * 2) < count) {
            query.limit(page.b()).skip((long)(page.a() * page.b()));
            return false;
        }
        int lastPageSize = (int)(count % (long)pageSize);
        int reversePageNum = (int)(count - (long)(pageNum * pageSize)) / pageSize;
        page.a(reversePageNum);
        if (lastPageSize > 0) {
            if (reversePageNum == 0) {
                query.limit(lastPageSize);
            } else {
                query.limit(page.b()).skip((long)(lastPageSize + (reversePageNum - 1) * page.b()));
            }
        } else {
            query.limit(page.b()).skip((long)(reversePageNum * page.b()));
        }
        if (!CollectionUtils.isEmpty(querySorts)) {
            for (e sort : querySorts) {
                if (direction.isAscending()) {
                    sort.a(g.a);
                    continue;
                }
                sort.a(g.b);
            }
        }
        return true;
    }

    public Query a(List<com.tplink.smb.omada.common.gridquery.c> filters, List<com.tplink.smb.omada.common.gridquery.c> searchFilters, String omadacId, String siteKey) {
        if (CollectionUtils.isEmpty(filters)) {
            filters = new ArrayList<com.tplink.smb.omada.common.gridquery.c>(4);
        }
        Criteria criteria = com.tplink.smb.omada.logmanager.port.mongo.a.a.b(searchFilters, filters);
        criteria.and("omadac_id").is((Object)omadacId);
        criteria.and("site").is((Object)siteKey);
        return new Query((CriteriaDefinition)criteria);
    }

    public Query a(List<com.tplink.smb.omada.common.gridquery.c> filters, List<com.tplink.smb.omada.common.gridquery.c> searchFilters, boolean isRoot, String omadacId, String siteKey) {
        if (CollectionUtils.isEmpty(filters)) {
            filters = new ArrayList<com.tplink.smb.omada.common.gridquery.c>(4);
        }
        if (CollectionUtils.isEmpty(searchFilters)) {
            searchFilters = new ArrayList<com.tplink.smb.omada.common.gridquery.c>(4);
        }
        filters = c.d(filters, searchFilters);
        Criteria criteria = com.tplink.smb.omada.logmanager.port.mongo.a.a.b(searchFilters, filters);
        criteria.and("omadac_id").is((Object)omadacId);
        if (isRoot && Objects.nonNull(siteKey)) {
            HashSet<String> siteIdQuery = new HashSet<String>(2);
            siteIdQuery.add(siteKey);
            siteIdQuery.add(null);
            criteria.and("site").in(siteIdQuery);
        } else {
            criteria.and("site").is((Object)siteKey);
        }
        return new Query((CriteriaDefinition)criteria);
    }

    public List<LogGroupInfoDTO> a(LogClassifyInfoRequestDTO logClassifyInfoRequestDTO, String ... groupKeys) {
        String omadacId = logClassifyInfoRequestDTO.getOmadacId();
        String siteId = logClassifyInfoRequestDTO.getSiteId();
        Long startTime = logClassifyInfoRequestDTO.getStartTime();
        Long endTime = logClassifyInfoRequestDTO.getEndTime();
        Criteria criteria = Criteria.where((String)"omadac_id").is((Object)omadacId);
        criteria.and("site").is((Object)siteId);
        if (LogTypeEnum.a.equals((Object)logClassifyInfoRequestDTO.getLogTypeEnum())) {
            criteria.and("alert").is((Object)Boolean.TRUE);
        }
        criteria.and("time").gte((Object)startTime).lte((Object)endTime);
        if (Objects.nonNull(logClassifyInfoRequestDTO.getDeviceType()) && T.b((String)logClassifyInfoRequestDTO.getDeviceType().b())) {
            criteria.and("device_type").is((Object)logClassifyInfoRequestDTO.getDeviceType().c());
        }
        Aggregation aggregation = Aggregation.newAggregation((AggregationOperation[])new AggregationOperation[]{Aggregation.match((Criteria)criteria), Aggregation.group((String[])groupKeys).count().as("countNumber")});
        ArrayList logGroupInfoDTOS = new ArrayList();
        this.iteratorCollectionsByTimeAndSliceKey(Sort.Direction.DESC, startTime / 1000L, endTime / 1000L, new com.tplink.smb.omada.logmanager.domain.model.e.g(omadacId), collectionName -> logGroupInfoDTOS.addAll(this.mongoTemplate.aggregate(aggregation, collectionName, LogGroupInfoDTO.class).getMappedResults()));
        Map<LogGroupDTO, LongSummaryStatistics> statisticsMap = logGroupInfoDTOS.stream().collect(Collectors.groupingBy(LogGroupInfoDTO::getId, Collectors.summarizingLong(LogGroupInfoDTO::getCountNumber)));
        ArrayList<LogGroupInfoDTO> logGroupList = new ArrayList<LogGroupInfoDTO>();
        for (Map.Entry<LogGroupDTO, LongSummaryStatistics> entry : statisticsMap.entrySet()) {
            logGroupList.add(LogGroupInfoDTO.builder().id(entry.getKey()).countNumber(Long.valueOf(entry.getValue().getSum())).build());
        }
        return logGroupList;
    }

    public List<LogClassifyInfoDTO> b(LogClassifyNumberQueryDTO logClassifyNumberQueryDTO) {
        String omadacId = logClassifyNumberQueryDTO.getOmadacId();
        Criteria criteria = Criteria.where((String)"omadac_id").is((Object)omadacId);
        criteria.and("site").is((Object)logClassifyNumberQueryDTO.getSiteId());
        Boolean alert = logClassifyNumberQueryDTO.getAlert();
        if (Boolean.TRUE.equals(alert)) {
            criteria.and("alert").is((Object)true);
        }
        long startTime = logClassifyNumberQueryDTO.getStartTime();
        long endTime = logClassifyNumberQueryDTO.getEndTime();
        criteria.and("time").gte((Object)startTime).lte((Object)endTime);
        if (Objects.nonNull(logClassifyNumberQueryDTO.getArchived())) {
            criteria.and("archived").is((Object)logClassifyNumberQueryDTO.getArchived());
        }
        if (!T.a((String)logClassifyNumberQueryDTO.getModule())) {
            criteria.and("module").is((Object)logClassifyNumberQueryDTO.getModule());
        }
        if (!T.a((String)logClassifyNumberQueryDTO.getSearchKey())) {
            criteria.andOperator(new Criteria[]{com.tplink.smb.omada.logmanager.port.mongo.a.d.a(com.tplink.smb.omada.logmanager.port.mongo.a.d.b(logClassifyNumberQueryDTO.getSearchKey()))});
        }
        Aggregation aggregation = Aggregation.newAggregation((AggregationOperation[])new AggregationOperation[]{Aggregation.match((Criteria)criteria), Aggregation.group((String[])new String[]{logClassifyNumberQueryDTO.getGroupKey()}).count().as("countNumber")});
        ArrayList logGroupInfoDTOS = new ArrayList();
        this.iteratorCollectionsByTimeAndSliceKey(Sort.Direction.DESC, startTime / 1000L, endTime / 1000L, new com.tplink.smb.omada.logmanager.domain.model.e.g(omadacId), collectionName -> logGroupInfoDTOS.addAll(this.mongoTemplate.aggregate(aggregation, collectionName, LogClassifyInfoDTO.class).getMappedResults()));
        Map<String, LongSummaryStatistics> statisticsMap = logGroupInfoDTOS.stream().collect(Collectors.groupingBy(LogClassifyInfoDTO::getId, Collectors.summarizingLong(LogClassifyInfoDTO::getCountNumber)));
        ArrayList<LogClassifyInfoDTO> logGroupInfo = new ArrayList<LogClassifyInfoDTO>();
        for (Map.Entry<String, LongSummaryStatistics> entry : statisticsMap.entrySet()) {
            logGroupInfo.add(LogClassifyInfoDTO.builder().id(entry.getKey()).countNumber(Long.valueOf(entry.getValue().getSum())).build());
        }
        return logGroupInfo;
    }

    public Map<String, Long> a(com.tplink.smb.omada.logmanager.domain.model.e.g omadacId, Set<String> sites, Long startTime, Long endTime) {
        Criteria criteria = Criteria.where((String)"omadac_id").is((Object)omadacId.a());
        criteria.and("site").in(sites);
        criteria.and("time").gte((Object)startTime).lte((Object)endTime);
        criteria.and("archived").is((Object)Boolean.FALSE);
        criteria.and("alert").is((Object)Boolean.TRUE);
        Aggregation aggregation = Aggregation.newAggregation((AggregationOperation[])new AggregationOperation[]{Aggregation.match((Criteria)criteria), Aggregation.group((String[])new String[]{"site"}).count().as("alertNumber")});
        ArrayList numClassifyInfoDTOS = new ArrayList();
        this.iteratorCollectionsByTimeAndSliceKey(Sort.Direction.DESC, startTime / 1000L, endTime / 1000L, omadacId, collectionName -> numClassifyInfoDTOS.addAll(this.mongoTemplate.aggregate(aggregation, collectionName, AlertNumClassifyInfoDTO.class).getMappedResults()));
        Map<String, LongSummaryStatistics> statisticsMap = numClassifyInfoDTOS.stream().collect(Collectors.groupingBy(AlertNumClassifyInfoDTO::getId, Collectors.summarizingLong(AlertNumClassifyInfoDTO::getAlertNumber)));
        HashMap<String, Long> sitesAlertNumMap = new HashMap<String, Long>(statisticsMap.size());
        for (Map.Entry<String, LongSummaryStatistics> entry : statisticsMap.entrySet()) {
            sitesAlertNumMap.put(entry.getKey(), entry.getValue().getSum());
        }
        return sitesAlertNumMap;
    }

    public void a(com.tplink.smb.omada.logmanager.domain.model.e.g omadacId, String siteId, List<String> ids, Long startTime, Long endTime) {
        Query query = new Query();
        query.addCriteria((CriteriaDefinition)Criteria.where((String)"omadac_id").is((Object)omadacId.a()));
        query.addCriteria((CriteriaDefinition)Criteria.where((String)"site").is((Object)siteId));
        query.addCriteria((CriteriaDefinition)Criteria.where((String)"_id").in(ids));
        AtomicInteger clearedNum = new AtomicInteger(0);
        int topNum = ids.size();
        this.iteratorCollectionsByTimeAndSliceKey(Sort.Direction.DESC, startTime / 1000L, endTime / 1000L, omadacId, collectionName -> {
            if (clearedNum.get() >= topNum) {
                return;
            }
            int removed = (int)this.mongoTemplate.remove(query, collectionName).getDeletedCount();
            clearedNum.addAndGet(removed);
        });
    }

    public void b(com.tplink.smb.omada.logmanager.domain.model.e.g omadacId, String siteId, List<String> ids, Long startTime, Long endTime) {
        Query query = new Query();
        query.addCriteria((CriteriaDefinition)Criteria.where((String)"omadac_id").is((Object)omadacId.a()));
        query.addCriteria((CriteriaDefinition)Criteria.where((String)"site").is((Object)siteId));
        query.addCriteria((CriteriaDefinition)Criteria.where((String)"_id").in(ids));
        Update update = new Update();
        update.set("archived", (Object)true);
        this.iteratorCollectionsByTimeAndSliceKey(Sort.Direction.DESC, startTime / 1000L, endTime / 1000L, omadacId, collectionName -> this.mongoTemplate.updateMulti(query, (UpdateDefinition)update, LiteOmadaLogSitePO.class, collectionName));
    }

    public Long a(String omadacId, String siteId, String collectionName, com.tplink.smb.omada.common.gridquery.a grid, List<String> alertKeys) {
        return this.mongoTemplate.count(this.a(grid.getFilters(), grid.getSearchFilters(), (boolean)Boolean.FALSE, omadacId, siteId, alertKeys), LiteOmadaLogSitePO.class, collectionName);
    }

    public Long b(String omadacId, String siteId, String collectionName, com.tplink.smb.omada.common.gridquery.a grid, List<String> eventKeys) {
        return this.mongoTemplate.count(this.b(grid.getFilters(), grid.getSearchFilters(), Boolean.FALSE, omadacId, siteId, eventKeys), LiteOmadaLogSitePO.class, collectionName);
    }

    public List<w> a(String omadacId, String siteId, String collectionName, com.tplink.smb.omada.common.gridquery.a grid, Long skip, Integer limit, List<String> alertKeys) {
        Query query = this.a(grid.getFilters(), grid.getSearchFilters(), (boolean)Boolean.FALSE, omadacId, siteId, alertKeys);
        com.tplink.smb.omada.logmanager.port.mongo.a.a.a(query, grid.getQuerySorts());
        query.skip(skip.longValue());
        query.limit(limit.intValue());
        return this.mongoTemplate.find(query, LiteOmadaLogSitePO.class, collectionName).stream().map(m::a).collect(Collectors.toList());
    }

    public List<w> b(String omadacId, String siteId, String collectionName, com.tplink.smb.omada.common.gridquery.a grid, Long skip, Integer limit, List<String> eventKeys) {
        Query query = this.b(grid.getFilters(), grid.getSearchFilters(), Boolean.FALSE, omadacId, siteId, eventKeys);
        com.tplink.smb.omada.logmanager.port.mongo.a.a.a(query, grid.getQuerySorts());
        query.skip(skip.longValue());
        query.limit(limit.intValue());
        return this.mongoTemplate.find(query, LiteOmadaLogSitePO.class, collectionName).stream().map(m::a).collect(Collectors.toList());
    }

    public Long a(String omadacId, String siteId, com.tplink.smb.omada.common.gridquery.a<w> grid, Long startTime, Long endTime, List<String> alertKeys) {
        grid.setFilters(c.b(grid.getFilters()));
        grid.setFilters(c.c(grid.getFilters()));
        Criteria criteria = this.c(grid.getFilters(), grid.getSearchFilters(), omadacId, siteId);
        criteria.and("key").in(alertKeys);
        Query query = new Query((CriteriaDefinition)criteria);
        AtomicLong count = new AtomicLong();
        this.iteratorCollectionsByTimeAndSliceKey(Sort.Direction.DESC, startTime / 1000L, endTime / 1000L, new com.tplink.smb.omada.logmanager.domain.model.e.g(omadacId), collectionName -> count.addAndGet(this.mongoTemplate.count(query, LiteOmadaLogSitePO.class, collectionName)));
        return count.get();
    }

    public Long b(String omadacId, String siteId, com.tplink.smb.omada.common.gridquery.a<w> grid, Long startTime, Long endTime, List<String> alertKeys) {
        grid.setFilters(c.b(grid.getFilters()));
        grid.setFilters(c.c(grid.getFilters()));
        Criteria criteria = this.c(grid.getFilters(), grid.getSearchFilters(), omadacId, siteId);
        criteria.and("key").in(alertKeys);
        criteria.and("archived").is((Object)true);
        Query query = new Query((CriteriaDefinition)criteria);
        AtomicLong count = new AtomicLong();
        this.iteratorCollectionsByTimeAndSliceKey(Sort.Direction.DESC, startTime / 1000L, endTime / 1000L, new com.tplink.smb.omada.logmanager.domain.model.e.g(omadacId), collectionName -> count.addAndGet(this.mongoTemplate.count(query, LiteOmadaLogSitePO.class, collectionName)));
        return count.get();
    }

    public Long c(String omadacId, String siteId, com.tplink.smb.omada.common.gridquery.a<w> grid, Long startTime, Long endTime, List<String> alertKeys) {
        grid.setFilters(c.b(grid.getFilters()));
        grid.setFilters(c.c(grid.getFilters()));
        Criteria criteria = this.c(grid.getFilters(), grid.getSearchFilters(), omadacId, siteId);
        criteria.and("key").in(alertKeys);
        criteria.and("archived").is((Object)false);
        Query query = new Query((CriteriaDefinition)criteria);
        AtomicLong count = new AtomicLong();
        this.iteratorCollectionsByTimeAndSliceKey(Sort.Direction.DESC, startTime / 1000L, endTime / 1000L, new com.tplink.smb.omada.logmanager.domain.model.e.g(omadacId), collectionName -> count.addAndGet(this.mongoTemplate.count(query, LiteOmadaLogSitePO.class, collectionName)));
        return count.get();
    }

    public List<LogClassifyInfoDTO> d(String omadacId, String siteId, com.tplink.smb.omada.common.gridquery.a<w> grid, Long startTime, Long endTime, List<String> alertKeys) {
        grid.setFilters(c.b(grid.getFilters()));
        grid.setFilters(c.c(grid.getFilters()));
        Criteria criteria = this.c(grid.getFilters(), grid.getSearchFilters(), omadacId, siteId);
        criteria.and("key").in(alertKeys);
        return this.a(criteria, "module", omadacId, startTime, endTime);
    }

    public List<LogClassifyInfoDTO> e(String omadacId, String siteId, com.tplink.smb.omada.common.gridquery.a<w> grid, Long startTime, Long endTime, List<String> alertKeys) {
        grid.setFilters(c.b(grid.getFilters()));
        Criteria criteria = this.c(grid.getFilters(), grid.getSearchFilters(), omadacId, siteId);
        criteria.and("key").in(alertKeys);
        return this.a(criteria, "level", omadacId, startTime, endTime);
    }

    public List<LogClassifyInfoDTO> f(String omadacId, String siteId, com.tplink.smb.omada.common.gridquery.a<w> grid, Long startTime, Long endTime, List<String> alertKeys) {
        grid.setFilters(c.b(grid.getFilters()));
        grid.setFilters(c.c(grid.getFilters()));
        Criteria criteria = this.c(grid.getFilters(), grid.getSearchFilters(), omadacId, siteId);
        criteria.and("key").in(alertKeys);
        criteria.and("archived").is((Object)true);
        return this.a(criteria, "module", omadacId, startTime, endTime);
    }

    public List<LogClassifyInfoDTO> g(String omadacId, String siteId, com.tplink.smb.omada.common.gridquery.a<w> grid, Long startTime, Long endTime, List<String> alertKeys) {
        grid.setFilters(c.b(grid.getFilters()));
        Criteria criteria = this.c(grid.getFilters(), grid.getSearchFilters(), omadacId, siteId);
        criteria.and("key").in(alertKeys);
        criteria.and("archived").is((Object)true);
        return this.a(criteria, "level", omadacId, startTime, endTime);
    }

    public List<LogClassifyInfoDTO> h(String omadacId, String siteId, com.tplink.smb.omada.common.gridquery.a<w> grid, Long startTime, Long endTime, List<String> alertKeys) {
        grid.setFilters(c.b(grid.getFilters()));
        grid.setFilters(c.c(grid.getFilters()));
        Criteria criteria = this.c(grid.getFilters(), grid.getSearchFilters(), omadacId, siteId);
        criteria.and("key").in(alertKeys);
        criteria.and("archived").is((Object)false);
        return this.a(criteria, "module", omadacId, startTime, endTime);
    }

    public List<LogClassifyInfoDTO> i(String omadacId, String siteId, com.tplink.smb.omada.common.gridquery.a<w> grid, Long startTime, Long endTime, List<String> alertKeys) {
        grid.setFilters(c.b(grid.getFilters()));
        Criteria criteria = this.c(grid.getFilters(), grid.getSearchFilters(), omadacId, siteId);
        criteria.and("key").in(alertKeys);
        criteria.and("archived").is((Object)false);
        return this.a(criteria, "level", omadacId, startTime, endTime);
    }

    public Long j(String omadacId, String siteId, com.tplink.smb.omada.common.gridquery.a<w> grid, Long startTime, Long endTime, List<String> eventKeys) {
        grid.setFilters(c.b(grid.getFilters()));
        grid.setFilters(c.c(grid.getFilters()));
        Criteria criteria = this.b(grid.getFilters(), grid.getSearchFilters(), omadacId, siteId);
        criteria.and("key").in(eventKeys);
        Query query = new Query((CriteriaDefinition)criteria);
        AtomicLong count = new AtomicLong();
        this.iteratorCollectionsByTimeAndSliceKey(Sort.Direction.DESC, startTime / 1000L, endTime / 1000L, new com.tplink.smb.omada.logmanager.domain.model.e.g(omadacId), collectionName -> count.addAndGet(this.mongoTemplate.count(query, LiteOmadaLogSitePO.class, collectionName)));
        return count.get();
    }

    public List<LogClassifyInfoDTO> k(String omadacId, String siteId, com.tplink.smb.omada.common.gridquery.a<w> grid, Long startTime, Long endTime, List<String> eventKeys) {
        grid.setFilters(c.b(grid.getFilters()));
        grid.setFilters(c.c(grid.getFilters()));
        Criteria criteria = this.b(grid.getFilters(), grid.getSearchFilters(), omadacId, siteId);
        criteria.and("key").in(eventKeys);
        return this.a(criteria, "module", omadacId, startTime, endTime);
    }

    public void a(com.tplink.smb.omada.logmanager.domain.model.e.g omadacId, String siteId, com.tplink.smb.omada.common.gridquery.a<w> grid, List<String> ids, List<String> alertKeys, Long startTime, Long endTime, Boolean isAlert) {
        ArrayList<w> omadaLogs = new ArrayList<w>();
        if (!CollectionUtils.isEmpty(ids)) {
            Criteria criteria = Criteria.where((String)"_id").in(ids).and("omadac_id").is((Object)omadacId.a()).and("site").is((Object)siteId);
            Query idQuery = new Query((CriteriaDefinition)criteria);
            this.iteratorCollectionsByTimeAndSliceKey(Sort.Direction.DESC, startTime / 1000L, endTime / 1000L, omadacId, collectionName -> omadaLogs.addAll(this.mongoTemplate.find(idQuery, LiteOmadaLogSitePO.class, collectionName).stream().map(m::a).collect(Collectors.toList())));
        }
        for (w omadalog : omadaLogs) {
            ids.remove(omadalog.getId().a());
        }
        grid.setFilters(c.a(grid.getFilters()));
        Query query = this.a((List<com.tplink.smb.omada.common.gridquery.c>)grid.getFilters(), (List<com.tplink.smb.omada.common.gridquery.c>)grid.getSearchFilters(), false, omadacId.a(), siteId);
        if (isAlert.booleanValue()) {
            query.addCriteria((CriteriaDefinition)Criteria.where((String)"key").in(alertKeys));
        }
        this.iteratorCollectionsByTimeAndSliceKey(Sort.Direction.DESC, startTime / 1000L, endTime / 1000L, omadacId, collectionName -> this.mongoTemplate.remove(query, collectionName));
        if (!CollectionUtils.isEmpty(omadaLogs)) {
            this.a(omadaLogs);
        }
    }

    public Map<String, Long> a(com.tplink.smb.omada.logmanager.domain.model.e.g omadacId, Set<String> sites, Long startTime, Long endTime, List<String> alertKeys) {
        Criteria criteria = Criteria.where((String)"omadac_id").is((Object)omadacId.a());
        criteria.and("site").in(sites);
        criteria.and("time").gte((Object)startTime).lte((Object)endTime);
        criteria.and("archived").is((Object)Boolean.FALSE);
        criteria.and("key").in(alertKeys);
        Aggregation aggregation = Aggregation.newAggregation((AggregationOperation[])new AggregationOperation[]{Aggregation.match((Criteria)criteria), Aggregation.group((String[])new String[]{"site"}).count().as("alertNumber")});
        ArrayList numClassifyInfoDTOS = new ArrayList();
        this.iteratorCollectionsByTimeAndSliceKey(Sort.Direction.DESC, startTime / 1000L, endTime / 1000L, omadacId, collectionName -> numClassifyInfoDTOS.addAll(this.mongoTemplate.aggregate(aggregation, collectionName, AlertNumClassifyInfoDTO.class).getMappedResults()));
        Map<String, LongSummaryStatistics> statisticsMap = numClassifyInfoDTOS.stream().collect(Collectors.groupingBy(AlertNumClassifyInfoDTO::getId, Collectors.summarizingLong(AlertNumClassifyInfoDTO::getAlertNumber)));
        HashMap<String, Long> sitesAlertNumMap = new HashMap<String, Long>(statisticsMap.size());
        for (Map.Entry<String, LongSummaryStatistics> entry : statisticsMap.entrySet()) {
            sitesAlertNumMap.put(entry.getKey(), entry.getValue().getSum());
        }
        return sitesAlertNumMap;
    }

    public long a(com.tplink.smb.omada.logmanager.domain.model.e.g omadacId, i siteId, Long startTime, Long endTime, List<String> alertKeys) {
        Query query = new Query();
        Criteria criteria = Criteria.where((String)"omadac_id").is((Object)omadacId.a());
        criteria.and("site").is((Object)siteId.a());
        criteria.and("archived").is((Object)Boolean.FALSE);
        criteria.and("time").gte((Object)startTime).lte((Object)endTime);
        criteria.and("key").in(alertKeys);
        query.addCriteria((CriteriaDefinition)criteria);
        AtomicLong total = new AtomicLong(0L);
        this.iteratorCollectionsByTimeAndSliceKey(Sort.Direction.DESC, startTime / 1000L, endTime / 1000L, omadacId, collectionName -> total.addAndGet(this.mongoTemplate.count(query, collectionName)));
        return total.get();
    }

    public void a(String omadacId, String siteId, Boolean rootLag, ArchiveDTO archiveDTO, com.tplink.smb.omada.common.gridquery.a<w> grid, List<String> alertKeys) {
        grid.setFilters(c.a(grid.getFilters()));
        Query query = this.a(grid.getFilters(), grid.getSearchFilters(), (boolean)rootLag, omadacId, siteId, alertKeys);
        Long startTime = archiveDTO.getTimeStart() / 1000L;
        Long endTime = archiveDTO.getTimeEnd() / 1000L;
        query.addCriteria((CriteriaDefinition)Criteria.where((String)"time").gte((Object)archiveDTO.getTimeStart()).lte((Object)archiveDTO.getTimeEnd()));
        this.iteratorCollectionsByTimeAndSliceKey(Sort.Direction.DESC, startTime, endTime, new com.tplink.smb.omada.logmanager.domain.model.e.g(omadacId), collectionName -> this.mongoTemplate.updateMulti(query, (UpdateDefinition)Update.update((String)"archived", (Object)true), LiteOmadaLogSitePO.class, collectionName));
        if (!CollectionUtils.isEmpty((Collection)archiveDTO.getLogs())) {
            Criteria criteria = Criteria.where((String)"_id").in((Collection)archiveDTO.getLogs()).and("omadac_id").is((Object)omadacId).and("site").is((Object)siteId);
            Query idQuery = new Query((CriteriaDefinition)criteria);
            this.iteratorCollectionsByTimeAndSliceKey(Sort.Direction.DESC, startTime, endTime, new com.tplink.smb.omada.logmanager.domain.model.e.g(omadacId), collectionName -> this.mongoTemplate.updateMulti(idQuery, (UpdateDefinition)Update.update((String)"archived", (Object)false), LiteOmadaLogSitePO.class, collectionName));
        }
    }

    public void b(w omadaLog) {
        if (Objects.isNull(omadaLog.getId()) || T.a((String)omadaLog.getId().a())) {
            a.warn("Failed to archived site omada log:{}", (Object)omadaLog.toString());
            return;
        }
        String collectionName = this.getCollectionNameForSave(m.d(omadaLog));
        this.iteratorCollectionsBySliceKey(omadaLog.getOmadacId(), logPo -> this.mongoTemplate.updateFirst(new Query((CriteriaDefinition)Criteria.where((String)"_id").is((Object)omadaLog.getId().a())), (UpdateDefinition)Update.update((String)"archived", (Object)true), LiteOmadaLogSitePO.class, collectionName));
    }

    public Criteria b(List<com.tplink.smb.omada.common.gridquery.c> filters, List<com.tplink.smb.omada.common.gridquery.c> searchFilters, String omadacId, String siteKey) {
        if (CollectionUtils.isEmpty(filters)) {
            filters = new ArrayList<com.tplink.smb.omada.common.gridquery.c>(4);
        }
        if (CollectionUtils.isEmpty(searchFilters)) {
            searchFilters = new ArrayList<com.tplink.smb.omada.common.gridquery.c>(4);
        }
        filters = c.d(filters, searchFilters);
        Criteria criteria = com.tplink.smb.omada.logmanager.port.mongo.a.a.b(searchFilters, filters);
        criteria.and("omadac_id").is((Object)omadacId);
        criteria.and("site").is((Object)siteKey);
        return criteria;
    }

    private List<LogClassifyInfoDTO> a(Criteria criteria, String groupKey, String omadacId, Long startTime, Long endTime) {
        Aggregation aggregation = Aggregation.newAggregation((AggregationOperation[])new AggregationOperation[]{Aggregation.match((Criteria)criteria), Aggregation.group((String[])new String[]{groupKey}).count().as("countNumber")});
        ArrayList logGroupInfoDTOS = new ArrayList();
        this.iteratorCollectionsByTimeAndSliceKey(Sort.Direction.DESC, startTime / 1000L, endTime / 1000L, new com.tplink.smb.omada.logmanager.domain.model.e.g(omadacId), collectionName -> logGroupInfoDTOS.addAll(this.mongoTemplate.aggregate(aggregation, collectionName, LogClassifyInfoDTO.class).getMappedResults()));
        Map<String, LongSummaryStatistics> statisticsMap = logGroupInfoDTOS.stream().collect(Collectors.groupingBy(LogClassifyInfoDTO::getId, Collectors.summarizingLong(LogClassifyInfoDTO::getCountNumber)));
        ArrayList<LogClassifyInfoDTO> logGroupInfo = new ArrayList<LogClassifyInfoDTO>();
        for (Map.Entry<String, LongSummaryStatistics> entry : statisticsMap.entrySet()) {
            logGroupInfo.add(LogClassifyInfoDTO.builder().id(entry.getKey()).countNumber(Long.valueOf(entry.getValue().getSum())).build());
        }
        return logGroupInfo;
    }

    public Criteria c(List<com.tplink.smb.omada.common.gridquery.c> filters, List<com.tplink.smb.omada.common.gridquery.c> searchFilters, String omadacId, String siteKey) {
        if (CollectionUtils.isEmpty(filters)) {
            filters = new ArrayList<com.tplink.smb.omada.common.gridquery.c>(4);
        }
        if (CollectionUtils.isEmpty(searchFilters)) {
            searchFilters = new ArrayList<com.tplink.smb.omada.common.gridquery.c>(4);
        }
        filters = c.c(filters, searchFilters);
        Criteria criteria = com.tplink.smb.omada.logmanager.port.mongo.a.a.b(searchFilters, filters);
        criteria.and("omadac_id").is((Object)omadacId);
        criteria.and("site").is((Object)siteKey);
        return criteria;
    }

    private Query a(List<com.tplink.smb.omada.common.gridquery.c> filters, List<com.tplink.smb.omada.common.gridquery.c> searchFilters, boolean isRoot, String omadacId, String siteKey, List<String> alertKeys) {
        if (CollectionUtils.isEmpty(filters)) {
            filters = new ArrayList<com.tplink.smb.omada.common.gridquery.c>(4);
        }
        if (CollectionUtils.isEmpty(searchFilters)) {
            searchFilters = new ArrayList<com.tplink.smb.omada.common.gridquery.c>(4);
        }
        filters = c.c(filters, searchFilters);
        Criteria criteria = com.tplink.smb.omada.logmanager.port.mongo.a.a.b(searchFilters, filters);
        criteria.and("omadac_id").is((Object)omadacId);
        if (isRoot && Objects.nonNull(siteKey)) {
            HashSet<String> siteIdQuery = new HashSet<String>(2);
            siteIdQuery.add(siteKey);
            siteIdQuery.add(null);
            criteria.and("site").in(siteIdQuery);
        } else {
            criteria.and("site").is((Object)siteKey);
        }
        criteria.and("key").in(alertKeys);
        return new Query((CriteriaDefinition)criteria);
    }

    private Query b(List<com.tplink.smb.omada.common.gridquery.c> filters, List<com.tplink.smb.omada.common.gridquery.c> searchFilters, boolean isRoot, String omadacId, String siteKey, List<String> eventKeys) {
        if (CollectionUtils.isEmpty(filters)) {
            filters = new ArrayList<com.tplink.smb.omada.common.gridquery.c>(4);
        }
        if (CollectionUtils.isEmpty(searchFilters)) {
            searchFilters = new ArrayList<com.tplink.smb.omada.common.gridquery.c>(4);
        }
        filters = c.d(filters, searchFilters);
        Criteria criteria = com.tplink.smb.omada.logmanager.port.mongo.a.a.b(searchFilters, filters);
        criteria.and("omadac_id").is((Object)omadacId);
        if (isRoot && Objects.nonNull(siteKey)) {
            HashSet<String> siteIdQuery = new HashSet<String>(2);
            siteIdQuery.add(siteKey);
            siteIdQuery.add(null);
            criteria.and("site").in(siteIdQuery);
        } else {
            criteria.and("site").is((Object)siteKey);
        }
        criteria.and("key").in(eventKeys);
        return new Query((CriteriaDefinition)criteria);
    }

    protected int a(@Nullable com.tplink.smb.omada.logmanager.domain.model.e.g key) {
        if (Objects.isNull(key)) {
            return 0;
        }
        return key.a().hashCode();
    }

    protected com.tplink.smb.omada.logmanager.port.mongo.data.a.d a() {
        return this.b;
    }

    protected Class getPOClass() {
        return LiteOmadaLogSitePO.class;
    }

    protected MongoTemplate getMongoTemplate() {
        return this.mongoTemplate;
    }

    @Nonnull
    protected String getCollectionNameOrPrefixIfSliced() {
        return "litesiteomadalog";
    }

    @Nonnull
    protected IndexDefinition[] getIndexDefinitions() {
        return LiteOmadaLogSitePO.INDEX_DEFINITIONS;
    }

    public void a(com.tplink.smb.omada.logmanager.port.commom.service.a.c event) {
        this.dbMaintenance(event.a());
    }

    @PostConstruct
    public void b() {
        DomainEventBusHolder.getHandlerRegistry().registerSync(com.tplink.smb.omada.logmanager.port.commom.service.a.c.class, (DomainEventSubscriber)this);
    }

    protected /* synthetic */ p getStrategy() {
        return this.a();
    }

    protected /* synthetic */ int hashCodeOfKey(@Nullable Object object) {
        return this.a((com.tplink.smb.omada.logmanager.domain.model.e.g)object);
    }

    protected /* synthetic */ u getStrategy() {
        return this.a();
    }

    public /* synthetic */ void handleEvent(Object object) {
        this.a((com.tplink.smb.omada.logmanager.port.commom.service.a.c)object);
    }
}

