/*
 * Decompiled with CFR 0.152.
 */
package com.tplink.smb.omada.logmanager.port.mongo.log.c;

import com.mongodb.bulk.BulkWriteResult;
import com.tplink.smb.eventcenter.api.event.DomainEventSubscriber;
import com.tplink.smb.eventcenter.domain.DomainEventBusHolder;
import com.tplink.smb.omada.common.gridquery.e;
import com.tplink.smb.omada.common.gridquery.g;
import com.tplink.smb.omada.common.mongo.repository.p;
import com.tplink.smb.omada.common.mongo.repository.q;
import com.tplink.smb.omada.common.mongo.repository.u;
import com.tplink.smb.omada.common.util.T;
import com.tplink.smb.omada.logmanager.api.external.dto.ArchiveDTO;
import com.tplink.smb.omada.logmanager.domain.model.log.AbstractOmadaLog;
import com.tplink.smb.omada.logmanager.domain.model.log.LogClassifyInfoDTO;
import com.tplink.smb.omada.logmanager.domain.model.log.LogClassifyNumberQueryDTO;
import com.tplink.smb.omada.logmanager.domain.model.log.w;
import com.tplink.smb.omada.logmanager.port.commom.c.b;
import com.tplink.smb.omada.logmanager.port.mongo.a.a;
import com.tplink.smb.omada.logmanager.port.mongo.a.d;
import com.tplink.smb.omada.logmanager.port.mongo.log.OmadaLogMspPO;
import com.tplink.smb.omada.logmanager.port.mongo.log.m;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import jakarta.annotation.PostConstruct;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.LongSummaryStatistics;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import java.util.stream.Collectors;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;
import org.springframework.data.mongodb.core.BulkOperations;
import org.springframework.data.mongodb.core.MongoTemplate;
import org.springframework.data.mongodb.core.aggregation.Aggregation;
import org.springframework.data.mongodb.core.aggregation.AggregationOperation;
import org.springframework.data.mongodb.core.index.IndexDefinition;
import org.springframework.data.mongodb.core.query.Criteria;
import org.springframework.data.mongodb.core.query.CriteriaDefinition;
import org.springframework.data.mongodb.core.query.Query;
import org.springframework.data.mongodb.core.query.Update;
import org.springframework.data.mongodb.core.query.UpdateDefinition;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;

@Component
public class c
extends q<OmadaLogMspPO, String>
implements DomainEventSubscriber<com.tplink.smb.omada.logmanager.port.commom.service.a.c>,
com.tplink.smb.omada.logmanager.domain.model.log.b.d {
    @Generated
    private static final Logger a = LoggerFactory.getLogger(c.class);
    @Autowired
    @Qualifier(value="dataMongoTemplate")
    private MongoTemplate mongoTemplate;
    @Autowired
    private com.tplink.smb.omada.logmanager.port.mongo.data.a.m b;
    @Autowired
    private b c;
    private static final String d = "count-log-by-mspId";
    private static final String e = "delete-msp-logs-by-type";

    public void a(List<w> omadaLogs) {
        if (CollectionUtils.isEmpty(omadaLogs)) {
            return;
        }
        Map<String, List<OmadaLogMspPO>> collectionNameToPOsMap = omadaLogs.stream().map(m::f).collect(Collectors.groupingBy(x$0 -> this.getCollectionNameForSave(x$0)));
        collectionNameToPOsMap.forEach((collectionName, poList) -> {
            BulkOperations bulkOperations = this.mongoTemplate.bulkOps(BulkOperations.BulkMode.UNORDERED, collectionName);
            poList.forEach(omadaLogPO -> bulkOperations.insert(omadaLogPO));
            BulkWriteResult result = bulkOperations.execute();
            a.debug("Bulk write omada log result: {}", (Object)result);
        });
    }

    public com.tplink.smb.omada.common.gridquery.a<w> a(com.tplink.smb.omada.common.gridquery.a<w> grid, String mspId) {
        long count = this.a((List<com.tplink.smb.omada.common.gridquery.c>)grid.getFilters(), (List<com.tplink.smb.omada.common.gridquery.c>)grid.getSearchFilters(), mspId, ((e)grid.getQuerySorts().get(0)).a());
        grid.setTotalRows(count);
        if (count < 1L) {
            grid.setData(Collections.EMPTY_LIST);
            return grid;
        }
        grid.setData(this.a(grid.getQueryPage(), grid.getQuerySorts(), grid.getFilters(), grid.getSearchFilters(), mspId, count));
        return grid;
    }

    private long a(List<com.tplink.smb.omada.common.gridquery.c> filters, List<com.tplink.smb.omada.common.gridquery.c> searchFilters, String mspId, g direction) {
        if (Objects.isNull(filters)) {
            filters = new ArrayList<com.tplink.smb.omada.common.gridquery.c>();
        }
        Long[] times = com.tplink.smb.omada.logmanager.port.mongo.a.d.a(filters);
        Query query = this.c(filters, searchFilters, mspId);
        AtomicLong total = new AtomicLong(0L);
        this.iteratorCollectionsByTimeAndSliceKey(direction.a().equals("asc") ? Sort.Direction.ASC : Sort.Direction.DESC, times[0], times[1], mspId, collectionName -> total.addAndGet(this.mongoTemplate.count(query, OmadaLogMspPO.class, collectionName)));
        return total.get();
    }

    private Query c(List<com.tplink.smb.omada.common.gridquery.c> filters, List<com.tplink.smb.omada.common.gridquery.c> searchFilters, String mspId) {
        if (CollectionUtils.isEmpty(filters)) {
            filters = new ArrayList<com.tplink.smb.omada.common.gridquery.c>(4);
        }
        if (CollectionUtils.isEmpty(searchFilters)) {
            searchFilters = new ArrayList<com.tplink.smb.omada.common.gridquery.c>(4);
        }
        filters = com.tplink.smb.omada.logmanager.port.mongo.a.c.d(filters, searchFilters);
        Criteria criteria = com.tplink.smb.omada.logmanager.port.mongo.a.a.b(searchFilters, filters);
        return new Query((CriteriaDefinition)new Criteria().andOperator(new Criteria[]{criteria, new Criteria("msp_id").is((Object)mspId)}));
    }

    public List<w> a(com.tplink.smb.omada.common.gridquery.d page, List<e> sort, List<com.tplink.smb.omada.common.gridquery.c> filters, List<com.tplink.smb.omada.common.gridquery.c> searchFilters, String mspId, long count) {
        if (Objects.isNull(filters)) {
            filters = new ArrayList<com.tplink.smb.omada.common.gridquery.c>();
        }
        Query query = this.c(filters, searchFilters, mspId);
        Long[] times = com.tplink.smb.omada.logmanager.port.mongo.a.d.a(filters);
        boolean reverse = this.a(page, query, sort, Sort.Direction.fromString((String)sort.get(0).a().a()), count);
        Sort.Direction direction = sort.get(0).a().a().equals("asc") ? Sort.Direction.ASC : Sort.Direction.DESC;
        com.tplink.smb.omada.logmanager.port.mongo.a.a.a(query, sort);
        ArrayList omadaLogMspPOS = new ArrayList();
        this.iteratorCollectionsByTimeAndSliceKeyWithSkip(direction, times[0], times[1], mspId, query, (collectionName, queryFilter) -> omadaLogMspPOS.addAll(this.mongoTemplate.find(query, OmadaLogMspPO.class, collectionName)));
        if (reverse) {
            return omadaLogMspPOS.stream().map(m::a).sorted(Comparator.comparing(AbstractOmadaLog::getTime).reversed()).collect(Collectors.toList());
        }
        return omadaLogMspPOS.stream().map(m::a).collect(Collectors.toList());
    }

    private boolean a(com.tplink.smb.omada.common.gridquery.d page, Query query, List<e> querySorts, Sort.Direction direction, long count) {
        int pageSize;
        if (Objects.isNull(page)) {
            return false;
        }
        int pageNum = page.a();
        if ((long)(pageNum * (pageSize = page.b()) * 2) < count) {
            query.limit(page.b()).skip((long)(page.a() * page.b()));
            return false;
        }
        int lastPageSize = (int)(count % (long)pageSize);
        int reversePageNum = (int)(count - (long)(pageNum * pageSize)) / pageSize;
        page.a(reversePageNum);
        if (lastPageSize > 0) {
            if (reversePageNum == 0) {
                query.limit(lastPageSize);
            } else {
                query.limit(page.b()).skip((long)(lastPageSize + (reversePageNum - 1) * page.b()));
            }
        } else {
            query.limit(page.b()).skip((long)(reversePageNum * page.b()));
        }
        if (!CollectionUtils.isEmpty(querySorts)) {
            for (e sort : querySorts) {
                if (direction.isAscending()) {
                    sort.a(g.a);
                    continue;
                }
                sort.a(g.b);
            }
        }
        return true;
    }

    public long a(String mspId, Long startTime, Long endTime) {
        this.c.c(d);
        Query query = new Query();
        Criteria criteria = Criteria.where((String)"msp_id").is((Object)mspId);
        criteria.and("alert").is((Object)Boolean.TRUE);
        criteria.and("archived").is((Object)Boolean.FALSE);
        criteria.and("time").gte((Object)startTime).lte((Object)endTime);
        query.addCriteria((CriteriaDefinition)criteria);
        AtomicLong total = new AtomicLong(0L);
        this.iteratorCollectionsByTimeAndSliceKey(Sort.Direction.DESC, startTime / 1000L, endTime / 1000L, mspId, collectionName -> total.addAndGet(this.mongoTemplate.count(query, collectionName)));
        return total.get();
    }

    public long a(String mspId, Long startTime, Long endTime, List<String> alertKeys) {
        this.c.c(d);
        Query query = new Query();
        Criteria criteria = Criteria.where((String)"msp_id").is((Object)mspId);
        criteria.and("archived").is((Object)Boolean.FALSE);
        criteria.and("time").gte((Object)startTime).lte((Object)endTime);
        criteria.and("key").in(alertKeys);
        query.addCriteria((CriteriaDefinition)criteria);
        AtomicLong total = new AtomicLong(0L);
        this.iteratorCollectionsByTimeAndSliceKey(Sort.Direction.DESC, startTime / 1000L, endTime / 1000L, mspId, collectionName -> total.addAndGet(this.mongoTemplate.count(query, collectionName)));
        return total.get();
    }

    public w a(String mspId, String logId) {
        Query query = new Query();
        Criteria criteria = Criteria.where((String)"msp_id").is((Object)mspId);
        criteria.and("_id").is((Object)logId);
        query.addCriteria((CriteriaDefinition)criteria);
        ArrayList mspLogPOS = new ArrayList();
        this.iteratorCollectionsBySliceKey(mspId, collectionName -> mspLogPOS.addAll(this.mongoTemplate.find(query, OmadaLogMspPO.class, collectionName)));
        if (CollectionUtils.isEmpty(mspLogPOS) || mspLogPOS.size() > 1) {
            a.warn("Fail to find omada msp log by mspId :{}, logId :{}", (Object)mspId, (Object)logId);
            return null;
        }
        return m.a((OmadaLogMspPO)mspLogPOS.get(0));
    }

    public void a(w omadaLog) {
        OmadaLogMspPO mspLogPO = m.f(omadaLog);
        String collectionName = this.getCollectionNameForSave(mspLogPO);
        this.iteratorCollectionsBySliceKey(omadaLog.getMspId(), logPo -> this.mongoTemplate.save((Object)mspLogPO, collectionName));
    }

    public void a(String mspId, ArchiveDTO archiveDTO) {
        Query query = new Query();
        query.addCriteria((CriteriaDefinition)Criteria.where((String)"msp_id").is((Object)mspId));
        query.addCriteria((CriteriaDefinition)Criteria.where((String)"archived").is((Object)false));
        query.addCriteria((CriteriaDefinition)Criteria.where((String)"alert").is((Object)true));
        Long startTime = archiveDTO.getTimeStart() / 1000L;
        Long endTime = archiveDTO.getTimeEnd() / 1000L;
        query.addCriteria((CriteriaDefinition)Criteria.where((String)"time").gte((Object)archiveDTO.getTimeStart()).lte((Object)archiveDTO.getTimeEnd()));
        this.iteratorCollectionsByTimeAndSliceKey(Sort.Direction.DESC, startTime, endTime, mspId, collectionName -> this.mongoTemplate.updateMulti(query, (UpdateDefinition)Update.update((String)"archived", (Object)true), OmadaLogMspPO.class, collectionName));
    }

    public void a(String mspId, ArchiveDTO archiveDTO, com.tplink.smb.omada.common.gridquery.a<w> grid, List<String> alertKeys) {
        grid.setFilters(com.tplink.smb.omada.logmanager.port.mongo.a.c.a(grid.getFilters()));
        Query query = this.a((List<com.tplink.smb.omada.common.gridquery.c>)grid.getFilters(), (List<com.tplink.smb.omada.common.gridquery.c>)grid.getSearchFilters(), mspId, alertKeys);
        Long startTime = archiveDTO.getTimeStart() / 1000L;
        Long endTime = archiveDTO.getTimeEnd() / 1000L;
        query.addCriteria((CriteriaDefinition)Criteria.where((String)"time").gte((Object)archiveDTO.getTimeStart()).lte((Object)archiveDTO.getTimeEnd()));
        this.iteratorCollectionsByTimeAndSliceKey(Sort.Direction.DESC, startTime, endTime, mspId, collectionName -> this.mongoTemplate.updateMulti(query, (UpdateDefinition)Update.update((String)"archived", (Object)true), OmadaLogMspPO.class, collectionName));
        if (!CollectionUtils.isEmpty((Collection)archiveDTO.getLogs())) {
            Criteria criteria = Criteria.where((String)"_id").in((Collection)archiveDTO.getLogs()).and("msp_id").is((Object)mspId);
            Query idQuery = new Query((CriteriaDefinition)criteria);
            this.iteratorCollectionsByTimeAndSliceKey(Sort.Direction.DESC, startTime, endTime, mspId, collectionName -> this.mongoTemplate.updateMulti(idQuery, (UpdateDefinition)Update.update((String)"archived", (Object)false), OmadaLogMspPO.class, collectionName));
        }
    }

    public List<LogClassifyInfoDTO> a(LogClassifyNumberQueryDTO logClassifyNumberQueryDTO) {
        String mspId = logClassifyNumberQueryDTO.getMspId();
        Criteria criteria = Criteria.where((String)"msp_id").is((Object)mspId);
        Boolean alert = logClassifyNumberQueryDTO.getAlert();
        Boolean event = logClassifyNumberQueryDTO.getEvent();
        if (Boolean.TRUE.equals(alert)) {
            criteria.and("alert").is((Object)true);
        }
        if (Boolean.TRUE.equals(event)) {
            criteria.and("event").is((Object)true);
        }
        long startTime = logClassifyNumberQueryDTO.getStartTime();
        long endTime = logClassifyNumberQueryDTO.getEndTime();
        criteria.and("time").gte((Object)startTime).lte((Object)endTime);
        if (Objects.nonNull(logClassifyNumberQueryDTO.getArchived())) {
            criteria.and("archived").is((Object)logClassifyNumberQueryDTO.getArchived());
        }
        if (!T.a((String)logClassifyNumberQueryDTO.getModule())) {
            criteria.and("module").is((Object)logClassifyNumberQueryDTO.getModule());
        }
        if (!T.a((String)logClassifyNumberQueryDTO.getSearchKey())) {
            criteria.andOperator(new Criteria[]{com.tplink.smb.omada.logmanager.port.mongo.a.d.a(com.tplink.smb.omada.logmanager.port.mongo.a.d.b(logClassifyNumberQueryDTO.getSearchKey()))});
        }
        Aggregation aggregation = Aggregation.newAggregation((AggregationOperation[])new AggregationOperation[]{Aggregation.match((Criteria)criteria), Aggregation.group((String[])new String[]{logClassifyNumberQueryDTO.getGroupKey()}).count().as("countNumber")});
        ArrayList logGroupInfoDTOS = new ArrayList();
        this.iteratorCollectionsByTimeAndSliceKey(Sort.Direction.DESC, startTime / 1000L, endTime / 1000L, mspId, collectionName -> logGroupInfoDTOS.addAll(this.mongoTemplate.aggregate(aggregation, collectionName, LogClassifyInfoDTO.class).getMappedResults()));
        Map<String, LongSummaryStatistics> statisticsMap = logGroupInfoDTOS.stream().collect(Collectors.groupingBy(LogClassifyInfoDTO::getId, Collectors.summarizingLong(LogClassifyInfoDTO::getCountNumber)));
        ArrayList<LogClassifyInfoDTO> logGroupInfo = new ArrayList<LogClassifyInfoDTO>();
        for (Map.Entry<String, LongSummaryStatistics> entry : statisticsMap.entrySet()) {
            logGroupInfo.add(LogClassifyInfoDTO.builder().id(entry.getKey()).countNumber(Long.valueOf(entry.getValue().getSum())).build());
        }
        return logGroupInfo;
    }

    public Long a(String mspId, com.tplink.smb.omada.common.gridquery.a<w> grid, Long startTime, Long endTime, List<String> alertKeys) {
        grid.setFilters(com.tplink.smb.omada.logmanager.port.mongo.a.c.b(grid.getFilters()));
        grid.setFilters(com.tplink.smb.omada.logmanager.port.mongo.a.c.c(grid.getFilters()));
        Criteria criteria = this.a((List<com.tplink.smb.omada.common.gridquery.c>)grid.getFilters(), grid.getSearchFilters(), mspId);
        criteria.and("key").in(alertKeys);
        Query query = new Query((CriteriaDefinition)criteria);
        AtomicLong count = new AtomicLong();
        this.iteratorCollectionsByTimeAndSliceKey(Sort.Direction.DESC, startTime / 1000L, endTime / 1000L, mspId, collectionName -> count.addAndGet(this.mongoTemplate.count(query, OmadaLogMspPO.class, collectionName)));
        return count.get();
    }

    public Long b(String mspId, com.tplink.smb.omada.common.gridquery.a<w> grid, Long startTime, Long endTime, List<String> alertKeys) {
        grid.setFilters(com.tplink.smb.omada.logmanager.port.mongo.a.c.b(grid.getFilters()));
        grid.setFilters(com.tplink.smb.omada.logmanager.port.mongo.a.c.c(grid.getFilters()));
        Criteria criteria = this.a((List<com.tplink.smb.omada.common.gridquery.c>)grid.getFilters(), grid.getSearchFilters(), mspId);
        criteria.and("key").in(alertKeys);
        criteria.and("archived").is((Object)true);
        Query query = new Query((CriteriaDefinition)criteria);
        AtomicLong count = new AtomicLong();
        this.iteratorCollectionsByTimeAndSliceKey(Sort.Direction.DESC, startTime / 1000L, endTime / 1000L, mspId, collectionName -> count.addAndGet(this.mongoTemplate.count(query, OmadaLogMspPO.class, collectionName)));
        return count.get();
    }

    public Long c(String mspId, com.tplink.smb.omada.common.gridquery.a<w> grid, Long startTime, Long endTime, List<String> alertKeys) {
        grid.setFilters(com.tplink.smb.omada.logmanager.port.mongo.a.c.b(grid.getFilters()));
        grid.setFilters(com.tplink.smb.omada.logmanager.port.mongo.a.c.c(grid.getFilters()));
        Criteria criteria = this.a((List<com.tplink.smb.omada.common.gridquery.c>)grid.getFilters(), grid.getSearchFilters(), mspId);
        criteria.and("key").in(alertKeys);
        criteria.and("archived").is((Object)false);
        Query query = new Query((CriteriaDefinition)criteria);
        AtomicLong count = new AtomicLong();
        this.iteratorCollectionsByTimeAndSliceKey(Sort.Direction.DESC, startTime / 1000L, endTime / 1000L, mspId, collectionName -> count.addAndGet(this.mongoTemplate.count(query, OmadaLogMspPO.class, collectionName)));
        return count.get();
    }

    public Long d(String mspId, com.tplink.smb.omada.common.gridquery.a<w> grid, Long startTime, Long endTime, List<String> eventKeys) {
        grid.setFilters(com.tplink.smb.omada.logmanager.port.mongo.a.c.b(grid.getFilters()));
        grid.setFilters(com.tplink.smb.omada.logmanager.port.mongo.a.c.c(grid.getFilters()));
        Criteria criteria = this.b((List<com.tplink.smb.omada.common.gridquery.c>)grid.getFilters(), grid.getSearchFilters(), mspId);
        criteria.and("key").in(eventKeys);
        Query query = new Query((CriteriaDefinition)criteria);
        AtomicLong count = new AtomicLong();
        this.iteratorCollectionsByTimeAndSliceKey(Sort.Direction.DESC, startTime / 1000L, endTime / 1000L, mspId, collectionName -> count.addAndGet(this.mongoTemplate.count(query, OmadaLogMspPO.class, collectionName)));
        return count.get();
    }

    public Long a(String mspId, com.tplink.smb.omada.common.gridquery.a<w> grid, Long startTime, Long endTime) {
        grid.setFilters(com.tplink.smb.omada.logmanager.port.mongo.a.c.b(grid.getFilters()));
        grid.setFilters(com.tplink.smb.omada.logmanager.port.mongo.a.c.c(grid.getFilters()));
        Criteria criteria = this.b((List<com.tplink.smb.omada.common.gridquery.c>)grid.getFilters(), grid.getSearchFilters(), mspId);
        Query query = new Query((CriteriaDefinition)criteria);
        AtomicLong count = new AtomicLong();
        this.iteratorCollectionsByTimeAndSliceKey(Sort.Direction.DESC, startTime / 1000L, endTime / 1000L, mspId, collectionName -> count.addAndGet(this.mongoTemplate.count(query, OmadaLogMspPO.class, collectionName)));
        return count.get();
    }

    public List<LogClassifyInfoDTO> e(String mspId, com.tplink.smb.omada.common.gridquery.a<w> grid, Long startTime, Long endTime, List<String> alertKeys) {
        grid.setFilters(com.tplink.smb.omada.logmanager.port.mongo.a.c.b(grid.getFilters()));
        Criteria criteria = this.a((List<com.tplink.smb.omada.common.gridquery.c>)grid.getFilters(), grid.getSearchFilters(), mspId);
        criteria.and("key").in(alertKeys);
        return this.a(criteria, "level", mspId, startTime, endTime);
    }

    public List<LogClassifyInfoDTO> f(String mspId, com.tplink.smb.omada.common.gridquery.a<w> grid, Long startTime, Long endTime, List<String> alertKeys) {
        grid.setFilters(com.tplink.smb.omada.logmanager.port.mongo.a.c.b(grid.getFilters()));
        Criteria criteria = this.a((List<com.tplink.smb.omada.common.gridquery.c>)grid.getFilters(), grid.getSearchFilters(), mspId);
        criteria.and("key").in(alertKeys);
        criteria.and("archived").is((Object)false);
        return this.a(criteria, "level", mspId, startTime, endTime);
    }

    public List<LogClassifyInfoDTO> g(String mspId, com.tplink.smb.omada.common.gridquery.a<w> grid, Long startTime, Long endTime, List<String> alertKeys) {
        grid.setFilters(com.tplink.smb.omada.logmanager.port.mongo.a.c.b(grid.getFilters()));
        Criteria criteria = this.a((List<com.tplink.smb.omada.common.gridquery.c>)grid.getFilters(), grid.getSearchFilters(), mspId);
        criteria.and("key").in(alertKeys);
        criteria.and("archived").is((Object)true);
        return this.a(criteria, "level", mspId, startTime, endTime);
    }

    public List<LogClassifyInfoDTO> h(String mspId, com.tplink.smb.omada.common.gridquery.a<w> grid, Long startTime, Long endTime, List<String> alertKeys) {
        grid.setFilters(com.tplink.smb.omada.logmanager.port.mongo.a.c.b(grid.getFilters()));
        grid.setFilters(com.tplink.smb.omada.logmanager.port.mongo.a.c.c(grid.getFilters()));
        Criteria criteria = this.a((List<com.tplink.smb.omada.common.gridquery.c>)grid.getFilters(), grid.getSearchFilters(), mspId);
        criteria.and("key").in(alertKeys);
        return this.a(criteria, "module", mspId, startTime, endTime);
    }

    public List<LogClassifyInfoDTO> i(String mspId, com.tplink.smb.omada.common.gridquery.a<w> grid, Long startTime, Long endTime, List<String> alertKeys) {
        grid.setFilters(com.tplink.smb.omada.logmanager.port.mongo.a.c.b(grid.getFilters()));
        grid.setFilters(com.tplink.smb.omada.logmanager.port.mongo.a.c.c(grid.getFilters()));
        Criteria criteria = this.a((List<com.tplink.smb.omada.common.gridquery.c>)grid.getFilters(), grid.getSearchFilters(), mspId);
        criteria.and("key").in(alertKeys);
        criteria.and("archived").is((Object)false);
        return this.a(criteria, "module", mspId, startTime, endTime);
    }

    public List<LogClassifyInfoDTO> j(String mspId, com.tplink.smb.omada.common.gridquery.a<w> grid, Long startTime, Long endTime, List<String> alertKeys) {
        grid.setFilters(com.tplink.smb.omada.logmanager.port.mongo.a.c.b(grid.getFilters()));
        grid.setFilters(com.tplink.smb.omada.logmanager.port.mongo.a.c.c(grid.getFilters()));
        Criteria criteria = this.a((List<com.tplink.smb.omada.common.gridquery.c>)grid.getFilters(), grid.getSearchFilters(), mspId);
        criteria.and("key").in(alertKeys);
        criteria.and("archived").is((Object)true);
        return this.a(criteria, "module", mspId, startTime, endTime);
    }

    public List<LogClassifyInfoDTO> k(String mspId, com.tplink.smb.omada.common.gridquery.a<w> grid, Long startTime, Long endTime, List<String> eventKeys) {
        grid.setFilters(com.tplink.smb.omada.logmanager.port.mongo.a.c.b(grid.getFilters()));
        grid.setFilters(com.tplink.smb.omada.logmanager.port.mongo.a.c.c(grid.getFilters()));
        Criteria criteria = this.b((List<com.tplink.smb.omada.common.gridquery.c>)grid.getFilters(), grid.getSearchFilters(), mspId);
        criteria.and("key").in(eventKeys);
        return this.a(criteria, "module", mspId, startTime, endTime);
    }

    public void b(String mspId, Long startTime, Long endTime, List<String> logKeys) {
        this.c.c(e);
        Query query = new Query();
        query.addCriteria((CriteriaDefinition)Criteria.where((String)"msp_id").is((Object)mspId));
        query.addCriteria((CriteriaDefinition)Criteria.where((String)"time").gte((Object)startTime).lte((Object)endTime));
        query.addCriteria((CriteriaDefinition)Criteria.where((String)"key").in(logKeys));
        ArrayList collectionNames = new ArrayList();
        this.iteratorCollectionsByTimeAndSliceKey(Sort.Direction.ASC, startTime / 1000L, endTime / 1000L, mspId, collectionName -> collectionNames.add(collectionName));
        for (String c2 : collectionNames) {
            this.mongoTemplate.remove(query, OmadaLogMspPO.class, c2);
            a.debug("Iterating collection(delete by type): {}", (Object)c2);
        }
    }

    public Long b(LogClassifyNumberQueryDTO logClassifyNumberQueryDTO) {
        Query query = new Query();
        Criteria criteria = Criteria.where((String)"msp_id").is((Object)logClassifyNumberQueryDTO.getMspId());
        criteria.and("level").is((Object)logClassifyNumberQueryDTO.getLevel());
        Long startTime = logClassifyNumberQueryDTO.getStartTime();
        Long endTime = logClassifyNumberQueryDTO.getEndTime();
        criteria.and("time").gte((Object)startTime).lte((Object)endTime);
        Boolean alert = logClassifyNumberQueryDTO.getAlert();
        Boolean event = logClassifyNumberQueryDTO.getEvent();
        if (Boolean.TRUE.equals(alert)) {
            criteria.and("alert").is((Object)true);
        }
        if (Boolean.TRUE.equals(event)) {
            criteria.and("event").is((Object)true);
        }
        if (Objects.nonNull(logClassifyNumberQueryDTO.getArchived())) {
            criteria.and("archived").is((Object)logClassifyNumberQueryDTO.getArchived());
        }
        if (!T.a((String)logClassifyNumberQueryDTO.getModule())) {
            criteria.and("module").is((Object)logClassifyNumberQueryDTO.getModule());
        }
        if (!T.a((String)logClassifyNumberQueryDTO.getSearchKey())) {
            criteria.andOperator(new Criteria[]{com.tplink.smb.omada.logmanager.port.mongo.a.d.a(com.tplink.smb.omada.logmanager.port.mongo.a.d.b(logClassifyNumberQueryDTO.getSearchKey()))});
        }
        query.addCriteria((CriteriaDefinition)criteria);
        AtomicLong total = new AtomicLong(0L);
        this.iteratorCollectionsByTimeAndSliceKey(Sort.Direction.DESC, startTime / 1000L, endTime / 1000L, logClassifyNumberQueryDTO.getMspId(), collectionName -> total.addAndGet(this.mongoTemplate.count(query, OmadaLogMspPO.class, collectionName)));
        return total.get();
    }

    public void a(String mspId, List<String> ids, Long startTime, Long endTime) {
        Query query = new Query();
        AtomicInteger clearedNum = new AtomicInteger(0);
        int topNum = ids.size();
        query.addCriteria((CriteriaDefinition)Criteria.where((String)"msp_id").is((Object)mspId));
        query.addCriteria((CriteriaDefinition)Criteria.where((String)"_id").in(ids));
        this.iteratorCollectionsByTimeAndSliceKey(Sort.Direction.DESC, startTime / 1000L, endTime / 1000L, mspId, collectionName -> {
            if (clearedNum.get() >= topNum) {
                return;
            }
            int removed = (int)this.mongoTemplate.remove(query, collectionName).getDeletedCount();
            clearedNum.addAndGet(removed);
        });
    }

    public void a(String mspId, com.tplink.smb.omada.common.gridquery.a<w> grid, List<String> ids, List<String> alertKeys, Long startTime, Long endTime, Boolean isAlert) {
        ArrayList<w> omadaLogs = new ArrayList<w>();
        if (!CollectionUtils.isEmpty(ids)) {
            Criteria criteria = Criteria.where((String)"_id").in(ids).and("msp_id").is((Object)mspId);
            Query idQuery = new Query((CriteriaDefinition)criteria);
            this.iteratorCollectionsByTimeAndSliceKey(Sort.Direction.DESC, startTime / 1000L, endTime / 1000L, mspId, collectionName -> omadaLogs.addAll(this.mongoTemplate.find(idQuery, OmadaLogMspPO.class, collectionName).stream().map(m::a).collect(Collectors.toList())));
        }
        for (w omadalog : omadaLogs) {
            ids.remove(omadalog.getId().a());
        }
        grid.setFilters(com.tplink.smb.omada.logmanager.port.mongo.a.c.a(grid.getFilters()));
        Query query = this.c(grid.getFilters(), grid.getSearchFilters(), mspId);
        if (isAlert.booleanValue()) {
            query.addCriteria((CriteriaDefinition)Criteria.where((String)"key").in(alertKeys));
        }
        this.iteratorCollectionsByTimeAndSliceKey(Sort.Direction.DESC, startTime / 1000L, endTime / 1000L, mspId, collectionName -> this.mongoTemplate.remove(query, collectionName));
        if (!CollectionUtils.isEmpty(omadaLogs)) {
            this.a(omadaLogs);
        }
    }

    public long a(String mspId, g direction) {
        Query query = new Query();
        Criteria criteria = Criteria.where((String)"msp_id").is((Object)mspId);
        query.addCriteria((CriteriaDefinition)criteria);
        AtomicLong total = new AtomicLong(0L);
        this.iteratorCollectionsByTimeAndSliceKey(Sort.Direction.DESC, 0L, System.currentTimeMillis() / 1000L, mspId, collectionName -> total.addAndGet(this.mongoTemplate.count(query, collectionName)));
        return total.get();
    }

    public List<w> a(String mspId, com.tplink.smb.omada.common.gridquery.d queryPage) {
        Query query = new Query();
        query.with((Pageable)PageRequest.of((int)queryPage.a(), (int)queryPage.b()));
        query.addCriteria((CriteriaDefinition)Criteria.where((String)"msp_id").is((Object)mspId));
        query.with(Sort.by((Sort.Order[])new Sort.Order[]{Sort.Order.desc((String)"time")}));
        ArrayList<w> omadaLogs = new ArrayList<w>();
        this.iteratorCollectionsByTimeDescWithSkip(0L, System.currentTimeMillis() / 1000L, query, (collectionName, queryPage1) -> omadaLogs.addAll(this.mongoTemplate.find(query, OmadaLogMspPO.class, collectionName).stream().map(m::a).collect(Collectors.toList())));
        return omadaLogs;
    }

    public void b(String mspId, List<String> ids, Long startTime, Long endTime) {
        Query query = new Query();
        query.addCriteria((CriteriaDefinition)Criteria.where((String)"msp_id").is((Object)mspId));
        query.addCriteria((CriteriaDefinition)Criteria.where((String)"_id").in(ids));
        Update update = new Update();
        update.set("archived", (Object)true);
        this.iteratorCollectionsByTimeAndSliceKey(Sort.Direction.DESC, startTime / 1000L, endTime / 1000L, mspId, collectionName -> this.mongoTemplate.updateMulti(query, (UpdateDefinition)update, OmadaLogMspPO.class, collectionName));
    }

    public List<String> a(String mspId, Long startTime, Long endTime, g direction) {
        ArrayList<String> collectionNames = new ArrayList<String>();
        this.iteratorCollectionsByTimeAndSliceKey(g.a.equals((Object)direction) ? Sort.Direction.DESC : Sort.Direction.ASC, startTime, endTime, mspId, collectionName -> collectionNames.add((String)collectionName));
        return collectionNames;
    }

    public Long a(String mspId, String collectionName, com.tplink.smb.omada.common.gridquery.a grid) {
        return this.mongoTemplate.count(this.c(grid.getFilters(), grid.getSearchFilters(), mspId), OmadaLogMspPO.class, collectionName);
    }

    public Long a(String mspId, String collectionName, com.tplink.smb.omada.common.gridquery.a grid, List<String> alertKeys) {
        return this.mongoTemplate.count(this.a((List<com.tplink.smb.omada.common.gridquery.c>)grid.getFilters(), (List<com.tplink.smb.omada.common.gridquery.c>)grid.getSearchFilters(), mspId, alertKeys), OmadaLogMspPO.class, collectionName);
    }

    public Long b(String mspId, String collectionName, com.tplink.smb.omada.common.gridquery.a grid, List<String> eventKeys) {
        return this.mongoTemplate.count(this.b((List<com.tplink.smb.omada.common.gridquery.c>)grid.getFilters(), grid.getSearchFilters(), mspId, eventKeys), OmadaLogMspPO.class, collectionName);
    }

    public List<w> a(String mspId, String collectionName, com.tplink.smb.omada.common.gridquery.a grid, Long skip, Integer limit) {
        Query query = this.c(grid.getFilters(), grid.getSearchFilters(), mspId);
        com.tplink.smb.omada.logmanager.port.mongo.a.a.a(query, grid.getQuerySorts());
        query.skip(skip.longValue());
        query.limit(limit.intValue());
        return this.mongoTemplate.find(query, OmadaLogMspPO.class, collectionName).stream().map(m::a).collect(Collectors.toList());
    }

    public List<w> a(String mspId, String collectionName, com.tplink.smb.omada.common.gridquery.a grid, Long skip, Integer limit, List<String> alertKeys) {
        Query query = this.a((List<com.tplink.smb.omada.common.gridquery.c>)grid.getFilters(), (List<com.tplink.smb.omada.common.gridquery.c>)grid.getSearchFilters(), mspId, alertKeys);
        com.tplink.smb.omada.logmanager.port.mongo.a.a.a(query, grid.getQuerySorts());
        query.skip(skip.longValue());
        query.limit(limit.intValue());
        return this.mongoTemplate.find(query, OmadaLogMspPO.class, collectionName).stream().map(m::a).collect(Collectors.toList());
    }

    public List<w> b(String mspId, String collectionName, com.tplink.smb.omada.common.gridquery.a grid, Long skip, Integer limit, List<String> eventKeys) {
        Query query = this.b((List<com.tplink.smb.omada.common.gridquery.c>)grid.getFilters(), grid.getSearchFilters(), mspId, eventKeys);
        com.tplink.smb.omada.logmanager.port.mongo.a.a.a(query, grid.getQuerySorts());
        query.skip(skip.longValue());
        query.limit(limit.intValue());
        return this.mongoTemplate.find(query, OmadaLogMspPO.class, collectionName).stream().map(m::a).collect(Collectors.toList());
    }

    private Query a(List<com.tplink.smb.omada.common.gridquery.c> filters, List<com.tplink.smb.omada.common.gridquery.c> searchFilters, String mspId, List<String> alertKeys) {
        if (CollectionUtils.isEmpty(filters)) {
            filters = new ArrayList<com.tplink.smb.omada.common.gridquery.c>(4);
        }
        if (CollectionUtils.isEmpty(searchFilters)) {
            searchFilters = new ArrayList<com.tplink.smb.omada.common.gridquery.c>(4);
        }
        filters = com.tplink.smb.omada.logmanager.port.mongo.a.c.c(filters, searchFilters);
        Criteria criteria = com.tplink.smb.omada.logmanager.port.mongo.a.a.b(searchFilters, filters);
        criteria.and("msp_id").is((Object)mspId);
        criteria.and("key").in(alertKeys);
        return new Query((CriteriaDefinition)criteria);
    }

    private Query b(List<com.tplink.smb.omada.common.gridquery.c> filters, List<com.tplink.smb.omada.common.gridquery.c> searchFilters, String mspId, List<String> eventKeys) {
        if (CollectionUtils.isEmpty(filters)) {
            filters = new ArrayList<com.tplink.smb.omada.common.gridquery.c>(4);
        }
        if (CollectionUtils.isEmpty(searchFilters)) {
            searchFilters = new ArrayList<com.tplink.smb.omada.common.gridquery.c>(4);
        }
        filters = com.tplink.smb.omada.logmanager.port.mongo.a.c.d(filters, searchFilters);
        Criteria criteria = com.tplink.smb.omada.logmanager.port.mongo.a.a.b(searchFilters, filters);
        criteria.and("msp_id").is((Object)mspId);
        criteria.and("key").in(eventKeys);
        return new Query((CriteriaDefinition)criteria);
    }

    public Criteria a(List<com.tplink.smb.omada.common.gridquery.c> filters, List<com.tplink.smb.omada.common.gridquery.c> searchFilters, String mspId) {
        if (CollectionUtils.isEmpty(filters)) {
            filters = new ArrayList<com.tplink.smb.omada.common.gridquery.c>(4);
        }
        if (CollectionUtils.isEmpty(searchFilters)) {
            searchFilters = new ArrayList<com.tplink.smb.omada.common.gridquery.c>(4);
        }
        filters = com.tplink.smb.omada.logmanager.port.mongo.a.c.c(filters, searchFilters);
        Criteria criteria = com.tplink.smb.omada.logmanager.port.mongo.a.a.b(searchFilters, filters);
        criteria.and("msp_id").is((Object)mspId);
        return criteria;
    }

    public Criteria b(List<com.tplink.smb.omada.common.gridquery.c> filters, List<com.tplink.smb.omada.common.gridquery.c> searchFilters, String mspId) {
        if (CollectionUtils.isEmpty(filters)) {
            filters = new ArrayList<com.tplink.smb.omada.common.gridquery.c>(4);
        }
        if (CollectionUtils.isEmpty(searchFilters)) {
            searchFilters = new ArrayList<com.tplink.smb.omada.common.gridquery.c>(4);
        }
        filters = com.tplink.smb.omada.logmanager.port.mongo.a.c.d(filters, searchFilters);
        Criteria criteria = com.tplink.smb.omada.logmanager.port.mongo.a.a.b(searchFilters, filters);
        criteria.and("msp_id").is((Object)mspId);
        return criteria;
    }

    private List<LogClassifyInfoDTO> a(Criteria criteria, String groupKey, String mspId, Long startTime, Long endTime) {
        Aggregation aggregation = Aggregation.newAggregation((AggregationOperation[])new AggregationOperation[]{Aggregation.match((Criteria)criteria), Aggregation.group((String[])new String[]{groupKey}).count().as("countNumber")});
        ArrayList logGroupInfoDTOS = new ArrayList();
        this.iteratorCollectionsByTimeAndSliceKey(Sort.Direction.DESC, startTime / 1000L, endTime / 1000L, mspId, collectionName -> logGroupInfoDTOS.addAll(this.mongoTemplate.aggregate(aggregation, collectionName, LogClassifyInfoDTO.class).getMappedResults()));
        Map<String, LongSummaryStatistics> statisticsMap = logGroupInfoDTOS.stream().collect(Collectors.groupingBy(LogClassifyInfoDTO::getId, Collectors.summarizingLong(LogClassifyInfoDTO::getCountNumber)));
        ArrayList<LogClassifyInfoDTO> logGroupInfo = new ArrayList<LogClassifyInfoDTO>();
        for (Map.Entry<String, LongSummaryStatistics> entry : statisticsMap.entrySet()) {
            logGroupInfo.add(LogClassifyInfoDTO.builder().id(entry.getKey()).countNumber(Long.valueOf(entry.getValue().getSum())).build());
        }
        return logGroupInfo;
    }

    protected int a(@Nullable String key) {
        if (Objects.isNull(key)) {
            return 0;
        }
        return key.hashCode();
    }

    protected com.tplink.smb.omada.logmanager.port.mongo.data.a.m a() {
        return this.b;
    }

    protected Class getPOClass() {
        return OmadaLogMspPO.class;
    }

    protected MongoTemplate getMongoTemplate() {
        return this.mongoTemplate;
    }

    @Nonnull
    protected String getCollectionNameOrPrefixIfSliced() {
        return "mspomadalog";
    }

    @Nonnull
    protected IndexDefinition[] getIndexDefinitions() {
        return OmadaLogMspPO.INDEX_DEFINITIONS;
    }

    public void a(com.tplink.smb.omada.logmanager.port.commom.service.a.c event) {
        this.dbMaintenance(event.a());
    }

    @PostConstruct
    public void b() {
        DomainEventBusHolder.getHandlerRegistry().registerSync(com.tplink.smb.omada.logmanager.port.commom.service.a.c.class, (DomainEventSubscriber)this);
    }

    protected /* synthetic */ p getStrategy() {
        return this.a();
    }

    protected /* synthetic */ int hashCodeOfKey(@Nullable Object object) {
        return this.a((String)object);
    }

    protected /* synthetic */ u getStrategy() {
        return this.a();
    }

    public /* synthetic */ void handleEvent(Object object) {
        this.a((com.tplink.smb.omada.logmanager.port.commom.service.a.c)object);
    }
}

