/*
 * Decompiled with CFR 0.152.
 */
package com.tplink.smb.omada.logmanager.port.mongo.log;

import com.mongodb.bulk.BulkWriteResult;
import com.tplink.smb.eventcenter.api.event.DomainEventSubscriber;
import com.tplink.smb.eventcenter.domain.DomainEventBusHolder;
import com.tplink.smb.omada.common.gridquery.e;
import com.tplink.smb.omada.common.gridquery.g;
import com.tplink.smb.omada.common.mongo.repository.p;
import com.tplink.smb.omada.common.mongo.repository.q;
import com.tplink.smb.omada.common.mongo.repository.u;
import com.tplink.smb.omada.common.util.T;
import com.tplink.smb.omada.logmanager.api.external.dto.ArchiveDTO;
import com.tplink.smb.omada.logmanager.domain.model.log.AbstractOmadaLog;
import com.tplink.smb.omada.logmanager.domain.model.log.LogClassifyInfoDTO;
import com.tplink.smb.omada.logmanager.domain.model.log.LogClassifyNumberQueryDTO;
import com.tplink.smb.omada.logmanager.domain.model.log.n;
import com.tplink.smb.omada.logmanager.domain.model.log.w;
import com.tplink.smb.omada.logmanager.port.mongo.a.a;
import com.tplink.smb.omada.logmanager.port.mongo.a.d;
import com.tplink.smb.omada.logmanager.port.mongo.log.LiteOmadaLogGlobalPO;
import com.tplink.smb.omada.logmanager.port.mongo.log.m;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.LongSummaryStatistics;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.PostConstruct;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;
import org.springframework.data.mongodb.core.BulkOperations;
import org.springframework.data.mongodb.core.MongoTemplate;
import org.springframework.data.mongodb.core.aggregation.Aggregation;
import org.springframework.data.mongodb.core.aggregation.AggregationOperation;
import org.springframework.data.mongodb.core.index.IndexDefinition;
import org.springframework.data.mongodb.core.query.Criteria;
import org.springframework.data.mongodb.core.query.CriteriaDefinition;
import org.springframework.data.mongodb.core.query.Query;
import org.springframework.data.mongodb.core.query.Update;
import org.springframework.data.mongodb.core.query.UpdateDefinition;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;

@Component
public class c
extends q<LiteOmadaLogGlobalPO, com.tplink.smb.omada.logmanager.domain.model.e.g>
implements DomainEventSubscriber<com.tplink.smb.omada.logmanager.port.commom.service.a.c>,
n {
    @Generated
    private static final Logger a = LoggerFactory.getLogger(c.class);
    @Autowired
    @Qualifier(value="dataMongoTemplate")
    private MongoTemplate mongoTemplate;
    @Autowired
    private com.tplink.smb.omada.logmanager.port.mongo.data.a.c b;

    public void a(List<w> omadaLogs) {
        if (CollectionUtils.isEmpty(omadaLogs)) {
            return;
        }
        Map<String, List<LiteOmadaLogGlobalPO>> collectionNameToPOsMap = omadaLogs.stream().map(m::e).collect(Collectors.groupingBy(x$0 -> this.getCollectionNameForSave(x$0)));
        collectionNameToPOsMap.forEach((collectionName, poList) -> {
            BulkOperations bulkOperations = this.mongoTemplate.bulkOps(BulkOperations.BulkMode.UNORDERED, collectionName);
            poList.forEach(liteOmadaLogPO -> bulkOperations.insert(liteOmadaLogPO));
            BulkWriteResult result = bulkOperations.execute();
            a.debug("Bulk write lite global omada log result: {}", (Object)result);
        });
    }

    public long a(com.tplink.smb.omada.logmanager.domain.model.e.g omadacId, Long startTime, Long endTime) {
        Query query = new Query();
        Criteria criteria = Criteria.where((String)"omadac_id").is((Object)omadacId.a());
        criteria.and("alert").is((Object)Boolean.TRUE);
        criteria.and("archived").is((Object)Boolean.FALSE);
        criteria.and("time").gte((Object)startTime).lte((Object)endTime);
        query.addCriteria((CriteriaDefinition)criteria);
        AtomicLong total = new AtomicLong(0L);
        this.iteratorCollectionsByTimeAndSliceKey(Sort.Direction.DESC, startTime / 1000L, endTime / 1000L, omadacId, collectionName -> total.addAndGet(this.mongoTemplate.count(query, collectionName)));
        return total.get();
    }

    public com.tplink.smb.omada.common.gridquery.a<w> a(com.tplink.smb.omada.common.gridquery.a<w> grid, String omadacId) {
        long count = this.a((List<com.tplink.smb.omada.common.gridquery.c>)grid.getFilters(), (List<com.tplink.smb.omada.common.gridquery.c>)grid.getSearchFilters(), omadacId, ((e)grid.getQuerySorts().get(0)).a());
        grid.setTotalRows(count);
        if (count < 1L) {
            grid.setData(Collections.EMPTY_LIST);
            return grid;
        }
        grid.setData(this.a(grid.getQueryPage(), grid.getQuerySorts(), grid.getFilters(), grid.getSearchFilters(), omadacId, count));
        return grid;
    }

    public List<String> a(String omadacId, Long startTime, Long endTime, g direction) {
        ArrayList<String> collectionNames = new ArrayList<String>();
        this.iteratorCollectionsByTimeAndSliceKey(g.a.equals((Object)direction) ? Sort.Direction.DESC : Sort.Direction.ASC, startTime, endTime, new com.tplink.smb.omada.logmanager.domain.model.e.g(omadacId), collectionName -> collectionNames.add((String)collectionName));
        return collectionNames;
    }

    public List<LogClassifyInfoDTO> b(LogClassifyNumberQueryDTO logClassifyNumberQueryDTO) {
        String omadacId = logClassifyNumberQueryDTO.getOmadacId();
        Criteria criteria = Criteria.where((String)"omadac_id").is((Object)omadacId);
        Boolean alert = logClassifyNumberQueryDTO.getAlert();
        if (Boolean.TRUE.equals(alert)) {
            criteria.and("alert").is((Object)true);
        }
        long startTime = logClassifyNumberQueryDTO.getStartTime();
        long endTime = logClassifyNumberQueryDTO.getEndTime();
        criteria.and("time").gte((Object)startTime).lte((Object)endTime);
        if (Objects.nonNull(logClassifyNumberQueryDTO.getArchived())) {
            criteria.and("archived").is((Object)logClassifyNumberQueryDTO.getArchived());
        }
        if (!T.a((String)logClassifyNumberQueryDTO.getModule())) {
            criteria.and("module").is((Object)logClassifyNumberQueryDTO.getModule());
        }
        if (!T.a((String)logClassifyNumberQueryDTO.getSearchKey())) {
            criteria.andOperator(new Criteria[]{d.a(d.b(logClassifyNumberQueryDTO.getSearchKey()))});
        }
        Aggregation aggregation = Aggregation.newAggregation((AggregationOperation[])new AggregationOperation[]{Aggregation.match((Criteria)criteria), Aggregation.group((String[])new String[]{logClassifyNumberQueryDTO.getGroupKey()}).count().as("countNumber")});
        ArrayList logGroupInfoDTOS = new ArrayList();
        this.iteratorCollectionsByTimeAndSliceKey(Sort.Direction.DESC, startTime / 1000L, endTime / 1000L, new com.tplink.smb.omada.logmanager.domain.model.e.g(omadacId), collectionName -> logGroupInfoDTOS.addAll(this.mongoTemplate.aggregate(aggregation, collectionName, LogClassifyInfoDTO.class).getMappedResults()));
        Map<String, LongSummaryStatistics> statisticsMap = logGroupInfoDTOS.stream().collect(Collectors.groupingBy(LogClassifyInfoDTO::getId, Collectors.summarizingLong(LogClassifyInfoDTO::getCountNumber)));
        ArrayList<LogClassifyInfoDTO> logGroupInfo = new ArrayList<LogClassifyInfoDTO>();
        for (Map.Entry<String, LongSummaryStatistics> entry : statisticsMap.entrySet()) {
            logGroupInfo.add(LogClassifyInfoDTO.builder().id(entry.getKey()).countNumber(Long.valueOf(entry.getValue().getSum())).build());
        }
        return logGroupInfo;
    }

    public Long a(LogClassifyNumberQueryDTO logClassifyNumberQueryDTO) {
        Query query = new Query();
        Criteria criteria = Criteria.where((String)"omadac_id").is((Object)logClassifyNumberQueryDTO.getOmadacId());
        Boolean alert = logClassifyNumberQueryDTO.getAlert();
        if (Boolean.TRUE.equals(alert)) {
            criteria.and("alert").is((Object)true);
        }
        criteria.and("level").is((Object)logClassifyNumberQueryDTO.getLevel());
        Long startTime = logClassifyNumberQueryDTO.getStartTime();
        Long endTime = logClassifyNumberQueryDTO.getEndTime();
        criteria.and("time").gte((Object)startTime).lte((Object)endTime);
        if (Objects.nonNull(logClassifyNumberQueryDTO.getArchived())) {
            criteria.and("archived").is((Object)logClassifyNumberQueryDTO.getArchived());
        }
        if (!T.a((String)logClassifyNumberQueryDTO.getModule())) {
            criteria.and("module").is((Object)logClassifyNumberQueryDTO.getModule());
        }
        if (!T.a((String)logClassifyNumberQueryDTO.getSearchKey())) {
            criteria.andOperator(new Criteria[]{d.a(d.b(logClassifyNumberQueryDTO.getSearchKey()))});
        }
        query.addCriteria((CriteriaDefinition)criteria);
        AtomicLong total = new AtomicLong(0L);
        this.iteratorCollectionsByTimeAndSliceKey(Sort.Direction.DESC, startTime / 1000L, endTime / 1000L, new com.tplink.smb.omada.logmanager.domain.model.e.g(logClassifyNumberQueryDTO.getOmadacId()), collectionName -> total.addAndGet(this.mongoTemplate.count(query, LiteOmadaLogGlobalPO.class, collectionName)));
        return total.get();
    }

    public w a(String omadacId, String logId) {
        Query query = new Query();
        Criteria criteria = Criteria.where((String)"omadac_id").is((Object)omadacId);
        criteria.and("_id").is((Object)logId);
        query.addCriteria((CriteriaDefinition)criteria);
        ArrayList liteOmadaLogPOS = new ArrayList();
        this.iteratorCollectionsBySliceKey(new com.tplink.smb.omada.logmanager.domain.model.e.g(omadacId), collectionName -> liteOmadaLogPOS.addAll(this.mongoTemplate.find(query, LiteOmadaLogGlobalPO.class, collectionName)));
        if (CollectionUtils.isEmpty(liteOmadaLogPOS) || liteOmadaLogPOS.size() > 1) {
            a.warn("fail to find lite global omada Log by omadacId :{}, logId :{}", (Object)omadacId, (Object)logId);
            return null;
        }
        return m.a((LiteOmadaLogGlobalPO)liteOmadaLogPOS.get(0));
    }

    public void a(w omadaLog) {
        LiteOmadaLogGlobalPO liteOmadaLogPO = m.e(omadaLog);
        String collectionName = this.getCollectionNameForSave(liteOmadaLogPO);
        this.iteratorCollectionsBySliceKey(omadaLog.getOmadacId(), logPo -> this.mongoTemplate.save((Object)liteOmadaLogPO, collectionName));
    }

    public void a(String omadacId, ArchiveDTO archiveDTO) {
        Criteria criteria = new Criteria("omadac_id").is((Object)omadacId);
        criteria.and("archived").is((Object)false);
        criteria.and("alert").is((Object)true);
        Query query = Query.query((CriteriaDefinition)criteria);
        Long startTime = archiveDTO.getTimeStart() / 1000L;
        Long endTime = archiveDTO.getTimeEnd() / 1000L;
        query.addCriteria((CriteriaDefinition)Criteria.where((String)"time").gte((Object)archiveDTO.getTimeStart()).lte((Object)archiveDTO.getTimeEnd()));
        this.iteratorCollectionsByTimeAndSliceKey(Sort.Direction.DESC, startTime, endTime, new com.tplink.smb.omada.logmanager.domain.model.e.g(omadacId), collectionName -> this.mongoTemplate.updateMulti(query, (UpdateDefinition)Update.update((String)"archived", (Object)true), LiteOmadaLogGlobalPO.class, collectionName));
    }

    public void a(String omadacId, Boolean deleteAlert, Long startTime, Long endTime) {
        Query query = new Query();
        query.addCriteria((CriteriaDefinition)Criteria.where((String)"omadac_id").is((Object)omadacId));
        if (deleteAlert.booleanValue()) {
            query.addCriteria((CriteriaDefinition)Criteria.where((String)"alert").is((Object)true));
        }
        query.addCriteria((CriteriaDefinition)Criteria.where((String)"time").gte((Object)startTime).lte((Object)endTime));
        this.iteratorCollectionsByTimeAndSliceKey(Sort.Direction.DESC, startTime / 1000L, endTime / 1000L, new com.tplink.smb.omada.logmanager.domain.model.e.g(omadacId), collectionName -> this.mongoTemplate.remove(query, LiteOmadaLogGlobalPO.class, collectionName));
    }

    public long a(List<com.tplink.smb.omada.common.gridquery.c> filters, List<com.tplink.smb.omada.common.gridquery.c> searchFilters, String omadacId, g direction) {
        if (Objects.isNull(filters)) {
            filters = new ArrayList<com.tplink.smb.omada.common.gridquery.c>();
        }
        Long[] times = d.a(filters);
        Query query = this.a(filters, searchFilters, omadacId);
        AtomicLong total = new AtomicLong(0L);
        this.iteratorCollectionsByTimeAndSliceKey(direction.a().equals("asc") ? Sort.Direction.ASC : Sort.Direction.DESC, times[0], times[1], new com.tplink.smb.omada.logmanager.domain.model.e.g(omadacId), collectionName -> total.addAndGet(this.mongoTemplate.count(query, LiteOmadaLogGlobalPO.class, collectionName)));
        return total.get();
    }

    public List<w> a(String omadacId, com.tplink.smb.omada.common.gridquery.d queryPage) {
        Query query = new Query();
        query.with((Pageable)PageRequest.of((int)queryPage.a(), (int)queryPage.b()));
        query.addCriteria((CriteriaDefinition)Criteria.where((String)"omadac_id").is((Object)omadacId));
        query.with(Sort.by((Sort.Order[])new Sort.Order[]{Sort.Order.desc((String)"time")}));
        ArrayList<w> omadaLogs = new ArrayList<w>();
        long endTime = System.currentTimeMillis() / 1000L;
        this.iteratorCollectionsByTimeAndSliceKeyWithSkip(Sort.Direction.DESC, 0L, endTime, new com.tplink.smb.omada.logmanager.domain.model.e.g(omadacId), query, (collectionName, queryCollection) -> omadaLogs.addAll(this.mongoTemplate.find(queryCollection, LiteOmadaLogGlobalPO.class, collectionName).stream().map(m::a).collect(Collectors.toList())));
        return omadaLogs;
    }

    public List<w> a(com.tplink.smb.omada.common.gridquery.d page, List<e> sort, List<com.tplink.smb.omada.common.gridquery.c> filters, List<com.tplink.smb.omada.common.gridquery.c> searchFilters, String omadacId, long count) {
        if (Objects.isNull(filters)) {
            filters = new ArrayList<com.tplink.smb.omada.common.gridquery.c>();
        }
        Query query = this.a(filters, searchFilters, omadacId);
        Long[] times = d.a(filters);
        boolean reverse = this.a(page, query, sort, Sort.Direction.fromString((String)sort.get(0).a().a()), count);
        Sort.Direction direction = sort.get(0).a().a().equals("asc") ? Sort.Direction.ASC : Sort.Direction.DESC;
        com.tplink.smb.omada.logmanager.port.mongo.a.a.a(query, sort);
        ArrayList liteOmmadaLogPOS = new ArrayList();
        this.iteratorCollectionsByTimeAndSliceKeyWithSkip(direction, times[0], times[1], new com.tplink.smb.omada.logmanager.domain.model.e.g(omadacId), query, (collectionName, queryFilter) -> liteOmmadaLogPOS.addAll(this.mongoTemplate.find(queryFilter, LiteOmadaLogGlobalPO.class, collectionName)));
        if (reverse) {
            return liteOmmadaLogPOS.stream().map(m::a).sorted(Comparator.comparing(AbstractOmadaLog::getTime).reversed()).collect(Collectors.toList());
        }
        return liteOmmadaLogPOS.stream().map(m::a).collect(Collectors.toList());
    }

    private boolean a(com.tplink.smb.omada.common.gridquery.d page, Query query, List<e> querySorts, Sort.Direction direction, long count) {
        int pageSize;
        if (Objects.isNull(page)) {
            return false;
        }
        int pageNum = page.a();
        if ((long)(pageNum * (pageSize = page.b()) * 2) < count) {
            query.limit(page.b()).skip((long)(page.a() * page.b()));
            return false;
        }
        int lastPageSize = (int)(count % (long)pageSize);
        int reversePageNum = (int)(count - (long)(pageNum * pageSize)) / pageSize;
        page.a(reversePageNum);
        if (lastPageSize > 0) {
            if (reversePageNum == 0) {
                query.limit(lastPageSize);
            } else {
                query.limit(page.b()).skip((long)(lastPageSize + (reversePageNum - 1) * page.b()));
            }
        } else {
            query.limit(page.b()).skip((long)(reversePageNum * page.b()));
        }
        if (!CollectionUtils.isEmpty(querySorts)) {
            for (e sort : querySorts) {
                if (direction.isAscending()) {
                    sort.a(g.a);
                    continue;
                }
                sort.a(g.b);
            }
        }
        return true;
    }

    public Query a(List<com.tplink.smb.omada.common.gridquery.c> filters, List<com.tplink.smb.omada.common.gridquery.c> searchFilters, String omadacId) {
        if (CollectionUtils.isEmpty(filters)) {
            filters = new ArrayList<com.tplink.smb.omada.common.gridquery.c>(4);
        }
        Criteria criteria = com.tplink.smb.omada.logmanager.port.mongo.a.a.b(searchFilters, filters);
        criteria.and("omadac_id").is((Object)omadacId);
        return new Query((CriteriaDefinition)criteria);
    }

    public void a(com.tplink.smb.omada.logmanager.domain.model.e.g omadacId, List<String> ids, Long startTime, Long endTime) {
        Query query = new Query();
        AtomicInteger clearedNum = new AtomicInteger(0);
        int topNum = ids.size();
        query.addCriteria((CriteriaDefinition)Criteria.where((String)"omadac_id").is((Object)omadacId.a()));
        query.addCriteria((CriteriaDefinition)Criteria.where((String)"_id").in(ids));
        this.iteratorCollectionsByTimeAndSliceKey(Sort.Direction.DESC, startTime / 1000L, endTime / 1000L, omadacId, collectionName -> {
            if (clearedNum.get() >= topNum) {
                return;
            }
            int removed = (int)this.mongoTemplate.remove(query, collectionName).getDeletedCount();
            clearedNum.addAndGet(removed);
        });
    }

    public void b(com.tplink.smb.omada.logmanager.domain.model.e.g omadacId, List<String> ids, Long startTime, Long endTime) {
        Query query = new Query();
        query.addCriteria((CriteriaDefinition)Criteria.where((String)"omadac_id").is((Object)omadacId.a()));
        query.addCriteria((CriteriaDefinition)Criteria.where((String)"_id").in(ids));
        Update update = new Update();
        update.set("archived", (Object)true);
        this.iteratorCollectionsByTimeAndSliceKey(Sort.Direction.DESC, startTime / 1000L, endTime / 1000L, omadacId, collectionName -> this.mongoTemplate.updateMulti(query, (UpdateDefinition)update, LiteOmadaLogGlobalPO.class, collectionName));
    }

    public Long a(String omadacId, String collectionName, com.tplink.smb.omada.common.gridquery.a grid, List<String> alertKeys) {
        return this.mongoTemplate.count(this.a((List<com.tplink.smb.omada.common.gridquery.c>)grid.getFilters(), (List<com.tplink.smb.omada.common.gridquery.c>)grid.getSearchFilters(), omadacId, alertKeys), LiteOmadaLogGlobalPO.class, collectionName);
    }

    public Long b(String omadacId, String collectionName, com.tplink.smb.omada.common.gridquery.a grid, List<String> eventKeys) {
        return this.mongoTemplate.count(this.b(grid.getFilters(), grid.getSearchFilters(), omadacId, eventKeys), LiteOmadaLogGlobalPO.class, collectionName);
    }

    public List<w> a(String omadacId, String collectionName, com.tplink.smb.omada.common.gridquery.a grid, Long skip, Integer limit, List<String> alertKeys) {
        Query query = this.a((List<com.tplink.smb.omada.common.gridquery.c>)grid.getFilters(), (List<com.tplink.smb.omada.common.gridquery.c>)grid.getSearchFilters(), omadacId, alertKeys);
        com.tplink.smb.omada.logmanager.port.mongo.a.a.a(query, grid.getQuerySorts());
        query.skip(skip.longValue());
        query.limit(limit.intValue());
        return this.mongoTemplate.find(query, LiteOmadaLogGlobalPO.class, collectionName).stream().map(m::a).collect(Collectors.toList());
    }

    public List<w> b(String omadacId, String collectionName, com.tplink.smb.omada.common.gridquery.a grid, Long skip, Integer limit, List<String> eventKeys) {
        Query query = this.b(grid.getFilters(), grid.getSearchFilters(), omadacId, eventKeys);
        com.tplink.smb.omada.logmanager.port.mongo.a.a.a(query, grid.getQuerySorts());
        query.skip(skip.longValue());
        query.limit(limit.intValue());
        return this.mongoTemplate.find(query, LiteOmadaLogGlobalPO.class, collectionName).stream().map(m::a).collect(Collectors.toList());
    }

    public Long a(String omadacId, com.tplink.smb.omada.common.gridquery.a<w> grid, Long startTime, Long endTime, List<String> alertKeys) {
        grid.setFilters(com.tplink.smb.omada.logmanager.port.mongo.a.c.b(grid.getFilters()));
        grid.setFilters(com.tplink.smb.omada.logmanager.port.mongo.a.c.c(grid.getFilters()));
        Criteria criteria = this.c(grid.getFilters(), grid.getSearchFilters(), omadacId);
        criteria.and("key").in(alertKeys);
        Query query = new Query((CriteriaDefinition)criteria);
        AtomicLong count = new AtomicLong();
        this.iteratorCollectionsByTimeAndSliceKey(Sort.Direction.DESC, startTime / 1000L, endTime / 1000L, new com.tplink.smb.omada.logmanager.domain.model.e.g(omadacId), collectionName -> count.addAndGet(this.mongoTemplate.count(query, LiteOmadaLogGlobalPO.class, collectionName)));
        return count.get();
    }

    public Long b(String omadacId, com.tplink.smb.omada.common.gridquery.a<w> grid, Long startTime, Long endTime, List<String> alertKeys) {
        grid.setFilters(com.tplink.smb.omada.logmanager.port.mongo.a.c.b(grid.getFilters()));
        grid.setFilters(com.tplink.smb.omada.logmanager.port.mongo.a.c.c(grid.getFilters()));
        Criteria criteria = this.c(grid.getFilters(), grid.getSearchFilters(), omadacId);
        criteria.and("key").in(alertKeys);
        criteria.and("archived").is((Object)true);
        Query query = new Query((CriteriaDefinition)criteria);
        AtomicLong count = new AtomicLong();
        this.iteratorCollectionsByTimeAndSliceKey(Sort.Direction.DESC, startTime / 1000L, endTime / 1000L, new com.tplink.smb.omada.logmanager.domain.model.e.g(omadacId), collectionName -> count.addAndGet(this.mongoTemplate.count(query, LiteOmadaLogGlobalPO.class, collectionName)));
        return count.get();
    }

    public Long c(String omadacId, com.tplink.smb.omada.common.gridquery.a<w> grid, Long startTime, Long endTime, List<String> alertKeys) {
        grid.setFilters(com.tplink.smb.omada.logmanager.port.mongo.a.c.b(grid.getFilters()));
        grid.setFilters(com.tplink.smb.omada.logmanager.port.mongo.a.c.c(grid.getFilters()));
        Criteria criteria = this.c(grid.getFilters(), grid.getSearchFilters(), omadacId);
        criteria.and("key").in(alertKeys);
        criteria.and("archived").is((Object)false);
        Query query = new Query((CriteriaDefinition)criteria);
        AtomicLong count = new AtomicLong();
        this.iteratorCollectionsByTimeAndSliceKey(Sort.Direction.DESC, startTime / 1000L, endTime / 1000L, new com.tplink.smb.omada.logmanager.domain.model.e.g(omadacId), collectionName -> count.addAndGet(this.mongoTemplate.count(query, LiteOmadaLogGlobalPO.class, collectionName)));
        return count.get();
    }

    public List<LogClassifyInfoDTO> d(String omadacId, com.tplink.smb.omada.common.gridquery.a<w> grid, Long startTime, Long endTime, List<String> alertKeys) {
        grid.setFilters(com.tplink.smb.omada.logmanager.port.mongo.a.c.b(grid.getFilters()));
        grid.setFilters(com.tplink.smb.omada.logmanager.port.mongo.a.c.c(grid.getFilters()));
        Criteria criteria = this.c(grid.getFilters(), grid.getSearchFilters(), omadacId);
        criteria.and("key").in(alertKeys);
        return this.a(criteria, "module", omadacId, startTime, endTime);
    }

    public List<LogClassifyInfoDTO> e(String omadacId, com.tplink.smb.omada.common.gridquery.a<w> grid, Long startTime, Long endTime, List<String> alertKeys) {
        grid.setFilters(com.tplink.smb.omada.logmanager.port.mongo.a.c.b(grid.getFilters()));
        Criteria criteria = this.c(grid.getFilters(), grid.getSearchFilters(), omadacId);
        criteria.and("key").in(alertKeys);
        return this.a(criteria, "level", omadacId, startTime, endTime);
    }

    public List<LogClassifyInfoDTO> f(String omadacId, com.tplink.smb.omada.common.gridquery.a<w> grid, Long startTime, Long endTime, List<String> alertKeys) {
        grid.setFilters(com.tplink.smb.omada.logmanager.port.mongo.a.c.b(grid.getFilters()));
        grid.setFilters(com.tplink.smb.omada.logmanager.port.mongo.a.c.c(grid.getFilters()));
        Criteria criteria = this.c(grid.getFilters(), grid.getSearchFilters(), omadacId);
        criteria.and("key").in(alertKeys);
        criteria.and("archived").is((Object)true);
        return this.a(criteria, "module", omadacId, startTime, endTime);
    }

    public List<LogClassifyInfoDTO> g(String omadacId, com.tplink.smb.omada.common.gridquery.a<w> grid, Long startTime, Long endTime, List<String> alertKeys) {
        grid.setFilters(com.tplink.smb.omada.logmanager.port.mongo.a.c.b(grid.getFilters()));
        Criteria criteria = this.c(grid.getFilters(), grid.getSearchFilters(), omadacId);
        criteria.and("key").in(alertKeys);
        criteria.and("archived").is((Object)true);
        return this.a(criteria, "level", omadacId, startTime, endTime);
    }

    public List<LogClassifyInfoDTO> h(String omadacId, com.tplink.smb.omada.common.gridquery.a<w> grid, Long startTime, Long endTime, List<String> alertKeys) {
        grid.setFilters(com.tplink.smb.omada.logmanager.port.mongo.a.c.b(grid.getFilters()));
        grid.setFilters(com.tplink.smb.omada.logmanager.port.mongo.a.c.c(grid.getFilters()));
        Criteria criteria = this.c(grid.getFilters(), grid.getSearchFilters(), omadacId);
        criteria.and("key").in(alertKeys);
        criteria.and("archived").is((Object)false);
        return this.a(criteria, "module", omadacId, startTime, endTime);
    }

    public List<LogClassifyInfoDTO> i(String omadacId, com.tplink.smb.omada.common.gridquery.a<w> grid, Long startTime, Long endTime, List<String> alertKeys) {
        grid.setFilters(com.tplink.smb.omada.logmanager.port.mongo.a.c.b(grid.getFilters()));
        Criteria criteria = this.c(grid.getFilters(), grid.getSearchFilters(), omadacId);
        criteria.and("key").in(alertKeys);
        criteria.and("archived").is((Object)false);
        return this.a(criteria, "level", omadacId, startTime, endTime);
    }

    public Long j(String omadacId, com.tplink.smb.omada.common.gridquery.a<w> grid, Long startTime, Long endTime, List<String> eventKeys) {
        grid.setFilters(com.tplink.smb.omada.logmanager.port.mongo.a.c.b(grid.getFilters()));
        grid.setFilters(com.tplink.smb.omada.logmanager.port.mongo.a.c.c(grid.getFilters()));
        Criteria criteria = this.b((List<com.tplink.smb.omada.common.gridquery.c>)grid.getFilters(), grid.getSearchFilters(), omadacId);
        criteria.and("key").in(eventKeys);
        Query query = new Query((CriteriaDefinition)criteria);
        AtomicLong count = new AtomicLong();
        this.iteratorCollectionsByTimeAndSliceKey(Sort.Direction.DESC, startTime / 1000L, endTime / 1000L, new com.tplink.smb.omada.logmanager.domain.model.e.g(omadacId), collectionName -> count.addAndGet(this.mongoTemplate.count(query, LiteOmadaLogGlobalPO.class, collectionName)));
        return count.get();
    }

    public List<LogClassifyInfoDTO> k(String omadacId, com.tplink.smb.omada.common.gridquery.a<w> grid, Long startTime, Long endTime, List<String> eventKeys) {
        grid.setFilters(com.tplink.smb.omada.logmanager.port.mongo.a.c.b(grid.getFilters()));
        grid.setFilters(com.tplink.smb.omada.logmanager.port.mongo.a.c.c(grid.getFilters()));
        Criteria criteria = this.b((List<com.tplink.smb.omada.common.gridquery.c>)grid.getFilters(), grid.getSearchFilters(), omadacId);
        criteria.and("key").in(eventKeys);
        return this.a(criteria, "module", omadacId, startTime, endTime);
    }

    public void a(com.tplink.smb.omada.logmanager.domain.model.e.g omadacId, com.tplink.smb.omada.common.gridquery.a<w> grid, List<String> ids, List<String> alertKeys, Long startTime, Long endTime, Boolean isAlert) {
        ArrayList<w> omadaLogs = new ArrayList<w>();
        if (!CollectionUtils.isEmpty(ids)) {
            Criteria criteria = Criteria.where((String)"_id").in(ids).and("omadac_id").is((Object)omadacId.a());
            Query idQuery = new Query((CriteriaDefinition)criteria);
            this.iteratorCollectionsByTimeAndSliceKey(Sort.Direction.DESC, startTime / 1000L, endTime / 1000L, omadacId, collectionName -> omadaLogs.addAll(this.mongoTemplate.find(idQuery, LiteOmadaLogGlobalPO.class, collectionName).stream().map(m::a).collect(Collectors.toList())));
        }
        for (w omadalog : omadaLogs) {
            ids.remove(omadalog.getId().a());
        }
        grid.setFilters(com.tplink.smb.omada.logmanager.port.mongo.a.c.a(grid.getFilters()));
        Query query = this.a((List<com.tplink.smb.omada.common.gridquery.c>)grid.getFilters(), grid.getSearchFilters(), omadacId.a());
        if (isAlert.booleanValue()) {
            query.addCriteria((CriteriaDefinition)Criteria.where((String)"key").in(alertKeys));
        }
        this.iteratorCollectionsByTimeAndSliceKey(Sort.Direction.DESC, startTime / 1000L, endTime / 1000L, omadacId, collectionName -> this.mongoTemplate.remove(query, collectionName));
        if (!CollectionUtils.isEmpty(omadaLogs)) {
            this.a(omadaLogs);
        }
    }

    public long a(com.tplink.smb.omada.logmanager.domain.model.e.g omadacId, Long startTime, Long endTime, List<String> alertKeys) {
        Query query = new Query();
        Criteria criteria = Criteria.where((String)"omadac_id").is((Object)omadacId.a());
        criteria.and("alert").is((Object)Boolean.TRUE);
        criteria.and("archived").is((Object)Boolean.FALSE);
        criteria.and("time").gte((Object)startTime).lte((Object)endTime);
        criteria.and("key").in(alertKeys);
        query.addCriteria((CriteriaDefinition)criteria);
        AtomicLong total = new AtomicLong(0L);
        this.iteratorCollectionsByTimeAndSliceKey(Sort.Direction.DESC, startTime / 1000L, endTime / 1000L, omadacId, collectionName -> total.addAndGet(this.mongoTemplate.count(query, collectionName)));
        return total.get();
    }

    public void a(String omadacId, ArchiveDTO archiveDTO, com.tplink.smb.omada.common.gridquery.a<w> grid, List<String> alertKeys) {
        grid.setFilters(com.tplink.smb.omada.logmanager.port.mongo.a.c.a(grid.getFilters()));
        Query query = this.a((List<com.tplink.smb.omada.common.gridquery.c>)grid.getFilters(), (List<com.tplink.smb.omada.common.gridquery.c>)grid.getSearchFilters(), omadacId, alertKeys);
        Long startTime = archiveDTO.getTimeStart() / 1000L;
        Long endTime = archiveDTO.getTimeEnd() / 1000L;
        query.addCriteria((CriteriaDefinition)Criteria.where((String)"time").gte((Object)archiveDTO.getTimeStart()).lte((Object)archiveDTO.getTimeEnd()));
        this.iteratorCollectionsByTimeAndSliceKey(Sort.Direction.DESC, startTime, endTime, new com.tplink.smb.omada.logmanager.domain.model.e.g(omadacId), collectionName -> this.mongoTemplate.updateMulti(query, (UpdateDefinition)Update.update((String)"archived", (Object)true), LiteOmadaLogGlobalPO.class, collectionName));
        if (!CollectionUtils.isEmpty((Collection)archiveDTO.getLogs())) {
            Criteria criteria = Criteria.where((String)"_id").in((Collection)archiveDTO.getLogs()).and("omadac_id").is((Object)omadacId);
            Query idQuery = new Query((CriteriaDefinition)criteria);
            this.iteratorCollectionsByTimeAndSliceKey(Sort.Direction.DESC, startTime, endTime, new com.tplink.smb.omada.logmanager.domain.model.e.g(omadacId), collectionName -> this.mongoTemplate.updateMulti(idQuery, (UpdateDefinition)Update.update((String)"archived", (Object)false), LiteOmadaLogGlobalPO.class, collectionName));
        }
    }

    public void b(w omadaLog) {
        if (Objects.isNull(omadaLog.getId()) || T.a((String)omadaLog.getId().a())) {
            a.warn("Failed to archived site omada log:{}", (Object)omadaLog.toString());
            return;
        }
        String collectionName = this.getCollectionNameForSave(m.e(omadaLog));
        this.iteratorCollectionsBySliceKey(omadaLog.getOmadacId(), logPo -> this.mongoTemplate.updateFirst(new Query((CriteriaDefinition)Criteria.where((String)"_id").is((Object)omadaLog.getId().a())), (UpdateDefinition)Update.update((String)"archived", (Object)true), LiteOmadaLogGlobalPO.class, collectionName));
    }

    public Criteria b(List<com.tplink.smb.omada.common.gridquery.c> filters, List<com.tplink.smb.omada.common.gridquery.c> searchFilters, String omadacId) {
        if (CollectionUtils.isEmpty(filters)) {
            filters = new ArrayList<com.tplink.smb.omada.common.gridquery.c>(4);
        }
        if (CollectionUtils.isEmpty(searchFilters)) {
            searchFilters = new ArrayList<com.tplink.smb.omada.common.gridquery.c>(4);
        }
        filters = com.tplink.smb.omada.logmanager.port.mongo.a.c.d(filters, searchFilters);
        Criteria criteria = com.tplink.smb.omada.logmanager.port.mongo.a.a.b(searchFilters, filters);
        criteria.and("omadac_id").is((Object)omadacId);
        return criteria;
    }

    private List<LogClassifyInfoDTO> a(Criteria criteria, String groupKey, String omadacId, Long startTime, Long endTime) {
        Aggregation aggregation = Aggregation.newAggregation((AggregationOperation[])new AggregationOperation[]{Aggregation.match((Criteria)criteria), Aggregation.group((String[])new String[]{groupKey}).count().as("countNumber")});
        ArrayList logGroupInfoDTOS = new ArrayList();
        this.iteratorCollectionsByTimeAndSliceKey(Sort.Direction.DESC, startTime / 1000L, endTime / 1000L, new com.tplink.smb.omada.logmanager.domain.model.e.g(omadacId), collectionName -> logGroupInfoDTOS.addAll(this.mongoTemplate.aggregate(aggregation, collectionName, LogClassifyInfoDTO.class).getMappedResults()));
        Map<String, LongSummaryStatistics> statisticsMap = logGroupInfoDTOS.stream().collect(Collectors.groupingBy(LogClassifyInfoDTO::getId, Collectors.summarizingLong(LogClassifyInfoDTO::getCountNumber)));
        ArrayList<LogClassifyInfoDTO> logGroupInfo = new ArrayList<LogClassifyInfoDTO>();
        for (Map.Entry<String, LongSummaryStatistics> entry : statisticsMap.entrySet()) {
            logGroupInfo.add(LogClassifyInfoDTO.builder().id(entry.getKey()).countNumber(Long.valueOf(entry.getValue().getSum())).build());
        }
        return logGroupInfo;
    }

    public Criteria c(List<com.tplink.smb.omada.common.gridquery.c> filters, List<com.tplink.smb.omada.common.gridquery.c> searchFilters, String omadacId) {
        if (CollectionUtils.isEmpty(filters)) {
            filters = new ArrayList<com.tplink.smb.omada.common.gridquery.c>(4);
        }
        if (CollectionUtils.isEmpty(searchFilters)) {
            searchFilters = new ArrayList<com.tplink.smb.omada.common.gridquery.c>(4);
        }
        filters = com.tplink.smb.omada.logmanager.port.mongo.a.c.c(filters, searchFilters);
        Criteria criteria = com.tplink.smb.omada.logmanager.port.mongo.a.a.b(searchFilters, filters);
        criteria.and("omadac_id").is((Object)omadacId);
        return criteria;
    }

    private Query a(List<com.tplink.smb.omada.common.gridquery.c> filters, List<com.tplink.smb.omada.common.gridquery.c> searchFilters, String omadacId, List<String> alertKeys) {
        if (CollectionUtils.isEmpty(filters)) {
            filters = new ArrayList<com.tplink.smb.omada.common.gridquery.c>(4);
        }
        if (CollectionUtils.isEmpty(searchFilters)) {
            searchFilters = new ArrayList<com.tplink.smb.omada.common.gridquery.c>(4);
        }
        filters = com.tplink.smb.omada.logmanager.port.mongo.a.c.c(filters, searchFilters);
        Criteria criteria = com.tplink.smb.omada.logmanager.port.mongo.a.a.b(searchFilters, filters);
        criteria.and("omadac_id").is((Object)omadacId);
        criteria.and("key").in(alertKeys);
        return new Query((CriteriaDefinition)criteria);
    }

    private Query b(List<com.tplink.smb.omada.common.gridquery.c> filters, List<com.tplink.smb.omada.common.gridquery.c> searchFilters, String omadacId, List<String> eventKeys) {
        if (CollectionUtils.isEmpty(filters)) {
            filters = new ArrayList<com.tplink.smb.omada.common.gridquery.c>(4);
        }
        if (CollectionUtils.isEmpty(searchFilters)) {
            searchFilters = new ArrayList<com.tplink.smb.omada.common.gridquery.c>(4);
        }
        filters = com.tplink.smb.omada.logmanager.port.mongo.a.c.d(filters, searchFilters);
        Criteria criteria = com.tplink.smb.omada.logmanager.port.mongo.a.a.b(searchFilters, filters);
        criteria.and("omadac_id").is((Object)omadacId);
        criteria.and("key").in(eventKeys);
        return new Query((CriteriaDefinition)criteria);
    }

    protected int a(@Nullable com.tplink.smb.omada.logmanager.domain.model.e.g key) {
        if (Objects.isNull(key)) {
            return 0;
        }
        return key.a().hashCode();
    }

    protected com.tplink.smb.omada.logmanager.port.mongo.data.a.c a() {
        return this.b;
    }

    protected Class getPOClass() {
        return LiteOmadaLogGlobalPO.class;
    }

    protected MongoTemplate getMongoTemplate() {
        return this.mongoTemplate;
    }

    @Nonnull
    protected String getCollectionNameOrPrefixIfSliced() {
        return "liteglobalomadalog";
    }

    @Nonnull
    protected IndexDefinition[] getIndexDefinitions() {
        return LiteOmadaLogGlobalPO.INDEX_DEFINITIONS;
    }

    public void a(com.tplink.smb.omada.logmanager.port.commom.service.a.c event) {
        this.dbMaintenance(event.a());
    }

    @PostConstruct
    public void b() {
        DomainEventBusHolder.getHandlerRegistry().registerSync(com.tplink.smb.omada.logmanager.port.commom.service.a.c.class, (DomainEventSubscriber)this);
    }

    protected /* synthetic */ p getStrategy() {
        return this.a();
    }

    protected /* synthetic */ int hashCodeOfKey(@Nullable Object object) {
        return this.a((com.tplink.smb.omada.logmanager.domain.model.e.g)object);
    }

    protected /* synthetic */ u getStrategy() {
        return this.a();
    }

    public /* synthetic */ void handleEvent(Object object) {
        this.a((com.tplink.smb.omada.logmanager.port.commom.service.a.c)object);
    }
}

