/*
 * Decompiled with CFR 0.152.
 */
package com.tplink.smb.omada.logmanager.port.mongo.log.b;

import com.mongodb.bulk.BulkWriteResult;
import com.mongodb.client.MongoIterable;
import com.tplink.nbu.common.utils.CollectionUtil;
import com.tplink.smb.eventcenter.api.event.DomainEventSubscriber;
import com.tplink.smb.eventcenter.domain.DomainEventBusHolder;
import com.tplink.smb.omada.common.gridquery.g;
import com.tplink.smb.omada.common.mongo.repository.p;
import com.tplink.smb.omada.common.mongo.repository.q;
import com.tplink.smb.omada.common.mongo.repository.u;
import com.tplink.smb.omada.common.util.T;
import com.tplink.smb.omada.logmanager.api.external.dto.ArchiveDTO;
import com.tplink.smb.omada.logmanager.api.internal.dto.LogClassifyInfoRequestDTO;
import com.tplink.smb.omada.logmanager.domain.model.log.AbstractOmadaLog;
import com.tplink.smb.omada.logmanager.domain.model.log.LogClassifyInfoDTO;
import com.tplink.smb.omada.logmanager.domain.model.log.LogClassifyNumberQueryDTO;
import com.tplink.smb.omada.logmanager.domain.model.log.LogGroupDTO;
import com.tplink.smb.omada.logmanager.domain.model.log.LogGroupInfoDTO;
import com.tplink.smb.omada.logmanager.domain.model.log.subscriber.AlertNumClassifyInfoDTO;
import com.tplink.smb.omada.logmanager.domain.model.log.w;
import com.tplink.smb.omada.logmanager.port.commom.c.b;
import com.tplink.smb.omada.logmanager.port.mongo.a.a;
import com.tplink.smb.omada.logmanager.port.mongo.a.c;
import com.tplink.smb.omada.logmanager.port.mongo.a.d;
import com.tplink.smb.omada.logmanager.port.mongo.data.a.l;
import com.tplink.smb.omada.logmanager.port.mongo.log.OmadaLogGlobalPO;
import com.tplink.smb.omada.logmanager.port.mongo.log.OmadaLogPO;
import com.tplink.smb.omada.logmanager.port.mongo.log.m;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import jakarta.annotation.PostConstruct;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.LongSummaryStatistics;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import java.util.stream.Collectors;
import lombok.Generated;
import org.bson.conversions.Bson;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.context.annotation.Lazy;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;
import org.springframework.data.mongodb.core.BulkOperations;
import org.springframework.data.mongodb.core.MongoTemplate;
import org.springframework.data.mongodb.core.aggregation.Aggregation;
import org.springframework.data.mongodb.core.aggregation.AggregationOperation;
import org.springframework.data.mongodb.core.index.IndexDefinition;
import org.springframework.data.mongodb.core.query.Criteria;
import org.springframework.data.mongodb.core.query.CriteriaDefinition;
import org.springframework.data.mongodb.core.query.Query;
import org.springframework.data.mongodb.core.query.Update;
import org.springframework.data.mongodb.core.query.UpdateDefinition;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;

@Component
public class e
extends q<OmadaLogGlobalPO, com.tplink.smb.omada.logmanager.domain.model.e.g>
implements DomainEventSubscriber<com.tplink.smb.omada.logmanager.port.commom.service.a.c>,
com.tplink.smb.omada.logmanager.domain.model.log.a.c {
    @Generated
    private static final Logger a = LoggerFactory.getLogger(e.class);
    @Autowired
    @Qualifier(value="dataMongoTemplate")
    private MongoTemplate mongoTemplate;
    @Autowired
    @Lazy
    private l b;
    @Autowired
    private b c;
    private static final int d = 10000;

    public void a(List<w> omadaLogs) {
        Map<String, List<OmadaLogGlobalPO>> collectionNameToPOsMap = omadaLogs.stream().map(m::b).collect(Collectors.groupingBy(x$0 -> this.getCollectionNameForSave(x$0)));
        collectionNameToPOsMap.forEach((collectionName, poList) -> {
            BulkOperations bulkOperations = this.mongoTemplate.bulkOps(BulkOperations.BulkMode.UNORDERED, collectionName);
            poList.forEach(omadaLogGlobalPO -> bulkOperations.insert(omadaLogGlobalPO));
            BulkWriteResult result = bulkOperations.execute();
            a.debug("Bulk write global omada log result: {}", (Object)result);
        });
    }

    public Long a(com.tplink.smb.omada.logmanager.domain.model.e.g omadacId) {
        Query query = new Query((CriteriaDefinition)Criteria.where((String)"omadac_id").is((Object)omadacId.a()));
        AtomicLong total = new AtomicLong(0L);
        this.iteratorCollectionsBySliceKey(omadacId, collectionName -> total.addAndGet(this.mongoTemplate.count(query, collectionName)));
        return total.get();
    }

    public int a(com.tplink.smb.omada.logmanager.domain.model.e.g omadacId, Integer topNum) {
        AtomicInteger clearedNum = new AtomicInteger(0);
        this.iteratorCollectionsByTimeAsc(0L, System.currentTimeMillis(), collectionName -> {
            int loopCount = topNum / 10000;
            for (int i2 = 0; i2 <= loopCount; ++i2) {
                int removeLimit = Math.min(topNum - clearedNum.get(), 10000);
                if (clearedNum.get() >= topNum) {
                    return;
                }
                int removed = (int)this.mongoTemplate.remove(new Query((CriteriaDefinition)Criteria.where((String)"omadac_id").is((Object)omadacId.a())).with(Sort.by((Sort.Direction)Sort.Direction.ASC, (String[])new String[]{"time"})).limit(removeLimit), collectionName).getDeletedCount();
                clearedNum.addAndGet(removed);
            }
        });
        return clearedNum.get();
    }

    public long a(com.tplink.smb.omada.logmanager.domain.model.e.g omadacId, Long startTime, Long endTime) {
        Query query = new Query();
        Criteria criteria = Criteria.where((String)"omadac_id").is((Object)omadacId.a());
        criteria.and("alert").is((Object)Boolean.TRUE);
        criteria.and("archived").is((Object)Boolean.FALSE);
        criteria.and("time").gte((Object)startTime).lte((Object)endTime);
        query.addCriteria((CriteriaDefinition)criteria);
        AtomicLong total = new AtomicLong(0L);
        this.iteratorCollectionsByTimeAndSliceKey(Sort.Direction.DESC, startTime / 1000L, endTime / 1000L, omadacId, collectionName -> total.addAndGet(this.mongoTemplate.count(query, collectionName)));
        return total.get();
    }

    public long a(com.tplink.smb.omada.logmanager.domain.model.e.g omadacId, Long startTime, Long endTime, List<String> alertKeys) {
        Query query = new Query();
        Criteria criteria = Criteria.where((String)"omadac_id").is((Object)omadacId.a());
        criteria.and("alert").is((Object)Boolean.TRUE);
        criteria.and("archived").is((Object)Boolean.FALSE);
        criteria.and("time").gte((Object)startTime).lte((Object)endTime);
        criteria.and("key").in(alertKeys);
        query.addCriteria((CriteriaDefinition)criteria);
        AtomicLong total = new AtomicLong(0L);
        this.iteratorCollectionsByTimeAndSliceKey(Sort.Direction.DESC, startTime / 1000L, endTime / 1000L, omadacId, collectionName -> total.addAndGet(this.mongoTemplate.count(query, collectionName)));
        return total.get();
    }

    public com.tplink.smb.omada.common.gridquery.a<w> a(com.tplink.smb.omada.common.gridquery.a<w> grid, String omadacId) {
        g sortDirection = ((com.tplink.smb.omada.common.gridquery.e)grid.getQuerySorts().get(0)).a();
        long count = this.a((List<com.tplink.smb.omada.common.gridquery.c>)grid.getFilters(), (List<com.tplink.smb.omada.common.gridquery.c>)grid.getSearchFilters(), omadacId, sortDirection);
        grid.setTotalRows(count);
        if (count < 1L) {
            grid.setData(Collections.EMPTY_LIST);
            return grid;
        }
        grid.setData(this.a(grid.getQueryPage(), grid.getQuerySorts(), grid.getFilters(), grid.getSearchFilters(), omadacId, count));
        return grid;
    }

    public Long a(LogClassifyNumberQueryDTO logClassifyNumberQueryDTO) {
        Query query = new Query();
        Criteria criteria = Criteria.where((String)"omadac_id").is((Object)logClassifyNumberQueryDTO.getOmadacId());
        Boolean alert = logClassifyNumberQueryDTO.getAlert();
        Boolean event = logClassifyNumberQueryDTO.getEvent();
        if (Boolean.TRUE.equals(alert)) {
            criteria.and("alert").is((Object)true);
        }
        if (Boolean.TRUE.equals(event)) {
            criteria.and("event").is((Object)true);
        }
        criteria.and("level").is((Object)logClassifyNumberQueryDTO.getLevel());
        Long startTime = logClassifyNumberQueryDTO.getStartTime();
        Long endTime = logClassifyNumberQueryDTO.getEndTime();
        criteria.and("time").gte((Object)startTime).lte((Object)endTime);
        if (Objects.nonNull(logClassifyNumberQueryDTO.getArchived())) {
            criteria.and("archived").is((Object)logClassifyNumberQueryDTO.getArchived());
        }
        if (!T.a((String)logClassifyNumberQueryDTO.getModule())) {
            criteria.and("module").is((Object)logClassifyNumberQueryDTO.getModule());
        }
        if (!T.a((String)logClassifyNumberQueryDTO.getSearchKey())) {
            criteria.andOperator(new Criteria[]{com.tplink.smb.omada.logmanager.port.mongo.a.d.a(com.tplink.smb.omada.logmanager.port.mongo.a.d.b(logClassifyNumberQueryDTO.getSearchKey()))});
        }
        query.addCriteria((CriteriaDefinition)criteria);
        AtomicLong total = new AtomicLong(0L);
        this.iteratorCollectionsByTimeAndSliceKey(Sort.Direction.DESC, startTime / 1000L, endTime / 1000L, new com.tplink.smb.omada.logmanager.domain.model.e.g(logClassifyNumberQueryDTO.getOmadacId()), collectionName -> total.addAndGet(this.mongoTemplate.count(query, OmadaLogGlobalPO.class, collectionName)));
        return total.get();
    }

    public w a(String omadacId, String logId) {
        Query query = new Query();
        Criteria criteria = Criteria.where((String)"omadac_id").is((Object)omadacId);
        criteria.and("_id").is((Object)logId);
        query.addCriteria((CriteriaDefinition)criteria);
        ArrayList omadaLogPOS = new ArrayList();
        this.iteratorCollectionsBySliceKey(new com.tplink.smb.omada.logmanager.domain.model.e.g(omadacId), collectionName -> omadaLogPOS.addAll(this.mongoTemplate.find(query, OmadaLogGlobalPO.class, collectionName)));
        if (CollectionUtils.isEmpty(omadaLogPOS) || omadaLogPOS.size() > 1) {
            return null;
        }
        return m.a((OmadaLogGlobalPO)omadaLogPOS.get(0));
    }

    public Boolean a(w omadaLog) {
        OmadaLogGlobalPO omadaLogPO = m.b(omadaLog);
        String collectionName = this.getCollectionNameForSave(omadaLogPO);
        if (CollectionUtil.isEmpty((Collection)this.mongoTemplate.find(Query.query((CriteriaDefinition)Criteria.where((String)"_id").is((Object)omadaLogPO.getId())), OmadaLogGlobalPO.class, collectionName))) {
            return Boolean.FALSE;
        }
        this.mongoTemplate.save((Object)omadaLogPO, collectionName);
        this.c.f(omadaLog.getOmadaLogEnum().a());
        return Boolean.TRUE;
    }

    public void a(String omadacId, ArchiveDTO archiveDTO) {
        Criteria criteria = new Criteria("omadac_id").is((Object)omadacId);
        criteria.and("alert").is((Object)true);
        criteria.and("archived").is((Object)false);
        Query query = Query.query((CriteriaDefinition)criteria);
        Long startTime = archiveDTO.getTimeStart() / 1000L;
        Long endTime = archiveDTO.getTimeEnd() / 1000L;
        query.addCriteria((CriteriaDefinition)Criteria.where((String)"time").gte((Object)archiveDTO.getTimeStart()).lte((Object)archiveDTO.getTimeEnd()));
        this.iteratorCollectionsByTimeAndSliceKey(Sort.Direction.DESC, startTime, endTime, new com.tplink.smb.omada.logmanager.domain.model.e.g(omadacId), collectionName -> this.mongoTemplate.updateMulti(query, (UpdateDefinition)Update.update((String)"archived", (Object)true), OmadaLogGlobalPO.class, collectionName));
    }

    public void a(String omadacId, ArchiveDTO archiveDTO, com.tplink.smb.omada.common.gridquery.a<w> grid, List<String> alertKeys) {
        grid.setFilters(com.tplink.smb.omada.logmanager.port.mongo.a.c.a(grid.getFilters()));
        Query query = this.a((List<com.tplink.smb.omada.common.gridquery.c>)grid.getFilters(), (List<com.tplink.smb.omada.common.gridquery.c>)grid.getSearchFilters(), omadacId, alertKeys);
        Long startTime = archiveDTO.getTimeStart() / 1000L;
        Long endTime = archiveDTO.getTimeEnd() / 1000L;
        query.addCriteria((CriteriaDefinition)Criteria.where((String)"time").gte((Object)archiveDTO.getTimeStart()).lte((Object)archiveDTO.getTimeEnd()));
        this.iteratorCollectionsByTimeAndSliceKey(Sort.Direction.DESC, startTime, endTime, new com.tplink.smb.omada.logmanager.domain.model.e.g(omadacId), collectionName -> this.mongoTemplate.updateMulti(query, (UpdateDefinition)Update.update((String)"archived", (Object)true), OmadaLogPO.class, collectionName));
        if (!CollectionUtils.isEmpty((Collection)archiveDTO.getLogs())) {
            Criteria criteria = Criteria.where((String)"_id").in((Collection)archiveDTO.getLogs()).and("omadac_id").is((Object)omadacId);
            Query idQuery = new Query((CriteriaDefinition)criteria);
            this.iteratorCollectionsByTimeAndSliceKey(Sort.Direction.DESC, startTime, endTime, new com.tplink.smb.omada.logmanager.domain.model.e.g(omadacId), collectionName -> this.mongoTemplate.updateMulti(idQuery, (UpdateDefinition)Update.update((String)"archived", (Object)false), OmadaLogPO.class, collectionName));
        }
    }

    public void a(String omadacId, Boolean deleteAlert, Long startTime, Long endTime) {
        Query query = new Query();
        this.a(query, omadacId, deleteAlert, startTime, endTime);
    }

    private void a(Query query, String omadacId, Boolean deleteAlert, Long startTime, Long endTime) {
        query.addCriteria((CriteriaDefinition)Criteria.where((String)"omadac_id").is((Object)omadacId));
        if (deleteAlert.booleanValue()) {
            query.addCriteria((CriteriaDefinition)Criteria.where((String)"alert").is((Object)true));
        } else {
            query.addCriteria((CriteriaDefinition)Criteria.where((String)"event").is((Object)true));
        }
        query.addCriteria((CriteriaDefinition)Criteria.where((String)"time").gte((Object)startTime).lte((Object)endTime));
        this.iteratorCollectionsByTimeAndSliceKey(Sort.Direction.DESC, startTime / 1000L, endTime / 1000L, new com.tplink.smb.omada.logmanager.domain.model.e.g(omadacId), collectionName -> this.mongoTemplate.remove(query, OmadaLogGlobalPO.class, collectionName));
    }

    public long a(List<com.tplink.smb.omada.common.gridquery.c> filters, List<com.tplink.smb.omada.common.gridquery.c> searchFilters, String omadacId, g direction) {
        if (Objects.isNull(filters)) {
            filters = new ArrayList<com.tplink.smb.omada.common.gridquery.c>();
        }
        Long[] times = com.tplink.smb.omada.logmanager.port.mongo.a.d.a(filters);
        Query query = this.a(filters, searchFilters, omadacId);
        AtomicLong total = new AtomicLong(0L);
        this.iteratorCollectionsByTimeAndSliceKey(direction.a().equals("asc") ? Sort.Direction.ASC : Sort.Direction.DESC, times[0], times[1], new com.tplink.smb.omada.logmanager.domain.model.e.g(omadacId), collectionName -> total.addAndGet(this.mongoTemplate.count(query, OmadaLogGlobalPO.class, collectionName)));
        return total.get();
    }

    public long a(String omadacId) {
        Criteria criteria = new Criteria();
        criteria.and("omadac_id").is((Object)omadacId);
        Query query = new Query((CriteriaDefinition)criteria);
        AtomicLong total = new AtomicLong(0L);
        this.iteratorCollectionsByTimeAndSliceKey(Sort.Direction.DESC, 0L, System.currentTimeMillis() / 1000L, new com.tplink.smb.omada.logmanager.domain.model.e.g(omadacId), collectionName -> total.addAndGet(this.mongoTemplate.count(query, OmadaLogGlobalPO.class, collectionName)));
        return total.get();
    }

    public List<w> a(String omadacId, com.tplink.smb.omada.common.gridquery.d queryPage) {
        Query query = new Query();
        query.with((Pageable)PageRequest.of((int)queryPage.a(), (int)queryPage.b()));
        query.addCriteria((CriteriaDefinition)Criteria.where((String)"omadac_id").is((Object)omadacId));
        ArrayList<w> omadaLogs = new ArrayList<w>();
        long endTime = System.currentTimeMillis() / 1000L;
        this.iteratorCollectionsByTimeAndSliceKeyWithSkip(Sort.Direction.DESC, 0L, endTime, new com.tplink.smb.omada.logmanager.domain.model.e.g(omadacId), query, (collectionName, queryCollection) -> omadaLogs.addAll(this.mongoTemplate.find(queryCollection, OmadaLogGlobalPO.class, collectionName).stream().map(m::a).collect(Collectors.toList())));
        return omadaLogs;
    }

    public void a(String omadacId, com.tplink.smb.omada.common.util.c.a<w> consumer) {
        Query query = new Query();
        query.addCriteria((CriteriaDefinition)Criteria.where((String)"omadac_id").is((Object)omadacId));
        long endTime = System.currentTimeMillis() / 1000L;
        this.iteratorCollectionsByTimeAndSliceKey(Sort.Direction.DESC, 0L, endTime, new com.tplink.smb.omada.logmanager.domain.model.e.g(omadacId), collectionName -> {
            MongoIterable iterable = this.mongoTemplate.getCollection(collectionName).find((Bson)query.getQueryObject()).batchSize(1000).map(src -> (OmadaLogGlobalPO)this.mongoTemplate.getConverter().read(OmadaLogGlobalPO.class, src));
            iterable.forEach(po -> consumer.a((Object)m.a(po)));
        });
    }

    public void a(String omadacId, Long startTime, Long endTime, List<String> logKeys) {
        Query query = new Query();
        query.addCriteria((CriteriaDefinition)Criteria.where((String)"omadac_id").is((Object)omadacId));
        query.addCriteria((CriteriaDefinition)Criteria.where((String)"time").gte((Object)startTime).lte((Object)endTime));
        query.addCriteria((CriteriaDefinition)Criteria.where((String)"key").in(logKeys));
        ArrayList collectionNames = new ArrayList();
        this.iteratorCollectionsByTimeAndSliceKey(Sort.Direction.ASC, startTime / 1000L, endTime / 1000L, new com.tplink.smb.omada.logmanager.domain.model.e.g(omadacId), collectionName -> collectionNames.add(collectionName));
        for (String c2 : collectionNames) {
            this.mongoTemplate.remove(query, OmadaLogGlobalPO.class, c2);
            a.debug("Iterating collection(delete by type): {}", (Object)c2);
        }
    }

    public List<w> a(com.tplink.smb.omada.common.gridquery.d page, List<com.tplink.smb.omada.common.gridquery.e> sort, List<com.tplink.smb.omada.common.gridquery.c> filters, List<com.tplink.smb.omada.common.gridquery.c> searchFilters, String omadacId, long count) {
        if (Objects.isNull(filters)) {
            filters = new ArrayList<com.tplink.smb.omada.common.gridquery.c>();
        }
        Query query = this.a(filters, searchFilters, omadacId);
        Long[] times = com.tplink.smb.omada.logmanager.port.mongo.a.d.a(filters);
        boolean reverse = this.a(page, query, sort, Sort.Direction.fromString((String)sort.get(0).a().a()), count);
        Sort.Direction direction = sort.get(0).a().a().equals("asc") ? Sort.Direction.ASC : Sort.Direction.DESC;
        com.tplink.smb.omada.logmanager.port.mongo.a.a.a(query, sort);
        ArrayList omadaLogPOS = new ArrayList();
        this.iteratorCollectionsByTimeAndSliceKeyWithSkip(direction, times[0], times[1], new com.tplink.smb.omada.logmanager.domain.model.e.g(omadacId), query, (collectionName, queryFilter) -> omadaLogPOS.addAll(this.mongoTemplate.find(queryFilter, OmadaLogGlobalPO.class, collectionName)));
        if (reverse) {
            return omadaLogPOS.stream().map(m::a).sorted(Comparator.comparing(AbstractOmadaLog::getTime).reversed()).collect(Collectors.toList());
        }
        return omadaLogPOS.stream().map(m::a).collect(Collectors.toList());
    }

    private boolean a(com.tplink.smb.omada.common.gridquery.d page, Query query, List<com.tplink.smb.omada.common.gridquery.e> querySorts, Sort.Direction direction, long count) {
        int pageSize;
        if (Objects.isNull(page)) {
            return false;
        }
        int pageNum = page.a();
        if ((long)(pageNum * (pageSize = page.b()) * 2) < count) {
            query.limit(page.b()).skip((long)(page.a() * page.b()));
            return false;
        }
        int lastPageSize = (int)(count % (long)pageSize);
        int reversePageNum = (int)(count - (long)(pageNum * pageSize)) / pageSize;
        page.a(reversePageNum);
        if (lastPageSize > 0) {
            if (reversePageNum == 0) {
                query.limit(lastPageSize);
            } else {
                query.limit(page.b()).skip((long)(lastPageSize + (reversePageNum - 1) * page.b()));
            }
        } else {
            query.limit(page.b()).skip((long)(reversePageNum * page.b()));
        }
        if (!CollectionUtils.isEmpty(querySorts)) {
            for (com.tplink.smb.omada.common.gridquery.e sort : querySorts) {
                if (direction.isAscending()) {
                    sort.a(g.a);
                    continue;
                }
                sort.a(g.b);
            }
        }
        return true;
    }

    public Query a(List<com.tplink.smb.omada.common.gridquery.c> filters, List<com.tplink.smb.omada.common.gridquery.c> searchFilters, String omadacId) {
        if (CollectionUtils.isEmpty(filters)) {
            filters = new ArrayList<com.tplink.smb.omada.common.gridquery.c>(4);
        }
        if (CollectionUtils.isEmpty(searchFilters)) {
            searchFilters = new ArrayList<com.tplink.smb.omada.common.gridquery.c>(4);
        }
        filters = com.tplink.smb.omada.logmanager.port.mongo.a.c.d(filters, searchFilters);
        Criteria criteria = com.tplink.smb.omada.logmanager.port.mongo.a.a.b(searchFilters, filters);
        criteria.and("omadac_id").is((Object)omadacId);
        return new Query((CriteriaDefinition)criteria);
    }

    public Criteria b(List<com.tplink.smb.omada.common.gridquery.c> filters, List<com.tplink.smb.omada.common.gridquery.c> searchFilters, String omadacId) {
        if (CollectionUtils.isEmpty(filters)) {
            filters = new ArrayList<com.tplink.smb.omada.common.gridquery.c>(4);
        }
        if (CollectionUtils.isEmpty(searchFilters)) {
            searchFilters = new ArrayList<com.tplink.smb.omada.common.gridquery.c>(4);
        }
        filters = com.tplink.smb.omada.logmanager.port.mongo.a.c.c(filters, searchFilters);
        Criteria criteria = com.tplink.smb.omada.logmanager.port.mongo.a.a.b(searchFilters, filters);
        criteria.and("omadac_id").is((Object)omadacId);
        return criteria;
    }

    public Criteria c(List<com.tplink.smb.omada.common.gridquery.c> filters, List<com.tplink.smb.omada.common.gridquery.c> searchFilters, String omadacId) {
        if (CollectionUtils.isEmpty(filters)) {
            filters = new ArrayList<com.tplink.smb.omada.common.gridquery.c>(4);
        }
        if (CollectionUtils.isEmpty(searchFilters)) {
            searchFilters = new ArrayList<com.tplink.smb.omada.common.gridquery.c>(4);
        }
        filters = com.tplink.smb.omada.logmanager.port.mongo.a.c.d(filters, searchFilters);
        Criteria criteria = com.tplink.smb.omada.logmanager.port.mongo.a.a.b(searchFilters, filters);
        criteria.and("omadac_id").is((Object)omadacId);
        return criteria;
    }

    public List<LogGroupInfoDTO> a(LogClassifyInfoRequestDTO logClassifyInfoRequestDTO, String ... groupKeys) {
        String omadacId = logClassifyInfoRequestDTO.getOmadacId();
        Long startTime = logClassifyInfoRequestDTO.getStartTime();
        Long endTime = logClassifyInfoRequestDTO.getEndTime();
        Criteria criteria = Criteria.where((String)"omadac_id").is((Object)omadacId);
        switch (logClassifyInfoRequestDTO.getLogTypeEnum()) {
            case a: {
                criteria.and("alert").is((Object)Boolean.TRUE);
                break;
            }
            case b: {
                criteria.and("event").is((Object)Boolean.TRUE);
                break;
            }
            case c: {
                criteria.andOperator(new Criteria[]{new Criteria().orOperator(new Criteria[]{Criteria.where((String)"alert").is((Object)Boolean.TRUE), Criteria.where((String)"event").is((Object)Boolean.TRUE)})});
                break;
            }
            default: {
                a.warn("Unknown log type: {}", (Object)logClassifyInfoRequestDTO.getLogTypeEnum());
                return new ArrayList<LogGroupInfoDTO>();
            }
        }
        criteria.and("time").gte((Object)startTime).lte((Object)endTime);
        if (Objects.nonNull(logClassifyInfoRequestDTO.getDeviceType()) && T.b((String)logClassifyInfoRequestDTO.getDeviceType().b())) {
            criteria.and("device_type").is((Object)logClassifyInfoRequestDTO.getDeviceType().c());
        }
        Aggregation aggregation = Aggregation.newAggregation((AggregationOperation[])new AggregationOperation[]{Aggregation.match((Criteria)criteria), Aggregation.group((String[])groupKeys).count().as("countNumber")});
        ArrayList logGroupInfoDTOS = new ArrayList();
        this.iteratorCollectionsByTimeAndSliceKey(Sort.Direction.DESC, startTime / 1000L, endTime / 1000L, new com.tplink.smb.omada.logmanager.domain.model.e.g(omadacId), collectionName -> logGroupInfoDTOS.addAll(this.mongoTemplate.aggregate(aggregation, collectionName, LogGroupInfoDTO.class).getMappedResults()));
        Map<LogGroupDTO, LongSummaryStatistics> statisticsMap = logGroupInfoDTOS.stream().collect(Collectors.groupingBy(LogGroupInfoDTO::getId, Collectors.summarizingLong(LogGroupInfoDTO::getCountNumber)));
        ArrayList<LogGroupInfoDTO> logGroupList = new ArrayList<LogGroupInfoDTO>();
        for (Map.Entry<LogGroupDTO, LongSummaryStatistics> entry : statisticsMap.entrySet()) {
            logGroupList.add(LogGroupInfoDTO.builder().id(entry.getKey()).countNumber(Long.valueOf(entry.getValue().getSum())).build());
        }
        return logGroupList;
    }

    public List<LogClassifyInfoDTO> b(LogClassifyNumberQueryDTO logClassifyNumberQueryDTO) {
        String omadacId = logClassifyNumberQueryDTO.getOmadacId();
        Criteria criteria = Criteria.where((String)"omadac_id").is((Object)omadacId);
        Boolean alert = logClassifyNumberQueryDTO.getAlert();
        Boolean event = logClassifyNumberQueryDTO.getEvent();
        if (Boolean.TRUE.equals(alert)) {
            criteria.and("alert").is((Object)true);
        }
        if (Boolean.TRUE.equals(event)) {
            criteria.and("event").is((Object)true);
        }
        long startTime = logClassifyNumberQueryDTO.getStartTime();
        long endTime = logClassifyNumberQueryDTO.getEndTime();
        criteria.and("time").gte((Object)startTime).lte((Object)endTime);
        if (Objects.nonNull(logClassifyNumberQueryDTO.getArchived())) {
            criteria.and("archived").is((Object)logClassifyNumberQueryDTO.getArchived());
        }
        if (!T.a((String)logClassifyNumberQueryDTO.getModule())) {
            criteria.and("module").is((Object)logClassifyNumberQueryDTO.getModule());
        }
        if (!T.a((String)logClassifyNumberQueryDTO.getSearchKey())) {
            criteria.andOperator(new Criteria[]{com.tplink.smb.omada.logmanager.port.mongo.a.d.a(com.tplink.smb.omada.logmanager.port.mongo.a.d.b(logClassifyNumberQueryDTO.getSearchKey()))});
        }
        Aggregation aggregation = Aggregation.newAggregation((AggregationOperation[])new AggregationOperation[]{Aggregation.match((Criteria)criteria), Aggregation.group((String[])new String[]{logClassifyNumberQueryDTO.getGroupKey()}).count().as("countNumber")});
        ArrayList logGroupInfoDTOS = new ArrayList();
        this.iteratorCollectionsByTimeAndSliceKey(Sort.Direction.DESC, startTime / 1000L, endTime / 1000L, new com.tplink.smb.omada.logmanager.domain.model.e.g(omadacId), collectionName -> logGroupInfoDTOS.addAll(this.mongoTemplate.aggregate(aggregation, collectionName, LogClassifyInfoDTO.class).getMappedResults()));
        Map<String, LongSummaryStatistics> statisticsMap = logGroupInfoDTOS.stream().collect(Collectors.groupingBy(LogClassifyInfoDTO::getId, Collectors.summarizingLong(LogClassifyInfoDTO::getCountNumber)));
        ArrayList<LogClassifyInfoDTO> logGroupInfo = new ArrayList<LogClassifyInfoDTO>();
        for (Map.Entry<String, LongSummaryStatistics> entry : statisticsMap.entrySet()) {
            logGroupInfo.add(LogClassifyInfoDTO.builder().id(entry.getKey()).countNumber(Long.valueOf(entry.getValue().getSum())).build());
        }
        return logGroupInfo;
    }

    public Long a(String omadacId, com.tplink.smb.omada.common.gridquery.a<w> grid, Long startTime, Long endTime, List<String> alertKeys) {
        grid.setFilters(com.tplink.smb.omada.logmanager.port.mongo.a.c.b(grid.getFilters()));
        grid.setFilters(com.tplink.smb.omada.logmanager.port.mongo.a.c.c(grid.getFilters()));
        Criteria criteria = this.b((List<com.tplink.smb.omada.common.gridquery.c>)grid.getFilters(), grid.getSearchFilters(), omadacId);
        criteria.and("key").in(alertKeys);
        Query query = new Query((CriteriaDefinition)criteria);
        AtomicLong count = new AtomicLong();
        this.iteratorCollectionsByTimeAndSliceKey(Sort.Direction.DESC, startTime / 1000L, endTime / 1000L, new com.tplink.smb.omada.logmanager.domain.model.e.g(omadacId), collectionName -> count.addAndGet(this.mongoTemplate.count(query, OmadaLogGlobalPO.class, collectionName)));
        return count.get();
    }

    public Long b(String omadacId, com.tplink.smb.omada.common.gridquery.a<w> grid, Long startTime, Long endTime, List<String> alertKeys) {
        grid.setFilters(com.tplink.smb.omada.logmanager.port.mongo.a.c.b(grid.getFilters()));
        grid.setFilters(com.tplink.smb.omada.logmanager.port.mongo.a.c.c(grid.getFilters()));
        Criteria criteria = this.b((List<com.tplink.smb.omada.common.gridquery.c>)grid.getFilters(), grid.getSearchFilters(), omadacId);
        criteria.and("key").in(alertKeys);
        criteria.and("archived").is((Object)true);
        Query query = new Query((CriteriaDefinition)criteria);
        AtomicLong count = new AtomicLong();
        this.iteratorCollectionsByTimeAndSliceKey(Sort.Direction.DESC, startTime / 1000L, endTime / 1000L, new com.tplink.smb.omada.logmanager.domain.model.e.g(omadacId), collectionName -> count.addAndGet(this.mongoTemplate.count(query, OmadaLogGlobalPO.class, collectionName)));
        return count.get();
    }

    public Long c(String omadacId, com.tplink.smb.omada.common.gridquery.a<w> grid, Long startTime, Long endTime, List<String> alertKeys) {
        grid.setFilters(com.tplink.smb.omada.logmanager.port.mongo.a.c.b(grid.getFilters()));
        grid.setFilters(com.tplink.smb.omada.logmanager.port.mongo.a.c.c(grid.getFilters()));
        Criteria criteria = this.b((List<com.tplink.smb.omada.common.gridquery.c>)grid.getFilters(), grid.getSearchFilters(), omadacId);
        criteria.and("key").in(alertKeys);
        criteria.and("archived").is((Object)false);
        Query query = new Query((CriteriaDefinition)criteria);
        AtomicLong count = new AtomicLong();
        this.iteratorCollectionsByTimeAndSliceKey(Sort.Direction.DESC, startTime / 1000L, endTime / 1000L, new com.tplink.smb.omada.logmanager.domain.model.e.g(omadacId), collectionName -> count.addAndGet(this.mongoTemplate.count(query, OmadaLogGlobalPO.class, collectionName)));
        return count.get();
    }

    public Long d(String omadacId, com.tplink.smb.omada.common.gridquery.a<w> grid, Long startTime, Long endTime, List<String> eventKeys) {
        grid.setFilters(com.tplink.smb.omada.logmanager.port.mongo.a.c.b(grid.getFilters()));
        grid.setFilters(com.tplink.smb.omada.logmanager.port.mongo.a.c.c(grid.getFilters()));
        Criteria criteria = this.c((List<com.tplink.smb.omada.common.gridquery.c>)grid.getFilters(), grid.getSearchFilters(), omadacId);
        criteria.and("key").in(eventKeys);
        Query query = new Query((CriteriaDefinition)criteria);
        AtomicLong count = new AtomicLong();
        this.iteratorCollectionsByTimeAndSliceKey(Sort.Direction.DESC, startTime / 1000L, endTime / 1000L, new com.tplink.smb.omada.logmanager.domain.model.e.g(omadacId), collectionName -> count.addAndGet(this.mongoTemplate.count(query, OmadaLogGlobalPO.class, collectionName)));
        return count.get();
    }

    public Long a(String omadacId, com.tplink.smb.omada.common.gridquery.a<w> grid, Long startTime, Long endTime) {
        grid.setFilters(com.tplink.smb.omada.logmanager.port.mongo.a.c.b(grid.getFilters()));
        grid.setFilters(com.tplink.smb.omada.logmanager.port.mongo.a.c.c(grid.getFilters()));
        Criteria criteria = this.c((List<com.tplink.smb.omada.common.gridquery.c>)grid.getFilters(), grid.getSearchFilters(), omadacId);
        Query query = new Query((CriteriaDefinition)criteria);
        AtomicLong count = new AtomicLong();
        this.iteratorCollectionsByTimeAndSliceKey(Sort.Direction.DESC, startTime / 1000L, endTime / 1000L, new com.tplink.smb.omada.logmanager.domain.model.e.g(omadacId), collectionName -> count.addAndGet(this.mongoTemplate.count(query, OmadaLogGlobalPO.class, collectionName)));
        return count.get();
    }

    public List<LogClassifyInfoDTO> e(String omadacId, com.tplink.smb.omada.common.gridquery.a<w> grid, Long startTime, Long endTime, List<String> alertKeys) {
        grid.setFilters(com.tplink.smb.omada.logmanager.port.mongo.a.c.b(grid.getFilters()));
        Criteria criteria = this.b((List<com.tplink.smb.omada.common.gridquery.c>)grid.getFilters(), grid.getSearchFilters(), omadacId);
        criteria.and("key").in(alertKeys);
        return this.a(criteria, "level", omadacId, startTime, endTime);
    }

    public List<LogClassifyInfoDTO> f(String omadacId, com.tplink.smb.omada.common.gridquery.a<w> grid, Long startTime, Long endTime, List<String> alertKeys) {
        grid.setFilters(com.tplink.smb.omada.logmanager.port.mongo.a.c.b(grid.getFilters()));
        Criteria criteria = this.b((List<com.tplink.smb.omada.common.gridquery.c>)grid.getFilters(), grid.getSearchFilters(), omadacId);
        criteria.and("key").in(alertKeys);
        criteria.and("archived").is((Object)false);
        return this.a(criteria, "level", omadacId, startTime, endTime);
    }

    public List<LogClassifyInfoDTO> g(String omadacId, com.tplink.smb.omada.common.gridquery.a<w> grid, Long startTime, Long endTime, List<String> alertKeys) {
        grid.setFilters(com.tplink.smb.omada.logmanager.port.mongo.a.c.b(grid.getFilters()));
        Criteria criteria = this.b((List<com.tplink.smb.omada.common.gridquery.c>)grid.getFilters(), grid.getSearchFilters(), omadacId);
        criteria.and("key").in(alertKeys);
        criteria.and("archived").is((Object)true);
        return this.a(criteria, "level", omadacId, startTime, endTime);
    }

    public List<LogClassifyInfoDTO> h(String omadacId, com.tplink.smb.omada.common.gridquery.a<w> grid, Long startTime, Long endTime, List<String> alertKeys) {
        grid.setFilters(com.tplink.smb.omada.logmanager.port.mongo.a.c.b(grid.getFilters()));
        grid.setFilters(com.tplink.smb.omada.logmanager.port.mongo.a.c.c(grid.getFilters()));
        Criteria criteria = this.b((List<com.tplink.smb.omada.common.gridquery.c>)grid.getFilters(), grid.getSearchFilters(), omadacId);
        criteria.and("key").in(alertKeys);
        return this.a(criteria, "module", omadacId, startTime, endTime);
    }

    public List<LogClassifyInfoDTO> i(String omadacId, com.tplink.smb.omada.common.gridquery.a<w> grid, Long startTime, Long endTime, List<String> alertKeys) {
        grid.setFilters(com.tplink.smb.omada.logmanager.port.mongo.a.c.b(grid.getFilters()));
        grid.setFilters(com.tplink.smb.omada.logmanager.port.mongo.a.c.c(grid.getFilters()));
        Criteria criteria = this.b((List<com.tplink.smb.omada.common.gridquery.c>)grid.getFilters(), grid.getSearchFilters(), omadacId);
        criteria.and("key").in(alertKeys);
        criteria.and("archived").is((Object)false);
        return this.a(criteria, "module", omadacId, startTime, endTime);
    }

    public List<LogClassifyInfoDTO> j(String omadacId, com.tplink.smb.omada.common.gridquery.a<w> grid, Long startTime, Long endTime, List<String> alertKeys) {
        grid.setFilters(com.tplink.smb.omada.logmanager.port.mongo.a.c.b(grid.getFilters()));
        grid.setFilters(com.tplink.smb.omada.logmanager.port.mongo.a.c.c(grid.getFilters()));
        Criteria criteria = this.b((List<com.tplink.smb.omada.common.gridquery.c>)grid.getFilters(), grid.getSearchFilters(), omadacId);
        criteria.and("key").in(alertKeys);
        criteria.and("archived").is((Object)true);
        return this.a(criteria, "module", omadacId, startTime, endTime);
    }

    public List<LogClassifyInfoDTO> k(String omadacId, com.tplink.smb.omada.common.gridquery.a<w> grid, Long startTime, Long endTime, List<String> eventKeys) {
        grid.setFilters(com.tplink.smb.omada.logmanager.port.mongo.a.c.b(grid.getFilters()));
        grid.setFilters(com.tplink.smb.omada.logmanager.port.mongo.a.c.c(grid.getFilters()));
        Criteria criteria = this.c((List<com.tplink.smb.omada.common.gridquery.c>)grid.getFilters(), grid.getSearchFilters(), omadacId);
        criteria.and("key").in(eventKeys);
        return this.a(criteria, "module", omadacId, startTime, endTime);
    }

    public Map<String, Long> a(Set<String> customers, Long startTime, Long endTime) {
        Criteria criteria = Criteria.where((String)"omadac_id").in(customers);
        criteria.and("time").gte((Object)startTime).lte((Object)endTime);
        criteria.and("archived").is((Object)Boolean.FALSE);
        criteria.and("alert").is((Object)Boolean.TRUE);
        Aggregation aggregation = Aggregation.newAggregation((AggregationOperation[])new AggregationOperation[]{Aggregation.match((Criteria)criteria), Aggregation.group((String[])new String[]{"omadac_id"}).count().as("alertNumber")});
        ArrayList numClassifyInfoDTOS = new ArrayList();
        this.iteratorCollectionsByTime(Sort.Direction.DESC, startTime / 1000L, endTime / 1000L, collectionName -> numClassifyInfoDTOS.addAll(this.mongoTemplate.aggregate(aggregation, collectionName, AlertNumClassifyInfoDTO.class).getMappedResults()));
        Map<String, LongSummaryStatistics> statisticsMap = numClassifyInfoDTOS.stream().collect(Collectors.groupingBy(AlertNumClassifyInfoDTO::getId, Collectors.summarizingLong(AlertNumClassifyInfoDTO::getAlertNumber)));
        HashMap<String, Long> customersAlertNumMap = new HashMap<String, Long>(statisticsMap.size());
        for (Map.Entry<String, LongSummaryStatistics> entry : statisticsMap.entrySet()) {
            customersAlertNumMap.put(entry.getKey(), entry.getValue().getSum());
        }
        return customersAlertNumMap;
    }

    public int a(com.tplink.smb.omada.logmanager.domain.model.e.g omadacId, List<String> ids, Long startTime, Long endTime) {
        Query query = new Query();
        AtomicInteger clearedNum = new AtomicInteger(0);
        int topNum = ids.size();
        query.addCriteria((CriteriaDefinition)Criteria.where((String)"omadac_id").is((Object)omadacId.a()));
        query.addCriteria((CriteriaDefinition)Criteria.where((String)"_id").in(ids));
        this.iteratorCollectionsByTimeAndSliceKey(Sort.Direction.DESC, startTime / 1000L, endTime / 1000L, omadacId, collectionName -> {
            if (clearedNum.get() >= topNum) {
                return;
            }
            int removed = (int)this.mongoTemplate.remove(query, collectionName).getDeletedCount();
            clearedNum.addAndGet(removed);
        });
        return clearedNum.get();
    }

    public void a(com.tplink.smb.omada.logmanager.domain.model.e.g omadacId, com.tplink.smb.omada.common.gridquery.a<w> grid, List<String> ids, List<String> alertKeys, Long startTime, Long endTime, Boolean isAlert) {
        ArrayList<w> omadaLogs = new ArrayList<w>();
        if (!CollectionUtils.isEmpty(ids)) {
            Criteria criteria = Criteria.where((String)"_id").in(ids).and("omadac_id").is((Object)omadacId.a());
            Query idQuery = new Query((CriteriaDefinition)criteria);
            this.iteratorCollectionsByTimeAndSliceKey(Sort.Direction.DESC, startTime / 1000L, endTime / 1000L, omadacId, collectionName -> omadaLogs.addAll(this.mongoTemplate.find(idQuery, OmadaLogGlobalPO.class, collectionName).stream().map(m::a).collect(Collectors.toList())));
        }
        for (w omadalog : omadaLogs) {
            ids.remove(omadalog.getId().a());
        }
        grid.setFilters(com.tplink.smb.omada.logmanager.port.mongo.a.c.a(grid.getFilters()));
        Query query = this.a((List<com.tplink.smb.omada.common.gridquery.c>)grid.getFilters(), grid.getSearchFilters(), omadacId.a());
        if (isAlert.booleanValue()) {
            query.addCriteria((CriteriaDefinition)Criteria.where((String)"key").in(alertKeys));
        }
        this.iteratorCollectionsByTimeAndSliceKey(Sort.Direction.DESC, startTime / 1000L, endTime / 1000L, omadacId, collectionName -> this.mongoTemplate.remove(query, collectionName));
        if (!CollectionUtils.isEmpty(omadaLogs)) {
            this.a(omadaLogs);
        }
    }

    public void b(com.tplink.smb.omada.logmanager.domain.model.e.g omadacId, List<String> ids, Long startTime, Long endTime) {
        Query query = new Query();
        this.a(omadacId, ids, startTime, endTime, query);
    }

    public List<String> a(String omadacId, Long startTime, Long endTime, g direction) {
        ArrayList<String> collectionNames = new ArrayList<String>();
        this.iteratorCollectionsByTimeAndSliceKey(g.a.equals((Object)direction) ? Sort.Direction.DESC : Sort.Direction.ASC, startTime, endTime, new com.tplink.smb.omada.logmanager.domain.model.e.g(omadacId), collectionName -> collectionNames.add((String)collectionName));
        return collectionNames;
    }

    public Long a(String omadacId, String collectionName, com.tplink.smb.omada.common.gridquery.a grid) {
        return this.mongoTemplate.count(this.a((List<com.tplink.smb.omada.common.gridquery.c>)grid.getFilters(), grid.getSearchFilters(), omadacId), OmadaLogGlobalPO.class, collectionName);
    }

    public Long a(String omadacId, String collectionName, com.tplink.smb.omada.common.gridquery.a grid, List<String> alertKeys) {
        return this.mongoTemplate.count(this.a((List<com.tplink.smb.omada.common.gridquery.c>)grid.getFilters(), (List<com.tplink.smb.omada.common.gridquery.c>)grid.getSearchFilters(), omadacId, alertKeys), OmadaLogGlobalPO.class, collectionName);
    }

    public Long b(String omadacId, String collectionName, com.tplink.smb.omada.common.gridquery.a grid, List<String> eventKeys) {
        return this.mongoTemplate.count(this.b(grid.getFilters(), grid.getSearchFilters(), omadacId, eventKeys), OmadaLogGlobalPO.class, collectionName);
    }

    public List<w> a(String omadacId, String collectionName, com.tplink.smb.omada.common.gridquery.a grid, Long skip, Integer limit) {
        Query query = this.a((List<com.tplink.smb.omada.common.gridquery.c>)grid.getFilters(), grid.getSearchFilters(), omadacId);
        com.tplink.smb.omada.logmanager.port.mongo.a.a.a(query, grid.getQuerySorts());
        query.skip(skip.longValue());
        query.limit(limit.intValue());
        return this.mongoTemplate.find(query, OmadaLogGlobalPO.class, collectionName).stream().map(m::a).collect(Collectors.toList());
    }

    public List<w> a(String omadacId, String collectionName, com.tplink.smb.omada.common.gridquery.a grid, Long skip, Integer limit, List<String> alertKeys) {
        Query query = this.a((List<com.tplink.smb.omada.common.gridquery.c>)grid.getFilters(), (List<com.tplink.smb.omada.common.gridquery.c>)grid.getSearchFilters(), omadacId, alertKeys);
        com.tplink.smb.omada.logmanager.port.mongo.a.a.a(query, grid.getQuerySorts());
        query.skip(skip.longValue());
        query.limit(limit.intValue());
        return this.mongoTemplate.find(query, OmadaLogGlobalPO.class, collectionName).stream().map(m::a).collect(Collectors.toList());
    }

    public List<w> b(String omadacId, String collectionName, com.tplink.smb.omada.common.gridquery.a grid, Long skip, Integer limit, List<String> eventKeys) {
        Query query = this.b(grid.getFilters(), grid.getSearchFilters(), omadacId, eventKeys);
        com.tplink.smb.omada.logmanager.port.mongo.a.a.a(query, grid.getQuerySorts());
        query.skip(skip.longValue());
        query.limit(limit.intValue());
        return this.mongoTemplate.find(query, OmadaLogGlobalPO.class, collectionName).stream().map(m::a).collect(Collectors.toList());
    }

    public void a(ArchiveDTO archiveDTO) {
        Criteria criteria = new Criteria("alert").is((Object)true);
        criteria.and("archived").is((Object)false);
        Query query = Query.query((CriteriaDefinition)criteria);
        Long startTime = archiveDTO.getTimeStart() / 1000L;
        Long endTime = archiveDTO.getTimeEnd() / 1000L;
        query.addCriteria((CriteriaDefinition)Criteria.where((String)"time").gte((Object)archiveDTO.getTimeStart()).lte((Object)archiveDTO.getTimeEnd()));
        this.iteratorCollectionsByTime(Sort.Direction.DESC, startTime, endTime, collectionName -> this.mongoTemplate.updateMulti(query, (UpdateDefinition)Update.update((String)"archived", (Object)true), OmadaLogGlobalPO.class, collectionName));
    }

    public void a() {
        long currentTime = System.currentTimeMillis() / 1000L;
        long timeEnd = currentTime - 604800L;
        long timeStart = currentTime - 2592000L;
        this.iteratorCollectionsByTime(Sort.Direction.DESC, timeStart, timeEnd, collectionName -> this.checkThenEnsureIndexes((String)collectionName, this.getIndexDefinitions()));
    }

    private Query a(List<com.tplink.smb.omada.common.gridquery.c> filters, List<com.tplink.smb.omada.common.gridquery.c> searchFilters, String omadacId, List<String> alertKeys) {
        if (CollectionUtils.isEmpty(filters)) {
            filters = new ArrayList<com.tplink.smb.omada.common.gridquery.c>(4);
        }
        if (CollectionUtils.isEmpty(searchFilters)) {
            searchFilters = new ArrayList<com.tplink.smb.omada.common.gridquery.c>(4);
        }
        filters = com.tplink.smb.omada.logmanager.port.mongo.a.c.c(filters, searchFilters);
        Criteria criteria = com.tplink.smb.omada.logmanager.port.mongo.a.a.b(searchFilters, filters);
        criteria.and("omadac_id").is((Object)omadacId);
        criteria.and("key").in(alertKeys);
        return new Query((CriteriaDefinition)criteria);
    }

    private Query b(List<com.tplink.smb.omada.common.gridquery.c> filters, List<com.tplink.smb.omada.common.gridquery.c> searchFilters, String omadacId, List<String> eventKeys) {
        if (CollectionUtils.isEmpty(filters)) {
            filters = new ArrayList<com.tplink.smb.omada.common.gridquery.c>(4);
        }
        if (CollectionUtils.isEmpty(searchFilters)) {
            searchFilters = new ArrayList<com.tplink.smb.omada.common.gridquery.c>(4);
        }
        filters = com.tplink.smb.omada.logmanager.port.mongo.a.c.d(filters, searchFilters);
        Criteria criteria = com.tplink.smb.omada.logmanager.port.mongo.a.a.b(searchFilters, filters);
        criteria.and("omadac_id").is((Object)omadacId);
        criteria.and("key").in(eventKeys);
        return new Query((CriteriaDefinition)criteria);
    }

    public void b(com.tplink.smb.omada.logmanager.domain.model.e.g omadacId) {
        a.debug("start to delete all global level logs of omadacId: {}", (Object)omadacId);
        long start = System.currentTimeMillis();
        this.iteratorCollectionsBySliceKey(omadacId, collectionName -> this.mongoTemplate.dropCollection(collectionName));
        a.debug("delete all global level log by drop collection of omadacId : {} use {} ms", (Object)omadacId, (Object)(System.currentTimeMillis() - start));
    }

    private void a(com.tplink.smb.omada.logmanager.domain.model.e.g omadacId, List<String> ids, Long startTime, Long endTime, Query query) {
        query.addCriteria((CriteriaDefinition)Criteria.where((String)"omadac_id").is((Object)omadacId.a()));
        query.addCriteria((CriteriaDefinition)Criteria.where((String)"_id").in(ids));
        Update update = new Update();
        update.set("archived", (Object)true);
        this.iteratorCollectionsByTimeAndSliceKey(Sort.Direction.DESC, startTime / 1000L, endTime / 1000L, omadacId, collectionName -> this.mongoTemplate.updateMulti(query, (UpdateDefinition)update, OmadaLogGlobalPO.class, collectionName));
    }

    private List<LogClassifyInfoDTO> a(Criteria criteria, String groupKey, String omadacId, Long startTime, Long endTime) {
        Aggregation aggregation = Aggregation.newAggregation((AggregationOperation[])new AggregationOperation[]{Aggregation.match((Criteria)criteria), Aggregation.group((String[])new String[]{groupKey}).count().as("countNumber")});
        ArrayList logGroupInfoDTOS = new ArrayList();
        this.iteratorCollectionsByTimeAndSliceKey(Sort.Direction.DESC, startTime / 1000L, endTime / 1000L, new com.tplink.smb.omada.logmanager.domain.model.e.g(omadacId), collectionName -> logGroupInfoDTOS.addAll(this.mongoTemplate.aggregate(aggregation, collectionName, LogClassifyInfoDTO.class).getMappedResults()));
        Map<String, LongSummaryStatistics> statisticsMap = logGroupInfoDTOS.stream().collect(Collectors.groupingBy(LogClassifyInfoDTO::getId, Collectors.summarizingLong(LogClassifyInfoDTO::getCountNumber)));
        ArrayList<LogClassifyInfoDTO> logGroupInfo = new ArrayList<LogClassifyInfoDTO>();
        for (Map.Entry<String, LongSummaryStatistics> entry : statisticsMap.entrySet()) {
            logGroupInfo.add(LogClassifyInfoDTO.builder().id(entry.getKey()).countNumber(Long.valueOf(entry.getValue().getSum())).build());
        }
        return logGroupInfo;
    }

    protected int c(@Nullable com.tplink.smb.omada.logmanager.domain.model.e.g key) {
        if (Objects.isNull(key)) {
            return 0;
        }
        return key.a().hashCode();
    }

    protected l b() {
        return this.b;
    }

    protected Class getPOClass() {
        return OmadaLogGlobalPO.class;
    }

    protected MongoTemplate getMongoTemplate() {
        return this.mongoTemplate;
    }

    @Nonnull
    protected String getCollectionNameOrPrefixIfSliced() {
        return "globalomadalog";
    }

    @Nonnull
    protected IndexDefinition[] getIndexDefinitions() {
        return OmadaLogGlobalPO.INDEX_DEFINITIONS;
    }

    public void a(com.tplink.smb.omada.logmanager.port.commom.service.a.c event) {
        this.dbMaintenance(event.a());
    }

    @PostConstruct
    public void c() {
        DomainEventBusHolder.getHandlerRegistry().registerSync(com.tplink.smb.omada.logmanager.port.commom.service.a.c.class, (DomainEventSubscriber)this);
    }

    protected /* synthetic */ p getStrategy() {
        return this.b();
    }

    protected /* synthetic */ int hashCodeOfKey(@Nullable Object object) {
        return this.c((com.tplink.smb.omada.logmanager.domain.model.e.g)object);
    }

    protected /* synthetic */ u getStrategy() {
        return this.b();
    }

    public /* synthetic */ void handleEvent(Object object) {
        this.a((com.tplink.smb.omada.logmanager.port.commom.service.a.c)object);
    }
}

