/*
 * Decompiled with CFR 0.152.
 */
package com.tplink.smb.omada.device.gateway.core.fileTransfer;

import com.tplink.smb.component.storage.api.repository.FileRepository;
import com.tplink.smb.ecsp.protocol.packet.EcspMessage;
import com.tplink.smb.eventcenter.api.event.DomainEvent;
import com.tplink.smb.eventcenter.domain.DomainEventBusHolder;
import com.tplink.smb.omada.common.util.T;
import com.tplink.smb.omada.common.util.b.c;
import com.tplink.smb.omada.common.util.b.h;
import com.tplink.smb.omada.common.util.x;
import com.tplink.smb.omada.device.gateway.core.fileTransfer.cache.FileInfoDTO;
import com.tplink.smb.omada.device.manage.message.body.manage.config.FileTransferRespBody;
import com.tplink.smb.omada.device.manage.message.body.manage.config.FileTransferResponse;
import com.tplink.smb.omada.manager.device.api.internal.device.b;
import com.tplink.smb.omada.manager.device.api.internal.device.dto.QueryDeviceAdoptInfoResponseDTO;
import com.tplink.smb.omada.manager.device.api.internal.device.request.device.j;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class a {
    @Generated
    private static final Logger a = LoggerFactory.getLogger(a.class);
    @Autowired
    private com.tplink.smb.omada.device.gateway.core.fileTransfer.cache.a b;
    @Autowired
    private FileRepository c;
    @Autowired
    private com.tplink.smb.omada.device.gateway.core.inform.cache.a d;
    @Autowired
    private b e;

    public void a(EcspMessage ecspMessage) {
        FileTransferRespBody transferRespBody = (FileTransferRespBody)x.a((Map)ecspMessage.getBody().getData(), FileTransferRespBody.class);
        if (Objects.isNull(transferRespBody)) {
            a.warn("device: {} file transfer response body is empty.", (Object)ecspMessage.getMac());
            return;
        }
        a.debug("start handle file response from : {}", (Object)ecspMessage.getMac());
        String devMac = ecspMessage.getMac();
        FileTransferResponse fileTransferResponse = transferRespBody.getFileTransfer();
        Integer errCode = fileTransferResponse.getErrCode();
        String fileName = fileTransferResponse.getFileName();
        if (Objects.nonNull(errCode) && !Objects.equals(errCode, 0)) {
            DomainEventBusHolder.getPublisher().publish((DomainEvent)com.tplink.smb.omada.device.gateway.core.fileTransfer.a.a.a(devMac, fileName));
            return;
        }
        Integer partition = fileTransferResponse.getPartition();
        FileInfoDTO fileInfoDTO = this.b.a(devMac, fileName);
        if (Objects.isNull(fileInfoDTO)) {
            a.debug("no file info cache : {} ,mac: {}", (Object)fileName, (Object)devMac);
            return;
        }
        String data = fileTransferResponse.getData();
        String[] fileData = fileInfoDTO.getFileData();
        fileData[partition.intValue()] = data;
        Integer[] partitions = fileInfoDTO.getPartitions();
        partitions[partition.intValue()] = 1;
        if (this.a(partitions)) {
            String md5;
            byte[] fileBytes = this.a(fileInfoDTO);
            if (!this.b(fileBytes, devMac, md5 = fileInfoDTO.getMd5())) {
                a.warn("file : {} check failed.", (Object)fileName);
                this.b.b(devMac, fileName);
                DomainEventBusHolder.getPublisher().publish((DomainEvent)com.tplink.smb.omada.device.gateway.core.fileTransfer.a.a.a(devMac, fileName));
                return;
            }
            if (!this.a(fileBytes, fileName, devMac)) {
                a.warn("file : {} failed to save.", (Object)fileName);
                this.b.b(devMac, fileName);
                DomainEventBusHolder.getPublisher().publish((DomainEvent)com.tplink.smb.omada.device.gateway.core.fileTransfer.a.a.a(devMac, fileName));
            }
            return;
        }
        this.b.a(devMac, fileName, fileInfoDTO);
    }

    private boolean a(Integer[] partition) {
        for (Integer integer : partition) {
            if (!Objects.isNull(integer)) continue;
            return false;
        }
        return true;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean a(byte[] data, String fileName, String devMac) {
        if (Objects.isNull(data)) {
            return false;
        }
        try (ByteArrayInputStream inputStream = new ByteArrayInputStream(data);){
            String omadacId = this.a(devMac);
            String prefix = T.c((String)omadacId) ? devMac : omadacId + "/" + devMac;
            a.debug("start save file: {}.", (Object)fileName);
            String fileId = this.c.saveFile(prefix, null, fileName, (InputStream)inputStream, 1);
            if (Objects.isNull(fileId)) {
                a.warn("failed to save device info for : {}.", (Object)devMac);
                boolean bl = false;
                return bl;
            }
            DomainEventBusHolder.getPublisher().publish((DomainEvent)com.tplink.smb.omada.device.gateway.core.fileTransfer.a.a.a(devMac, fileName, fileId));
            this.b.b(devMac, fileName);
            boolean bl = true;
            return bl;
        }
        catch (Exception e2) {
            a.warn("Exception while convert {}", (Object)fileName, (Object)e2);
            return false;
        }
    }

    private boolean b(byte[] data, String devMac, String md5) {
        try {
            a.debug("data of device : {} before calculate md5 is {}", (Object)devMac, (Object)data);
            String controllerMd5 = Optional.ofNullable(h.a((byte[])data)).map(s -> s.toLowerCase(Locale.ROOT)).orElse(null);
            String devMd5 = Optional.ofNullable(md5).map(s -> s.toLowerCase(Locale.ROOT)).orElse(null);
            a.debug("md5 from device {} is {}\n ,md5 from controller is {}", new Object[]{devMac, devMd5, controllerMd5});
            return Objects.nonNull(devMd5) && Objects.equals(devMd5, controllerMd5);
        }
        catch (Exception e2) {
            a.warn("Exception: {} occurred when check md5 of device : {} ", new Object[]{e2.getMessage(), devMac, e2});
            return false;
        }
    }

    private byte[] a(FileInfoDTO fileInfoDTO) {
        String[] fileData;
        ArrayList<byte[]> filePartitionBytes = new ArrayList<byte[]>();
        int totalByteSize = 0;
        for (String file : fileData = fileInfoDTO.getFileData()) {
            a.debug("file:{}", (Object)file);
            byte[] decodedBytes = com.tplink.smb.omada.common.util.b.c.a((String)file);
            if (Objects.isNull(decodedBytes)) {
                a.debug("fail to decode file partition : {}", (Object)file);
                continue;
            }
            filePartitionBytes.add(decodedBytes);
            totalByteSize += decodedBytes.length;
        }
        byte[] data = new byte[totalByteSize];
        int offset = 0;
        for (byte[] byteArray : filePartitionBytes) {
            int subSize = byteArray.length;
            System.arraycopy(byteArray, 0, data, offset, subSize);
            offset += subSize;
        }
        a.debug("data :{}", (Object)data);
        return data;
    }

    private String a(String deviceMac) {
        try {
            com.tplink.smb.omada.manager.device.api.internal.device.dto.a.a deviceInfo = this.d.a(deviceMac);
            if (Objects.nonNull(deviceInfo) && !T.c((String)deviceInfo.c())) {
                return deviceInfo.c();
            }
            QueryDeviceAdoptInfoResponseDTO deviceAdoptInfoResponseDTO = this.e.a(new j(deviceMac));
            return deviceAdoptInfoResponseDTO.getOmadacId();
        }
        catch (Exception e2) {
            a.warn("fail to get omadacId by mac : {}", (Object)deviceMac);
            return null;
        }
    }
}

