/*
 * Decompiled with CFR 0.152.
 */
package com.tplink.smb.omada.device.gateway.core.cache.omadac;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.tplink.smb.component.cache.api.CacheService;
import com.tplink.smb.omada.common.spring.b;
import com.tplink.smb.omada.common.util.K;
import com.tplink.smb.omada.device.gateway.core.cache.omadac.ActiveSiteCacheProperties;
import com.tplink.smb.omada.device.gateway.core.datatrack.task.DeviceGatewayDatatrackScheduleProperties;
import jakarta.annotation.Nonnull;
import jakarta.annotation.PostConstruct;
import java.time.Duration;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.ZoneOffset;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import java.util.StringJoiner;
import java.util.concurrent.ConcurrentSkipListSet;
import java.util.concurrent.TimeUnit;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
@b
public class ActiveSiteCacheImpl
implements com.tplink.smb.omada.device.gateway.a.c.a.a {
    private static final Logger d = LoggerFactory.getLogger(ActiveSiteCacheImpl.class);
    private static final String e = "device-gateway.active.sites.daily";
    protected final DeviceGatewayDatatrackScheduleProperties a;
    protected final ActiveSiteCacheProperties b;
    protected final CacheService c;
    private final Set<String> f = new ConcurrentSkipListSet<String>();

    @Autowired
    public ActiveSiteCacheImpl(DeviceGatewayDatatrackScheduleProperties scheduleProperties, ActiveSiteCacheProperties activeSiteCacheProperties, CacheService cacheService) {
        this.a = scheduleProperties;
        this.b = activeSiteCacheProperties;
        this.c = cacheService;
    }

    protected static String a(@Nonnull String siteId, int totalPartitions, a timestamp) {
        int partition = siteId.hashCode() & totalPartitions - 1;
        return ActiveSiteCacheImpl.a(partition, timestamp);
    }

    protected static String a(int partitionIdx, a timestamp) {
        return new StringJoiner(":").add("partition").add(String.valueOf(partitionIdx)).add("date").add(K.b((long)timestamp.a())).toString();
    }

    @PostConstruct
    public void a() {
        if (this.b.getFlushInterval().equals(Duration.ZERO)) {
            d.info("ActiveSitesCache period flush buf is disabled.");
            return;
        }
        long millis = this.b.getFlushInterval().toMillis();
        d.info("Scheduled ActiveSitesCache period flush buf task at fixed rate of {} millis.", (Object)millis);
        com.tplink.smb.omada.common.concurrent.thread.b.b(() -> {
            d.trace("Starting to flush buffed active ids {}", this.f);
            try {
                this.b();
            }
            catch (Exception e2) {
                d.warn("Failed to execute ActiveSiteCache.flushBuf()", (Throwable)e2);
            }
        }, (long)millis, (long)millis, (TimeUnit)TimeUnit.MILLISECONDS);
    }

    public void a(String omadacId) {
        if (this.b.getFlushInterval().equals(Duration.ZERO)) {
            d.trace("Saving OmadacId: {}, into ActiveSitesCache buf directly", (Object)omadacId);
            int partitions = this.a.getPartitions();
            Set<OmadacIdSiteIdPO> set = Collections.singleton(new OmadacIdSiteIdPO(omadacId));
            String dailyCacheKey = ActiveSiteCacheImpl.a(omadacId, partitions, new a());
            this.a(dailyCacheKey, set);
        } else {
            d.trace("Putting OmadacId: {}, into ActiveSitesCache buf", (Object)omadacId);
            this.f.add(omadacId);
        }
    }

    public Set<String> a(int partition) {
        d.trace("Getting ActiveSites of Today by partition: {}", (Object)partition);
        long currentSec = System.currentTimeMillis() / 1000L;
        long yesterdayEndSec = ActiveSiteCacheImpl.c();
        HashSet yesterdaySet = new HashSet();
        long delta = currentSec - yesterdayEndSec;
        if (delta > 0L && delta < this.b.getDailyWarmingUpWindow().getSeconds()) {
            d.trace("Getting ActiveSites of Today by partition: {}. Currently within warming up window: {} seconds, need fetch both yesterday and today", (Object)partition, (Object)this.b.getDailyWarmingUpWindow().getSeconds());
            yesterdaySet = new HashSet(this.c.getSet(e, ActiveSiteCacheImpl.a(partition, new a(yesterdayEndSec * 1000L)), OmadacIdSiteIdPO.class));
            d.trace("Fetched Yesterday's set by partition: {}, result: {}", (Object)partition, yesterdaySet);
        }
        HashSet todaySet = new HashSet(this.c.getSet(e, ActiveSiteCacheImpl.a(partition, new a()), OmadacIdSiteIdPO.class));
        d.trace("Fetched Today's set by partition: {}, result: {}", (Object)partition, todaySet);
        HashSet<String> result = new HashSet<String>();
        todaySet.forEach(po -> result.add(po.getOmadacId()));
        yesterdaySet.forEach(po -> result.add(po.getOmadacId()));
        d.trace("Fetched active sites of day by partition: {}, result: {}", (Object)partition, result);
        return result;
    }

    protected void b() {
        this.a(this.f, true);
    }

    private void a(Set<String> map, boolean removeWhenIteration) {
        int partitions = this.a.getPartitions();
        HashMap<String, Set> dailyTargetMap = new HashMap<String, Set>();
        Iterator<String> iterator = map.iterator();
        while (iterator.hasNext()) {
            String omadacId = iterator.next();
            String dailyCacheKey = ActiveSiteCacheImpl.a(omadacId, partitions, new a());
            dailyTargetMap.computeIfAbsent(dailyCacheKey, k -> new HashSet()).add(new OmadacIdSiteIdPO(omadacId));
            if (removeWhenIteration) {
                iterator.remove();
            }
            d.trace("Removed <OmadacId:{}> from buf, need write to cache", (Object)omadacId);
        }
        dailyTargetMap.forEach(this::a);
    }

    private void a(String dailyCacheKey, Set<OmadacIdSiteIdPO> set) {
        try {
            this.c.getSet(e, dailyCacheKey, OmadacIdSiteIdPO.class).addAll(set);
            if (d.isTraceEnabled()) {
                d.trace("Successfully updated cache {}:{} with values {}", new Object[]{e, dailyCacheKey, set});
            }
            this.c.expireKey(e, dailyCacheKey, this.b.getDailyKeepAlive().getSeconds(), TimeUnit.SECONDS);
            if (d.isTraceEnabled()) {
                d.trace("Successfully set expiration of {}:{} with {} seconds", new Object[]{e, dailyCacheKey, this.b.getDailyKeepAlive().getSeconds()});
            }
        }
        catch (Exception e2) {
            d.warn("Failed to flush {}, {} to {}", new Object[]{dailyCacheKey, set, e, e2});
        }
    }

    private static long c() {
        return LocalDate.now(ZoneOffset.UTC).atStartOfDay().toEpochSecond(ZoneOffset.UTC) - 1L;
    }

    private static class a {
        public static final int a = 999999999;
        private final long b;

        public a() {
            this.b = LocalDateTime.ofInstant(Instant.now(), ZoneOffset.UTC).withHour(23).withMinute(59).withSecond(59).withNano(999999999).toEpochSecond(ZoneOffset.UTC);
        }

        public a(long anyMillis) {
            this.b = LocalDateTime.ofEpochSecond(TimeUnit.MILLISECONDS.toSeconds(anyMillis), 999999999, ZoneOffset.UTC).withHour(23).withMinute(59).withSecond(59).toEpochSecond(ZoneOffset.UTC);
        }

        public long a() {
            return this.b;
        }
    }

    @JsonPropertyOrder(value={"omadacId"})
    private static class OmadacIdSiteIdPO {
        @JsonProperty(value="omadacId")
        private String omadacId;

        @Generated
        public String getOmadacId() {
            return this.omadacId;
        }

        @JsonProperty(value="omadacId")
        @Generated
        public void setOmadacId(String omadacId) {
            this.omadacId = omadacId;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof OmadacIdSiteIdPO)) {
                return false;
            }
            OmadacIdSiteIdPO other = (OmadacIdSiteIdPO)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$omadacId = this.getOmadacId();
            String other$omadacId = other.getOmadacId();
            return !(this$omadacId == null ? other$omadacId != null : !this$omadacId.equals(other$omadacId));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof OmadacIdSiteIdPO;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $omadacId = this.getOmadacId();
            result = result * 59 + ($omadacId == null ? 43 : $omadacId.hashCode());
            return result;
        }

        @Generated
        public String toString() {
            return "ActiveSiteCacheImpl.OmadacIdSiteIdPO(omadacId=" + this.getOmadacId() + ")";
        }

        @Generated
        public OmadacIdSiteIdPO() {
        }

        @Generated
        public OmadacIdSiteIdPO(String omadacId) {
            this.omadacId = omadacId;
        }
    }
}

