/*
 * Decompiled with CFR 0.152.
 */
package com.tplink.smb.omada.manager.license.api.web.dto.embed;

import jakarta.validation.constraints.Min;
import java.util.List;
import lombok.Generated;

public class LicenseNumVO {
    @Min(value=0L)
    private @Min(value=0L) Integer ap;
    @Min(value=0L)
    private @Min(value=0L) Integer l2Switch;
    @Min(value=0L)
    private @Min(value=0L) Integer l3Switch;
    @Min(value=0L)
    private @Min(value=0L) Integer gateway;
    @Min(value=0L)
    private @Min(value=0L) Integer basic;
    @Min(value=0L)
    private @Min(value=0L) Integer pro;
    @Min(value=0L)
    private @Min(value=0L) Integer ipc;
    private String type;

    public LicenseNumVO() {
        this.ap = 0;
        this.l2Switch = 0;
        this.l3Switch = 0;
        this.gateway = 0;
        this.basic = 0;
        this.pro = 0;
        this.ipc = 0;
    }

    public LicenseNumVO(String type, boolean pro) {
        if (pro) {
            this.ap = 0;
            this.l2Switch = 0;
            this.l3Switch = 0;
            this.gateway = 0;
            this.pro = 0;
        } else {
            this.ipc = 0;
            this.basic = 0;
        }
        this.type = type;
    }

    public Integer getNumByShortName(String shortName) {
        if ("ap".equals(shortName)) {
            return this.ap;
        }
        if ("l2Switch".equals(shortName)) {
            return this.l2Switch;
        }
        if ("l3Switch".equals(shortName)) {
            return this.l3Switch;
        }
        if ("gateway".equals(shortName)) {
            return this.gateway;
        }
        if ("basic".equals(shortName) || "advanced".equals(shortName)) {
            return this.basic;
        }
        if ("pro".equals(shortName)) {
            return this.pro;
        }
        if ("ipc".equals(shortName)) {
            return this.ipc;
        }
        return null;
    }

    public LicenseNumVO addNumByShortName(String shortName, Integer num) {
        if (num == null) {
            return this;
        }
        if ("ap".equals(shortName)) {
            if (this.ap == null) {
                this.ap = 0;
            }
            this.ap = this.ap + num;
        } else if ("l2Switch".equals(shortName)) {
            if (this.l2Switch == null) {
                this.l2Switch = 0;
            }
            this.l2Switch = this.l2Switch + num;
        } else if ("l3Switch".equals(shortName)) {
            if (this.l3Switch == null) {
                this.l3Switch = 0;
            }
            this.l3Switch = this.l3Switch + num;
        } else if ("gateway".equals(shortName)) {
            if (this.gateway == null) {
                this.gateway = 0;
            }
            this.gateway = this.gateway + num;
        } else if ("basic".equals(shortName) || "advanced".equals(shortName)) {
            if (this.basic == null) {
                this.basic = 0;
            }
            this.basic = this.basic + num;
        } else if ("pro".equals(shortName)) {
            if (this.pro == null) {
                this.pro = 0;
            }
            this.pro = this.pro + num;
        } else if ("ipc".equals(shortName)) {
            if (this.ipc == null) {
                this.ipc = 0;
            }
            this.ipc = this.ipc + num;
        } else {
            return null;
        }
        return this;
    }

    public int getTotal() {
        return this.getAp() + this.getL2Switch() + this.getL3Switch() + this.getGateway() + this.getBasic() + this.getPro() + this.getIpc();
    }

    public Integer getAp() {
        return this.ap == null ? 0 : this.ap;
    }

    public Integer getL2Switch() {
        return this.l2Switch == null ? 0 : this.l2Switch;
    }

    public Integer getL3Switch() {
        return this.l3Switch == null ? 0 : this.l3Switch;
    }

    public Integer getGateway() {
        return this.gateway == null ? 0 : this.gateway;
    }

    public Integer getBasic() {
        return this.basic == null ? 0 : this.basic;
    }

    public Integer getPro() {
        return this.pro == null ? 0 : this.pro;
    }

    public Integer getIpc() {
        return this.ipc == null ? 0 : this.ipc;
    }

    public static void add(List<LicenseNumVO> licenseNumVOS, LicenseNumVO licenseNumVO) {
        if (licenseNumVO.getTotal() != 0) {
            licenseNumVOS.add(licenseNumVO);
        }
    }

    public void add(LicenseNumVO licenseNumVO, boolean pro) {
        if (pro) {
            this.ap = this.ap + licenseNumVO.getAp();
            this.l2Switch = this.l2Switch + licenseNumVO.getL2Switch();
            this.l3Switch = this.l3Switch + licenseNumVO.getL3Switch();
            this.gateway = this.gateway + licenseNumVO.getGateway();
            this.pro = this.pro + licenseNumVO.pro;
        } else {
            this.basic = this.basic + licenseNumVO.getBasic();
            this.ipc = this.ipc + licenseNumVO.getIpc();
        }
    }

    @Generated
    protected LicenseNumVO(LicenseNumVOBuilder<?, ?> b2) {
        this.ap = b2.ap;
        this.l2Switch = b2.l2Switch;
        this.l3Switch = b2.l3Switch;
        this.gateway = b2.gateway;
        this.basic = b2.basic;
        this.pro = b2.pro;
        this.ipc = b2.ipc;
        this.type = b2.type;
    }

    @Generated
    public static LicenseNumVOBuilder<?, ?> builder() {
        return new LicenseNumVOBuilderImpl();
    }

    @Generated
    public String getType() {
        return this.type;
    }

    @Generated
    public void setAp(Integer ap) {
        this.ap = ap;
    }

    @Generated
    public void setL2Switch(Integer l2Switch) {
        this.l2Switch = l2Switch;
    }

    @Generated
    public void setL3Switch(Integer l3Switch) {
        this.l3Switch = l3Switch;
    }

    @Generated
    public void setGateway(Integer gateway) {
        this.gateway = gateway;
    }

    @Generated
    public void setBasic(Integer basic) {
        this.basic = basic;
    }

    @Generated
    public void setPro(Integer pro) {
        this.pro = pro;
    }

    @Generated
    public void setIpc(Integer ipc) {
        this.ipc = ipc;
    }

    @Generated
    public void setType(String type) {
        this.type = type;
    }

    @Generated
    public LicenseNumVO(Integer ap, Integer l2Switch, Integer l3Switch, Integer gateway, Integer basic, Integer pro, Integer ipc, String type) {
        this.ap = ap;
        this.l2Switch = l2Switch;
        this.l3Switch = l3Switch;
        this.gateway = gateway;
        this.basic = basic;
        this.pro = pro;
        this.ipc = ipc;
        this.type = type;
    }

    @Generated
    public static abstract class LicenseNumVOBuilder<C extends LicenseNumVO, B extends LicenseNumVOBuilder<C, B>> {
        @Generated
        private Integer ap;
        @Generated
        private Integer l2Switch;
        @Generated
        private Integer l3Switch;
        @Generated
        private Integer gateway;
        @Generated
        private Integer basic;
        @Generated
        private Integer pro;
        @Generated
        private Integer ipc;
        @Generated
        private String type;

        @Generated
        public B ap(Integer ap) {
            this.ap = ap;
            return this.self();
        }

        @Generated
        public B l2Switch(Integer l2Switch) {
            this.l2Switch = l2Switch;
            return this.self();
        }

        @Generated
        public B l3Switch(Integer l3Switch) {
            this.l3Switch = l3Switch;
            return this.self();
        }

        @Generated
        public B gateway(Integer gateway) {
            this.gateway = gateway;
            return this.self();
        }

        @Generated
        public B basic(Integer basic) {
            this.basic = basic;
            return this.self();
        }

        @Generated
        public B pro(Integer pro) {
            this.pro = pro;
            return this.self();
        }

        @Generated
        public B ipc(Integer ipc) {
            this.ipc = ipc;
            return this.self();
        }

        @Generated
        public B type(String type) {
            this.type = type;
            return this.self();
        }

        @Generated
        protected abstract B self();

        @Generated
        public abstract C build();

        @Generated
        public String toString() {
            return "LicenseNumVO.LicenseNumVOBuilder(ap=" + this.ap + ", l2Switch=" + this.l2Switch + ", l3Switch=" + this.l3Switch + ", gateway=" + this.gateway + ", basic=" + this.basic + ", pro=" + this.pro + ", ipc=" + this.ipc + ", type=" + this.type + ")";
        }
    }

    @Generated
    private static final class LicenseNumVOBuilderImpl
    extends LicenseNumVOBuilder<LicenseNumVO, LicenseNumVOBuilderImpl> {
        @Generated
        private LicenseNumVOBuilderImpl() {
        }

        @Override
        @Generated
        protected LicenseNumVOBuilderImpl self() {
            return this;
        }

        @Override
        @Generated
        public LicenseNumVO build() {
            return new LicenseNumVO(this);
        }
    }
}

