/*
 * Decompiled with CFR 0.152.
 */
package com.tplink.smb.omada.manager.license.api.web.dto;

import com.tplink.nbu.common.pii.annotation.PII;
import com.tplink.nbu.common.pii.constant.PIIMaskStrategy;
import com.tplink.smb.omada.manager.license.api.web.dto.embed.LicenseActivationCodeLicenseSelectVO;
import com.tplink.smb.omada.manager.license.api.web.dto.embed.LicenseActivationCodeReqDetailVO;
import jakarta.validation.constraints.NotNull;
import java.util.List;
import java.util.Optional;
import lombok.Generated;

public class LicenseActivationCodeImportVO {
    @PII(strategy=PIIMaskStrategy.HASH)
    @NotNull
    private String activationCode;
    @NotNull
    private List<LicenseActivationCodeReqDetailVO> licenses;

    public int getTotalCount() {
        return Optional.ofNullable(this.licenses).map(licenseList -> licenseList.stream().mapToInt(item -> {
            LicenseActivationCodeLicenseSelectVO selectVO = item.getItem();
            int count = selectVO.getYear1() + selectVO.getYear2() + selectVO.getYear3() + selectVO.getYear4() + selectVO.getYear5() + selectVO.getTrial();
            if (selectVO.getUsed() != null) {
                count += selectVO.getUsed().getTotal();
            }
            return count;
        }).sum()).orElse(0);
    }

    @Generated
    public String getActivationCode() {
        return this.activationCode;
    }

    @Generated
    public List<LicenseActivationCodeReqDetailVO> getLicenses() {
        return this.licenses;
    }

    @Generated
    public void setActivationCode(String activationCode) {
        this.activationCode = activationCode;
    }

    @Generated
    public void setLicenses(List<LicenseActivationCodeReqDetailVO> licenses) {
        this.licenses = licenses;
    }

    @Generated
    public boolean equals(Object o2) {
        if (o2 == this) {
            return true;
        }
        if (!(o2 instanceof LicenseActivationCodeImportVO)) {
            return false;
        }
        LicenseActivationCodeImportVO other = (LicenseActivationCodeImportVO)o2;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$activationCode = this.getActivationCode();
        String other$activationCode = other.getActivationCode();
        if (this$activationCode == null ? other$activationCode != null : !this$activationCode.equals(other$activationCode)) {
            return false;
        }
        List<LicenseActivationCodeReqDetailVO> this$licenses = this.getLicenses();
        List<LicenseActivationCodeReqDetailVO> other$licenses = other.getLicenses();
        return !(this$licenses == null ? other$licenses != null : !((Object)this$licenses).equals(other$licenses));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof LicenseActivationCodeImportVO;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $activationCode = this.getActivationCode();
        result = result * 59 + ($activationCode == null ? 43 : $activationCode.hashCode());
        List<LicenseActivationCodeReqDetailVO> $licenses = this.getLicenses();
        result = result * 59 + ($licenses == null ? 43 : ((Object)$licenses).hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "LicenseActivationCodeImportVO(activationCode=" + this.getActivationCode() + ", licenses=" + this.getLicenses() + ")";
    }

    @Generated
    public LicenseActivationCodeImportVO() {
    }

    @Generated
    public LicenseActivationCodeImportVO(String activationCode, List<LicenseActivationCodeReqDetailVO> licenses) {
        this.activationCode = activationCode;
        this.licenses = licenses;
    }
}

