/*
 * Decompiled with CFR 0.152.
 */
package com.tplink.smb.omada.manager.device.api.web.osw.dto.mlag;

import com.tplink.nbu.common.pii.annotation.PII;
import com.tplink.nbu.common.pii.constant.PIIMaskStrategy;
import com.tplink.smb.omada.a.a;
import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.validation.constraints.NotNull;
import jakarta.validation.constraints.Pattern;
import java.util.List;
import lombok.Generated;
import org.hibernate.validator.constraints.Range;

public class MlagMemberConfigVO {
    @NotNull(message="Mac should not be null")
    @PII(strategy=PIIMaskStrategy.ENCRYPT)
    @Schema(name="mac", description="Device Mac.")
    @a
    private @NotNull(message="Mac should not be null") String mac;
    @NotNull(message="Priority should not be null")
    @Range(min=1L, max=256L)
    @Schema(name="priority", description="Priority of the device in the M-LAG group.")
    private @NotNull(message="Priority should not be null") @Range(min=1L, max=256L) Integer priority;
    @Schema(name="dadEnable", description="Whether the DAD enable.")
    private Boolean dadEnable;
    @Schema(name="dadLinkPorts", description="DAD Link Ports")
    private List<String> dadLinkPorts;
    @Pattern(regexp="^\\b((?!\\d\\d\\d)\\d+|1\\d\\d|2[0-4]\\d|25[0-5])\\.((?!\\d\\d\\d)\\d+|1\\d\\d|2[0-4]\\d|25[0-5])\\.((?!\\d\\d\\d)\\d+|1\\d\\d|2[0-4]\\d|25[0-5])\\.((?!\\d\\d\\d)\\d+|1\\d\\d|2[0-4]\\d|25[0-5])\\b$")
    @Schema(name="dadLocalIp", description="DAD Local IP")
    private @Pattern(regexp="^\\b((?!\\d\\d\\d)\\d+|1\\d\\d|2[0-4]\\d|25[0-5])\\.((?!\\d\\d\\d)\\d+|1\\d\\d|2[0-4]\\d|25[0-5])\\.((?!\\d\\d\\d)\\d+|1\\d\\d|2[0-4]\\d|25[0-5])\\.((?!\\d\\d\\d)\\d+|1\\d\\d|2[0-4]\\d|25[0-5])\\b$") String dadLocalIp;
    @Pattern(regexp="^\\s*((([0-9A-Fa-f]{1,4}:){7}([0-9A-Fa-f]{1,4}|:))|(([0-9A-Fa-f]{1,4}:){6}(:[0-9A-Fa-f]{1,4}|((25[0-5]|2[0-4]\\d|1\\d\\d|[1-9]?\\d)(\\.(25[0-5]|2[0-4]\\d|1\\d\\d|[1-9]?\\d)){3})|:))|(([0-9A-Fa-f]{1,4}:){5}(((:[0-9A-Fa-f]{1,4}){1,2})|:((25[0-5]|2[0-4]\\d|1\\d\\d|[1-9]?\\d)(\\.(25[0-5]|2[0-4]\\d|1\\d\\d|[1-9]?\\d)){3})|:))|(([0-9A-Fa-f]{1,4}:){4}(((:[0-9A-Fa-f]{1,4}){1,3})|((:[0-9A-Fa-f]{1,4})?:((25[0-5]|2[0-4]\\d|1\\d\\d|[1-9]?\\d)(\\.(25[0-5]|2[0-4]\\d|1\\d\\d|[1-9]?\\d)){3}))|:))|(([0-9A-Fa-f]{1,4}:){3}(((:[0-9A-Fa-f]{1,4}){1,4})|((:[0-9A-Fa-f]{1,4}){0,2}:((25[0-5]|2[0-4]\\d|1\\d\\d|[1-9]?\\d)(\\.(25[0-5]|2[0-4]\\d|1\\d\\d|[1-9]?\\d)){3}))|:))|(([0-9A-Fa-f]{1,4}:){2}(((:[0-9A-Fa-f]{1,4}){1,5})|((:[0-9A-Fa-f]{1,4}){0,3}:((25[0-5]|2[0-4]\\d|1\\d\\d|[1-9]?\\d)(\\.(25[0-5]|2[0-4]\\d|1\\d\\d|[1-9]?\\d)){3}))|:))|(([0-9A-Fa-f]{1,4}:){1}(((:[0-9A-Fa-f]{1,4}){1,6})|((:[0-9A-Fa-f]{1,4}){0,4}:((25[0-5]|2[0-4]\\d|1\\d\\d|[1-9]?\\d)(\\.(25[0-5]|2[0-4]\\d|1\\d\\d|[1-9]?\\d)){3}))|:))|(:(((:[0-9A-Fa-f]{1,4}){1,7})|((:[0-9A-Fa-f]{1,4}){0,5}:((25[0-5]|2[0-4]\\d|1\\d\\d|[1-9]?\\d)(\\.(25[0-5]|2[0-4]\\d|1\\d\\d|[1-9]?\\d)){3}))|:)))(%.+)?\\s*$")
    @Schema(name="dadLocalIpv6", description="DAD Local IPv6")
    private @Pattern(regexp="^\\s*((([0-9A-Fa-f]{1,4}:){7}([0-9A-Fa-f]{1,4}|:))|(([0-9A-Fa-f]{1,4}:){6}(:[0-9A-Fa-f]{1,4}|((25[0-5]|2[0-4]\\d|1\\d\\d|[1-9]?\\d)(\\.(25[0-5]|2[0-4]\\d|1\\d\\d|[1-9]?\\d)){3})|:))|(([0-9A-Fa-f]{1,4}:){5}(((:[0-9A-Fa-f]{1,4}){1,2})|:((25[0-5]|2[0-4]\\d|1\\d\\d|[1-9]?\\d)(\\.(25[0-5]|2[0-4]\\d|1\\d\\d|[1-9]?\\d)){3})|:))|(([0-9A-Fa-f]{1,4}:){4}(((:[0-9A-Fa-f]{1,4}){1,3})|((:[0-9A-Fa-f]{1,4})?:((25[0-5]|2[0-4]\\d|1\\d\\d|[1-9]?\\d)(\\.(25[0-5]|2[0-4]\\d|1\\d\\d|[1-9]?\\d)){3}))|:))|(([0-9A-Fa-f]{1,4}:){3}(((:[0-9A-Fa-f]{1,4}){1,4})|((:[0-9A-Fa-f]{1,4}){0,2}:((25[0-5]|2[0-4]\\d|1\\d\\d|[1-9]?\\d)(\\.(25[0-5]|2[0-4]\\d|1\\d\\d|[1-9]?\\d)){3}))|:))|(([0-9A-Fa-f]{1,4}:){2}(((:[0-9A-Fa-f]{1,4}){1,5})|((:[0-9A-Fa-f]{1,4}){0,3}:((25[0-5]|2[0-4]\\d|1\\d\\d|[1-9]?\\d)(\\.(25[0-5]|2[0-4]\\d|1\\d\\d|[1-9]?\\d)){3}))|:))|(([0-9A-Fa-f]{1,4}:){1}(((:[0-9A-Fa-f]{1,4}){1,6})|((:[0-9A-Fa-f]{1,4}){0,4}:((25[0-5]|2[0-4]\\d|1\\d\\d|[1-9]?\\d)(\\.(25[0-5]|2[0-4]\\d|1\\d\\d|[1-9]?\\d)){3}))|:))|(:(((:[0-9A-Fa-f]{1,4}){1,7})|((:[0-9A-Fa-f]{1,4}){0,5}:((25[0-5]|2[0-4]\\d|1\\d\\d|[1-9]?\\d)(\\.(25[0-5]|2[0-4]\\d|1\\d\\d|[1-9]?\\d)){3}))|:)))(%.+)?\\s*$") String dadLocalIpv6;
    @Pattern(regexp="^\\b((?!\\d\\d\\d)\\d+|1\\d\\d|2[0-4]\\d|25[0-5])\\.((?!\\d\\d\\d)\\d+|1\\d\\d|2[0-4]\\d|25[0-5])\\.((?!\\d\\d\\d)\\d+|1\\d\\d|2[0-4]\\d|25[0-5])\\.((?!\\d\\d\\d)\\d+|1\\d\\d|2[0-4]\\d|25[0-5])\\b$")
    @Schema(name="dadPeerIp", description="DAD Peer IP")
    private @Pattern(regexp="^\\b((?!\\d\\d\\d)\\d+|1\\d\\d|2[0-4]\\d|25[0-5])\\.((?!\\d\\d\\d)\\d+|1\\d\\d|2[0-4]\\d|25[0-5])\\.((?!\\d\\d\\d)\\d+|1\\d\\d|2[0-4]\\d|25[0-5])\\.((?!\\d\\d\\d)\\d+|1\\d\\d|2[0-4]\\d|25[0-5])\\b$") String dadPeerIp;
    @Pattern(regexp="^\\s*((([0-9A-Fa-f]{1,4}:){7}([0-9A-Fa-f]{1,4}|:))|(([0-9A-Fa-f]{1,4}:){6}(:[0-9A-Fa-f]{1,4}|((25[0-5]|2[0-4]\\d|1\\d\\d|[1-9]?\\d)(\\.(25[0-5]|2[0-4]\\d|1\\d\\d|[1-9]?\\d)){3})|:))|(([0-9A-Fa-f]{1,4}:){5}(((:[0-9A-Fa-f]{1,4}){1,2})|:((25[0-5]|2[0-4]\\d|1\\d\\d|[1-9]?\\d)(\\.(25[0-5]|2[0-4]\\d|1\\d\\d|[1-9]?\\d)){3})|:))|(([0-9A-Fa-f]{1,4}:){4}(((:[0-9A-Fa-f]{1,4}){1,3})|((:[0-9A-Fa-f]{1,4})?:((25[0-5]|2[0-4]\\d|1\\d\\d|[1-9]?\\d)(\\.(25[0-5]|2[0-4]\\d|1\\d\\d|[1-9]?\\d)){3}))|:))|(([0-9A-Fa-f]{1,4}:){3}(((:[0-9A-Fa-f]{1,4}){1,4})|((:[0-9A-Fa-f]{1,4}){0,2}:((25[0-5]|2[0-4]\\d|1\\d\\d|[1-9]?\\d)(\\.(25[0-5]|2[0-4]\\d|1\\d\\d|[1-9]?\\d)){3}))|:))|(([0-9A-Fa-f]{1,4}:){2}(((:[0-9A-Fa-f]{1,4}){1,5})|((:[0-9A-Fa-f]{1,4}){0,3}:((25[0-5]|2[0-4]\\d|1\\d\\d|[1-9]?\\d)(\\.(25[0-5]|2[0-4]\\d|1\\d\\d|[1-9]?\\d)){3}))|:))|(([0-9A-Fa-f]{1,4}:){1}(((:[0-9A-Fa-f]{1,4}){1,6})|((:[0-9A-Fa-f]{1,4}){0,4}:((25[0-5]|2[0-4]\\d|1\\d\\d|[1-9]?\\d)(\\.(25[0-5]|2[0-4]\\d|1\\d\\d|[1-9]?\\d)){3}))|:))|(:(((:[0-9A-Fa-f]{1,4}){1,7})|((:[0-9A-Fa-f]{1,4}){0,5}:((25[0-5]|2[0-4]\\d|1\\d\\d|[1-9]?\\d)(\\.(25[0-5]|2[0-4]\\d|1\\d\\d|[1-9]?\\d)){3}))|:)))(%.+)?\\s*$")
    @Schema(name="dadPeerIpv6", description="DAD Peer IPv6")
    private @Pattern(regexp="^\\s*((([0-9A-Fa-f]{1,4}:){7}([0-9A-Fa-f]{1,4}|:))|(([0-9A-Fa-f]{1,4}:){6}(:[0-9A-Fa-f]{1,4}|((25[0-5]|2[0-4]\\d|1\\d\\d|[1-9]?\\d)(\\.(25[0-5]|2[0-4]\\d|1\\d\\d|[1-9]?\\d)){3})|:))|(([0-9A-Fa-f]{1,4}:){5}(((:[0-9A-Fa-f]{1,4}){1,2})|:((25[0-5]|2[0-4]\\d|1\\d\\d|[1-9]?\\d)(\\.(25[0-5]|2[0-4]\\d|1\\d\\d|[1-9]?\\d)){3})|:))|(([0-9A-Fa-f]{1,4}:){4}(((:[0-9A-Fa-f]{1,4}){1,3})|((:[0-9A-Fa-f]{1,4})?:((25[0-5]|2[0-4]\\d|1\\d\\d|[1-9]?\\d)(\\.(25[0-5]|2[0-4]\\d|1\\d\\d|[1-9]?\\d)){3}))|:))|(([0-9A-Fa-f]{1,4}:){3}(((:[0-9A-Fa-f]{1,4}){1,4})|((:[0-9A-Fa-f]{1,4}){0,2}:((25[0-5]|2[0-4]\\d|1\\d\\d|[1-9]?\\d)(\\.(25[0-5]|2[0-4]\\d|1\\d\\d|[1-9]?\\d)){3}))|:))|(([0-9A-Fa-f]{1,4}:){2}(((:[0-9A-Fa-f]{1,4}){1,5})|((:[0-9A-Fa-f]{1,4}){0,3}:((25[0-5]|2[0-4]\\d|1\\d\\d|[1-9]?\\d)(\\.(25[0-5]|2[0-4]\\d|1\\d\\d|[1-9]?\\d)){3}))|:))|(([0-9A-Fa-f]{1,4}:){1}(((:[0-9A-Fa-f]{1,4}){1,6})|((:[0-9A-Fa-f]{1,4}){0,4}:((25[0-5]|2[0-4]\\d|1\\d\\d|[1-9]?\\d)(\\.(25[0-5]|2[0-4]\\d|1\\d\\d|[1-9]?\\d)){3}))|:))|(:(((:[0-9A-Fa-f]{1,4}){1,7})|((:[0-9A-Fa-f]{1,4}){0,5}:((25[0-5]|2[0-4]\\d|1\\d\\d|[1-9]?\\d)(\\.(25[0-5]|2[0-4]\\d|1\\d\\d|[1-9]?\\d)){3}))|:)))(%.+)?\\s*$") String dadPeerIpv6;
    @Schema(name="peerLinkPorts", description="Peer Link Ports")
    private List<String> peerLinkPorts;

    @Generated
    public static MlagMemberConfigVOBuilder builder() {
        return new MlagMemberConfigVOBuilder();
    }

    @Generated
    public String getMac() {
        return this.mac;
    }

    @Generated
    public Integer getPriority() {
        return this.priority;
    }

    @Generated
    public Boolean getDadEnable() {
        return this.dadEnable;
    }

    @Generated
    public List<String> getDadLinkPorts() {
        return this.dadLinkPorts;
    }

    @Generated
    public String getDadLocalIp() {
        return this.dadLocalIp;
    }

    @Generated
    public String getDadLocalIpv6() {
        return this.dadLocalIpv6;
    }

    @Generated
    public String getDadPeerIp() {
        return this.dadPeerIp;
    }

    @Generated
    public String getDadPeerIpv6() {
        return this.dadPeerIpv6;
    }

    @Generated
    public List<String> getPeerLinkPorts() {
        return this.peerLinkPorts;
    }

    @Generated
    public void setMac(String mac) {
        this.mac = mac;
    }

    @Generated
    public void setPriority(Integer priority) {
        this.priority = priority;
    }

    @Generated
    public void setDadEnable(Boolean dadEnable) {
        this.dadEnable = dadEnable;
    }

    @Generated
    public void setDadLinkPorts(List<String> dadLinkPorts) {
        this.dadLinkPorts = dadLinkPorts;
    }

    @Generated
    public void setDadLocalIp(String dadLocalIp) {
        this.dadLocalIp = dadLocalIp;
    }

    @Generated
    public void setDadLocalIpv6(String dadLocalIpv6) {
        this.dadLocalIpv6 = dadLocalIpv6;
    }

    @Generated
    public void setDadPeerIp(String dadPeerIp) {
        this.dadPeerIp = dadPeerIp;
    }

    @Generated
    public void setDadPeerIpv6(String dadPeerIpv6) {
        this.dadPeerIpv6 = dadPeerIpv6;
    }

    @Generated
    public void setPeerLinkPorts(List<String> peerLinkPorts) {
        this.peerLinkPorts = peerLinkPorts;
    }

    @Generated
    public String toString() {
        return "MlagMemberConfigVO(mac=" + this.getMac() + ", priority=" + this.getPriority() + ", dadEnable=" + this.getDadEnable() + ", dadLinkPorts=" + this.getDadLinkPorts() + ", dadLocalIp=" + this.getDadLocalIp() + ", dadLocalIpv6=" + this.getDadLocalIpv6() + ", dadPeerIp=" + this.getDadPeerIp() + ", dadPeerIpv6=" + this.getDadPeerIpv6() + ", peerLinkPorts=" + this.getPeerLinkPorts() + ")";
    }

    @Generated
    public MlagMemberConfigVO() {
    }

    @Generated
    public MlagMemberConfigVO(String mac, Integer priority, Boolean dadEnable, List<String> dadLinkPorts, String dadLocalIp, String dadLocalIpv6, String dadPeerIp, String dadPeerIpv6, List<String> peerLinkPorts) {
        this.mac = mac;
        this.priority = priority;
        this.dadEnable = dadEnable;
        this.dadLinkPorts = dadLinkPorts;
        this.dadLocalIp = dadLocalIp;
        this.dadLocalIpv6 = dadLocalIpv6;
        this.dadPeerIp = dadPeerIp;
        this.dadPeerIpv6 = dadPeerIpv6;
        this.peerLinkPorts = peerLinkPorts;
    }

    @Generated
    public static class MlagMemberConfigVOBuilder {
        @Generated
        private String mac;
        @Generated
        private Integer priority;
        @Generated
        private Boolean dadEnable;
        @Generated
        private List<String> dadLinkPorts;
        @Generated
        private String dadLocalIp;
        @Generated
        private String dadLocalIpv6;
        @Generated
        private String dadPeerIp;
        @Generated
        private String dadPeerIpv6;
        @Generated
        private List<String> peerLinkPorts;

        @Generated
        MlagMemberConfigVOBuilder() {
        }

        @Generated
        public MlagMemberConfigVOBuilder mac(String mac) {
            this.mac = mac;
            return this;
        }

        @Generated
        public MlagMemberConfigVOBuilder priority(Integer priority) {
            this.priority = priority;
            return this;
        }

        @Generated
        public MlagMemberConfigVOBuilder dadEnable(Boolean dadEnable) {
            this.dadEnable = dadEnable;
            return this;
        }

        @Generated
        public MlagMemberConfigVOBuilder dadLinkPorts(List<String> dadLinkPorts) {
            this.dadLinkPorts = dadLinkPorts;
            return this;
        }

        @Generated
        public MlagMemberConfigVOBuilder dadLocalIp(String dadLocalIp) {
            this.dadLocalIp = dadLocalIp;
            return this;
        }

        @Generated
        public MlagMemberConfigVOBuilder dadLocalIpv6(String dadLocalIpv6) {
            this.dadLocalIpv6 = dadLocalIpv6;
            return this;
        }

        @Generated
        public MlagMemberConfigVOBuilder dadPeerIp(String dadPeerIp) {
            this.dadPeerIp = dadPeerIp;
            return this;
        }

        @Generated
        public MlagMemberConfigVOBuilder dadPeerIpv6(String dadPeerIpv6) {
            this.dadPeerIpv6 = dadPeerIpv6;
            return this;
        }

        @Generated
        public MlagMemberConfigVOBuilder peerLinkPorts(List<String> peerLinkPorts) {
            this.peerLinkPorts = peerLinkPorts;
            return this;
        }

        @Generated
        public MlagMemberConfigVO build() {
            return new MlagMemberConfigVO(this.mac, this.priority, this.dadEnable, this.dadLinkPorts, this.dadLocalIp, this.dadLocalIpv6, this.dadPeerIp, this.dadPeerIpv6, this.peerLinkPorts);
        }

        @Generated
        public String toString() {
            return "MlagMemberConfigVO.MlagMemberConfigVOBuilder(mac=" + this.mac + ", priority=" + this.priority + ", dadEnable=" + this.dadEnable + ", dadLinkPorts=" + this.dadLinkPorts + ", dadLocalIp=" + this.dadLocalIp + ", dadLocalIpv6=" + this.dadLocalIpv6 + ", dadPeerIp=" + this.dadPeerIp + ", dadPeerIpv6=" + this.dadPeerIpv6 + ", peerLinkPorts=" + this.peerLinkPorts + ")";
        }
    }
}

