/*
 * Decompiled with CFR 0.152.
 */
package com.tplink.smb.omada.manager.device.api.web.osw.dto;

import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.validation.constraints.NotNull;
import jakarta.validation.constraints.Pattern;
import lombok.Generated;

public class OswVrfVO {
    @Schema(description="VRF ID", requiredMode=Schema.RequiredMode.NOT_REQUIRED)
    private String id;
    @NotNull(message="vrf should not be null")
    @Pattern(regexp="^(?!(\\.|\\.\\.)$)[a-zA-Z0-9.\\-_@+]{1,15}$", message="Parameter [vrf] is invalid.")
    @Schema(name="vrf", description="VRF should be 1 to 15 characters consisting of numbers (0 to 9), uppercase and lowercase letters (A to Z, a to z), and symbols -_@.+ but cannot be . or .. only.", requiredMode=Schema.RequiredMode.REQUIRED)
    private @NotNull(message="vrf should not be null") @Pattern(regexp="^(?!(\\.|\\.\\.)$)[a-zA-Z0-9.\\-_@+]{1,15}$", message="Parameter [vrf] is invalid.") String vrf;
    @NotNull(message="ipv4Enable should not be null")
    @Schema(description="Whether to enable ipv4. Ipv4Enable should be true", requiredMode=Schema.RequiredMode.REQUIRED)
    private @NotNull(message="ipv4Enable should not be null") Boolean ipv4Enable;
    @NotNull(message="ipv6Enable should not be null")
    @Schema(description="Whether to enable ipv6", requiredMode=Schema.RequiredMode.REQUIRED)
    private @NotNull(message="ipv6Enable should not be null") Boolean ipv6Enable;
    @Schema(hidden=true)
    private Boolean isDefault;
    @Schema(hidden=true)
    private Integer resource;

    public OswVrfVO toAuditLogVO() {
        return OswVrfVO.builder().ipv4Enable(this.getIpv4Enable()).ipv6Enable(this.getIpv6Enable()).vrf(this.vrf).build();
    }

    @Generated
    public static OswVrfVOBuilder builder() {
        return new OswVrfVOBuilder();
    }

    @Generated
    public String getId() {
        return this.id;
    }

    @Generated
    public String getVrf() {
        return this.vrf;
    }

    @Generated
    public Boolean getIpv4Enable() {
        return this.ipv4Enable;
    }

    @Generated
    public Boolean getIpv6Enable() {
        return this.ipv6Enable;
    }

    @Generated
    public Boolean getIsDefault() {
        return this.isDefault;
    }

    @Generated
    public Integer getResource() {
        return this.resource;
    }

    @Generated
    public void setId(String id) {
        this.id = id;
    }

    @Generated
    public void setVrf(String vrf) {
        this.vrf = vrf;
    }

    @Generated
    public void setIpv4Enable(Boolean ipv4Enable) {
        this.ipv4Enable = ipv4Enable;
    }

    @Generated
    public void setIpv6Enable(Boolean ipv6Enable) {
        this.ipv6Enable = ipv6Enable;
    }

    @Generated
    public void setIsDefault(Boolean isDefault) {
        this.isDefault = isDefault;
    }

    @Generated
    public void setResource(Integer resource) {
        this.resource = resource;
    }

    @Generated
    public String toString() {
        return "OswVrfVO(id=" + this.getId() + ", vrf=" + this.getVrf() + ", ipv4Enable=" + this.getIpv4Enable() + ", ipv6Enable=" + this.getIpv6Enable() + ", isDefault=" + this.getIsDefault() + ", resource=" + this.getResource() + ")";
    }

    @Generated
    public OswVrfVO() {
    }

    @Generated
    public OswVrfVO(String id, String vrf, Boolean ipv4Enable, Boolean ipv6Enable, Boolean isDefault, Integer resource) {
        this.id = id;
        this.vrf = vrf;
        this.ipv4Enable = ipv4Enable;
        this.ipv6Enable = ipv6Enable;
        this.isDefault = isDefault;
        this.resource = resource;
    }

    @Generated
    public static class OswVrfVOBuilder {
        @Generated
        private String id;
        @Generated
        private String vrf;
        @Generated
        private Boolean ipv4Enable;
        @Generated
        private Boolean ipv6Enable;
        @Generated
        private Boolean isDefault;
        @Generated
        private Integer resource;

        @Generated
        OswVrfVOBuilder() {
        }

        @Generated
        public OswVrfVOBuilder id(String id) {
            this.id = id;
            return this;
        }

        @Generated
        public OswVrfVOBuilder vrf(String vrf) {
            this.vrf = vrf;
            return this;
        }

        @Generated
        public OswVrfVOBuilder ipv4Enable(Boolean ipv4Enable) {
            this.ipv4Enable = ipv4Enable;
            return this;
        }

        @Generated
        public OswVrfVOBuilder ipv6Enable(Boolean ipv6Enable) {
            this.ipv6Enable = ipv6Enable;
            return this;
        }

        @Generated
        public OswVrfVOBuilder isDefault(Boolean isDefault) {
            this.isDefault = isDefault;
            return this;
        }

        @Generated
        public OswVrfVOBuilder resource(Integer resource) {
            this.resource = resource;
            return this;
        }

        @Generated
        public OswVrfVO build() {
            return new OswVrfVO(this.id, this.vrf, this.ipv4Enable, this.ipv6Enable, this.isDefault, this.resource);
        }

        @Generated
        public String toString() {
            return "OswVrfVO.OswVrfVOBuilder(id=" + this.id + ", vrf=" + this.vrf + ", ipv4Enable=" + this.ipv4Enable + ", ipv6Enable=" + this.ipv6Enable + ", isDefault=" + this.isDefault + ", resource=" + this.resource + ")";
        }
    }
}

