/*
 * Decompiled with CFR 0.152.
 */
package com.tplink.smb.omada.manager.device.api.web.osw.dto;

import com.tplink.smb.omada.common.device.StandardOswPortIndex;
import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.validation.constraints.NotNull;
import lombok.Generated;

public class OswStandPortVO {
    @Schema(name="unit", description="Unit")
    @NotNull(message="Parameter [unit] must not be null.")
    private @NotNull(message="Parameter [unit] must not be null.") Integer unit;
    @Schema(name="slot", description="Slot")
    @NotNull(message="Parameter [slot] must not be null.")
    private @NotNull(message="Parameter [slot] must not be null.") Integer slot;
    @Schema(name="port", description="Port")
    @NotNull(message="Parameter [port] must not be null.")
    private @NotNull(message="Parameter [port] must not be null.") Integer port;

    public OswStandPortVO(Integer i2) {
        this.port = i2;
    }

    public static OswStandPortVO fromOswStandPortIdex(StandardOswPortIndex index) {
        if (index == null) {
            return new OswStandPortVO();
        }
        return new OswStandPortVO(index.getUnit(), index.getSlot(), index.getPort());
    }

    public static StandardOswPortIndex toOswStandardPortIndex(OswStandPortVO oswStandPortVO) {
        if (oswStandPortVO == null) {
            return new StandardOswPortIndex();
        }
        return new StandardOswPortIndex(oswStandPortVO.getUnit(), oswStandPortVO.getSlot(), oswStandPortVO.getPort());
    }

    public static OswStandPortVO buildDefaultWithPort(Integer port) {
        return new OswStandPortVO(1, 0, port);
    }

    public String toStandardStr() {
        return this.unit + "/" + this.slot + "/" + this.port;
    }

    @Generated
    public Integer getUnit() {
        return this.unit;
    }

    @Generated
    public Integer getSlot() {
        return this.slot;
    }

    @Generated
    public Integer getPort() {
        return this.port;
    }

    @Generated
    public void setUnit(Integer unit) {
        this.unit = unit;
    }

    @Generated
    public void setSlot(Integer slot) {
        this.slot = slot;
    }

    @Generated
    public void setPort(Integer port) {
        this.port = port;
    }

    @Generated
    public boolean equals(Object o2) {
        if (o2 == this) {
            return true;
        }
        if (!(o2 instanceof OswStandPortVO)) {
            return false;
        }
        OswStandPortVO other = (OswStandPortVO)o2;
        if (!other.canEqual(this)) {
            return false;
        }
        Integer this$unit = this.getUnit();
        Integer other$unit = other.getUnit();
        if (this$unit == null ? other$unit != null : !((Object)this$unit).equals(other$unit)) {
            return false;
        }
        Integer this$slot = this.getSlot();
        Integer other$slot = other.getSlot();
        if (this$slot == null ? other$slot != null : !((Object)this$slot).equals(other$slot)) {
            return false;
        }
        Integer this$port = this.getPort();
        Integer other$port = other.getPort();
        return !(this$port == null ? other$port != null : !((Object)this$port).equals(other$port));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof OswStandPortVO;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Integer $unit = this.getUnit();
        result = result * 59 + ($unit == null ? 43 : ((Object)$unit).hashCode());
        Integer $slot = this.getSlot();
        result = result * 59 + ($slot == null ? 43 : ((Object)$slot).hashCode());
        Integer $port = this.getPort();
        result = result * 59 + ($port == null ? 43 : ((Object)$port).hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "OswStandPortVO(unit=" + this.getUnit() + ", slot=" + this.getSlot() + ", port=" + this.getPort() + ")";
    }

    @Generated
    public OswStandPortVO(Integer unit, Integer slot, Integer port) {
        this.unit = unit;
        this.slot = slot;
        this.port = port;
    }

    @Generated
    public OswStandPortVO() {
    }
}

