/*
 * Decompiled with CFR 0.152.
 */
package com.tplink.smb.omada.manager.device.api.web.osw.dto;

import com.tplink.smb.omada.common.device.StandardOswPortIndex;
import com.tplink.smb.omada.manager.device.api.web.osw.dto.OswStandPortVO;
import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.validation.constraints.NotEmpty;
import jakarta.validation.constraints.NotNull;
import java.util.List;
import java.util.stream.Collectors;
import lombok.Generated;
import org.springframework.util.CollectionUtils;

public class OswStackPortGroupVO {
    @NotNull(message="The ID of the stack port aggregation group should not be null")
    @Schema(name="ID", description="The ID of the stack port aggregation group")
    private @NotNull(message="The ID of the stack port aggregation group should not be null") Integer id;
    @Schema(name="name", description="Name of the stacking port aggregation group")
    private String name;
    @NotEmpty(message="Port list should not be null or empty")
    @Schema(name="ports", description="Stack port aggregation group member port")
    private @NotEmpty(message="Port list should not be null or empty") List<OswStandPortVO> ports;

    public static OswStackPortGroupVO fromRawOswStackUnitStackPortLagInfo(Integer id, String name, List<StandardOswPortIndex> ports) {
        OswStackPortGroupVO oswStackPortGroupVO = new OswStackPortGroupVO();
        oswStackPortGroupVO.setId(id);
        oswStackPortGroupVO.setName(name);
        if (!CollectionUtils.isEmpty(ports)) {
            oswStackPortGroupVO.setPorts(ports.stream().map(OswStandPortVO::fromOswStandPortIdex).collect(Collectors.toList()));
        }
        return oswStackPortGroupVO;
    }

    @Generated
    public OswStackPortGroupVO() {
    }

    @Generated
    public Integer getId() {
        return this.id;
    }

    @Generated
    public String getName() {
        return this.name;
    }

    @Generated
    public List<OswStandPortVO> getPorts() {
        return this.ports;
    }

    @Generated
    public void setId(Integer id) {
        this.id = id;
    }

    @Generated
    public void setName(String name) {
        this.name = name;
    }

    @Generated
    public void setPorts(List<OswStandPortVO> ports) {
        this.ports = ports;
    }

    @Generated
    public boolean equals(Object o2) {
        if (o2 == this) {
            return true;
        }
        if (!(o2 instanceof OswStackPortGroupVO)) {
            return false;
        }
        OswStackPortGroupVO other = (OswStackPortGroupVO)o2;
        if (!other.canEqual(this)) {
            return false;
        }
        Integer this$id = this.getId();
        Integer other$id = other.getId();
        if (this$id == null ? other$id != null : !((Object)this$id).equals(other$id)) {
            return false;
        }
        String this$name = this.getName();
        String other$name = other.getName();
        if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
            return false;
        }
        List<OswStandPortVO> this$ports = this.getPorts();
        List<OswStandPortVO> other$ports = other.getPorts();
        return !(this$ports == null ? other$ports != null : !((Object)this$ports).equals(other$ports));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof OswStackPortGroupVO;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Integer $id = this.getId();
        result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
        String $name = this.getName();
        result = result * 59 + ($name == null ? 43 : $name.hashCode());
        List<OswStandPortVO> $ports = this.getPorts();
        result = result * 59 + ($ports == null ? 43 : ((Object)$ports).hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "OswStackPortGroupVO(id=" + this.getId() + ", name=" + this.getName() + ", ports=" + this.getPorts() + ")";
    }
}

