/*
 * Decompiled with CFR 0.152.
 */
package com.tplink.smb.omada.manager.device.api.web.osw.dto;

import com.tplink.smb.omada.common.validator.anons.NumberSet;
import com.tplink.smb.omada.manager.device.api.web.osw.dto.AbstractOswPortSettingVO;
import com.tplink.smb.omada.manager.device.api.web.osw.dto.OswLagBasicVO;
import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.validation.Valid;
import jakarta.validation.constraints.Pattern;
import java.util.Set;
import lombok.Generated;

public class OswPortSettingVO
extends AbstractOswPortSettingVO {
    @Pattern(regexp="switching|mirroring|aggregating", message="PortSetting parameter [operation] should be \"switching\" or \"mirroring\" or \"aggregating\"")
    @Schema(name="operation", description="Operation should be a value as follows: \"switching\" or \"mirroring\" or \"aggregating\"")
    private @Pattern(regexp="switching|mirroring|aggregating", message="PortSetting parameter [operation] should be \"switching\" or \"mirroring\" or \"aggregating\"") String operation;
    @Schema(name="mirroredPorts", description="Mirrored Ports")
    private Set<Integer> mirroredPorts;
    @Schema(name="mirroredLags", description="Mirrored Lags")
    private Set<Integer> mirroredLags;
    @Valid
    @Schema(name="lagSetting", description="Lag Setting")
    private OswLagBasicVO lagSetting;
    @NumberSet(value={0, 1, 2}, message="PortSetting parameter [dot1x] should be 0 or 1 or 2")
    @Schema(name="dot1x", description="Dot1x should be a value as follows: 0: Force unauthorized; 1: Force authorized; 2: Auto")
    private Integer dot1x;
    @NumberSet(value={0, 1}, message="PortSetting parameter [poe] should be 0 or 1")
    @Schema(name="poe", description="Poe should be a value as follows: 0: Off; 1: 802.3at/af")
    private Integer poe;
    @Schema(name="lldpMedEnable", description="Indicates whether LLDP-MED is enabled")
    private Boolean lldpMedEnable;
    @Schema(name="topoNotifyEnable", description="Indicates whether Topology Notify is enabled")
    private Boolean topoNotifyEnable;

    @Generated
    public String getOperation() {
        return this.operation;
    }

    @Generated
    public Set<Integer> getMirroredPorts() {
        return this.mirroredPorts;
    }

    @Generated
    public Set<Integer> getMirroredLags() {
        return this.mirroredLags;
    }

    @Generated
    public OswLagBasicVO getLagSetting() {
        return this.lagSetting;
    }

    @Generated
    public Integer getDot1x() {
        return this.dot1x;
    }

    @Generated
    public Integer getPoe() {
        return this.poe;
    }

    @Generated
    public Boolean getLldpMedEnable() {
        return this.lldpMedEnable;
    }

    @Generated
    public Boolean getTopoNotifyEnable() {
        return this.topoNotifyEnable;
    }

    @Generated
    public OswPortSettingVO setOperation(String operation) {
        this.operation = operation;
        return this;
    }

    @Generated
    public OswPortSettingVO setMirroredPorts(Set<Integer> mirroredPorts) {
        this.mirroredPorts = mirroredPorts;
        return this;
    }

    @Generated
    public OswPortSettingVO setMirroredLags(Set<Integer> mirroredLags) {
        this.mirroredLags = mirroredLags;
        return this;
    }

    @Generated
    public OswPortSettingVO setLagSetting(OswLagBasicVO lagSetting) {
        this.lagSetting = lagSetting;
        return this;
    }

    @Generated
    public OswPortSettingVO setDot1x(Integer dot1x) {
        this.dot1x = dot1x;
        return this;
    }

    @Generated
    public OswPortSettingVO setPoe(Integer poe) {
        this.poe = poe;
        return this;
    }

    @Generated
    public OswPortSettingVO setLldpMedEnable(Boolean lldpMedEnable) {
        this.lldpMedEnable = lldpMedEnable;
        return this;
    }

    @Generated
    public OswPortSettingVO setTopoNotifyEnable(Boolean topoNotifyEnable) {
        this.topoNotifyEnable = topoNotifyEnable;
        return this;
    }

    @Override
    @Generated
    public String toString() {
        return "OswPortSettingVO(operation=" + this.getOperation() + ", mirroredPorts=" + this.getMirroredPorts() + ", mirroredLags=" + this.getMirroredLags() + ", lagSetting=" + this.getLagSetting() + ", dot1x=" + this.getDot1x() + ", poe=" + this.getPoe() + ", lldpMedEnable=" + this.getLldpMedEnable() + ", topoNotifyEnable=" + this.getTopoNotifyEnable() + ")";
    }
}

