/*
 * Decompiled with CFR 0.152.
 */
package com.tplink.smb.omada.manager.device.api.web.osw.dto;

import com.tplink.smb.omada.a.a;
import com.tplink.smb.omada.common.validator.anons.NumberSet;
import com.tplink.smb.omada.manager.device.api.web.device.dto.DeviceLocationDetailVO;
import com.tplink.smb.omada.manager.device.api.web.osw.dto.OswSnmpVO;
import com.tplink.smb.omada.manager.device.api.web.osw.dto.f;
import com.tplink.smb.omada.manager.device.api.web.osw.dto.sdm.OswSdmBriefVO;
import jakarta.validation.Valid;
import jakarta.validation.constraints.NotNull;
import jakarta.validation.constraints.Pattern;
import jakarta.validation.constraints.Size;
import java.util.List;
import lombok.Generated;
import org.hibernate.validator.constraints.Range;

public class OswGeneralConfigVO {
    @NotNull(groups={f.a.class}, message="Parameter [switchMacList] should not be null")
    @Size(min=1, groups={f.a.class}, message="Parameter [switchMacList] should contain at least one switch MAC")
    @a
    private @NotNull(groups={f.a.class}, message="Parameter [switchMacList] should not be null") @Size(min=1, groups={f.a.class}, message="Parameter [switchMacList] should contain at least one switch MAC") List<String> switchMacList;
    @Pattern(regexp="^[^ \\+\\-\\@\\=]$|^[^ \\+\\-\\@\\=].{0,126}[^ ]$", message="Parameter [name] should be 1 ~ 128 characters")
    private @Pattern(regexp="^[^ \\+\\-\\@\\=]$|^[^ \\+\\-\\@\\=].{0,126}[^ ]$", message="Parameter [name] should be 1 ~ 128 characters") String name;
    @NumberSet(value={0, 1, 2}, message="Parameter [ledSetting] should be 0 or 1 or 2")
    private Integer ledSetting;
    private List<String> tagIds;
    @Range(min=1518L, max=9216L, message="Jumbo should be between 1518 and 9216.")
    private @Range(min=1518L, max=9216L, message="Jumbo should be between 1518 and 9216.") Integer jumbo;
    @NumberSet(value={0, 1, 2, 3, 4, 5}, message="Controller does't support this value.")
    private Integer lagHashAlg;
    @Valid
    private DeviceLocationDetailVO location;
    @Deprecated
    private Boolean remember;
    @NumberSet(value={0, 1, 2}, message="Parameter [rememberDevice] should be 0 or 1 or 2")
    private Integer rememberDevice;
    private String mvlanNetworkId;
    private Integer mvlanBridgeVlan;
    @Valid
    private OswSnmpVO snmp;
    @Size(max=1024, message="Parameter [description] should be 1 ~ 1024 characters")
    private @Size(max=1024, message="Parameter [description] should be 1 ~ 1024 characters") String description;
    @Valid
    private OswSdmBriefVO sdmTemplate;

    @Generated
    public List<String> getSwitchMacList() {
        return this.switchMacList;
    }

    @Generated
    public String getName() {
        return this.name;
    }

    @Generated
    public Integer getLedSetting() {
        return this.ledSetting;
    }

    @Generated
    public List<String> getTagIds() {
        return this.tagIds;
    }

    @Generated
    public Integer getJumbo() {
        return this.jumbo;
    }

    @Generated
    public Integer getLagHashAlg() {
        return this.lagHashAlg;
    }

    @Generated
    public DeviceLocationDetailVO getLocation() {
        return this.location;
    }

    @Deprecated
    @Generated
    public Boolean getRemember() {
        return this.remember;
    }

    @Generated
    public Integer getRememberDevice() {
        return this.rememberDevice;
    }

    @Generated
    public String getMvlanNetworkId() {
        return this.mvlanNetworkId;
    }

    @Generated
    public Integer getMvlanBridgeVlan() {
        return this.mvlanBridgeVlan;
    }

    @Generated
    public OswSnmpVO getSnmp() {
        return this.snmp;
    }

    @Generated
    public String getDescription() {
        return this.description;
    }

    @Generated
    public OswSdmBriefVO getSdmTemplate() {
        return this.sdmTemplate;
    }

    @Generated
    public OswGeneralConfigVO setSwitchMacList(List<String> switchMacList) {
        this.switchMacList = switchMacList;
        return this;
    }

    @Generated
    public OswGeneralConfigVO setName(String name) {
        this.name = name;
        return this;
    }

    @Generated
    public OswGeneralConfigVO setLedSetting(Integer ledSetting) {
        this.ledSetting = ledSetting;
        return this;
    }

    @Generated
    public OswGeneralConfigVO setTagIds(List<String> tagIds) {
        this.tagIds = tagIds;
        return this;
    }

    @Generated
    public OswGeneralConfigVO setJumbo(Integer jumbo) {
        this.jumbo = jumbo;
        return this;
    }

    @Generated
    public OswGeneralConfigVO setLagHashAlg(Integer lagHashAlg) {
        this.lagHashAlg = lagHashAlg;
        return this;
    }

    @Generated
    public OswGeneralConfigVO setLocation(DeviceLocationDetailVO location) {
        this.location = location;
        return this;
    }

    @Deprecated
    @Generated
    public OswGeneralConfigVO setRemember(Boolean remember) {
        this.remember = remember;
        return this;
    }

    @Generated
    public OswGeneralConfigVO setRememberDevice(Integer rememberDevice) {
        this.rememberDevice = rememberDevice;
        return this;
    }

    @Generated
    public OswGeneralConfigVO setMvlanNetworkId(String mvlanNetworkId) {
        this.mvlanNetworkId = mvlanNetworkId;
        return this;
    }

    @Generated
    public OswGeneralConfigVO setMvlanBridgeVlan(Integer mvlanBridgeVlan) {
        this.mvlanBridgeVlan = mvlanBridgeVlan;
        return this;
    }

    @Generated
    public OswGeneralConfigVO setSnmp(OswSnmpVO snmp) {
        this.snmp = snmp;
        return this;
    }

    @Generated
    public OswGeneralConfigVO setDescription(String description) {
        this.description = description;
        return this;
    }

    @Generated
    public OswGeneralConfigVO setSdmTemplate(OswSdmBriefVO sdmTemplate) {
        this.sdmTemplate = sdmTemplate;
        return this;
    }

    @Generated
    public String toString() {
        return "OswGeneralConfigVO(switchMacList=" + this.getSwitchMacList() + ", name=" + this.getName() + ", ledSetting=" + this.getLedSetting() + ", tagIds=" + this.getTagIds() + ", jumbo=" + this.getJumbo() + ", lagHashAlg=" + this.getLagHashAlg() + ", location=" + this.getLocation() + ", remember=" + this.getRemember() + ", rememberDevice=" + this.getRememberDevice() + ", mvlanNetworkId=" + this.getMvlanNetworkId() + ", mvlanBridgeVlan=" + this.getMvlanBridgeVlan() + ", snmp=" + this.getSnmp() + ", description=" + this.getDescription() + ", sdmTemplate=" + this.getSdmTemplate() + ")";
    }
}

