/*
 * Decompiled with CFR 0.152.
 */
package com.tplink.smb.omada.manager.device.api.web.osw.dto;

import com.tplink.smb.omada.a.a;
import com.tplink.smb.omada.common.validator.anons.NumberSet;
import com.tplink.smb.omada.device.manage.message.config.osw.OswStpMstpConfig;
import com.tplink.smb.omada.manager.device.api.web.device.dto.DeviceLocationDetailVO;
import com.tplink.smb.omada.manager.device.api.web.device.dto.IpSettingVO;
import com.tplink.smb.omada.manager.device.api.web.osw.dto.OswQosConfigVO;
import com.tplink.smb.omada.manager.device.api.web.osw.dto.OswSnmpVO;
import com.tplink.smb.omada.manager.device.api.web.osw.dto.f;
import com.tplink.smb.omada.manager.device.api.web.osw.dto.sdm.OswSdmBriefVO;
import com.tplink.smb.omada.manager.device.api.web.osw.dto.validator.ValidLoopbackControl;
import jakarta.annotation.Nullable;
import jakarta.validation.Valid;
import jakarta.validation.constraints.NotNull;
import jakarta.validation.constraints.Pattern;
import jakarta.validation.constraints.Size;
import java.util.List;
import lombok.Generated;
import org.hibernate.validator.constraints.Range;

@ValidLoopbackControl
public class OswConfigVO {
    @NotNull(groups={f.a.class}, message="Parameter [switchMacList] should not be null")
    @Size(min=1, groups={f.a.class}, message="Parameter [switchMacList] should contain at least one switch MAC")
    @a
    private @NotNull(groups={f.a.class}, message="Parameter [switchMacList] should not be null") @Size(min=1, groups={f.a.class}, message="Parameter [switchMacList] should contain at least one switch MAC") List<String> switchMacList;
    @Pattern(regexp="^[^ \\+\\-\\@\\=]$|^[^ \\+\\-\\@\\=].{0,126}[^ ]$", message="Parameter [name] should be 1 ~ 128 characters")
    private @Pattern(regexp="^[^ \\+\\-\\@\\=]$|^[^ \\+\\-\\@\\=].{0,126}[^ ]$", message="Parameter [name] should be 1 ~ 128 characters") String name;
    @NumberSet(value={0, 1, 2}, message="Parameter [ledSetting] should be 0 or 1 or 2")
    private Integer ledSetting;
    private String mvlanNetworkId;
    private Integer mvlanBridgeVlan;
    @Valid
    private IpSettingVO ipSetting;
    private Boolean loopbackDetectEnable;
    @NumberSet(value={0, 1, 2, 3}, message="Parameter [stp] should be 0 or 1 or 2 or 3")
    private Integer stp;
    @Valid
    private OswSnmpVO snmp;
    @NumberSet(value={0, 4096, 8192, 12288, 16384, 20480, 24576, 28672, 32768, 36864, 40960, 45056, 49152, 53248, 57344, 61440}, message="Parameter [priority] should be an integer from 0 to 61440 and divisible by 4096.")
    private Integer priority;
    @Range(min=1L, max=10L, message="helloTime should be between 1 and 10.")
    private @Range(min=1L, max=10L, message="helloTime should be between 1 and 10.") Integer helloTime;
    @Range(min=6L, max=40L, message="maxAge should be between 6 and 40.")
    private @Range(min=6L, max=40L, message="maxAge should be between 6 and 40.") Integer maxAge;
    @Range(min=4L, max=30L, message="forwardDelay should be between 4 and 30.")
    private @Range(min=4L, max=30L, message="forwardDelay should be between 4 and 30.") Integer forwardDelay;
    @Range(min=1L, max=20L, message="txHoldCount should be between 1 and 20.")
    private @Range(min=1L, max=20L, message="txHoldCount should be between 1 and 20.") Integer txHoldCount;
    @Range(min=1L, max=40L, message="maxHops should be between 1 and 40.")
    private @Range(min=1L, max=40L, message="maxHops should be between 1 and 40.") Integer maxHops;
    @Valid
    private OswStpMstpConfig mstp;
    private List<String> tagIds;
    @Range(min=1518L, max=9216L, message="Jumbo should be between 1518 and 9216.")
    private @Range(min=1518L, max=9216L, message="Jumbo should be between 1518 and 9216.") Integer jumbo;
    @NumberSet(value={0, 1, 2, 3, 4, 5}, message="Controller does't support this value.")
    private Integer lagHashAlg;
    @Valid
    private DeviceLocationDetailVO location;
    @Deprecated
    private Boolean remember;
    @Nullable
    private OswQosConfigVO qosConfig;
    @NumberSet(value={0, 1, 2}, message="Parameter [rememberDevice] should be 0 or 1 or 2")
    private Integer rememberDevice;
    @Size(max=1024, message="Parameter [description] should be 1 ~ 1024 characters")
    private @Size(max=1024, message="Parameter [description] should be 1 ~ 1024 characters") String description;
    private Boolean powerAlertEnable;
    @Valid
    private OswSdmBriefVO sdmTemplate;

    @Generated
    public List<String> getSwitchMacList() {
        return this.switchMacList;
    }

    @Generated
    public String getName() {
        return this.name;
    }

    @Generated
    public Integer getLedSetting() {
        return this.ledSetting;
    }

    @Generated
    public String getMvlanNetworkId() {
        return this.mvlanNetworkId;
    }

    @Generated
    public Integer getMvlanBridgeVlan() {
        return this.mvlanBridgeVlan;
    }

    @Generated
    public IpSettingVO getIpSetting() {
        return this.ipSetting;
    }

    @Generated
    public Boolean getLoopbackDetectEnable() {
        return this.loopbackDetectEnable;
    }

    @Generated
    public Integer getStp() {
        return this.stp;
    }

    @Generated
    public OswSnmpVO getSnmp() {
        return this.snmp;
    }

    @Generated
    public Integer getPriority() {
        return this.priority;
    }

    @Generated
    public Integer getHelloTime() {
        return this.helloTime;
    }

    @Generated
    public Integer getMaxAge() {
        return this.maxAge;
    }

    @Generated
    public Integer getForwardDelay() {
        return this.forwardDelay;
    }

    @Generated
    public Integer getTxHoldCount() {
        return this.txHoldCount;
    }

    @Generated
    public Integer getMaxHops() {
        return this.maxHops;
    }

    @Generated
    public OswStpMstpConfig getMstp() {
        return this.mstp;
    }

    @Generated
    public List<String> getTagIds() {
        return this.tagIds;
    }

    @Generated
    public Integer getJumbo() {
        return this.jumbo;
    }

    @Generated
    public Integer getLagHashAlg() {
        return this.lagHashAlg;
    }

    @Generated
    public DeviceLocationDetailVO getLocation() {
        return this.location;
    }

    @Deprecated
    @Generated
    public Boolean getRemember() {
        return this.remember;
    }

    @Nullable
    @Generated
    public OswQosConfigVO getQosConfig() {
        return this.qosConfig;
    }

    @Generated
    public Integer getRememberDevice() {
        return this.rememberDevice;
    }

    @Generated
    public String getDescription() {
        return this.description;
    }

    @Generated
    public Boolean getPowerAlertEnable() {
        return this.powerAlertEnable;
    }

    @Generated
    public OswSdmBriefVO getSdmTemplate() {
        return this.sdmTemplate;
    }

    @Generated
    public void setSwitchMacList(List<String> switchMacList) {
        this.switchMacList = switchMacList;
    }

    @Generated
    public void setName(String name) {
        this.name = name;
    }

    @Generated
    public void setLedSetting(Integer ledSetting) {
        this.ledSetting = ledSetting;
    }

    @Generated
    public void setMvlanNetworkId(String mvlanNetworkId) {
        this.mvlanNetworkId = mvlanNetworkId;
    }

    @Generated
    public void setMvlanBridgeVlan(Integer mvlanBridgeVlan) {
        this.mvlanBridgeVlan = mvlanBridgeVlan;
    }

    @Generated
    public void setIpSetting(IpSettingVO ipSetting) {
        this.ipSetting = ipSetting;
    }

    @Generated
    public void setLoopbackDetectEnable(Boolean loopbackDetectEnable) {
        this.loopbackDetectEnable = loopbackDetectEnable;
    }

    @Generated
    public void setStp(Integer stp) {
        this.stp = stp;
    }

    @Generated
    public void setSnmp(OswSnmpVO snmp) {
        this.snmp = snmp;
    }

    @Generated
    public void setPriority(Integer priority) {
        this.priority = priority;
    }

    @Generated
    public void setHelloTime(Integer helloTime) {
        this.helloTime = helloTime;
    }

    @Generated
    public void setMaxAge(Integer maxAge) {
        this.maxAge = maxAge;
    }

    @Generated
    public void setForwardDelay(Integer forwardDelay) {
        this.forwardDelay = forwardDelay;
    }

    @Generated
    public void setTxHoldCount(Integer txHoldCount) {
        this.txHoldCount = txHoldCount;
    }

    @Generated
    public void setMaxHops(Integer maxHops) {
        this.maxHops = maxHops;
    }

    @Generated
    public void setMstp(OswStpMstpConfig mstp) {
        this.mstp = mstp;
    }

    @Generated
    public void setTagIds(List<String> tagIds) {
        this.tagIds = tagIds;
    }

    @Generated
    public void setJumbo(Integer jumbo) {
        this.jumbo = jumbo;
    }

    @Generated
    public void setLagHashAlg(Integer lagHashAlg) {
        this.lagHashAlg = lagHashAlg;
    }

    @Generated
    public void setLocation(DeviceLocationDetailVO location) {
        this.location = location;
    }

    @Deprecated
    @Generated
    public void setRemember(Boolean remember) {
        this.remember = remember;
    }

    @Generated
    public void setQosConfig(@Nullable OswQosConfigVO qosConfig) {
        this.qosConfig = qosConfig;
    }

    @Generated
    public void setRememberDevice(Integer rememberDevice) {
        this.rememberDevice = rememberDevice;
    }

    @Generated
    public void setDescription(String description) {
        this.description = description;
    }

    @Generated
    public void setPowerAlertEnable(Boolean powerAlertEnable) {
        this.powerAlertEnable = powerAlertEnable;
    }

    @Generated
    public void setSdmTemplate(OswSdmBriefVO sdmTemplate) {
        this.sdmTemplate = sdmTemplate;
    }

    @Generated
    public String toString() {
        return "OswConfigVO(switchMacList=" + this.getSwitchMacList() + ", name=" + this.getName() + ", ledSetting=" + this.getLedSetting() + ", mvlanNetworkId=" + this.getMvlanNetworkId() + ", mvlanBridgeVlan=" + this.getMvlanBridgeVlan() + ", ipSetting=" + this.getIpSetting() + ", loopbackDetectEnable=" + this.getLoopbackDetectEnable() + ", stp=" + this.getStp() + ", snmp=" + this.getSnmp() + ", priority=" + this.getPriority() + ", helloTime=" + this.getHelloTime() + ", maxAge=" + this.getMaxAge() + ", forwardDelay=" + this.getForwardDelay() + ", txHoldCount=" + this.getTxHoldCount() + ", maxHops=" + this.getMaxHops() + ", mstp=" + this.getMstp() + ", tagIds=" + this.getTagIds() + ", jumbo=" + this.getJumbo() + ", lagHashAlg=" + this.getLagHashAlg() + ", location=" + this.getLocation() + ", remember=" + this.getRemember() + ", qosConfig=" + this.getQosConfig() + ", rememberDevice=" + this.getRememberDevice() + ", description=" + this.getDescription() + ", powerAlertEnable=" + this.getPowerAlertEnable() + ", sdmTemplate=" + this.getSdmTemplate() + ")";
    }
}

