/*
 * Decompiled with CFR 0.152.
 */
package com.tplink.smb.omada.manager.device.api.web.osw.dto;

import com.tplink.smb.omada.common.validator.anons.NumberSet;
import com.tplink.smb.omada.manager.device.api.web.osw.dto.OswBandCtrlLimitRangeVO;
import com.tplink.smb.omada.manager.device.api.web.osw.dto.validator.ValidOswBandCtrl;
import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.validation.Valid;
import jakarta.validation.constraints.NotNull;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import lombok.Generated;

@ValidOswBandCtrl
@Valid
public class OswBandCtrlVO {
    @NotNull(message="bandCtrl parameter [egressEnable] should not be null")
    @Schema(name="egressEnable", description="Indicates whether egress is enabled")
    private @NotNull(message="bandCtrl parameter [egressEnable] should not be null") Boolean egressEnable;
    @Schema(name="egressLimit", description="Egress Limit, when the user-configured value is much larger than the actual maximum value, the device will process it at the maximum value")
    private Integer egressLimit;
    @NumberSet(value={1, 2}, message="bandCtrl parameter [egressUnit] should be 1 or 2")
    @Schema(name="egressUnit", description="Egress Unit should be a value as follows: 1: Kbps; 2: Mbps")
    private Integer egressUnit;
    @NotNull(message="bandCtrl parameter [ingressEnable] should not be null")
    @Schema(name="ingressEnable", description="Indicates whether egress is enabled")
    private @NotNull(message="bandCtrl parameter [ingressEnable] should not be null") Boolean ingressEnable;
    @Schema(name="ingressLimit", description="Ingress Limit, when the user-configured value is much larger than the actual maximum value, the device will process it at the maximum value")
    private Integer ingressLimit;
    @NumberSet(value={1, 2}, message="bandCtrl parameter [ingressUnit] should be 1 or 2")
    @Schema(name="ingressUnit", description="Ingress Unit should be a value as follows: 1: Kbps; 2: Mbps")
    private Integer ingressUnit;
    private List<OswBandCtrlLimitRangeVO> limitRange;
    private List<Integer> unitSupport;

    public static List<Integer> buildUnitSupport() {
        return Stream.of(1, 2).collect(Collectors.toList());
    }

    public static List<OswBandCtrlLimitRangeVO> buildLimitRange() {
        return Stream.of(OswBandCtrlLimitRangeVO.buildKbpsLimitRange(null), OswBandCtrlLimitRangeVO.buildMbpsLimitRange(null)).collect(Collectors.toList());
    }

    public static List<OswBandCtrlLimitRangeVO> buildLimitRange(Integer maxSpeed) {
        return Stream.of(OswBandCtrlLimitRangeVO.buildKbpsLimitRange(maxSpeed * 1000), OswBandCtrlLimitRangeVO.buildMbpsLimitRange(maxSpeed)).collect(Collectors.toList());
    }

    @Generated
    public static OswBandCtrlVOBuilder builder() {
        return new OswBandCtrlVOBuilder();
    }

    @Generated
    public Boolean getEgressEnable() {
        return this.egressEnable;
    }

    @Generated
    public Integer getEgressLimit() {
        return this.egressLimit;
    }

    @Generated
    public Integer getEgressUnit() {
        return this.egressUnit;
    }

    @Generated
    public Boolean getIngressEnable() {
        return this.ingressEnable;
    }

    @Generated
    public Integer getIngressLimit() {
        return this.ingressLimit;
    }

    @Generated
    public Integer getIngressUnit() {
        return this.ingressUnit;
    }

    @Generated
    public List<OswBandCtrlLimitRangeVO> getLimitRange() {
        return this.limitRange;
    }

    @Generated
    public List<Integer> getUnitSupport() {
        return this.unitSupport;
    }

    @Generated
    public void setEgressEnable(Boolean egressEnable) {
        this.egressEnable = egressEnable;
    }

    @Generated
    public void setEgressLimit(Integer egressLimit) {
        this.egressLimit = egressLimit;
    }

    @Generated
    public void setEgressUnit(Integer egressUnit) {
        this.egressUnit = egressUnit;
    }

    @Generated
    public void setIngressEnable(Boolean ingressEnable) {
        this.ingressEnable = ingressEnable;
    }

    @Generated
    public void setIngressLimit(Integer ingressLimit) {
        this.ingressLimit = ingressLimit;
    }

    @Generated
    public void setIngressUnit(Integer ingressUnit) {
        this.ingressUnit = ingressUnit;
    }

    @Generated
    public void setLimitRange(List<OswBandCtrlLimitRangeVO> limitRange) {
        this.limitRange = limitRange;
    }

    @Generated
    public void setUnitSupport(List<Integer> unitSupport) {
        this.unitSupport = unitSupport;
    }

    @Generated
    public String toString() {
        return "OswBandCtrlVO(egressEnable=" + this.getEgressEnable() + ", egressLimit=" + this.getEgressLimit() + ", egressUnit=" + this.getEgressUnit() + ", ingressEnable=" + this.getIngressEnable() + ", ingressLimit=" + this.getIngressLimit() + ", ingressUnit=" + this.getIngressUnit() + ", limitRange=" + this.getLimitRange() + ", unitSupport=" + this.getUnitSupport() + ")";
    }

    @Generated
    public OswBandCtrlVO(Boolean egressEnable, Integer egressLimit, Integer egressUnit, Boolean ingressEnable, Integer ingressLimit, Integer ingressUnit, List<OswBandCtrlLimitRangeVO> limitRange, List<Integer> unitSupport) {
        this.egressEnable = egressEnable;
        this.egressLimit = egressLimit;
        this.egressUnit = egressUnit;
        this.ingressEnable = ingressEnable;
        this.ingressLimit = ingressLimit;
        this.ingressUnit = ingressUnit;
        this.limitRange = limitRange;
        this.unitSupport = unitSupport;
    }

    @Generated
    public OswBandCtrlVO() {
    }

    @Generated
    public static class OswBandCtrlVOBuilder {
        @Generated
        private Boolean egressEnable;
        @Generated
        private Integer egressLimit;
        @Generated
        private Integer egressUnit;
        @Generated
        private Boolean ingressEnable;
        @Generated
        private Integer ingressLimit;
        @Generated
        private Integer ingressUnit;
        @Generated
        private List<OswBandCtrlLimitRangeVO> limitRange;
        @Generated
        private List<Integer> unitSupport;

        @Generated
        OswBandCtrlVOBuilder() {
        }

        @Generated
        public OswBandCtrlVOBuilder egressEnable(Boolean egressEnable) {
            this.egressEnable = egressEnable;
            return this;
        }

        @Generated
        public OswBandCtrlVOBuilder egressLimit(Integer egressLimit) {
            this.egressLimit = egressLimit;
            return this;
        }

        @Generated
        public OswBandCtrlVOBuilder egressUnit(Integer egressUnit) {
            this.egressUnit = egressUnit;
            return this;
        }

        @Generated
        public OswBandCtrlVOBuilder ingressEnable(Boolean ingressEnable) {
            this.ingressEnable = ingressEnable;
            return this;
        }

        @Generated
        public OswBandCtrlVOBuilder ingressLimit(Integer ingressLimit) {
            this.ingressLimit = ingressLimit;
            return this;
        }

        @Generated
        public OswBandCtrlVOBuilder ingressUnit(Integer ingressUnit) {
            this.ingressUnit = ingressUnit;
            return this;
        }

        @Generated
        public OswBandCtrlVOBuilder limitRange(List<OswBandCtrlLimitRangeVO> limitRange) {
            this.limitRange = limitRange;
            return this;
        }

        @Generated
        public OswBandCtrlVOBuilder unitSupport(List<Integer> unitSupport) {
            this.unitSupport = unitSupport;
            return this;
        }

        @Generated
        public OswBandCtrlVO build() {
            return new OswBandCtrlVO(this.egressEnable, this.egressLimit, this.egressUnit, this.ingressEnable, this.ingressLimit, this.ingressUnit, this.limitRange, this.unitSupport);
        }

        @Generated
        public String toString() {
            return "OswBandCtrlVO.OswBandCtrlVOBuilder(egressEnable=" + this.egressEnable + ", egressLimit=" + this.egressLimit + ", egressUnit=" + this.egressUnit + ", ingressEnable=" + this.ingressEnable + ", ingressLimit=" + this.ingressLimit + ", ingressUnit=" + this.ingressUnit + ", limitRange=" + this.limitRange + ", unitSupport=" + this.unitSupport + ")";
        }
    }
}

