/*
 * Decompiled with CFR 0.152.
 */
package com.tplink.smb.omada.manager.device.api.web.osw.dto;

import com.tplink.smb.omada.common.validator.anons.NumberSet;
import com.tplink.smb.omada.manager.configuration.api.openapi.site.dhcp.dto.ImpbVO;
import com.tplink.smb.omada.manager.device.api.web.osw.dto.OswBandCtrlVO;
import com.tplink.smb.omada.manager.device.api.web.osw.dto.OswPortDhcpL2RelayVO;
import com.tplink.smb.omada.manager.device.api.web.osw.dto.OswStormCtrlVO;
import com.tplink.smb.omada.manager.device.api.web.osw.dto.SpanningTreeSettingVO;
import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.validation.Valid;
import jakarta.validation.constraints.Pattern;
import java.util.List;
import java.util.Map;
import java.util.Set;
import lombok.Generated;
import org.hibernate.validator.constraints.Range;

public abstract class AbstractOswPortSettingVO {
    @Pattern(regexp="^[^ ?\"]$|^[^ ?\"][^?\"]{0,126}[^ ?\"]$", message="parameter [name] should be 1 to 128 characters")
    @Schema(name="name", description="Port or Lag Name")
    private @Pattern(regexp="^[^ ?\"]$|^[^ ?\"][^?\"]{0,126}[^ ?\"]$", message="parameter [name] should be 1 to 128 characters") String name;
    @Schema(name="tagIds", description="Tag ID List")
    private List<String> tagIds;
    @Schema(name="nativeNetworkId", description="Native Network ID, Native Network cannot be selected from Tagged Networks or Untagged Networks.")
    private String nativeNetworkId;
    @Schema(name="nativeBridgeVlan", description="Native Network Bridge Vlan.")
    private Integer nativeBridgeVlan;
    @Schema(name="networkTagsSetting", description="Network Tags Setting should be a value as follows: 0: Allow All; 1: Block All; 2: Custom")
    private Integer networkTagsSetting;
    @Schema(name="tagNetworkIds", description="Tag Network IDs")
    private List<String> tagNetworkIds;
    @Schema(name="tagBridgeVlanMap", description="Tag Network Bridge Vlan Map")
    private Map<String, Set<Integer>> tagBridgeVlanMap;
    @Schema(name="untagNetworkIds", description="Untag Network IDs")
    private List<String> untagNetworkIds;
    @Schema(name="untagBridgeVlanMap", description="Untag Network Bridge Vlan Map")
    private Map<String, Set<Integer>> untagBridgeVlanMap;
    @Schema(name="voiceNetworkEnable", description="Indicates whether voice network is enabled")
    private Boolean voiceNetworkEnable;
    @Schema(name="voiceNetworkId", description="Voice Network ID")
    private String voiceNetworkId;
    @Schema(name="voiceBridgeVlan", description="Voice Network Bridge Vlan")
    private Integer voiceBridgeVlan;
    @Schema(name="voiceDscpEnable", description="Indicates whether voice DSCP is enabled")
    private Boolean voiceDscpEnable;
    @Schema(name="voiceDscp", description="Voice DSCP")
    private Integer voiceDscp;
    @Schema(name="portAlertEnable", description="Indicates whether port alert is enabled")
    private Boolean portAlertEnable;
    @Range(min=1L, max=5L, message="PortSetting parameter [fecMode] should should be within the range of {min}-{max}")
    @Schema(name="fecMode", description="FEC mode should be a value as follows: 1: Off; 2: RS528; 3: RS544; 4: Auto; 5: Base-R")
    private @Range(min=1L, max=5L, message="PortSetting parameter [fecMode] should should be within the range of {min}-{max}") Integer fecMode;
    @Schema(name="fecLinkPeerApplyEnable", description="Indicates whether the FEC Mode is synchronously applied to the link peer port.")
    private Boolean fecLinkPeerApplyEnable;
    @Schema(name="disable", description="Indicates whether to disable")
    private Boolean disable;
    @Schema(name="profileId", description="Profile ID")
    private String profileId;
    @Schema(name="profileOverrideEnable", description="Indicates whether to enable Profile Override")
    private Boolean profileOverrideEnable;
    @NumberSet(value={0, 1, 2, 3, 4, 5, 6, 7, 8, 9}, message="PortSetting parameter [linkSpeed] should be [0, 1, 2, 3, 4, 5,6,7,8,9]")
    @Schema(name="linkSpeed", description="Link Speed should be a value as follows: 0: auto; 1: 10M; 2: 100M; 3: 1000M; 4: 2.5G; 5: 10G")
    private Integer linkSpeed;
    @NumberSet(value={0, 1, 2}, message="PortSetting parameter [duplex] should be 0 or 1 or 2")
    @Schema(name="duplex", description="Duplex should be a value as follows: 0: Auto; 1: Half; 2: Full")
    private Integer duplex;
    @Schema(name="igmpSnoopingEnable", description="Indicates whether IGMP Snooping is enabled")
    private Boolean igmpSnoopingEnable;
    @NumberSet(value={0, 1, 2}, message="PortSetting parameter [bandWidthCtrlType] should be 0, 1, 2")
    @Schema(name="bandWidthCtrlType", description="BandWidthCtrlType should be a value as follows: 0: Off; 1: Rate Limit; 2: Storming Control")
    private Integer bandWidthCtrlType;
    @Valid
    @Schema(name="bandCtrl", description="Speed Limit")
    private OswBandCtrlVO bandCtrl;
    @Valid
    @Schema(name="stormCtrl", description="Storm Control")
    private OswStormCtrlVO stormCtrl;
    @Schema(name="spanningTreeEnable", description="Indicates whether SpanningTree is enabled")
    private Boolean spanningTreeEnable;
    @Valid
    @Schema(name="spanningTreeSetting", description="SpanningTree Setting")
    private SpanningTreeSettingVO spanningTreeSetting;
    @Schema(name="loopbackDetectEnable", description="Indicates whether loopbackDetect port based is enabled")
    private Boolean loopbackDetectEnable;
    @Schema(name="loopbackDetectVlanBasedEnable", description="Indicates whether loopbackDetect vlan based is enabled")
    private Boolean loopbackDetectVlanBasedEnable;
    @Schema(name="igmpFastLeaveEnable", description="Indicates whether igmp fast leave is enabled")
    private Boolean igmpFastLeaveEnable;
    @Schema(name="mldFastLeaveEnable", description="Indicates whether mld fast leave is enabled")
    private Boolean mldFastLeaveEnable;
    @Schema(name="dhcpSnoopEnable", description="Indicates whether dhcp snoop is enabled")
    private Boolean dhcpSnoopEnable;
    @Schema(name="arpDetectEnable", description="Indicates whether arp detect is enabled")
    private Boolean arpDetectEnable;
    @Schema(name="impbs", description="Impbs")
    private List<ImpbVO> impbs;
    @Schema(name="portIsolationEnable", description="Indicates whether port isolation is enabled")
    private Boolean portIsolationEnable;
    @Schema(name="eeeEnable", description="Indicates whether EEE is enabled")
    private Boolean eeeEnable;
    @Schema(name="flowControlEnable", description="Indicates whether flow control is enabled")
    private Boolean flowControlEnable;
    @Schema(name="fastLeaveEnable", description="Indicates whether igmpSnooping fastLeave is enabled")
    private Boolean fastLeaveEnable;
    @Valid
    @Schema(name="dhcpL2RelaySettings", description="Dhcp L2 Relay Setting")
    private OswPortDhcpL2RelayVO dhcpL2RelaySettings;
    @Range(min=0L, max=7L, message="PortSetting parameter [dot1pPriority] should be within the range of {min}-{max}")
    @Schema(name="dot1pPriority", description="Dot1p Priority")
    private @Range(min=0L, max=7L, message="PortSetting parameter [dot1pPriority] should be within the range of {min}-{max}") Integer dot1pPriority;
    @NumberSet(value={0, 1, 2}, message="PortSetting parameter [trustMode] should be 0 or 1 or 2")
    @Schema(name="trustMode", description="TrustMode should be a value as follows: 0: Untrusted; 1: Trust 802.1p; 2: Trust DSCP")
    private Integer trustMode;
    @Schema(name="qosQueueEnable", description="Indicates whether the ES device port has enabled the Qos scheduling queue configuration")
    private Boolean qosQueueEnable;
    @Schema(name="queueId", description="ES Qos scheduling queue ID")
    private Integer queueId;

    @Generated
    public String getName() {
        return this.name;
    }

    @Generated
    public List<String> getTagIds() {
        return this.tagIds;
    }

    @Generated
    public String getNativeNetworkId() {
        return this.nativeNetworkId;
    }

    @Generated
    public Integer getNativeBridgeVlan() {
        return this.nativeBridgeVlan;
    }

    @Generated
    public Integer getNetworkTagsSetting() {
        return this.networkTagsSetting;
    }

    @Generated
    public List<String> getTagNetworkIds() {
        return this.tagNetworkIds;
    }

    @Generated
    public Map<String, Set<Integer>> getTagBridgeVlanMap() {
        return this.tagBridgeVlanMap;
    }

    @Generated
    public List<String> getUntagNetworkIds() {
        return this.untagNetworkIds;
    }

    @Generated
    public Map<String, Set<Integer>> getUntagBridgeVlanMap() {
        return this.untagBridgeVlanMap;
    }

    @Generated
    public Boolean getVoiceNetworkEnable() {
        return this.voiceNetworkEnable;
    }

    @Generated
    public String getVoiceNetworkId() {
        return this.voiceNetworkId;
    }

    @Generated
    public Integer getVoiceBridgeVlan() {
        return this.voiceBridgeVlan;
    }

    @Generated
    public Boolean getVoiceDscpEnable() {
        return this.voiceDscpEnable;
    }

    @Generated
    public Integer getVoiceDscp() {
        return this.voiceDscp;
    }

    @Generated
    public Boolean getPortAlertEnable() {
        return this.portAlertEnable;
    }

    @Generated
    public Integer getFecMode() {
        return this.fecMode;
    }

    @Generated
    public Boolean getFecLinkPeerApplyEnable() {
        return this.fecLinkPeerApplyEnable;
    }

    @Generated
    public Boolean getDisable() {
        return this.disable;
    }

    @Generated
    public String getProfileId() {
        return this.profileId;
    }

    @Generated
    public Boolean getProfileOverrideEnable() {
        return this.profileOverrideEnable;
    }

    @Generated
    public Integer getLinkSpeed() {
        return this.linkSpeed;
    }

    @Generated
    public Integer getDuplex() {
        return this.duplex;
    }

    @Generated
    public Boolean getIgmpSnoopingEnable() {
        return this.igmpSnoopingEnable;
    }

    @Generated
    public Integer getBandWidthCtrlType() {
        return this.bandWidthCtrlType;
    }

    @Generated
    public OswBandCtrlVO getBandCtrl() {
        return this.bandCtrl;
    }

    @Generated
    public OswStormCtrlVO getStormCtrl() {
        return this.stormCtrl;
    }

    @Generated
    public Boolean getSpanningTreeEnable() {
        return this.spanningTreeEnable;
    }

    @Generated
    public SpanningTreeSettingVO getSpanningTreeSetting() {
        return this.spanningTreeSetting;
    }

    @Generated
    public Boolean getLoopbackDetectEnable() {
        return this.loopbackDetectEnable;
    }

    @Generated
    public Boolean getLoopbackDetectVlanBasedEnable() {
        return this.loopbackDetectVlanBasedEnable;
    }

    @Generated
    public Boolean getIgmpFastLeaveEnable() {
        return this.igmpFastLeaveEnable;
    }

    @Generated
    public Boolean getMldFastLeaveEnable() {
        return this.mldFastLeaveEnable;
    }

    @Generated
    public Boolean getDhcpSnoopEnable() {
        return this.dhcpSnoopEnable;
    }

    @Generated
    public Boolean getArpDetectEnable() {
        return this.arpDetectEnable;
    }

    @Generated
    public List<ImpbVO> getImpbs() {
        return this.impbs;
    }

    @Generated
    public Boolean getPortIsolationEnable() {
        return this.portIsolationEnable;
    }

    @Generated
    public Boolean getEeeEnable() {
        return this.eeeEnable;
    }

    @Generated
    public Boolean getFlowControlEnable() {
        return this.flowControlEnable;
    }

    @Generated
    public Boolean getFastLeaveEnable() {
        return this.fastLeaveEnable;
    }

    @Generated
    public OswPortDhcpL2RelayVO getDhcpL2RelaySettings() {
        return this.dhcpL2RelaySettings;
    }

    @Generated
    public Integer getDot1pPriority() {
        return this.dot1pPriority;
    }

    @Generated
    public Integer getTrustMode() {
        return this.trustMode;
    }

    @Generated
    public Boolean getQosQueueEnable() {
        return this.qosQueueEnable;
    }

    @Generated
    public Integer getQueueId() {
        return this.queueId;
    }

    @Generated
    public AbstractOswPortSettingVO setName(String name) {
        this.name = name;
        return this;
    }

    @Generated
    public AbstractOswPortSettingVO setTagIds(List<String> tagIds) {
        this.tagIds = tagIds;
        return this;
    }

    @Generated
    public AbstractOswPortSettingVO setNativeNetworkId(String nativeNetworkId) {
        this.nativeNetworkId = nativeNetworkId;
        return this;
    }

    @Generated
    public AbstractOswPortSettingVO setNativeBridgeVlan(Integer nativeBridgeVlan) {
        this.nativeBridgeVlan = nativeBridgeVlan;
        return this;
    }

    @Generated
    public AbstractOswPortSettingVO setNetworkTagsSetting(Integer networkTagsSetting) {
        this.networkTagsSetting = networkTagsSetting;
        return this;
    }

    @Generated
    public AbstractOswPortSettingVO setTagNetworkIds(List<String> tagNetworkIds) {
        this.tagNetworkIds = tagNetworkIds;
        return this;
    }

    @Generated
    public AbstractOswPortSettingVO setTagBridgeVlanMap(Map<String, Set<Integer>> tagBridgeVlanMap) {
        this.tagBridgeVlanMap = tagBridgeVlanMap;
        return this;
    }

    @Generated
    public AbstractOswPortSettingVO setUntagNetworkIds(List<String> untagNetworkIds) {
        this.untagNetworkIds = untagNetworkIds;
        return this;
    }

    @Generated
    public AbstractOswPortSettingVO setUntagBridgeVlanMap(Map<String, Set<Integer>> untagBridgeVlanMap) {
        this.untagBridgeVlanMap = untagBridgeVlanMap;
        return this;
    }

    @Generated
    public AbstractOswPortSettingVO setVoiceNetworkEnable(Boolean voiceNetworkEnable) {
        this.voiceNetworkEnable = voiceNetworkEnable;
        return this;
    }

    @Generated
    public AbstractOswPortSettingVO setVoiceNetworkId(String voiceNetworkId) {
        this.voiceNetworkId = voiceNetworkId;
        return this;
    }

    @Generated
    public AbstractOswPortSettingVO setVoiceBridgeVlan(Integer voiceBridgeVlan) {
        this.voiceBridgeVlan = voiceBridgeVlan;
        return this;
    }

    @Generated
    public AbstractOswPortSettingVO setVoiceDscpEnable(Boolean voiceDscpEnable) {
        this.voiceDscpEnable = voiceDscpEnable;
        return this;
    }

    @Generated
    public AbstractOswPortSettingVO setVoiceDscp(Integer voiceDscp) {
        this.voiceDscp = voiceDscp;
        return this;
    }

    @Generated
    public AbstractOswPortSettingVO setPortAlertEnable(Boolean portAlertEnable) {
        this.portAlertEnable = portAlertEnable;
        return this;
    }

    @Generated
    public AbstractOswPortSettingVO setFecMode(Integer fecMode) {
        this.fecMode = fecMode;
        return this;
    }

    @Generated
    public AbstractOswPortSettingVO setFecLinkPeerApplyEnable(Boolean fecLinkPeerApplyEnable) {
        this.fecLinkPeerApplyEnable = fecLinkPeerApplyEnable;
        return this;
    }

    @Generated
    public AbstractOswPortSettingVO setDisable(Boolean disable) {
        this.disable = disable;
        return this;
    }

    @Generated
    public AbstractOswPortSettingVO setProfileId(String profileId) {
        this.profileId = profileId;
        return this;
    }

    @Generated
    public AbstractOswPortSettingVO setProfileOverrideEnable(Boolean profileOverrideEnable) {
        this.profileOverrideEnable = profileOverrideEnable;
        return this;
    }

    @Generated
    public AbstractOswPortSettingVO setLinkSpeed(Integer linkSpeed) {
        this.linkSpeed = linkSpeed;
        return this;
    }

    @Generated
    public AbstractOswPortSettingVO setDuplex(Integer duplex) {
        this.duplex = duplex;
        return this;
    }

    @Generated
    public AbstractOswPortSettingVO setIgmpSnoopingEnable(Boolean igmpSnoopingEnable) {
        this.igmpSnoopingEnable = igmpSnoopingEnable;
        return this;
    }

    @Generated
    public AbstractOswPortSettingVO setBandWidthCtrlType(Integer bandWidthCtrlType) {
        this.bandWidthCtrlType = bandWidthCtrlType;
        return this;
    }

    @Generated
    public AbstractOswPortSettingVO setBandCtrl(OswBandCtrlVO bandCtrl) {
        this.bandCtrl = bandCtrl;
        return this;
    }

    @Generated
    public AbstractOswPortSettingVO setStormCtrl(OswStormCtrlVO stormCtrl) {
        this.stormCtrl = stormCtrl;
        return this;
    }

    @Generated
    public AbstractOswPortSettingVO setSpanningTreeEnable(Boolean spanningTreeEnable) {
        this.spanningTreeEnable = spanningTreeEnable;
        return this;
    }

    @Generated
    public AbstractOswPortSettingVO setSpanningTreeSetting(SpanningTreeSettingVO spanningTreeSetting) {
        this.spanningTreeSetting = spanningTreeSetting;
        return this;
    }

    @Generated
    public AbstractOswPortSettingVO setLoopbackDetectEnable(Boolean loopbackDetectEnable) {
        this.loopbackDetectEnable = loopbackDetectEnable;
        return this;
    }

    @Generated
    public AbstractOswPortSettingVO setLoopbackDetectVlanBasedEnable(Boolean loopbackDetectVlanBasedEnable) {
        this.loopbackDetectVlanBasedEnable = loopbackDetectVlanBasedEnable;
        return this;
    }

    @Generated
    public AbstractOswPortSettingVO setIgmpFastLeaveEnable(Boolean igmpFastLeaveEnable) {
        this.igmpFastLeaveEnable = igmpFastLeaveEnable;
        return this;
    }

    @Generated
    public AbstractOswPortSettingVO setMldFastLeaveEnable(Boolean mldFastLeaveEnable) {
        this.mldFastLeaveEnable = mldFastLeaveEnable;
        return this;
    }

    @Generated
    public AbstractOswPortSettingVO setDhcpSnoopEnable(Boolean dhcpSnoopEnable) {
        this.dhcpSnoopEnable = dhcpSnoopEnable;
        return this;
    }

    @Generated
    public AbstractOswPortSettingVO setArpDetectEnable(Boolean arpDetectEnable) {
        this.arpDetectEnable = arpDetectEnable;
        return this;
    }

    @Generated
    public AbstractOswPortSettingVO setImpbs(List<ImpbVO> impbs) {
        this.impbs = impbs;
        return this;
    }

    @Generated
    public AbstractOswPortSettingVO setPortIsolationEnable(Boolean portIsolationEnable) {
        this.portIsolationEnable = portIsolationEnable;
        return this;
    }

    @Generated
    public AbstractOswPortSettingVO setEeeEnable(Boolean eeeEnable) {
        this.eeeEnable = eeeEnable;
        return this;
    }

    @Generated
    public AbstractOswPortSettingVO setFlowControlEnable(Boolean flowControlEnable) {
        this.flowControlEnable = flowControlEnable;
        return this;
    }

    @Generated
    public AbstractOswPortSettingVO setFastLeaveEnable(Boolean fastLeaveEnable) {
        this.fastLeaveEnable = fastLeaveEnable;
        return this;
    }

    @Generated
    public AbstractOswPortSettingVO setDhcpL2RelaySettings(OswPortDhcpL2RelayVO dhcpL2RelaySettings) {
        this.dhcpL2RelaySettings = dhcpL2RelaySettings;
        return this;
    }

    @Generated
    public AbstractOswPortSettingVO setDot1pPriority(Integer dot1pPriority) {
        this.dot1pPriority = dot1pPriority;
        return this;
    }

    @Generated
    public AbstractOswPortSettingVO setTrustMode(Integer trustMode) {
        this.trustMode = trustMode;
        return this;
    }

    @Generated
    public AbstractOswPortSettingVO setQosQueueEnable(Boolean qosQueueEnable) {
        this.qosQueueEnable = qosQueueEnable;
        return this;
    }

    @Generated
    public AbstractOswPortSettingVO setQueueId(Integer queueId) {
        this.queueId = queueId;
        return this;
    }

    @Generated
    public String toString() {
        return "AbstractOswPortSettingVO(name=" + this.getName() + ", tagIds=" + this.getTagIds() + ", nativeNetworkId=" + this.getNativeNetworkId() + ", nativeBridgeVlan=" + this.getNativeBridgeVlan() + ", networkTagsSetting=" + this.getNetworkTagsSetting() + ", tagNetworkIds=" + this.getTagNetworkIds() + ", tagBridgeVlanMap=" + this.getTagBridgeVlanMap() + ", untagNetworkIds=" + this.getUntagNetworkIds() + ", untagBridgeVlanMap=" + this.getUntagBridgeVlanMap() + ", voiceNetworkEnable=" + this.getVoiceNetworkEnable() + ", voiceNetworkId=" + this.getVoiceNetworkId() + ", voiceBridgeVlan=" + this.getVoiceBridgeVlan() + ", voiceDscpEnable=" + this.getVoiceDscpEnable() + ", voiceDscp=" + this.getVoiceDscp() + ", portAlertEnable=" + this.getPortAlertEnable() + ", fecMode=" + this.getFecMode() + ", fecLinkPeerApplyEnable=" + this.getFecLinkPeerApplyEnable() + ", disable=" + this.getDisable() + ", profileId=" + this.getProfileId() + ", profileOverrideEnable=" + this.getProfileOverrideEnable() + ", linkSpeed=" + this.getLinkSpeed() + ", duplex=" + this.getDuplex() + ", igmpSnoopingEnable=" + this.getIgmpSnoopingEnable() + ", bandWidthCtrlType=" + this.getBandWidthCtrlType() + ", bandCtrl=" + this.getBandCtrl() + ", stormCtrl=" + this.getStormCtrl() + ", spanningTreeEnable=" + this.getSpanningTreeEnable() + ", spanningTreeSetting=" + this.getSpanningTreeSetting() + ", loopbackDetectEnable=" + this.getLoopbackDetectEnable() + ", loopbackDetectVlanBasedEnable=" + this.getLoopbackDetectVlanBasedEnable() + ", igmpFastLeaveEnable=" + this.getIgmpFastLeaveEnable() + ", mldFastLeaveEnable=" + this.getMldFastLeaveEnable() + ", dhcpSnoopEnable=" + this.getDhcpSnoopEnable() + ", arpDetectEnable=" + this.getArpDetectEnable() + ", impbs=" + this.getImpbs() + ", portIsolationEnable=" + this.getPortIsolationEnable() + ", eeeEnable=" + this.getEeeEnable() + ", flowControlEnable=" + this.getFlowControlEnable() + ", fastLeaveEnable=" + this.getFastLeaveEnable() + ", dhcpL2RelaySettings=" + this.getDhcpL2RelaySettings() + ", dot1pPriority=" + this.getDot1pPriority() + ", trustMode=" + this.getTrustMode() + ", qosQueueEnable=" + this.getQosQueueEnable() + ", queueId=" + this.getQueueId() + ")";
    }
}

