/*
 * Decompiled with CFR 0.152.
 */
package com.tplink.smb.omada.manager.device.api.web.osg.dto;

import com.tplink.smb.omada.common.validator.anons.NumberSet;
import com.tplink.smb.omada.manager.device.api.app.osg.dto.OsgConfigAppVO;
import com.tplink.smb.omada.manager.device.api.web.ap.dto.ApL3AccessVO;
import com.tplink.smb.omada.manager.device.api.web.ap.dto.ApLoadBalanceVO;
import com.tplink.smb.omada.manager.device.api.web.ap.dto.ApQosVO;
import com.tplink.smb.omada.manager.device.api.web.ap.dto.ApRadioSettingVO;
import com.tplink.smb.omada.manager.device.api.web.ap.dto.ApRssiThresholdVO;
import com.tplink.smb.omada.manager.device.api.web.ap.dto.SsidOverrideVO;
import com.tplink.smb.omada.manager.device.api.web.device.dto.DeviceLocationDetailVO;
import com.tplink.smb.omada.manager.device.api.web.osg.dto.OsgIptvVO;
import com.tplink.smb.omada.manager.device.api.web.osg.dto.OsgLtePinSettingVO;
import com.tplink.smb.omada.manager.device.api.web.osg.dto.OsgPortConfigVO;
import com.tplink.smb.omada.manager.device.api.web.osg.dto.OsgPortPoeVO;
import com.tplink.smb.omada.manager.device.api.web.osg.dto.OsgSnmpVO;
import jakarta.validation.Valid;
import jakarta.validation.constraints.Pattern;
import jakarta.validation.constraints.Size;
import java.util.List;
import lombok.Generated;

public class OsgConfigVO {
    @Pattern(regexp="^[^ \\+\\-\\@\\=]$|^[^ \\+\\-\\@\\=].{0,126}[^ ]$", message="Parameter [name] should be 1 ~ 128 characters")
    private @Pattern(regexp="^[^ \\+\\-\\@\\=]$|^[^ \\+\\-\\@\\=].{0,126}[^ ]$", message="Parameter [name] should be 1 ~ 128 characters") String name;
    @NumberSet(value={0, 1, 2}, message="Parameter [ledSetting] should be 0 or 1 or 2")
    private Integer ledSetting;
    @Deprecated
    private Boolean remember;
    @NumberSet(value={0, 1, 2}, message="Parameter [rememberDevice] should be 0 or 1 or 2")
    private Integer rememberDevice;
    @Size(max=1024, message="Parameter [description] should be 1 ~ 1024 characters")
    private @Size(max=1024, message="Parameter [description] should be 1 ~ 1024 characters") String description;
    @Valid
    private OsgSnmpVO snmp;
    @Valid
    private OsgIptvVO iptv;
    private Boolean hwOffloadEnable;
    @Deprecated
    private Boolean lldpEnable;
    private Integer lldpSetting;
    private List<OsgPortPoeVO> poeSettings;
    @Pattern(regexp="((\\d{1,2}|1\\d\\d|2[0-4]\\d|25[0-5])(\\.(\\d{1,2}|1\\d\\d|2[0-4]\\d|25[0-5])){3}|([a-zA-Z0-9]([a-zA-Z0-9\\-]{0,61}[a-zA-Z0-9])?\\.)+[a-zA-Z]{2,6})", message="Parameter [domain] Invalid.")
    private @Pattern(regexp="((\\d{1,2}|1\\d\\d|2[0-4]\\d|25[0-5])(\\.(\\d{1,2}|1\\d\\d|2[0-4]\\d|25[0-5])){3}|([a-zA-Z0-9]([a-zA-Z0-9\\-]{0,61}[a-zA-Z0-9])?\\.)+[a-zA-Z]{2,6})", message="Parameter [domain] Invalid.") String echoServer;
    @Valid
    private List<OsgPortConfigVO> portConfigs;
    @Valid
    private DeviceLocationDetailVO location;
    @Valid
    private OsgLtePinSettingVO pinSetting;
    private Integer jumboSize;
    @Valid
    private ApRadioSettingVO radioSetting2g;
    @Valid
    private ApRadioSettingVO radioSetting5g;
    @Valid
    private ApRadioSettingVO radioSetting5g1;
    @Valid
    private ApRadioSettingVO radioSetting5g2;
    @Valid
    private ApRadioSettingVO radioSetting6g;
    private String wlanId;
    @Valid
    List<SsidOverrideVO> ssidOverrides;
    @Valid
    private ApL3AccessVO l3AccessSetting;
    @Valid
    private ApLoadBalanceVO lbSetting2g;
    @Valid
    private ApLoadBalanceVO lbSetting5g;
    @Valid
    private ApLoadBalanceVO lbSetting5g1;
    @Valid
    private ApLoadBalanceVO lbSetting5g2;
    @Valid
    private ApLoadBalanceVO lbSetting6g;
    @Valid
    private ApRssiThresholdVO rssiSetting2g;
    @Valid
    private ApRssiThresholdVO rssiSetting5g;
    @Valid
    private ApRssiThresholdVO rssiSetting5g1;
    @Valid
    private ApRssiThresholdVO rssiSetting5g2;
    @Valid
    private ApRssiThresholdVO rssiSetting6g;
    @Valid
    private ApQosVO qosSetting2g;
    @Valid
    private ApQosVO qosSetting5g;
    @Valid
    private ApQosVO qosSetting5g1;
    @Valid
    private ApQosVO qosSetting5g2;
    @Valid
    private ApQosVO qosSetting6g;
    private Boolean ofdmaEnable2g;
    private Boolean ofdmaEnable5g;
    private Boolean ofdmaEnable5g1;
    private Boolean ofdmaEnable5g2;
    private Boolean ofdmaEnable6g;
    private List<String> tagIds;

    public static OsgConfigVO fromAppVO(OsgConfigAppVO appVO) {
        OsgConfigVO osgConfigVO = new OsgConfigVO();
        osgConfigVO.setName(appVO.getName());
        osgConfigVO.setLedSetting(appVO.getLedSetting());
        osgConfigVO.setSnmp(OsgSnmpVO.fromAppVO(appVO.getSnmp()));
        osgConfigVO.setIptv(OsgIptvVO.fromAppVO(appVO.getIptv()));
        osgConfigVO.setHwOffloadEnable(appVO.getHwOffloadEnable());
        osgConfigVO.setLldpEnable(appVO.getLldpEnable());
        osgConfigVO.setLldpSetting(appVO.getLldpSetting());
        osgConfigVO.setEchoServer(appVO.getEchoServer());
        osgConfigVO.setRadioSetting2g(ApRadioSettingVO.buildFromAppVO(appVO.getRadioSetting2g()));
        osgConfigVO.setRadioSetting5g(ApRadioSettingVO.buildFromAppVO(appVO.getRadioSetting5g()));
        osgConfigVO.setRadioSetting5g1(ApRadioSettingVO.buildFromAppVO(appVO.getRadioSetting5g1()));
        osgConfigVO.setRadioSetting5g2(ApRadioSettingVO.buildFromAppVO(appVO.getRadioSetting5g2()));
        osgConfigVO.setRadioSetting6g(ApRadioSettingVO.buildFromAppVO(appVO.getRadioSetting6g()));
        osgConfigVO.setWlanId(appVO.getWlanId());
        osgConfigVO.setSsidOverrides(appVO.getSsidOverrides());
        osgConfigVO.setL3AccessSetting(appVO.getL3AccessSetting());
        osgConfigVO.setLbSetting2g(appVO.getLbSetting2g());
        osgConfigVO.setLbSetting5g(appVO.getLbSetting5g());
        osgConfigVO.setLbSetting5g1(appVO.getLbSetting5g1());
        osgConfigVO.setLbSetting5g2(appVO.getLbSetting5g2());
        osgConfigVO.setLbSetting6g(appVO.getLbSetting6g());
        osgConfigVO.setQosSetting2g(appVO.getQosSetting2g());
        osgConfigVO.setQosSetting5g(appVO.getQosSetting5g());
        osgConfigVO.setQosSetting5g1(appVO.getQosSetting5g1());
        osgConfigVO.setQosSetting5g2(appVO.getQosSetting5g2());
        osgConfigVO.setQosSetting6g(appVO.getQosSetting6g());
        osgConfigVO.setRssiSetting2g(appVO.getRssiSetting2g());
        osgConfigVO.setRssiSetting5g(appVO.getRssiSetting5g());
        osgConfigVO.setRssiSetting5g1(appVO.getRssiSetting5g1());
        osgConfigVO.setRssiSetting5g2(appVO.getRssiSetting5g2());
        osgConfigVO.setRssiSetting6g(appVO.getRssiSetting6g());
        osgConfigVO.setPortConfigs(appVO.getPortConfigs());
        return osgConfigVO;
    }

    @Generated
    public String getName() {
        return this.name;
    }

    @Generated
    public Integer getLedSetting() {
        return this.ledSetting;
    }

    @Deprecated
    @Generated
    public Boolean getRemember() {
        return this.remember;
    }

    @Generated
    public Integer getRememberDevice() {
        return this.rememberDevice;
    }

    @Generated
    public String getDescription() {
        return this.description;
    }

    @Generated
    public OsgSnmpVO getSnmp() {
        return this.snmp;
    }

    @Generated
    public OsgIptvVO getIptv() {
        return this.iptv;
    }

    @Generated
    public Boolean getHwOffloadEnable() {
        return this.hwOffloadEnable;
    }

    @Deprecated
    @Generated
    public Boolean getLldpEnable() {
        return this.lldpEnable;
    }

    @Generated
    public Integer getLldpSetting() {
        return this.lldpSetting;
    }

    @Generated
    public List<OsgPortPoeVO> getPoeSettings() {
        return this.poeSettings;
    }

    @Generated
    public String getEchoServer() {
        return this.echoServer;
    }

    @Generated
    public List<OsgPortConfigVO> getPortConfigs() {
        return this.portConfigs;
    }

    @Generated
    public DeviceLocationDetailVO getLocation() {
        return this.location;
    }

    @Generated
    public OsgLtePinSettingVO getPinSetting() {
        return this.pinSetting;
    }

    @Generated
    public Integer getJumboSize() {
        return this.jumboSize;
    }

    @Generated
    public ApRadioSettingVO getRadioSetting2g() {
        return this.radioSetting2g;
    }

    @Generated
    public ApRadioSettingVO getRadioSetting5g() {
        return this.radioSetting5g;
    }

    @Generated
    public ApRadioSettingVO getRadioSetting5g1() {
        return this.radioSetting5g1;
    }

    @Generated
    public ApRadioSettingVO getRadioSetting5g2() {
        return this.radioSetting5g2;
    }

    @Generated
    public ApRadioSettingVO getRadioSetting6g() {
        return this.radioSetting6g;
    }

    @Generated
    public String getWlanId() {
        return this.wlanId;
    }

    @Generated
    public List<SsidOverrideVO> getSsidOverrides() {
        return this.ssidOverrides;
    }

    @Generated
    public ApL3AccessVO getL3AccessSetting() {
        return this.l3AccessSetting;
    }

    @Generated
    public ApLoadBalanceVO getLbSetting2g() {
        return this.lbSetting2g;
    }

    @Generated
    public ApLoadBalanceVO getLbSetting5g() {
        return this.lbSetting5g;
    }

    @Generated
    public ApLoadBalanceVO getLbSetting5g1() {
        return this.lbSetting5g1;
    }

    @Generated
    public ApLoadBalanceVO getLbSetting5g2() {
        return this.lbSetting5g2;
    }

    @Generated
    public ApLoadBalanceVO getLbSetting6g() {
        return this.lbSetting6g;
    }

    @Generated
    public ApRssiThresholdVO getRssiSetting2g() {
        return this.rssiSetting2g;
    }

    @Generated
    public ApRssiThresholdVO getRssiSetting5g() {
        return this.rssiSetting5g;
    }

    @Generated
    public ApRssiThresholdVO getRssiSetting5g1() {
        return this.rssiSetting5g1;
    }

    @Generated
    public ApRssiThresholdVO getRssiSetting5g2() {
        return this.rssiSetting5g2;
    }

    @Generated
    public ApRssiThresholdVO getRssiSetting6g() {
        return this.rssiSetting6g;
    }

    @Generated
    public ApQosVO getQosSetting2g() {
        return this.qosSetting2g;
    }

    @Generated
    public ApQosVO getQosSetting5g() {
        return this.qosSetting5g;
    }

    @Generated
    public ApQosVO getQosSetting5g1() {
        return this.qosSetting5g1;
    }

    @Generated
    public ApQosVO getQosSetting5g2() {
        return this.qosSetting5g2;
    }

    @Generated
    public ApQosVO getQosSetting6g() {
        return this.qosSetting6g;
    }

    @Generated
    public Boolean getOfdmaEnable2g() {
        return this.ofdmaEnable2g;
    }

    @Generated
    public Boolean getOfdmaEnable5g() {
        return this.ofdmaEnable5g;
    }

    @Generated
    public Boolean getOfdmaEnable5g1() {
        return this.ofdmaEnable5g1;
    }

    @Generated
    public Boolean getOfdmaEnable5g2() {
        return this.ofdmaEnable5g2;
    }

    @Generated
    public Boolean getOfdmaEnable6g() {
        return this.ofdmaEnable6g;
    }

    @Generated
    public List<String> getTagIds() {
        return this.tagIds;
    }

    @Generated
    public void setName(String name) {
        this.name = name;
    }

    @Generated
    public void setLedSetting(Integer ledSetting) {
        this.ledSetting = ledSetting;
    }

    @Deprecated
    @Generated
    public void setRemember(Boolean remember) {
        this.remember = remember;
    }

    @Generated
    public void setRememberDevice(Integer rememberDevice) {
        this.rememberDevice = rememberDevice;
    }

    @Generated
    public void setDescription(String description) {
        this.description = description;
    }

    @Generated
    public void setSnmp(OsgSnmpVO snmp) {
        this.snmp = snmp;
    }

    @Generated
    public void setIptv(OsgIptvVO iptv) {
        this.iptv = iptv;
    }

    @Generated
    public void setHwOffloadEnable(Boolean hwOffloadEnable) {
        this.hwOffloadEnable = hwOffloadEnable;
    }

    @Deprecated
    @Generated
    public void setLldpEnable(Boolean lldpEnable) {
        this.lldpEnable = lldpEnable;
    }

    @Generated
    public void setLldpSetting(Integer lldpSetting) {
        this.lldpSetting = lldpSetting;
    }

    @Generated
    public void setPoeSettings(List<OsgPortPoeVO> poeSettings) {
        this.poeSettings = poeSettings;
    }

    @Generated
    public void setEchoServer(String echoServer) {
        this.echoServer = echoServer;
    }

    @Generated
    public void setPortConfigs(List<OsgPortConfigVO> portConfigs) {
        this.portConfigs = portConfigs;
    }

    @Generated
    public void setLocation(DeviceLocationDetailVO location) {
        this.location = location;
    }

    @Generated
    public void setPinSetting(OsgLtePinSettingVO pinSetting) {
        this.pinSetting = pinSetting;
    }

    @Generated
    public void setJumboSize(Integer jumboSize) {
        this.jumboSize = jumboSize;
    }

    @Generated
    public void setRadioSetting2g(ApRadioSettingVO radioSetting2g) {
        this.radioSetting2g = radioSetting2g;
    }

    @Generated
    public void setRadioSetting5g(ApRadioSettingVO radioSetting5g) {
        this.radioSetting5g = radioSetting5g;
    }

    @Generated
    public void setRadioSetting5g1(ApRadioSettingVO radioSetting5g1) {
        this.radioSetting5g1 = radioSetting5g1;
    }

    @Generated
    public void setRadioSetting5g2(ApRadioSettingVO radioSetting5g2) {
        this.radioSetting5g2 = radioSetting5g2;
    }

    @Generated
    public void setRadioSetting6g(ApRadioSettingVO radioSetting6g) {
        this.radioSetting6g = radioSetting6g;
    }

    @Generated
    public void setWlanId(String wlanId) {
        this.wlanId = wlanId;
    }

    @Generated
    public void setSsidOverrides(List<SsidOverrideVO> ssidOverrides) {
        this.ssidOverrides = ssidOverrides;
    }

    @Generated
    public void setL3AccessSetting(ApL3AccessVO l3AccessSetting) {
        this.l3AccessSetting = l3AccessSetting;
    }

    @Generated
    public void setLbSetting2g(ApLoadBalanceVO lbSetting2g) {
        this.lbSetting2g = lbSetting2g;
    }

    @Generated
    public void setLbSetting5g(ApLoadBalanceVO lbSetting5g) {
        this.lbSetting5g = lbSetting5g;
    }

    @Generated
    public void setLbSetting5g1(ApLoadBalanceVO lbSetting5g1) {
        this.lbSetting5g1 = lbSetting5g1;
    }

    @Generated
    public void setLbSetting5g2(ApLoadBalanceVO lbSetting5g2) {
        this.lbSetting5g2 = lbSetting5g2;
    }

    @Generated
    public void setLbSetting6g(ApLoadBalanceVO lbSetting6g) {
        this.lbSetting6g = lbSetting6g;
    }

    @Generated
    public void setRssiSetting2g(ApRssiThresholdVO rssiSetting2g) {
        this.rssiSetting2g = rssiSetting2g;
    }

    @Generated
    public void setRssiSetting5g(ApRssiThresholdVO rssiSetting5g) {
        this.rssiSetting5g = rssiSetting5g;
    }

    @Generated
    public void setRssiSetting5g1(ApRssiThresholdVO rssiSetting5g1) {
        this.rssiSetting5g1 = rssiSetting5g1;
    }

    @Generated
    public void setRssiSetting5g2(ApRssiThresholdVO rssiSetting5g2) {
        this.rssiSetting5g2 = rssiSetting5g2;
    }

    @Generated
    public void setRssiSetting6g(ApRssiThresholdVO rssiSetting6g) {
        this.rssiSetting6g = rssiSetting6g;
    }

    @Generated
    public void setQosSetting2g(ApQosVO qosSetting2g) {
        this.qosSetting2g = qosSetting2g;
    }

    @Generated
    public void setQosSetting5g(ApQosVO qosSetting5g) {
        this.qosSetting5g = qosSetting5g;
    }

    @Generated
    public void setQosSetting5g1(ApQosVO qosSetting5g1) {
        this.qosSetting5g1 = qosSetting5g1;
    }

    @Generated
    public void setQosSetting5g2(ApQosVO qosSetting5g2) {
        this.qosSetting5g2 = qosSetting5g2;
    }

    @Generated
    public void setQosSetting6g(ApQosVO qosSetting6g) {
        this.qosSetting6g = qosSetting6g;
    }

    @Generated
    public void setOfdmaEnable2g(Boolean ofdmaEnable2g) {
        this.ofdmaEnable2g = ofdmaEnable2g;
    }

    @Generated
    public void setOfdmaEnable5g(Boolean ofdmaEnable5g) {
        this.ofdmaEnable5g = ofdmaEnable5g;
    }

    @Generated
    public void setOfdmaEnable5g1(Boolean ofdmaEnable5g1) {
        this.ofdmaEnable5g1 = ofdmaEnable5g1;
    }

    @Generated
    public void setOfdmaEnable5g2(Boolean ofdmaEnable5g2) {
        this.ofdmaEnable5g2 = ofdmaEnable5g2;
    }

    @Generated
    public void setOfdmaEnable6g(Boolean ofdmaEnable6g) {
        this.ofdmaEnable6g = ofdmaEnable6g;
    }

    @Generated
    public void setTagIds(List<String> tagIds) {
        this.tagIds = tagIds;
    }

    @Generated
    public String toString() {
        return "OsgConfigVO(name=" + this.getName() + ", ledSetting=" + this.getLedSetting() + ", remember=" + this.getRemember() + ", rememberDevice=" + this.getRememberDevice() + ", description=" + this.getDescription() + ", snmp=" + this.getSnmp() + ", iptv=" + this.getIptv() + ", hwOffloadEnable=" + this.getHwOffloadEnable() + ", lldpEnable=" + this.getLldpEnable() + ", lldpSetting=" + this.getLldpSetting() + ", poeSettings=" + this.getPoeSettings() + ", echoServer=" + this.getEchoServer() + ", portConfigs=" + this.getPortConfigs() + ", location=" + this.getLocation() + ", pinSetting=" + this.getPinSetting() + ", jumboSize=" + this.getJumboSize() + ", radioSetting2g=" + this.getRadioSetting2g() + ", radioSetting5g=" + this.getRadioSetting5g() + ", radioSetting5g1=" + this.getRadioSetting5g1() + ", radioSetting5g2=" + this.getRadioSetting5g2() + ", radioSetting6g=" + this.getRadioSetting6g() + ", wlanId=" + this.getWlanId() + ", ssidOverrides=" + this.getSsidOverrides() + ", l3AccessSetting=" + this.getL3AccessSetting() + ", lbSetting2g=" + this.getLbSetting2g() + ", lbSetting5g=" + this.getLbSetting5g() + ", lbSetting5g1=" + this.getLbSetting5g1() + ", lbSetting5g2=" + this.getLbSetting5g2() + ", lbSetting6g=" + this.getLbSetting6g() + ", rssiSetting2g=" + this.getRssiSetting2g() + ", rssiSetting5g=" + this.getRssiSetting5g() + ", rssiSetting5g1=" + this.getRssiSetting5g1() + ", rssiSetting5g2=" + this.getRssiSetting5g2() + ", rssiSetting6g=" + this.getRssiSetting6g() + ", qosSetting2g=" + this.getQosSetting2g() + ", qosSetting5g=" + this.getQosSetting5g() + ", qosSetting5g1=" + this.getQosSetting5g1() + ", qosSetting5g2=" + this.getQosSetting5g2() + ", qosSetting6g=" + this.getQosSetting6g() + ", ofdmaEnable2g=" + this.getOfdmaEnable2g() + ", ofdmaEnable5g=" + this.getOfdmaEnable5g() + ", ofdmaEnable5g1=" + this.getOfdmaEnable5g1() + ", ofdmaEnable5g2=" + this.getOfdmaEnable5g2() + ", ofdmaEnable6g=" + this.getOfdmaEnable6g() + ", tagIds=" + this.getTagIds() + ")";
    }
}

