/*
 * Decompiled with CFR 0.152.
 */
package com.tplink.smb.omada.manager.device.api.web.device.dto;

import com.tplink.nbu.common.pii.annotation.PII;
import com.tplink.nbu.common.pii.constant.PIIMaskStrategy;
import com.tplink.smb.omada.a.a;
import com.tplink.smb.omada.manager.device.api.web.ap.dto.ApFeatureLimitVO;
import com.tplink.smb.omada.manager.device.api.web.device.dto.LocationVO;
import io.swagger.v3.oas.annotations.media.Schema;
import java.util.List;
import java.util.Objects;
import lombok.Generated;

public class DeviceVO {
    @Schema(description="Customer ID")
    private String customId;
    @Schema(description="Customer name displayed in MSP mode")
    private String customName;
    @Schema(description="Site name")
    private String siteName;
    @Schema(description="Device type:ap\u3001gateway\u3001switch\u3001olt")
    private String type;
    @Schema(description="Device subtype, indicating a special device type for wireless routers. This field is not present for ordinary devices, where 1 represents a wireless router.")
    private Integer subDevType;
    @Schema(description="Mac address")
    @PII(strategy=PIIMaskStrategy.ENCRYPT)
    @a
    private String mac;
    @Schema(description="Default uses the MAC address as the name.")
    @PII(strategy=PIIMaskStrategy.HASH)
    private String name;
    @Schema(description="Model, such as EAP225.")
    private String model;
    @Schema(name="compoundModel", description="Model complex used in the backend.Ap\uff1amodel+(country)+modelVersion,  EAP225(EU) v3.0 Ap: specialModel+modelVersion, EAP225-Outdoor-1a20a950b8d950e8 v1.0  Gateway/Switch\uff1amodel+modelVersion, Osg v3.0")
    private String compoundModel;
    @Schema(name="showModel", description="Model complex shown in the front end.Ap\uff1amodel+(country)+modelVersion,EAP225(EU) v3.0  Gateway/Switch\uff1amodel+modelVersion,Osg v3.0")
    private String showModel;
    @Schema(name="modelVersion", description="Model version of device,for example:3.0")
    private String modelVersion;
    @Schema(name="firmwareVersion", description="Version of firmware,for example:2.5.0 Build 20190118 Rel. 64821")
    private String firmwareVersion;
    @Schema(description="Software version, such as \"2.5.0,\" extracted from DeviceDO.firmwareVersion - \"2.5.0 Build 20190118 Rel. 64821.\"")
    private String version;
    @Schema(name="hwVersion", description="Version of hardware,for example 1.0")
    private String hwVersion;
    @Schema(name="specialModel", description="Special device model,for example:EAP225-Outdoor-1a20a950b8d950e8")
    private String specialModel;
    @Schema(description="Ip address,such as 192.168.0.105")
    @PII(strategy=PIIMaskStrategy.HASH)
    private String ip;
    @Schema(name="publicIp", description="Public ip address")
    @PII(strategy=PIIMaskStrategy.HASH)
    private String publicIp;
    @Schema(name="ipv6List", description="Ipv6 address List")
    @PII(strategy=PIIMaskStrategy.HASH)
    private List<String> ipv6List;
    @Schema(description="Device uptime")
    private String uptime;
    @Schema(description="Runtime duration, in seconds (s).")
    private Long uptimeLong;
    @Schema(name="statusCategory", description="Category of device status,statusCategory should be a value as follows: 0:Disconnected;1:Connected;2:Pending;3:Heartbeat Missed;4:Isolated")
    private Integer statusCategory;
    @Schema(name="status", description="Status of device,status should be a value as follows: 0:Disconnected;1:Disconnected(Migrating);10:Provisioning;11:Configuring;12:Upgrading;13:Rebooting;14:Connected;15:Connected(Wireless);16:Connected(Migrating);17:Connected(Wireless,Migrating);20:Pending;21:Pending(Wireless);22:Adopting;23:Adopting(Wireless);24:Adopt Failed;25:Adopt Failed(Wireless);26:Managed By Others;27:Managed By Others(Wireless);30:Heartbeat Missed;31:Heartbeat Missed(Wireless);32:Heartbeat Missed(Migrating);33:Heartbeat Missed(Wireless,Migrating);40:Isolated;41:Isolated(Migrating);50:Slice Configuring")
    private Integer status;
    @Schema(description="Adopt fail reason should be a value as follows: -1:adopt timeout;-2:user/password error")
    private Integer adoptFailType;
    @Schema(description="Last active time.")
    private Long lastSeen;
    @Schema(description="Whether the device needs upgrade")
    private Boolean needUpgrade;
    @Schema(description="Latest firmware version")
    private String latestVersion;
    @Schema(description="Whether the device is downloading firmware")
    private Boolean fwDownload;
    @Schema(description="Cpu utilization")
    private Integer cpuUtil;
    @Schema(description="Memory utilization")
    private Integer memUtil;
    @Schema(description="Real-time total downstream traffic (bytes).")
    private Long download;
    @Schema(description="Real-time total upstream traffic (bytes).")
    private Long upload;
    @Schema(description="\"Site of the device\"")
    private String site;
    @Schema(description="Device location information on the map; null indicates unplaced.")
    private LocationVO location;
    @Schema(description="Number of clients.")
    private Integer clientNum;
    @Schema(name="compatible", description="Device firmware and controller compatibility type.Compatible should be a value as follows: 0:COMPATIBLE;1:HIGH_MAJOR_VER;2:LOW_MAJOR_VER;3:HIGH_MINOR_VER;4:LOW_MINOR_VER;7:HIGH_COMPONENT_VER;10:DEVICE_NOT_COMPATIBLE;11:HIGH_ADOPT_COMMPONENT;12:DEVICE_CATEGORY_NOT_COMPATIBLE;14:DEVICE_NOT_COMPATIBLE_IN_CLUSTER")
    private Integer compatible;
    @Schema(description="Whether locate function is enabled")
    private Boolean locateEnable;
    @Schema(description="Mark whether the device is activated: When license (specific to cloud base) is false, the status column shows the pre-bound status. When it is true or null, the status column displays as it originally did.")
    private Boolean active;
    @Schema(description="License status should be a value as follows:0: unActive 1: Unbind 2: Expired 3: active If there is a value and it is not 3, display the Active button. license (specific to cloud base).")
    private Integer licenseStatus;
    @Schema(description="Expire timestamp of license(cloud base exclusive)")
    private Long dueTime;
    @Schema(description="Milliseconds from the current moment to the expiration time(cloud base exclusive)")
    private Long dueTimeLeft;
    @Schema(description="Remaining unbind count for license on detail Page of device(cloud base exclusive)")
    private Integer licenseUnbindingLimit;
    @Schema(description="Whether the device is in white list")
    private Boolean inWhitelist;
    @Schema(description="SN code of device")
    @PII(strategy=PIIMaskStrategy.ENCRYPT)
    private String sn;
    @Schema(description="End of service time of device(CBC exclusive)")
    private Long eost;
    @Schema(description="End of support time of device(CBC exclusive)")
    private Long eos;
    @Schema(description="Is it an combined gateway?")
    private Boolean combinedGateway;
    @Schema(description="Whether it is Agile Series Switch")
    private Boolean es;
    @Schema(description="Whether it is LTE Backup")
    private Boolean ippt;
    private Boolean supportIppt;
    @Schema(description="Whether the device firmware support intelligent anomaly detection")
    private Boolean supportAnomaly;
    @Schema(description="1~3: poor; 4~7: fair; 0: no data; 8~10 good.")
    private Integer healthScore;
    @Schema(description="The time of healthScore")
    private Long healthScoreTime;
    @Schema(description="Device tag name")
    private String tagName;
    @Schema(description="Whether the device is added in advanced.")
    private Boolean addedInAdvanced;
    @Schema(description="Category of license.When activating in bulk for the pro site, the front end can only select the same type for bulk activation.")
    private String category;
    @Schema(description="When the pre-added devices cannot properly pass through, an error will be returned.")
    private Integer preConfigErrorCode;
    @Schema(description="When retrying the path through, if there is a value, the front end will display a retry button. The types are: 1:Requires password input.2: No password input needed.")
    private Integer preConfigRetryType;
    @Schema(description="AP power mode.The power supply types are as follows: 0: DC power supply 1: 802.3bt power supply 2: 802.3at power supply 3: 802.3af power supply 4: Switch power supply (display restart)")
    private Integer powerMode;
    @Schema(description="Indicating the power supply modes for AP devices across frequency bands, with array indices corresponding to the frequency bands: 0: 2.4G 1: 5G/5G1 2: 5G2 3: 6G. The corresponding values for power supply modes are: 0: Normal operation 1: Power limited 2: Frequency band disabled")
    private List<Integer> powerModeList;
    @Schema(description="Functions that need to be restricted under the current power supply mode.")
    private ApFeatureLimitVO featureLimit;
    @Schema(description="Indicates whether it is a wireless router; it is true only when this device is a wireless router.")
    private Boolean wirelessRouter;
    private String description;
    @Schema(description="Device online upgrade status should be a value as follows: 0:IDLE,1:DOWNLOADING,2:UPGRADING")
    private Integer onlineUpgradeStatus;
    @Schema(description="Device type should be a value as follows:0:advanced,1:pro")
    private Integer deviceSeriesType;
    @Schema(description="Device configuration synchronization status , including: 0: noConfig (No configuration) 1: success (Success) 2: fail (Failure) 3: info (Information) 4: configuring (Configuring) 5: preConfig (Pre-configuration)")
    private Integer configSyncStatus;
    @Schema(description="Whether the device supports show running config.")
    private Boolean supportRunningConfig;
    @Schema(name="resource", description="Data source.Resource should be a value as follows: 0:new created;1:from template;2:override")
    private Integer resource;
    @Schema(description="Address")
    private String address;
    @Schema(description="Uplink device mac")
    @a
    private String uplinkDeviceMac;
    @Schema(description="Uplink device mac name")
    private String uplinkDeviceName;
    @Schema(description="Uplink device port")
    private String uplinkDevicePort;
    @Schema(description="Link speed")
    private Integer linkSpeed;
    @Schema(description="Duplex should be a value as follows:0:Auto,1:Half, 2:Full")
    private Integer duplex;
    @Schema(description="Whether the device can be adopted by the site.")
    private Boolean switchConsistent;
    @Schema(name="ecspFirstVersion", description="Ecsp first version")
    private Integer ecspFirstVersion;
    @Schema(name="packageCaptureStatus")
    private Integer packageCaptureStatus = 0;

    public String getLicenseStatusStr() {
        if (this.licenseStatus == null) {
            return "-";
        }
        return LicenseNameEnum.getName(this.licenseStatus);
    }

    @Generated
    protected DeviceVO(DeviceVOBuilder<?, ?> b2) {
        this.customId = b2.customId;
        this.customName = b2.customName;
        this.siteName = b2.siteName;
        this.type = b2.type;
        this.subDevType = b2.subDevType;
        this.mac = b2.mac;
        this.name = b2.name;
        this.model = b2.model;
        this.compoundModel = b2.compoundModel;
        this.showModel = b2.showModel;
        this.modelVersion = b2.modelVersion;
        this.firmwareVersion = b2.firmwareVersion;
        this.version = b2.version;
        this.hwVersion = b2.hwVersion;
        this.specialModel = b2.specialModel;
        this.ip = b2.ip;
        this.publicIp = b2.publicIp;
        this.ipv6List = b2.ipv6List;
        this.uptime = b2.uptime;
        this.uptimeLong = b2.uptimeLong;
        this.statusCategory = b2.statusCategory;
        this.status = b2.status;
        this.adoptFailType = b2.adoptFailType;
        this.lastSeen = b2.lastSeen;
        this.needUpgrade = b2.needUpgrade;
        this.latestVersion = b2.latestVersion;
        this.fwDownload = b2.fwDownload;
        this.cpuUtil = b2.cpuUtil;
        this.memUtil = b2.memUtil;
        this.download = b2.download;
        this.upload = b2.upload;
        this.site = b2.site;
        this.location = b2.location;
        this.clientNum = b2.clientNum;
        this.compatible = b2.compatible;
        this.locateEnable = b2.locateEnable;
        this.active = b2.active;
        this.licenseStatus = b2.licenseStatus;
        this.dueTime = b2.dueTime;
        this.dueTimeLeft = b2.dueTimeLeft;
        this.licenseUnbindingLimit = b2.licenseUnbindingLimit;
        this.inWhitelist = b2.inWhitelist;
        this.sn = b2.sn;
        this.eost = b2.eost;
        this.eos = b2.eos;
        this.combinedGateway = b2.combinedGateway;
        this.es = b2.es;
        this.ippt = b2.ippt;
        this.supportIppt = b2.supportIppt;
        this.supportAnomaly = b2.supportAnomaly;
        this.healthScore = b2.healthScore;
        this.healthScoreTime = b2.healthScoreTime;
        this.tagName = b2.tagName;
        this.addedInAdvanced = b2.addedInAdvanced;
        this.category = b2.category;
        this.preConfigErrorCode = b2.preConfigErrorCode;
        this.preConfigRetryType = b2.preConfigRetryType;
        this.powerMode = b2.powerMode;
        this.powerModeList = b2.powerModeList;
        this.featureLimit = b2.featureLimit;
        this.wirelessRouter = b2.wirelessRouter;
        this.description = b2.description;
        this.onlineUpgradeStatus = b2.onlineUpgradeStatus;
        this.deviceSeriesType = b2.deviceSeriesType;
        this.configSyncStatus = b2.configSyncStatus;
        this.supportRunningConfig = b2.supportRunningConfig;
        this.resource = b2.resource;
        this.address = b2.address;
        this.uplinkDeviceMac = b2.uplinkDeviceMac;
        this.uplinkDeviceName = b2.uplinkDeviceName;
        this.uplinkDevicePort = b2.uplinkDevicePort;
        this.linkSpeed = b2.linkSpeed;
        this.duplex = b2.duplex;
        this.switchConsistent = b2.switchConsistent;
        this.ecspFirstVersion = b2.ecspFirstVersion;
        this.packageCaptureStatus = b2.packageCaptureStatus;
    }

    @Generated
    public static DeviceVOBuilder<?, ?> builder() {
        return new DeviceVOBuilderImpl();
    }

    @Generated
    public String getCustomId() {
        return this.customId;
    }

    @Generated
    public String getCustomName() {
        return this.customName;
    }

    @Generated
    public String getSiteName() {
        return this.siteName;
    }

    @Generated
    public String getType() {
        return this.type;
    }

    @Generated
    public Integer getSubDevType() {
        return this.subDevType;
    }

    @Generated
    public String getMac() {
        return this.mac;
    }

    @Generated
    public String getName() {
        return this.name;
    }

    @Generated
    public String getModel() {
        return this.model;
    }

    @Generated
    public String getCompoundModel() {
        return this.compoundModel;
    }

    @Generated
    public String getShowModel() {
        return this.showModel;
    }

    @Generated
    public String getModelVersion() {
        return this.modelVersion;
    }

    @Generated
    public String getFirmwareVersion() {
        return this.firmwareVersion;
    }

    @Generated
    public String getVersion() {
        return this.version;
    }

    @Generated
    public String getHwVersion() {
        return this.hwVersion;
    }

    @Generated
    public String getSpecialModel() {
        return this.specialModel;
    }

    @Generated
    public String getIp() {
        return this.ip;
    }

    @Generated
    public String getPublicIp() {
        return this.publicIp;
    }

    @Generated
    public List<String> getIpv6List() {
        return this.ipv6List;
    }

    @Generated
    public String getUptime() {
        return this.uptime;
    }

    @Generated
    public Long getUptimeLong() {
        return this.uptimeLong;
    }

    @Generated
    public Integer getStatusCategory() {
        return this.statusCategory;
    }

    @Generated
    public Integer getStatus() {
        return this.status;
    }

    @Generated
    public Integer getAdoptFailType() {
        return this.adoptFailType;
    }

    @Generated
    public Long getLastSeen() {
        return this.lastSeen;
    }

    @Generated
    public Boolean getNeedUpgrade() {
        return this.needUpgrade;
    }

    @Generated
    public String getLatestVersion() {
        return this.latestVersion;
    }

    @Generated
    public Boolean getFwDownload() {
        return this.fwDownload;
    }

    @Generated
    public Integer getCpuUtil() {
        return this.cpuUtil;
    }

    @Generated
    public Integer getMemUtil() {
        return this.memUtil;
    }

    @Generated
    public Long getDownload() {
        return this.download;
    }

    @Generated
    public Long getUpload() {
        return this.upload;
    }

    @Generated
    public String getSite() {
        return this.site;
    }

    @Generated
    public LocationVO getLocation() {
        return this.location;
    }

    @Generated
    public Integer getClientNum() {
        return this.clientNum;
    }

    @Generated
    public Integer getCompatible() {
        return this.compatible;
    }

    @Generated
    public Boolean getLocateEnable() {
        return this.locateEnable;
    }

    @Generated
    public Boolean getActive() {
        return this.active;
    }

    @Generated
    public Integer getLicenseStatus() {
        return this.licenseStatus;
    }

    @Generated
    public Long getDueTime() {
        return this.dueTime;
    }

    @Generated
    public Long getDueTimeLeft() {
        return this.dueTimeLeft;
    }

    @Generated
    public Integer getLicenseUnbindingLimit() {
        return this.licenseUnbindingLimit;
    }

    @Generated
    public Boolean getInWhitelist() {
        return this.inWhitelist;
    }

    @Generated
    public String getSn() {
        return this.sn;
    }

    @Generated
    public Long getEost() {
        return this.eost;
    }

    @Generated
    public Long getEos() {
        return this.eos;
    }

    @Generated
    public Boolean getCombinedGateway() {
        return this.combinedGateway;
    }

    @Generated
    public Boolean getEs() {
        return this.es;
    }

    @Generated
    public Boolean getIppt() {
        return this.ippt;
    }

    @Generated
    public Boolean getSupportIppt() {
        return this.supportIppt;
    }

    @Generated
    public Boolean getSupportAnomaly() {
        return this.supportAnomaly;
    }

    @Generated
    public Integer getHealthScore() {
        return this.healthScore;
    }

    @Generated
    public Long getHealthScoreTime() {
        return this.healthScoreTime;
    }

    @Generated
    public String getTagName() {
        return this.tagName;
    }

    @Generated
    public Boolean getAddedInAdvanced() {
        return this.addedInAdvanced;
    }

    @Generated
    public String getCategory() {
        return this.category;
    }

    @Generated
    public Integer getPreConfigErrorCode() {
        return this.preConfigErrorCode;
    }

    @Generated
    public Integer getPreConfigRetryType() {
        return this.preConfigRetryType;
    }

    @Generated
    public Integer getPowerMode() {
        return this.powerMode;
    }

    @Generated
    public List<Integer> getPowerModeList() {
        return this.powerModeList;
    }

    @Generated
    public ApFeatureLimitVO getFeatureLimit() {
        return this.featureLimit;
    }

    @Generated
    public Boolean getWirelessRouter() {
        return this.wirelessRouter;
    }

    @Generated
    public String getDescription() {
        return this.description;
    }

    @Generated
    public Integer getOnlineUpgradeStatus() {
        return this.onlineUpgradeStatus;
    }

    @Generated
    public Integer getDeviceSeriesType() {
        return this.deviceSeriesType;
    }

    @Generated
    public Integer getConfigSyncStatus() {
        return this.configSyncStatus;
    }

    @Generated
    public Boolean getSupportRunningConfig() {
        return this.supportRunningConfig;
    }

    @Generated
    public Integer getResource() {
        return this.resource;
    }

    @Generated
    public String getAddress() {
        return this.address;
    }

    @Generated
    public String getUplinkDeviceMac() {
        return this.uplinkDeviceMac;
    }

    @Generated
    public String getUplinkDeviceName() {
        return this.uplinkDeviceName;
    }

    @Generated
    public String getUplinkDevicePort() {
        return this.uplinkDevicePort;
    }

    @Generated
    public Integer getLinkSpeed() {
        return this.linkSpeed;
    }

    @Generated
    public Integer getDuplex() {
        return this.duplex;
    }

    @Generated
    public Boolean getSwitchConsistent() {
        return this.switchConsistent;
    }

    @Generated
    public Integer getEcspFirstVersion() {
        return this.ecspFirstVersion;
    }

    @Generated
    public Integer getPackageCaptureStatus() {
        return this.packageCaptureStatus;
    }

    @Generated
    public void setCustomId(String customId) {
        this.customId = customId;
    }

    @Generated
    public void setCustomName(String customName) {
        this.customName = customName;
    }

    @Generated
    public void setSiteName(String siteName) {
        this.siteName = siteName;
    }

    @Generated
    public void setType(String type) {
        this.type = type;
    }

    @Generated
    public void setSubDevType(Integer subDevType) {
        this.subDevType = subDevType;
    }

    @Generated
    public void setMac(String mac) {
        this.mac = mac;
    }

    @Generated
    public void setName(String name) {
        this.name = name;
    }

    @Generated
    public void setModel(String model) {
        this.model = model;
    }

    @Generated
    public void setCompoundModel(String compoundModel) {
        this.compoundModel = compoundModel;
    }

    @Generated
    public void setShowModel(String showModel) {
        this.showModel = showModel;
    }

    @Generated
    public void setModelVersion(String modelVersion) {
        this.modelVersion = modelVersion;
    }

    @Generated
    public void setFirmwareVersion(String firmwareVersion) {
        this.firmwareVersion = firmwareVersion;
    }

    @Generated
    public void setVersion(String version) {
        this.version = version;
    }

    @Generated
    public void setHwVersion(String hwVersion) {
        this.hwVersion = hwVersion;
    }

    @Generated
    public void setSpecialModel(String specialModel) {
        this.specialModel = specialModel;
    }

    @Generated
    public void setIp(String ip) {
        this.ip = ip;
    }

    @Generated
    public void setPublicIp(String publicIp) {
        this.publicIp = publicIp;
    }

    @Generated
    public void setIpv6List(List<String> ipv6List) {
        this.ipv6List = ipv6List;
    }

    @Generated
    public void setUptime(String uptime) {
        this.uptime = uptime;
    }

    @Generated
    public void setUptimeLong(Long uptimeLong) {
        this.uptimeLong = uptimeLong;
    }

    @Generated
    public void setStatusCategory(Integer statusCategory) {
        this.statusCategory = statusCategory;
    }

    @Generated
    public void setStatus(Integer status) {
        this.status = status;
    }

    @Generated
    public void setAdoptFailType(Integer adoptFailType) {
        this.adoptFailType = adoptFailType;
    }

    @Generated
    public void setLastSeen(Long lastSeen) {
        this.lastSeen = lastSeen;
    }

    @Generated
    public void setNeedUpgrade(Boolean needUpgrade) {
        this.needUpgrade = needUpgrade;
    }

    @Generated
    public void setLatestVersion(String latestVersion) {
        this.latestVersion = latestVersion;
    }

    @Generated
    public void setFwDownload(Boolean fwDownload) {
        this.fwDownload = fwDownload;
    }

    @Generated
    public void setCpuUtil(Integer cpuUtil) {
        this.cpuUtil = cpuUtil;
    }

    @Generated
    public void setMemUtil(Integer memUtil) {
        this.memUtil = memUtil;
    }

    @Generated
    public void setDownload(Long download) {
        this.download = download;
    }

    @Generated
    public void setUpload(Long upload) {
        this.upload = upload;
    }

    @Generated
    public void setSite(String site) {
        this.site = site;
    }

    @Generated
    public void setLocation(LocationVO location) {
        this.location = location;
    }

    @Generated
    public void setClientNum(Integer clientNum) {
        this.clientNum = clientNum;
    }

    @Generated
    public void setCompatible(Integer compatible) {
        this.compatible = compatible;
    }

    @Generated
    public void setLocateEnable(Boolean locateEnable) {
        this.locateEnable = locateEnable;
    }

    @Generated
    public void setActive(Boolean active) {
        this.active = active;
    }

    @Generated
    public void setLicenseStatus(Integer licenseStatus) {
        this.licenseStatus = licenseStatus;
    }

    @Generated
    public void setDueTime(Long dueTime) {
        this.dueTime = dueTime;
    }

    @Generated
    public void setDueTimeLeft(Long dueTimeLeft) {
        this.dueTimeLeft = dueTimeLeft;
    }

    @Generated
    public void setLicenseUnbindingLimit(Integer licenseUnbindingLimit) {
        this.licenseUnbindingLimit = licenseUnbindingLimit;
    }

    @Generated
    public void setInWhitelist(Boolean inWhitelist) {
        this.inWhitelist = inWhitelist;
    }

    @Generated
    public void setSn(String sn) {
        this.sn = sn;
    }

    @Generated
    public void setEost(Long eost) {
        this.eost = eost;
    }

    @Generated
    public void setEos(Long eos) {
        this.eos = eos;
    }

    @Generated
    public void setCombinedGateway(Boolean combinedGateway) {
        this.combinedGateway = combinedGateway;
    }

    @Generated
    public void setEs(Boolean es) {
        this.es = es;
    }

    @Generated
    public void setIppt(Boolean ippt) {
        this.ippt = ippt;
    }

    @Generated
    public void setSupportIppt(Boolean supportIppt) {
        this.supportIppt = supportIppt;
    }

    @Generated
    public void setSupportAnomaly(Boolean supportAnomaly) {
        this.supportAnomaly = supportAnomaly;
    }

    @Generated
    public void setHealthScore(Integer healthScore) {
        this.healthScore = healthScore;
    }

    @Generated
    public void setHealthScoreTime(Long healthScoreTime) {
        this.healthScoreTime = healthScoreTime;
    }

    @Generated
    public void setTagName(String tagName) {
        this.tagName = tagName;
    }

    @Generated
    public void setAddedInAdvanced(Boolean addedInAdvanced) {
        this.addedInAdvanced = addedInAdvanced;
    }

    @Generated
    public void setCategory(String category) {
        this.category = category;
    }

    @Generated
    public void setPreConfigErrorCode(Integer preConfigErrorCode) {
        this.preConfigErrorCode = preConfigErrorCode;
    }

    @Generated
    public void setPreConfigRetryType(Integer preConfigRetryType) {
        this.preConfigRetryType = preConfigRetryType;
    }

    @Generated
    public void setPowerMode(Integer powerMode) {
        this.powerMode = powerMode;
    }

    @Generated
    public void setPowerModeList(List<Integer> powerModeList) {
        this.powerModeList = powerModeList;
    }

    @Generated
    public void setFeatureLimit(ApFeatureLimitVO featureLimit) {
        this.featureLimit = featureLimit;
    }

    @Generated
    public void setWirelessRouter(Boolean wirelessRouter) {
        this.wirelessRouter = wirelessRouter;
    }

    @Generated
    public void setDescription(String description) {
        this.description = description;
    }

    @Generated
    public void setOnlineUpgradeStatus(Integer onlineUpgradeStatus) {
        this.onlineUpgradeStatus = onlineUpgradeStatus;
    }

    @Generated
    public void setDeviceSeriesType(Integer deviceSeriesType) {
        this.deviceSeriesType = deviceSeriesType;
    }

    @Generated
    public void setConfigSyncStatus(Integer configSyncStatus) {
        this.configSyncStatus = configSyncStatus;
    }

    @Generated
    public void setSupportRunningConfig(Boolean supportRunningConfig) {
        this.supportRunningConfig = supportRunningConfig;
    }

    @Generated
    public void setResource(Integer resource) {
        this.resource = resource;
    }

    @Generated
    public void setAddress(String address) {
        this.address = address;
    }

    @Generated
    public void setUplinkDeviceMac(String uplinkDeviceMac) {
        this.uplinkDeviceMac = uplinkDeviceMac;
    }

    @Generated
    public void setUplinkDeviceName(String uplinkDeviceName) {
        this.uplinkDeviceName = uplinkDeviceName;
    }

    @Generated
    public void setUplinkDevicePort(String uplinkDevicePort) {
        this.uplinkDevicePort = uplinkDevicePort;
    }

    @Generated
    public void setLinkSpeed(Integer linkSpeed) {
        this.linkSpeed = linkSpeed;
    }

    @Generated
    public void setDuplex(Integer duplex) {
        this.duplex = duplex;
    }

    @Generated
    public void setSwitchConsistent(Boolean switchConsistent) {
        this.switchConsistent = switchConsistent;
    }

    @Generated
    public void setEcspFirstVersion(Integer ecspFirstVersion) {
        this.ecspFirstVersion = ecspFirstVersion;
    }

    @Generated
    public void setPackageCaptureStatus(Integer packageCaptureStatus) {
        this.packageCaptureStatus = packageCaptureStatus;
    }

    @Generated
    public String toString() {
        return "DeviceVO(super=" + super.toString() + ", customId=" + this.getCustomId() + ", customName=" + this.getCustomName() + ", siteName=" + this.getSiteName() + ", type=" + this.getType() + ", subDevType=" + this.getSubDevType() + ", mac=" + this.getMac() + ", name=" + this.getName() + ", model=" + this.getModel() + ", compoundModel=" + this.getCompoundModel() + ", showModel=" + this.getShowModel() + ", modelVersion=" + this.getModelVersion() + ", firmwareVersion=" + this.getFirmwareVersion() + ", version=" + this.getVersion() + ", hwVersion=" + this.getHwVersion() + ", specialModel=" + this.getSpecialModel() + ", ip=" + this.getIp() + ", publicIp=" + this.getPublicIp() + ", ipv6List=" + this.getIpv6List() + ", uptime=" + this.getUptime() + ", uptimeLong=" + this.getUptimeLong() + ", statusCategory=" + this.getStatusCategory() + ", status=" + this.getStatus() + ", adoptFailType=" + this.getAdoptFailType() + ", lastSeen=" + this.getLastSeen() + ", needUpgrade=" + this.getNeedUpgrade() + ", latestVersion=" + this.getLatestVersion() + ", fwDownload=" + this.getFwDownload() + ", cpuUtil=" + this.getCpuUtil() + ", memUtil=" + this.getMemUtil() + ", download=" + this.getDownload() + ", upload=" + this.getUpload() + ", site=" + this.getSite() + ", location=" + this.getLocation() + ", clientNum=" + this.getClientNum() + ", compatible=" + this.getCompatible() + ", locateEnable=" + this.getLocateEnable() + ", active=" + this.getActive() + ", licenseStatus=" + this.getLicenseStatus() + ", dueTime=" + this.getDueTime() + ", dueTimeLeft=" + this.getDueTimeLeft() + ", licenseUnbindingLimit=" + this.getLicenseUnbindingLimit() + ", inWhitelist=" + this.getInWhitelist() + ", sn=" + this.getSn() + ", eost=" + this.getEost() + ", eos=" + this.getEos() + ", combinedGateway=" + this.getCombinedGateway() + ", es=" + this.getEs() + ", ippt=" + this.getIppt() + ", supportIppt=" + this.getSupportIppt() + ", supportAnomaly=" + this.getSupportAnomaly() + ", healthScore=" + this.getHealthScore() + ", healthScoreTime=" + this.getHealthScoreTime() + ", tagName=" + this.getTagName() + ", addedInAdvanced=" + this.getAddedInAdvanced() + ", category=" + this.getCategory() + ", preConfigErrorCode=" + this.getPreConfigErrorCode() + ", preConfigRetryType=" + this.getPreConfigRetryType() + ", powerMode=" + this.getPowerMode() + ", powerModeList=" + this.getPowerModeList() + ", featureLimit=" + this.getFeatureLimit() + ", wirelessRouter=" + this.getWirelessRouter() + ", description=" + this.getDescription() + ", onlineUpgradeStatus=" + this.getOnlineUpgradeStatus() + ", deviceSeriesType=" + this.getDeviceSeriesType() + ", configSyncStatus=" + this.getConfigSyncStatus() + ", supportRunningConfig=" + this.getSupportRunningConfig() + ", resource=" + this.getResource() + ", address=" + this.getAddress() + ", uplinkDeviceMac=" + this.getUplinkDeviceMac() + ", uplinkDeviceName=" + this.getUplinkDeviceName() + ", uplinkDevicePort=" + this.getUplinkDevicePort() + ", linkSpeed=" + this.getLinkSpeed() + ", duplex=" + this.getDuplex() + ", switchConsistent=" + this.getSwitchConsistent() + ", ecspFirstVersion=" + this.getEcspFirstVersion() + ", packageCaptureStatus=" + this.getPackageCaptureStatus() + ")";
    }

    @Generated
    public DeviceVO() {
    }

    @Generated
    public DeviceVO(String customId, String customName, String siteName, String type, Integer subDevType, String mac, String name, String model, String compoundModel, String showModel, String modelVersion, String firmwareVersion, String version, String hwVersion, String specialModel, String ip, String publicIp, List<String> ipv6List, String uptime, Long uptimeLong, Integer statusCategory, Integer status, Integer adoptFailType, Long lastSeen, Boolean needUpgrade, String latestVersion, Boolean fwDownload, Integer cpuUtil, Integer memUtil, Long download, Long upload, String site, LocationVO location, Integer clientNum, Integer compatible, Boolean locateEnable, Boolean active, Integer licenseStatus, Long dueTime, Long dueTimeLeft, Integer licenseUnbindingLimit, Boolean inWhitelist, String sn, Long eost, Long eos, Boolean combinedGateway, Boolean es, Boolean ippt, Boolean supportIppt, Boolean supportAnomaly, Integer healthScore, Long healthScoreTime, String tagName, Boolean addedInAdvanced, String category, Integer preConfigErrorCode, Integer preConfigRetryType, Integer powerMode, List<Integer> powerModeList, ApFeatureLimitVO featureLimit, Boolean wirelessRouter, String description, Integer onlineUpgradeStatus, Integer deviceSeriesType, Integer configSyncStatus, Boolean supportRunningConfig, Integer resource, String address, String uplinkDeviceMac, String uplinkDeviceName, String uplinkDevicePort, Integer linkSpeed, Integer duplex, Boolean switchConsistent, Integer ecspFirstVersion, Integer packageCaptureStatus) {
        this.customId = customId;
        this.customName = customName;
        this.siteName = siteName;
        this.type = type;
        this.subDevType = subDevType;
        this.mac = mac;
        this.name = name;
        this.model = model;
        this.compoundModel = compoundModel;
        this.showModel = showModel;
        this.modelVersion = modelVersion;
        this.firmwareVersion = firmwareVersion;
        this.version = version;
        this.hwVersion = hwVersion;
        this.specialModel = specialModel;
        this.ip = ip;
        this.publicIp = publicIp;
        this.ipv6List = ipv6List;
        this.uptime = uptime;
        this.uptimeLong = uptimeLong;
        this.statusCategory = statusCategory;
        this.status = status;
        this.adoptFailType = adoptFailType;
        this.lastSeen = lastSeen;
        this.needUpgrade = needUpgrade;
        this.latestVersion = latestVersion;
        this.fwDownload = fwDownload;
        this.cpuUtil = cpuUtil;
        this.memUtil = memUtil;
        this.download = download;
        this.upload = upload;
        this.site = site;
        this.location = location;
        this.clientNum = clientNum;
        this.compatible = compatible;
        this.locateEnable = locateEnable;
        this.active = active;
        this.licenseStatus = licenseStatus;
        this.dueTime = dueTime;
        this.dueTimeLeft = dueTimeLeft;
        this.licenseUnbindingLimit = licenseUnbindingLimit;
        this.inWhitelist = inWhitelist;
        this.sn = sn;
        this.eost = eost;
        this.eos = eos;
        this.combinedGateway = combinedGateway;
        this.es = es;
        this.ippt = ippt;
        this.supportIppt = supportIppt;
        this.supportAnomaly = supportAnomaly;
        this.healthScore = healthScore;
        this.healthScoreTime = healthScoreTime;
        this.tagName = tagName;
        this.addedInAdvanced = addedInAdvanced;
        this.category = category;
        this.preConfigErrorCode = preConfigErrorCode;
        this.preConfigRetryType = preConfigRetryType;
        this.powerMode = powerMode;
        this.powerModeList = powerModeList;
        this.featureLimit = featureLimit;
        this.wirelessRouter = wirelessRouter;
        this.description = description;
        this.onlineUpgradeStatus = onlineUpgradeStatus;
        this.deviceSeriesType = deviceSeriesType;
        this.configSyncStatus = configSyncStatus;
        this.supportRunningConfig = supportRunningConfig;
        this.resource = resource;
        this.address = address;
        this.uplinkDeviceMac = uplinkDeviceMac;
        this.uplinkDeviceName = uplinkDeviceName;
        this.uplinkDevicePort = uplinkDevicePort;
        this.linkSpeed = linkSpeed;
        this.duplex = duplex;
        this.switchConsistent = switchConsistent;
        this.ecspFirstVersion = ecspFirstVersion;
        this.packageCaptureStatus = packageCaptureStatus;
    }

    public static enum LicenseNameEnum {
        UNACTIVE("Unactivated", 0),
        UNBIND("Unbound", 1),
        EXPIRED("Expired", 2),
        ACTIVE("Activated", 3),
        NOT_MATCH("NotMatch", 4),
        NEAR_EXPIRED("NearExpired", 5),
        NOT_REQUIRED("NotRequired", 6);

        @Schema(description="The name displayed on the frontend for the license status.")
        private String typeName;
        @Schema(description="License status parameters for front-end and back-end communication")
        private int value;

        private LicenseNameEnum(String typeName, int value) {
            this.typeName = typeName;
            this.value = value;
        }

        public static String getName(int value) {
            LicenseNameEnum[] licenseNameEnums;
            for (LicenseNameEnum licenseNameEnum : licenseNameEnums = LicenseNameEnum.values()) {
                if (!Objects.equals(licenseNameEnum.value, value)) continue;
                return licenseNameEnum.typeName;
            }
            return "-";
        }

        public String getTypeName() {
            return this.typeName;
        }
    }

    @Generated
    public static abstract class DeviceVOBuilder<C extends DeviceVO, B extends DeviceVOBuilder<C, B>> {
        @Generated
        private String customId;
        @Generated
        private String customName;
        @Generated
        private String siteName;
        @Generated
        private String type;
        @Generated
        private Integer subDevType;
        @Generated
        private String mac;
        @Generated
        private String name;
        @Generated
        private String model;
        @Generated
        private String compoundModel;
        @Generated
        private String showModel;
        @Generated
        private String modelVersion;
        @Generated
        private String firmwareVersion;
        @Generated
        private String version;
        @Generated
        private String hwVersion;
        @Generated
        private String specialModel;
        @Generated
        private String ip;
        @Generated
        private String publicIp;
        @Generated
        private List<String> ipv6List;
        @Generated
        private String uptime;
        @Generated
        private Long uptimeLong;
        @Generated
        private Integer statusCategory;
        @Generated
        private Integer status;
        @Generated
        private Integer adoptFailType;
        @Generated
        private Long lastSeen;
        @Generated
        private Boolean needUpgrade;
        @Generated
        private String latestVersion;
        @Generated
        private Boolean fwDownload;
        @Generated
        private Integer cpuUtil;
        @Generated
        private Integer memUtil;
        @Generated
        private Long download;
        @Generated
        private Long upload;
        @Generated
        private String site;
        @Generated
        private LocationVO location;
        @Generated
        private Integer clientNum;
        @Generated
        private Integer compatible;
        @Generated
        private Boolean locateEnable;
        @Generated
        private Boolean active;
        @Generated
        private Integer licenseStatus;
        @Generated
        private Long dueTime;
        @Generated
        private Long dueTimeLeft;
        @Generated
        private Integer licenseUnbindingLimit;
        @Generated
        private Boolean inWhitelist;
        @Generated
        private String sn;
        @Generated
        private Long eost;
        @Generated
        private Long eos;
        @Generated
        private Boolean combinedGateway;
        @Generated
        private Boolean es;
        @Generated
        private Boolean ippt;
        @Generated
        private Boolean supportIppt;
        @Generated
        private Boolean supportAnomaly;
        @Generated
        private Integer healthScore;
        @Generated
        private Long healthScoreTime;
        @Generated
        private String tagName;
        @Generated
        private Boolean addedInAdvanced;
        @Generated
        private String category;
        @Generated
        private Integer preConfigErrorCode;
        @Generated
        private Integer preConfigRetryType;
        @Generated
        private Integer powerMode;
        @Generated
        private List<Integer> powerModeList;
        @Generated
        private ApFeatureLimitVO featureLimit;
        @Generated
        private Boolean wirelessRouter;
        @Generated
        private String description;
        @Generated
        private Integer onlineUpgradeStatus;
        @Generated
        private Integer deviceSeriesType;
        @Generated
        private Integer configSyncStatus;
        @Generated
        private Boolean supportRunningConfig;
        @Generated
        private Integer resource;
        @Generated
        private String address;
        @Generated
        private String uplinkDeviceMac;
        @Generated
        private String uplinkDeviceName;
        @Generated
        private String uplinkDevicePort;
        @Generated
        private Integer linkSpeed;
        @Generated
        private Integer duplex;
        @Generated
        private Boolean switchConsistent;
        @Generated
        private Integer ecspFirstVersion;
        @Generated
        private Integer packageCaptureStatus;

        @Generated
        public B customId(String customId) {
            this.customId = customId;
            return this.self();
        }

        @Generated
        public B customName(String customName) {
            this.customName = customName;
            return this.self();
        }

        @Generated
        public B siteName(String siteName) {
            this.siteName = siteName;
            return this.self();
        }

        @Generated
        public B type(String type) {
            this.type = type;
            return this.self();
        }

        @Generated
        public B subDevType(Integer subDevType) {
            this.subDevType = subDevType;
            return this.self();
        }

        @Generated
        public B mac(String mac) {
            this.mac = mac;
            return this.self();
        }

        @Generated
        public B name(String name) {
            this.name = name;
            return this.self();
        }

        @Generated
        public B model(String model) {
            this.model = model;
            return this.self();
        }

        @Generated
        public B compoundModel(String compoundModel) {
            this.compoundModel = compoundModel;
            return this.self();
        }

        @Generated
        public B showModel(String showModel) {
            this.showModel = showModel;
            return this.self();
        }

        @Generated
        public B modelVersion(String modelVersion) {
            this.modelVersion = modelVersion;
            return this.self();
        }

        @Generated
        public B firmwareVersion(String firmwareVersion) {
            this.firmwareVersion = firmwareVersion;
            return this.self();
        }

        @Generated
        public B version(String version) {
            this.version = version;
            return this.self();
        }

        @Generated
        public B hwVersion(String hwVersion) {
            this.hwVersion = hwVersion;
            return this.self();
        }

        @Generated
        public B specialModel(String specialModel) {
            this.specialModel = specialModel;
            return this.self();
        }

        @Generated
        public B ip(String ip) {
            this.ip = ip;
            return this.self();
        }

        @Generated
        public B publicIp(String publicIp) {
            this.publicIp = publicIp;
            return this.self();
        }

        @Generated
        public B ipv6List(List<String> ipv6List) {
            this.ipv6List = ipv6List;
            return this.self();
        }

        @Generated
        public B uptime(String uptime) {
            this.uptime = uptime;
            return this.self();
        }

        @Generated
        public B uptimeLong(Long uptimeLong) {
            this.uptimeLong = uptimeLong;
            return this.self();
        }

        @Generated
        public B statusCategory(Integer statusCategory) {
            this.statusCategory = statusCategory;
            return this.self();
        }

        @Generated
        public B status(Integer status) {
            this.status = status;
            return this.self();
        }

        @Generated
        public B adoptFailType(Integer adoptFailType) {
            this.adoptFailType = adoptFailType;
            return this.self();
        }

        @Generated
        public B lastSeen(Long lastSeen) {
            this.lastSeen = lastSeen;
            return this.self();
        }

        @Generated
        public B needUpgrade(Boolean needUpgrade) {
            this.needUpgrade = needUpgrade;
            return this.self();
        }

        @Generated
        public B latestVersion(String latestVersion) {
            this.latestVersion = latestVersion;
            return this.self();
        }

        @Generated
        public B fwDownload(Boolean fwDownload) {
            this.fwDownload = fwDownload;
            return this.self();
        }

        @Generated
        public B cpuUtil(Integer cpuUtil) {
            this.cpuUtil = cpuUtil;
            return this.self();
        }

        @Generated
        public B memUtil(Integer memUtil) {
            this.memUtil = memUtil;
            return this.self();
        }

        @Generated
        public B download(Long download) {
            this.download = download;
            return this.self();
        }

        @Generated
        public B upload(Long upload) {
            this.upload = upload;
            return this.self();
        }

        @Generated
        public B site(String site) {
            this.site = site;
            return this.self();
        }

        @Generated
        public B location(LocationVO location) {
            this.location = location;
            return this.self();
        }

        @Generated
        public B clientNum(Integer clientNum) {
            this.clientNum = clientNum;
            return this.self();
        }

        @Generated
        public B compatible(Integer compatible) {
            this.compatible = compatible;
            return this.self();
        }

        @Generated
        public B locateEnable(Boolean locateEnable) {
            this.locateEnable = locateEnable;
            return this.self();
        }

        @Generated
        public B active(Boolean active) {
            this.active = active;
            return this.self();
        }

        @Generated
        public B licenseStatus(Integer licenseStatus) {
            this.licenseStatus = licenseStatus;
            return this.self();
        }

        @Generated
        public B dueTime(Long dueTime) {
            this.dueTime = dueTime;
            return this.self();
        }

        @Generated
        public B dueTimeLeft(Long dueTimeLeft) {
            this.dueTimeLeft = dueTimeLeft;
            return this.self();
        }

        @Generated
        public B licenseUnbindingLimit(Integer licenseUnbindingLimit) {
            this.licenseUnbindingLimit = licenseUnbindingLimit;
            return this.self();
        }

        @Generated
        public B inWhitelist(Boolean inWhitelist) {
            this.inWhitelist = inWhitelist;
            return this.self();
        }

        @Generated
        public B sn(String sn) {
            this.sn = sn;
            return this.self();
        }

        @Generated
        public B eost(Long eost) {
            this.eost = eost;
            return this.self();
        }

        @Generated
        public B eos(Long eos) {
            this.eos = eos;
            return this.self();
        }

        @Generated
        public B combinedGateway(Boolean combinedGateway) {
            this.combinedGateway = combinedGateway;
            return this.self();
        }

        @Generated
        public B es(Boolean es) {
            this.es = es;
            return this.self();
        }

        @Generated
        public B ippt(Boolean ippt) {
            this.ippt = ippt;
            return this.self();
        }

        @Generated
        public B supportIppt(Boolean supportIppt) {
            this.supportIppt = supportIppt;
            return this.self();
        }

        @Generated
        public B supportAnomaly(Boolean supportAnomaly) {
            this.supportAnomaly = supportAnomaly;
            return this.self();
        }

        @Generated
        public B healthScore(Integer healthScore) {
            this.healthScore = healthScore;
            return this.self();
        }

        @Generated
        public B healthScoreTime(Long healthScoreTime) {
            this.healthScoreTime = healthScoreTime;
            return this.self();
        }

        @Generated
        public B tagName(String tagName) {
            this.tagName = tagName;
            return this.self();
        }

        @Generated
        public B addedInAdvanced(Boolean addedInAdvanced) {
            this.addedInAdvanced = addedInAdvanced;
            return this.self();
        }

        @Generated
        public B category(String category) {
            this.category = category;
            return this.self();
        }

        @Generated
        public B preConfigErrorCode(Integer preConfigErrorCode) {
            this.preConfigErrorCode = preConfigErrorCode;
            return this.self();
        }

        @Generated
        public B preConfigRetryType(Integer preConfigRetryType) {
            this.preConfigRetryType = preConfigRetryType;
            return this.self();
        }

        @Generated
        public B powerMode(Integer powerMode) {
            this.powerMode = powerMode;
            return this.self();
        }

        @Generated
        public B powerModeList(List<Integer> powerModeList) {
            this.powerModeList = powerModeList;
            return this.self();
        }

        @Generated
        public B featureLimit(ApFeatureLimitVO featureLimit) {
            this.featureLimit = featureLimit;
            return this.self();
        }

        @Generated
        public B wirelessRouter(Boolean wirelessRouter) {
            this.wirelessRouter = wirelessRouter;
            return this.self();
        }

        @Generated
        public B description(String description) {
            this.description = description;
            return this.self();
        }

        @Generated
        public B onlineUpgradeStatus(Integer onlineUpgradeStatus) {
            this.onlineUpgradeStatus = onlineUpgradeStatus;
            return this.self();
        }

        @Generated
        public B deviceSeriesType(Integer deviceSeriesType) {
            this.deviceSeriesType = deviceSeriesType;
            return this.self();
        }

        @Generated
        public B configSyncStatus(Integer configSyncStatus) {
            this.configSyncStatus = configSyncStatus;
            return this.self();
        }

        @Generated
        public B supportRunningConfig(Boolean supportRunningConfig) {
            this.supportRunningConfig = supportRunningConfig;
            return this.self();
        }

        @Generated
        public B resource(Integer resource) {
            this.resource = resource;
            return this.self();
        }

        @Generated
        public B address(String address) {
            this.address = address;
            return this.self();
        }

        @Generated
        public B uplinkDeviceMac(String uplinkDeviceMac) {
            this.uplinkDeviceMac = uplinkDeviceMac;
            return this.self();
        }

        @Generated
        public B uplinkDeviceName(String uplinkDeviceName) {
            this.uplinkDeviceName = uplinkDeviceName;
            return this.self();
        }

        @Generated
        public B uplinkDevicePort(String uplinkDevicePort) {
            this.uplinkDevicePort = uplinkDevicePort;
            return this.self();
        }

        @Generated
        public B linkSpeed(Integer linkSpeed) {
            this.linkSpeed = linkSpeed;
            return this.self();
        }

        @Generated
        public B duplex(Integer duplex) {
            this.duplex = duplex;
            return this.self();
        }

        @Generated
        public B switchConsistent(Boolean switchConsistent) {
            this.switchConsistent = switchConsistent;
            return this.self();
        }

        @Generated
        public B ecspFirstVersion(Integer ecspFirstVersion) {
            this.ecspFirstVersion = ecspFirstVersion;
            return this.self();
        }

        @Generated
        public B packageCaptureStatus(Integer packageCaptureStatus) {
            this.packageCaptureStatus = packageCaptureStatus;
            return this.self();
        }

        @Generated
        protected abstract B self();

        @Generated
        public abstract C build();

        @Generated
        public String toString() {
            return "DeviceVO.DeviceVOBuilder(customId=" + this.customId + ", customName=" + this.customName + ", siteName=" + this.siteName + ", type=" + this.type + ", subDevType=" + this.subDevType + ", mac=" + this.mac + ", name=" + this.name + ", model=" + this.model + ", compoundModel=" + this.compoundModel + ", showModel=" + this.showModel + ", modelVersion=" + this.modelVersion + ", firmwareVersion=" + this.firmwareVersion + ", version=" + this.version + ", hwVersion=" + this.hwVersion + ", specialModel=" + this.specialModel + ", ip=" + this.ip + ", publicIp=" + this.publicIp + ", ipv6List=" + this.ipv6List + ", uptime=" + this.uptime + ", uptimeLong=" + this.uptimeLong + ", statusCategory=" + this.statusCategory + ", status=" + this.status + ", adoptFailType=" + this.adoptFailType + ", lastSeen=" + this.lastSeen + ", needUpgrade=" + this.needUpgrade + ", latestVersion=" + this.latestVersion + ", fwDownload=" + this.fwDownload + ", cpuUtil=" + this.cpuUtil + ", memUtil=" + this.memUtil + ", download=" + this.download + ", upload=" + this.upload + ", site=" + this.site + ", location=" + this.location + ", clientNum=" + this.clientNum + ", compatible=" + this.compatible + ", locateEnable=" + this.locateEnable + ", active=" + this.active + ", licenseStatus=" + this.licenseStatus + ", dueTime=" + this.dueTime + ", dueTimeLeft=" + this.dueTimeLeft + ", licenseUnbindingLimit=" + this.licenseUnbindingLimit + ", inWhitelist=" + this.inWhitelist + ", sn=" + this.sn + ", eost=" + this.eost + ", eos=" + this.eos + ", combinedGateway=" + this.combinedGateway + ", es=" + this.es + ", ippt=" + this.ippt + ", supportIppt=" + this.supportIppt + ", supportAnomaly=" + this.supportAnomaly + ", healthScore=" + this.healthScore + ", healthScoreTime=" + this.healthScoreTime + ", tagName=" + this.tagName + ", addedInAdvanced=" + this.addedInAdvanced + ", category=" + this.category + ", preConfigErrorCode=" + this.preConfigErrorCode + ", preConfigRetryType=" + this.preConfigRetryType + ", powerMode=" + this.powerMode + ", powerModeList=" + this.powerModeList + ", featureLimit=" + this.featureLimit + ", wirelessRouter=" + this.wirelessRouter + ", description=" + this.description + ", onlineUpgradeStatus=" + this.onlineUpgradeStatus + ", deviceSeriesType=" + this.deviceSeriesType + ", configSyncStatus=" + this.configSyncStatus + ", supportRunningConfig=" + this.supportRunningConfig + ", resource=" + this.resource + ", address=" + this.address + ", uplinkDeviceMac=" + this.uplinkDeviceMac + ", uplinkDeviceName=" + this.uplinkDeviceName + ", uplinkDevicePort=" + this.uplinkDevicePort + ", linkSpeed=" + this.linkSpeed + ", duplex=" + this.duplex + ", switchConsistent=" + this.switchConsistent + ", ecspFirstVersion=" + this.ecspFirstVersion + ", packageCaptureStatus=" + this.packageCaptureStatus + ")";
        }
    }

    @Generated
    private static final class DeviceVOBuilderImpl
    extends DeviceVOBuilder<DeviceVO, DeviceVOBuilderImpl> {
        @Generated
        private DeviceVOBuilderImpl() {
        }

        @Override
        @Generated
        protected DeviceVOBuilderImpl self() {
            return this;
        }

        @Override
        @Generated
        public DeviceVO build() {
            return new DeviceVO(this);
        }
    }
}

